/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.targetformulate;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.formplugin.web.activitymanage.targetformulate.IndicatorRollBackNodePlugin;
import kd.opmc.pbs.business.domain.workflow.entity.FlowValidateResultBo;
import kd.opmc.pbs.business.domain.workflow.model.RollbackParamBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;

public class IndicatorRollBackHandlePlugin
extends AbstractReportFormPlugin {
    private static final Log LOG = LogFactory.getLog(IndicatorRollBackNodePlugin.class);
    private static final FlowRuSecondDomainService FLOW_RU_SECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final ActivityEvaluationObjectDomainService OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        Long procRuId = (Long)this.getView().getFormShowParameter().getCustomParams().get("PROC_RU_ID");
        Map customParam = queryParam.getCustomParam();
        customParam.put("PROC_RU_ID", procRuId);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        reportList.setShowCount(false);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        if (CollectionUtils.isNotEmpty((Collection)rowData)) {
            for (DynamicObject row : rowData) {
                DynamicObject handler;
                DynamicObject task;
                String roleName;
                DynamicObject nodeRu = row.getDynamicObject("runodebasedata");
                row.set("flownodedef", nodeRu.get("flownodedef"));
                DynamicObject roleRu = row.getDynamicObject("rurolebasedata");
                if (!HRObjectUtils.isEmpty((Object)roleRu) && !HRStringUtils.isEmpty((String)(roleName = roleRu.getString("roletype.name")))) {
                    row.set("roletype", (Object)roleName);
                }
                if (HRObjectUtils.isEmpty((Object)(task = row.getDynamicObject("rutaskbasedata"))) || null == (handler = task.getDynamicObject("handler"))) continue;
                String number = handler.getString("number");
                row.set("taskhandler", (Object)(handler.get("name") + (HRStringUtils.isEmpty((String)number) ? "" : "\uff08" + number + "\uff09")));
            }
            rowData.sort((Comparator)new SortByIndex());
        }
    }

    public void setMergeColums(List<String> columns) {
        super.setMergeColums(columns);
        columns.add("nodename");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)"confirm", (String)key)) {
            ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
            int[] rows = reportList.getEntryState().getSelectedRows();
            if (rows.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u56de\u9000\u5236\u5b9a\u4eba\u3002", (String)"IndicatorRollBackHandlePlugin_0", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                return;
            }
            String backReason = this.getModel().getDataEntity().getString("backreason");
            if (HRStringUtils.isEmpty((String)backReason)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u9000\u56de\u539f\u56e0\u201d", (String)"IndicatorRollBackHandlePlugin_1", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                return;
            }
            if (backReason.length() > 255) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u9000\u56de\u539f\u56e0\u201d\u5b57\u6bb5\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4\uff0c\u6700\u5927\u957f\u5ea6[0,255]\u3002", (String)"IndicatorRollBackHandlePlugin_2", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                return;
            }
            long currUserId = RequestContext.get().getCurrUserId();
            boolean hasPermission = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"epa", (String)"epa_activity", (String)"37LTQSOQE94P");
            if (!this.getView().getFormShowParameter().isHasRight() && !hasPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8003\u6838\u6d3b\u52a8\u201d\u7684\u201c\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IndicatorRollBackHandlePlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            DynamicObject rowData = reportList.getReportModel().getRowData(rows[0]);
            JSONArray evalObjs = (JSONArray)formShowParameter.getCustomParam("actevalobj");
            List objIds = evalObjs.toJavaList(Long.class);
            ArrayList<RollbackParamBo> rollbackParamBos = new ArrayList<RollbackParamBo>(10);
            RollbackParamBo bo = new RollbackParamBo();
            bo.setReason(backReason);
            bo.setRuTaskId(Long.valueOf(rowData.getLong("rutaskbasedata.id")));
            bo.setRollbackType("1");
            rollbackParamBos.add(bo);
            FlowValidateResultBo flowValidateResultBo = FLOW_RU_SECOND_DOMAIN_SERVICE.rollbackToSpecifiedTask(rollbackParamBos);
            LOG.warn("=======flowValidateResultBo:{0}======", (Object)flowValidateResultBo);
            Map validateMap = flowValidateResultBo.getValidateMap();
            Set failObjs = validateMap.keySet();
            List successIds = objIds.stream().filter(id -> !failObjs.contains(id)).collect(Collectors.toList());
            ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.dealWithAfterBaskFormulate(successIds);
            String titleStr = ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u9000\u56de\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"IndicatorRollBackHandlePlugin_4", (String)"opmc-epa-business", (Object[])new Object[]{objIds.size(), successIds.size(), failObjs.size()});
            HashMap<String, String> resultMap = new HashMap<String, String>(16);
            resultMap.put("title", titleStr);
            resultMap.put("detail", "");
            if (!failObjs.isEmpty()) {
                DynamicObject[] dynamicObjects;
                ArrayList<String> errorMsg = new ArrayList<String>(16);
                for (DynamicObject dynamicObject : dynamicObjects = OBJECT_DOMAIN_SERVICE.queryActevalObjs(failObjs.toArray())) {
                    errorMsg.add(ResManager.loadKDString((String)"{0} {1}\uff1a{2}", (String)"IndicatorRollBackHandlePlugin_5", (String)"opmc-epa-business", (Object[])new Object[]{dynamicObject.getString("perffile.name"), dynamicObject.getString("perffile.billno"), validateMap.get(dynamicObject.getLong("id"))}));
                }
                String detailStr = String.join((CharSequence)"\n", errorMsg);
                resultMap.put("detail", detailStr);
            }
            this.getView().returnDataToParent(resultMap);
            this.getView().close();
        }
    }

    private static class SortByIndex
    implements Comparator<DynamicObject> {
        private SortByIndex() {
        }

        @Override
        public int compare(DynamicObject o1, DynamicObject o2) {
            try {
                Integer a = o1.getDynamicObject("runodebasedata").getInt("index");
                Integer b = o2.getDynamicObject("runodebasedata").getInt("index");
                return a.compareTo(b);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return 0;
            }
        }
    }
}

