/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.targetformulate;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.ProcessManageApEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.formplugin.web.activitymanage.targetformulate.FormulateBaseList;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.service.FlowHandlerDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRunSupDomainService;
import kd.opmc.pbs.common.utils.OpmcPermissionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class SendFormulateTaskListPlugin
extends FormulateBaseList {
    private static final String DEFPROC = "epa_actevalobj.formulateflow";
    private static final String NODESTATUS = "epa_actevalobj.nodestatus";
    private static final String ASSESSNODE = "epa_actevalobj.assessnode";
    private static final String QUERY_NODEINDEX = "epa_actevalobj.nodeindex";
    private static final String QUERY_ASSGROUP_NAME = "epa_actevalobj.assgroup.name";
    private static final String SEND_TASK_CONFIRM_BACK = "sendTaskConfirmBack";
    private static final String NOTHING_SENDTASK = "donothing_sendtask";
    private static final String NOTHING_CLOSE = "donothing_close";
    private static final String WAIT_TIME = "waittime";
    private static final String UPDATE_STATUS_TIME = "updatestatustime";
    private static final long dayLong = 86400000L;
    private static final FlowHandlerDomainService FLOW_HANDLER_DOMAIN_SERVICE = FlowHandlerDomainService.getInstance();
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final FlowRunSupDomainService FLOW_RUSUP_DOMAIN_SERVICE = FlowRunSupDomainService.getInstance();
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();
    protected static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();

    public void setFilter(SetFilterEvent e) {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Object flowId = this.getView().getFormShowParameter().getCustomParam("flowDefId");
        int nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        QFilter filter = new QFilter("activity", "=", (Object)activityId).and(DEFPROC, "=", (Object)Long.parseLong(flowId.toString())).and(NODESTATUS, "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getStatus()).and(ASSESSNODE, "=", (Object)Long.valueOf(ProcessManageApEnum.TARGET_FORMULATING.getLabId())).and(QUERY_NODEINDEX, "=", (Object)nodeIndex).and("taskstatus", "=", (Object)FlowRuTaskStatusEnum.BE_WAITTING.getCode());
        e.getQFilters().add(filter);
        String order = "handler.number desc,epa_actevalobj.perffile.person.number desc,updatestatustime desc";
        e.setOrderBy(order);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (super.isCloseParentView() && !HRStringUtils.equals((String)NOTHING_CLOSE, (String)operateKey)) {
            return;
        }
        switch (operateKey) {
            case "donothing_close": {
                this.getView().close();
                this.getView().getParentView().close();
                this.getView().sendFormAction(this.getView().getParentView());
                break;
            }
            case "refresh": {
                String flowId = this.getView().getParentView().getPageCache().get("flowDefId");
                this.getView().getFormShowParameter().setCustomParam("flowDefId", (Object)flowId);
                break;
            }
            case "donothing_sendtask": {
                this.handleSendHandlerTask(args);
                break;
            }
        }
    }

    private void handleSendHandlerTask(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        int size = selectedRows.size();
        if (size > 0) {
            String msg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u60a8\u5df2\u9009\u62e9{0}\u4eba\uff0c\u70b9\u51fb\u201c\u53d1\u9001\u5236\u5b9a\u4efb\u52a1\u201d\u4f1a\u5c06\u5904\u7406\u72b6\u6001\u4e3a\u201c\u7b49\u5f85\u4e2d\u201d\u7684\u4efb\u52a1\u6fc0\u6d3b\u53d1\u9001\u7ed9\u5236\u5b9a\u4eba\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"SendFormulateTaskListPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[]{size}));
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(SEND_TASK_CONFIRM_BACK, (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    public void packageData(PackageDataEvent evt) {
        DynamicTextColumnDesc columnDesc;
        Object source = evt.getSource();
        if (source instanceof DynamicTextColumnDesc && WAIT_TIME.equals((columnDesc = (DynamicTextColumnDesc)source).getKey())) {
            this.setWaitTimeFormatValue(evt);
        }
    }

    private void setWaitTimeFormatValue(PackageDataEvent dataEvent) {
        DynamicObject taskDy = dataEvent.getRowData();
        Date updateStatusTime = taskDy.getDate(UPDATE_STATUS_TIME);
        Date today = new Date();
        long diffTime = today.getTime() - updateStatusTime.getTime();
        long days = diffTime / 86400000L;
        dataEvent.setFormatValue((Object)MessageFormat.format("{0}{1}", String.valueOf(days), "d"));
    }

    private void sendTaskToFlow() {
        int totalSize;
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List<Long> taskIdList = selectedRows.stream().map(ListSelectedRow2 -> (Long)ListSelectedRow2.getPrimaryKeyValue()).collect(Collectors.toList());
        ArrayList taskIds = Lists.newArrayListWithCapacity((int)10);
        Map<Long, DynamicObject> taskMap = this.queryEvalIdsByTaskIds(taskIdList);
        Map<Long, DynamicObject> evalMap = this.queryEvalByTaskIds(taskMap);
        if (MapUtils.isEmpty(taskMap) || MapUtils.isEmpty(evalMap)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u9001\u5931\u8d25", (String)"SendFormulateTaskListPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> failMessage = new ArrayList<String>(16);
        int success = totalSize = taskIdList.size();
        for (Long l : taskIdList) {
            DynamicObject evalObj;
            DynamicObject dynamicObject = taskMap.get(l);
            if (ObjectUtils.isEmpty((Object)dynamicObject) || ObjectUtils.isEmpty((Object)(evalObj = evalMap.get(dynamicObject.get("flowruproc.actevalobj"))))) continue;
            if (!HRStringUtils.equals((String)evalObj.getString("nodestatus"), (String)AssessNodeStatusEnum.TARGET_FORMULATING.getStatus()) || !HRStringUtils.equals((String)evalObj.getString("assessnode.id"), (String)ProcessManageApEnum.TARGET_FORMULATING.getLabId()) || evalObj.getLong("nodeindex") != AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId().longValue()) {
                String msg = ResManager.loadKDString((String)"{0} {1}\uff1a\u5236\u5b9a\u5bf9\u8c61\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u5236\u5b9a\u4e2d\u201d\uff0c\u4e0d\u53ef\u53d1\u9001\u5236\u5b9a\u4efb\u52a1\u3002", (String)"SendFormulateTaskListPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{evalObj.getString("person.name"), evalObj.getString("person.number")});
                failMessage.add(msg);
                --success;
                continue;
            }
            String taskstatus = dynamicObject.getString("taskstatus");
            if (!StringUtils.equals((CharSequence)taskstatus, (CharSequence)FlowRuTaskStatusEnum.BE_WAITTING.getCode())) {
                this.setFailMessage(failMessage, evalObj, dynamicObject.getDynamicObject("handler"), ResManager.loadKDString((String)"\u5236\u5b9a\u4efb\u52a1\u5df2\u4e0d\u5728\u201c\u7b49\u5f85\u4e2d\u201d\u3002 ", (String)"SendFormulateTaskListPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                --success;
                continue;
            }
            taskIds.add(l);
        }
        Map resultMap = FLOW_HANDLER_DOMAIN_SERVICE.startProcessAfterWaiting((List)taskIds);
        if (!MapUtils.isEmpty((Map)resultMap)) {
            for (Map.Entry entry : resultMap.entrySet()) {
                if (Objects.isNull(entry.getValue()) || ((Boolean)entry.getValue()).booleanValue()) continue;
                DynamicObject taskInfo = taskMap.get(entry.getKey());
                if (!Objects.isNull(taskInfo)) {
                    this.setFailMessage(failMessage, evalMap.get(taskInfo.get("flowruproc.actevalobj")), taskInfo.getDynamicObject("handler"), ResManager.loadKDString((String)"\u5236\u5b9a\u4efb\u52a1\u53d1\u9001\u5931\u8d25\u3002 ", (String)"SendFormulateTaskListPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                }
                --success;
            }
        }
        if (totalSize == success) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u9001\u5236\u5b9a\u4efb\u52a1\u6210\u529f", (String)"SendFormulateTaskListPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            String string = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"SendFormulateTaskListPlugin_6", (String)"opmc-epa-business", (Object[])new Object[0]), totalSize, success, totalSize - success);
            Tuple tuple = Tuple.create((Object)string, (Object)String.join((CharSequence)"\n", failMessage));
            this.getView().showMessage(String.valueOf(tuple.item1), String.valueOf(tuple.item2), MessageTypes.Default);
        }
        this.getView().invokeOperation("refresh");
    }

    private void setFailMessage(List<String> failMessage, DynamicObject actevalobj, DynamicObject handler, String detail) {
        if (Objects.isNull(actevalobj)) {
            return;
        }
        String name = Objects.isNull(handler) || HRStringUtils.isEmpty((String)handler.getString("name")) ? "" : handler.getString("name");
        String number = Objects.isNull(handler) || HRStringUtils.isEmpty((String)handler.getString("number")) ? "" : handler.getString("number");
        failMessage.add(String.format("%s - %s %s :%s - {%s %s} %s", ResManager.loadKDString((String)"\u5236\u5b9a\u5bf9\u8c61", (String)"SendFormulateTaskListPlugin_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]), actevalobj.get("person.name"), actevalobj.get("person.number"), CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5236\u5b9a\u4eba", (String)"SendFormulateTaskListPlugin_8", (String)"opmc-epa-formplugin", (Object[])new Object[0])), name, number, detail));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (!MessageBoxResult.Yes.equals((Object)result)) {
            return;
        }
        if (!this.checkActivityPermission()) {
            return;
        }
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((CharSequence)SEND_TASK_CONFIRM_BACK, (CharSequence)callBackId)) {
            this.sendTaskToFlow();
        }
        if (HRStringUtils.equals((String)callBackId, (String)"closeView")) {
            this.getView().getParentView().close();
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private Map<Long, DynamicObject> queryEvalByTaskIds(Map<Long, DynamicObject> taskMap) {
        if (MapUtils.isEmpty(taskMap)) {
            return null;
        }
        List evalIds = taskMap.values().stream().map(DynamicObject2 -> DynamicObject2.getLong("flowruproc.actevalobj")).collect(Collectors.toList());
        return EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvalObjectsByIds(evalIds);
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List<ComboItem> groupCombos = this.buildGroupComboItems();
        DynamicObject flowProc = this.getFlowProcDy();
        List<ComboItem> nodeCombos = this.buildNodeComboItems(flowProc);
        List<ComboItem> roleCombos = this.buildRoleComboItems(flowProc);
        List commonFilterCols = args.getCommonFilterColumns().stream().map(commonFilterCol -> (CommonFilterColumn)commonFilterCol).collect(Collectors.toList());
        for (CommonFilterColumn commonFilterColumn : commonFilterCols) {
            String fieldName = commonFilterColumn.getFieldName();
            if (HRStringUtils.equals((String)fieldName, (String)QUERY_ASSGROUP_NAME)) {
                commonFilterColumn.setComboItems(groupCombos);
            }
            if (HRStringUtils.equals((String)fieldName, (String)"flowrurole.flowdefrole.rolename")) {
                commonFilterColumn.setComboItems(roleCombos);
            }
            if (!HRStringUtils.equals((String)fieldName, (String)"flowrunode.flownodedef.nodename")) continue;
            commonFilterColumn.setComboItems(nodeCombos);
        }
    }

    private List<ComboItem> buildGroupComboItems() {
        DynamicObject[] assessGroup;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        DynamicObject activity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
        DynamicObjectCollection assgroupentry = activity.getDynamicObjectCollection("assgroupentry");
        for (DynamicObject group : assessGroup = (DynamicObject[])assgroupentry.stream().map(dy -> dy.getDynamicObject("assgroup")).toArray(DynamicObject[]::new)) {
            if (group == null) continue;
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(group.getPkValue()));
            item.setCaption(new LocaleString(group.getString("name")));
            item.setValue(String.valueOf(group.getPkValue()));
            combos.add(item);
        }
        return combos;
    }

    private List<ComboItem> buildNodeComboItems(DynamicObject flowProc) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        if (Objects.isNull(flowProc)) {
            return combos;
        }
        DynamicObjectCollection nodeDy = flowProc.getDynamicObjectCollection("nodeentry");
        for (DynamicObject node : nodeDy) {
            if (node == null) continue;
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(node.getPkValue()));
            item.setCaption(new LocaleString(node.getString("nodename")));
            item.setValue(String.valueOf(node.getPkValue()));
            combos.add(item);
        }
        return combos;
    }

    private List<ComboItem> buildRoleComboItems(DynamicObject flowProc) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        if (Objects.isNull(flowProc)) {
            return combos;
        }
        List nodeIds = flowProc.getDynamicObjectCollection("nodeentry").stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        DynamicObject[] roleDy = FLOW_RUSUP_DOMAIN_SERVICE.queryRoleDefByNodeDef(nodeIds);
        if (Objects.isNull(roleDy)) {
            return combos;
        }
        for (DynamicObject role : roleDy) {
            if (role == null) continue;
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(role.getPkValue()));
            item.setCaption(new LocaleString(role.getString("rolename")));
            item.setValue(String.valueOf(role.getPkValue()));
            combos.add(item);
        }
        return combos;
    }

    private DynamicObject getFlowProcDy() {
        String flowId = this.getView().getParentView().getPageCache().get("flowDefId");
        DynamicObject[] flows = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFlowByPkValue((Set)Sets.newHashSet((Object[])new Object[]{Long.parseLong(flowId)}));
        if (Objects.isNull(flows) || flows.length <= 0) {
            return null;
        }
        Long flowProcId = ((DynamicObject)flows[0].getDynamicObjectCollection("entryentity").get(0)).getLong("flowdefproc");
        DynamicObject flowProc = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFlowProcPkValue(flowProcId);
        if (Objects.isNull(flowProc)) {
            return null;
        }
        return flowProc;
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("flowrunode.flownodedef.id".equals(fieldName) || "flowrunode.flownodedef.nodename".equals(fieldName)) {
            List<Long> nodeIds = this.getNodeIdLists();
            if (CollectionUtils.isEmpty(nodeIds)) {
                return;
            }
            List qFilters = args.getQfilters();
            qFilters.add(new QFilter("id", "in", nodeIds));
        }
        if ("flowrurole.flowdefrole.id".equals(fieldName) || "flowrurole.flowdefrole.rolename".equals(fieldName)) {
            String nodeIDsStr = this.getView().getPageCache().get("nodeIds");
            List nodeIds = HRStringUtils.isEmpty((String)nodeIDsStr) ? this.getNodeIdLists() : (List)SerializationUtils.fromJsonString((String)nodeIDsStr, List.class);
            if (CollectionUtils.isEmpty((Collection)nodeIds)) {
                return;
            }
            List qFilters = args.getQfilters();
            qFilters.add(new QFilter("defnode", "in", (Object)nodeIds));
        }
    }

    private List<Long> getNodeIdLists() {
        DynamicObject flowProc = this.getFlowProcDy();
        if (flowProc == null) {
            return null;
        }
        List<Long> nodeIds = flowProc.getDynamicObjectCollection("nodeentry").stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        this.getView().getPageCache().put("nodeIds", SerializationUtils.toJsonString(nodeIds));
        return nodeIds;
    }

    public Map<Long, DynamicObject> queryEvalIdsByTaskIds(List<Long> taskIds) {
        if (CollectionUtils.isEmpty(taskIds)) {
            return new HashMap<Long, DynamicObject>(0);
        }
        String properties = "id, taskstatus, updatestatustime, flowruproc,handler.name,handler.number";
        QFilter qFilter = new QFilter("id", "in", taskIds);
        DynamicObject[] tasks = FLOW_RU_TASK_ENTITY_SERVICE.query(properties, qFilter.toArray());
        return Arrays.stream(tasks).collect(Collectors.toMap(task -> task.getLong("id"), task -> task));
    }

    private boolean checkActivityPermission() {
        boolean isPass = OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_activity", (String)"37LTQSOQE94P");
        if (!isPass) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8003\u6838\u6d3b\u52a8\u7684\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u6743\u9650", (String)"SendFormulateTaskListPlugin_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
        return isPass;
    }
}

