/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.targetformulate;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.LikeHint;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterHint;
import kd.hr.hbp.business.service.query.ksql.IKsqlConfig;
import kd.hr.hbp.business.service.query.ksql.KsqlConfig;
import kd.hr.hbp.business.service.query.ksql.KsqlListDataProvider;
import kd.hr.hbp.business.servicehelper.EntityReleaseInfoService;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.query.QueryListPlugin;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.formplugin.web.utils.BosListUtil;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.business.domain.workflow.entity.FlowCommonResultBo;

public class SetFormulatorRoleList
extends QueryListPlugin {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();
    private static final String ACTIVITY = "epa_actevalobj.activity";
    private static final String DEFPROC = "epa_actevalobj.formulateflow";
    private static final String INDEX = "pbs_flowrunode.index";
    private static final String ASSESSSTAUS = "epa_actevalobj.assessstaus";
    private static final String FORMULATOR = "formulator";
    private Map<Long, String> evaluatorMap = new HashMap<Long, String>(16);

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Object flowId = this.getView().getFormShowParameter().getCustomParam("flowDefId");
        Object seq = this.getView().getFormShowParameter().getCustomParam("seq");
        QFilter filter = new QFilter(ACTIVITY, "=", (Object)activityId).and(INDEX, "=", seq).and(DEFPROC, "=", (Object)Long.parseLong(flowId.toString())).and(ASSESSSTAUS, "=", (Object)AssessStausEnum.JOINED.getStatus());
        e.getQFilters().add(filter);
        e.setOrderBy("modifytime desc");
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        super.beforePackageData(event);
        DynamicObjectCollection pageData = event.getPageData();
        if (!pageData.isEmpty()) {
            List roleIds = pageData.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
            this.evaluatorMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryEvaluator(roleIds);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        KsqlConfig ksqlConfig;
        DynamicObject entityReleaseInfo = EntityReleaseInfoService.getEntityReleaseInfoByName((String)"epa_formulaterolequery");
        if (Objects.isNull(entityReleaseInfo)) {
            return;
        }
        String ksqlQueryType = entityReleaseInfo.getString("ksqlquerytype");
        boolean ksqlUseUnion = entityReleaseInfo.getBoolean("ksqluseunion");
        String queryType = "FULLSQL";
        if (HRStringUtils.equals((String)ksqlQueryType, (String)"IDQUERY")) {
            queryType = "PKSQL";
        }
        if ((ksqlConfig = this.setCustomKSqlConfig()) == null) {
            ksqlConfig = new KsqlConfig();
        }
        args.setListDataProvider((IListDataProvider)new KsqlListDataProvider(this.getView(), (IKsqlConfig)ksqlConfig, queryType, ksqlUseUnion, true){

            public List<QFilter> getQFilters() {
                List qFilterList = super.getQFilters();
                for (int i = 0; i < qFilterList.size(); ++i) {
                    String property;
                    QFilter qFilter = (QFilter)qFilterList.get(i);
                    if (qFilter == null || !"evalpersonshow".equals(property = qFilter.getProperty())) continue;
                    List roleList = SetFormulatorRoleList.this.getDefaultList();
                    Map nameOrNumRoleSetMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryNameOrNumRoleSetMap(roleList);
                    qFilterList.remove(i);
                    --i;
                    QFilter roleFilter = this.getPersonToRoleFilter(qFilter, nameOrNumRoleSetMap);
                    if (roleFilter == null) continue;
                    qFilterList.add(roleFilter);
                }
                return qFilterList;
            }

            private QFilter getPersonToRoleFilter(QFilter qFilter, Map<String, Set<Long>> nameOrNumberRoleMap) {
                String cp = qFilter.getCP();
                cp = cp.toLowerCase();
                QFilter roleQFilter = null;
                switch (cp) {
                    case "like": {
                        roleQFilter = this.like(qFilter, nameOrNumberRoleMap);
                        break;
                    }
                    case "not like": {
                        roleQFilter = this.notLike(qFilter, nameOrNumberRoleMap);
                        break;
                    }
                    case "=": {
                        roleQFilter = this.equalsValue(qFilter, nameOrNumberRoleMap);
                        break;
                    }
                    case "!=": {
                        roleQFilter = this.notEqualsValue(qFilter, nameOrNumberRoleMap);
                        break;
                    }
                    case "in": {
                        roleQFilter = this.inValues(qFilter, nameOrNumberRoleMap);
                        break;
                    }
                    case "not in": {
                        roleQFilter = this.notInValues(qFilter, nameOrNumberRoleMap);
                        break;
                    }
                    case "is not null": {
                        roleQFilter = this.notNullValue(nameOrNumberRoleMap);
                        break;
                    }
                }
                return roleQFilter;
            }

            private QFilter like(QFilter qFilter, Map<String, Set<Long>> nameOrNumberRoleMap) {
                QFilterHint qFilterHint = qFilter.getQFilterHint();
                HashSet queryRoleIds = new HashSet(16);
                if (qFilterHint instanceof LikeHint) {
                    boolean hasLeftPercent = ((LikeHint)qFilterHint).isAppendLeftPercent();
                    boolean hasRightPercent = ((LikeHint)qFilterHint).isAppendRightPercent();
                    Object value = qFilter.getOriginValue();
                    if (value instanceof String) {
                        nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                            if (hasLeftPercent && hasRightPercent) {
                                if (nameOrNum != null && nameOrNum.contains((String)value)) {
                                    queryRoleIds.addAll(roleIds);
                                }
                            } else if (hasLeftPercent && !hasRightPercent) {
                                if (nameOrNum != null && nameOrNum.endsWith((String)value)) {
                                    queryRoleIds.addAll(roleIds);
                                }
                            } else if (!hasLeftPercent && hasRightPercent && nameOrNum != null && nameOrNum.startsWith((String)value)) {
                                queryRoleIds.addAll(roleIds);
                            }
                        });
                    }
                }
                return new QFilter("id", "in", queryRoleIds);
            }

            private QFilter notLike(QFilter qFilter, Map<String, Set<Long>> nameOrNumberRoleMap) {
                HashSet queryRoleIds = new HashSet(16);
                Object value = qFilter.getOriginValue();
                if (value instanceof String) {
                    nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                        if (nameOrNum != null && nameOrNum.contains((String)value)) {
                            queryRoleIds.addAll(roleIds);
                        }
                    });
                }
                return new QFilter("id", "not in", queryRoleIds);
            }

            private QFilter equalsValue(QFilter qFilter, Map<String, Set<Long>> nameOrNumberRoleMap) {
                HashSet queryRoleIds = new HashSet(16);
                Object value = qFilter.getOriginValue();
                if (value instanceof String) {
                    nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                        if (nameOrNum != null && nameOrNum.equals(value)) {
                            queryRoleIds.addAll(roleIds);
                        }
                    });
                } else if (value instanceof QEmptyValue) {
                    nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                        if (nameOrNum != null && HRStringUtils.isEmpty((String)nameOrNum)) {
                            queryRoleIds.addAll(roleIds);
                        }
                    });
                }
                return new QFilter("id", "in", queryRoleIds);
            }

            private QFilter notEqualsValue(QFilter qFilter, Map<String, Set<Long>> nameOrNumberRoleMap) {
                HashSet queryRoleIds = new HashSet(16);
                Object value = qFilter.getOriginValue();
                if (value instanceof String) {
                    nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                        if (nameOrNum != null && nameOrNum.equals(value)) {
                            queryRoleIds.addAll(roleIds);
                        }
                    });
                }
                return new QFilter("id", "not in", queryRoleIds);
            }

            private QFilter notNullValue(Map<String, Set<Long>> nameOrNumberRoleMap) {
                HashSet queryRoleIds = new HashSet(16);
                nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                    if (nameOrNum != null && HRStringUtils.isNotEmpty((String)nameOrNum)) {
                        queryRoleIds.addAll(roleIds);
                    }
                });
                return new QFilter("id", "in", queryRoleIds);
            }

            private QFilter inValues(QFilter qFilter, Map<String, Set<Long>> nameOrNumberRoleMap) {
                HashSet queryRoleIds = new HashSet(16);
                Object value = qFilter.getOriginValue();
                if (value instanceof List) {
                    nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                        if (nameOrNum != null && ((List)value).contains(nameOrNum)) {
                            queryRoleIds.addAll(roleIds);
                        }
                    });
                }
                return new QFilter("id", "in", queryRoleIds);
            }

            private QFilter notInValues(QFilter qFilter, Map<String, Set<Long>> nameOrNumberRoleMap) {
                HashSet queryRoleIds = new HashSet(16);
                Object value = qFilter.getOriginValue();
                if (value instanceof List) {
                    nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                        if (nameOrNum != null && ((List)value).contains(nameOrNum)) {
                            queryRoleIds.addAll(roleIds);
                        }
                    });
                }
                return new QFilter("id", "not in", queryRoleIds);
            }
        });
    }

    private List<Long> getDefaultList() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Object flowId = this.getView().getFormShowParameter().getCustomParam("flowDefId");
        Object seq = this.getView().getFormShowParameter().getCustomParam("seq");
        return ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFormulatorByListDefaultFilter(activityId, seq, Long.valueOf(Long.parseLong(flowId.toString())));
    }

    public void packageData(PackageDataEvent evt) {
        DynamicObject rowData;
        DynamicTextColumnDesc columnDesc;
        super.packageData(evt);
        Object source = evt.getSource();
        if (source instanceof DynamicTextColumnDesc && FORMULATOR.equals((columnDesc = (DynamicTextColumnDesc)source).getKey())) {
            rowData = evt.getRowData();
            String formulator = this.evaluatorMap.get(rowData.getLong("id"));
            evt.setFormatValue((Object)formulator);
        }
        if (source instanceof ColumnDesc && "evalpersonshow".equals((columnDesc = (ColumnDesc)source).getKey())) {
            rowData = evt.getRowData();
            String evalPersonShow = this.evaluatorMap.get(rowData.getLong("id"));
            evt.setFormatValue((Object)evalPersonShow);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BosListUtil.setListBgColor(this.getView(), "#ffffff");
        BosListUtil.setGripAndMargin(this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (this.getView().getParentView().getParentView() == null) {
            args.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"SetFormulatorRoleList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
            return;
        }
        AbstractOperate source = (AbstractOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        String operateKey = source.getOperateKey();
        if ("sethandler".equals(operateKey) && !HRStringUtils.equals((String)systemInvoke, (String)"true")) {
            FormShowParameter baseShowParameter = new FormShowParameter();
            baseShowParameter.setFormId("epa_setformulator");
            baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            baseShowParameter.setStatus(OperationStatus.EDIT);
            baseShowParameter.setCaption(CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.getLocaleString((String)"\u8bbe\u7f6e\u5236\u5b9a\u4eba", (String)"SetFormulatorRoleList_0", (String)"opmc-epa-formplugin").getLocaleValue()));
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            baseShowParameter.setCustomParam("SELECTED_ROW", (Object)primaryKeyValues.length);
            baseShowParameter.setCustomParam("ROW_DATA", (Object)primaryKeyValues);
            baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_setformulator"));
            this.getView().showForm(baseShowParameter);
            args.setCancel(true);
        } else if ("refresh".equals(operateKey)) {
            String systemRefresh = source.getOption().getVariableValue("system_refresh", "false");
            if (HRStringUtils.equals((String)systemRefresh, (String)"true")) {
                return;
            }
            args.setCancel(true);
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("sethandler".equals(key) && args.getOperationResult().isSuccess()) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("system_refresh", "true");
            this.getView().invokeOperation("refresh", operateOption);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object childMap = closedCallBackEvent.getReturnData();
        if (HRObjectUtils.isEmpty((Object)childMap)) {
            return;
        }
        if ("epa_setformulator".equals(actionId)) {
            Map handlers = (Map)childMap;
            List userIds = (List)handlers.get("handlers");
            List flowCommonResultBos = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.verifyUserIsValid(userIds);
            for (FlowCommonResultBo flowCommonResultBo : flowCommonResultBos) {
                if (!"-1".equals(flowCommonResultBo.getCode())) continue;
                this.getView().showErrorNotification(flowCommonResultBo.getMessage());
                return;
            }
            OperateOption setHandler = OperateOption.create();
            String returnStr = SerializationUtils.serializeToBase64((Object)childMap);
            setHandler.setVariableValue("return_str", returnStr);
            setHandler.setVariableValue("systeminvoke", "true");
            setHandler.setVariableValue("OP_SOURCE", "epa_sethandler");
            this.getView().invokeOperation("sethandler", setHandler);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("flowdefrole.rolename".equals(fieldName)) {
            Object nodeId = this.getView().getFormShowParameter().getCustomParam("flownode");
            List qFilters = args.getQfilters();
            qFilters.add(new QFilter("defnode", "=", nodeId));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        MessageBoxResult result;
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"closeView") && MessageBoxResult.Yes == (result = event.getResult())) {
            this.getView().getParentView().close();
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }
}

