/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.targetformulate;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.activitymanage.entity.FormulatorRoleListDataBO;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;

public class TargetFormulateSettingPlugin
extends HRDynamicFormBasePlugin
implements RowClickEventListener {
    private static final Log logger = LogFactory.getLog(TargetFormulateSettingPlugin.class);
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final AssessActivityApplicationService ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();
    private static final String FLOW_NODE_MAP = "flowNodeMap";
    private static final String EXPORT_FLEX_AP = "exportflexap";
    private static final String EXPORT_VECTOR_AP = "exportvectorap";
    private static final String EXPORT_LABEL_AP = "exportlabelap";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        CardEntry nodeEntry = (CardEntry)this.getView().getControl("entryentity");
        nodeEntry.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{EXPORT_FLEX_AP, EXPORT_VECTOR_AP, EXPORT_LABEL_AP});
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (ObjectUtils.isEmpty((Object)this.getParentViewPageCache())) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        boolean hasPermission = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"epa", (String)"epa_activity", (String)"37LTQSOQE94P");
        if (!hasPermission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8003\u6838\u6d3b\u52a8\u201d\u7684\u201c\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ActivitySaveAndStartResultPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        this.exportExcel();
    }

    private void exportExcel() {
        String excelName = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5bfc\u51fa\u5217\u8868_\u8bbe\u7f6e\u5236\u5b9a\u4eba_{0}", (String)"TargetFormulateSettingPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[]{HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss")}));
        List<HRExportHeadObject> headDataList = this.getExportHead();
        List<Map<String, Object>> exportDataList = this.getExportData();
        String exportUrl = null;
        try {
            exportUrl = HRExportDataHelper.getExportExcelUrl((String)excelName, exportDataList, headDataList);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        if (!HRStringUtils.isEmpty((String)exportUrl)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.addAction("download", (Object)exportUrl);
        }
    }

    private List<HRExportHeadObject> getExportHead() {
        ArrayList<HRExportHeadObject> headDataList = new ArrayList<HRExportHeadObject>();
        headDataList.add(new HRExportHeadObject("perffilenumber", ResManager.loadKDString((String)"\u7ee9\u6548\u6863\u6848\u7f16\u7801", (String)"TargetFormulateSettingPlugin_13", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"TargetFormulateSettingPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"TargetFormulateSettingPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("process.name", ResManager.loadKDString((String)"\u6d41\u7a0b\u540d\u79f0", (String)"TargetFormulateSettingPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("node.name", ResManager.loadKDString((String)"\u8282\u70b9\u540d\u79f0", (String)"TargetFormulateSettingPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("handle.name", CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5236\u5b9a\u4eba", (String)"TargetFormulateSettingPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]))));
        headDataList.add(new HRExportHeadObject("setup", ResManager.loadKDString((String)"\u624b\u52a8\u8bbe\u7f6e", (String)"TargetFormulateSettingPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("role.name", ResManager.loadKDString((String)"\u89d2\u8272", (String)"TargetFormulateSettingPlugin_7", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("job.name", ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"TargetFormulateSettingPlugin_8", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("adminorg.name", ResManager.loadKDString((String)"\u6302\u9760\u884c\u653f\u7ec4\u7ec7", (String)"TargetFormulateSettingPlugin_9", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("belongcom.name", ResManager.loadKDString((String)"\u6240\u5c5e\u516c\u53f8", (String)"TargetFormulateSettingPlugin_10", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        return headDataList;
    }

    private List<Map<String, Object>> getExportData() {
        ArrayList<Map<String, Object>> exportDataList = new ArrayList<Map<String, Object>>(10);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        List formulatorRoleListData = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getFormulatorRoleListData(activityId);
        if (ObjectUtils.isEmpty((Object)formulatorRoleListData)) {
            return exportDataList;
        }
        for (FormulatorRoleListDataBO dataBO : formulatorRoleListData) {
            HashMap<String, String> exportData = new HashMap<String, String>(16);
            exportData.put("perffilenumber", dataBO.getPerfFileNumber());
            exportData.put("name", dataBO.getName());
            exportData.put("number", dataBO.getNumber());
            exportData.put("process.name", dataBO.getProcessName());
            exportData.put("node.name", dataBO.getNodeName());
            exportData.put("handle.name", dataBO.getHandle());
            exportData.put("setup", dataBO.getIsSetHandler());
            exportData.put("role.name", dataBO.getRole());
            exportData.put("job.name", dataBO.getJob());
            exportData.put("adminorg.name", dataBO.getAdminorg());
            exportData.put("belongcom.name", dataBO.getBelongCom());
            exportDataList.add(exportData);
        }
        return exportDataList;
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        this.getModel().setDataChanged(false);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Map flowMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryTobeFormulateFlowsMap(activityId);
        DynamicObject[] flows = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFlowByPkValue(flowMap.keySet());
        DynamicObject perfWorkFlow = ACTIVITY_APPLICATION_SERVICE.queryPerfWorkFlow(activityId);
        DynamicObjectCollection flowEntry = perfWorkFlow.getDynamicObjectCollection("flowentry");
        Map<Long, Boolean> temMap = flowEntry.stream().collect(Collectors.toMap(itemL -> itemL.getLong("flowvid"), itemB -> itemB.getBoolean("isdefaultflow")));
        logger.info("\u7ee9\u6548\u6d41\u7a0b\u5206\u5f55(perfWorkFlow.flowentry)\u9ed8\u8ba4\u4fe1\u606f\u4e3a\uff1a{}", (Object)temMap.toString());
        Arrays.stream(flows).forEach(item -> {
            if (temMap.containsKey(item.getLong("id"))) {
                item.set("isdefault", temMap.get(item.getLong("id")));
            }
        });
        String isdefault = Arrays.stream(flows).collect(Collectors.toMap(itemL -> itemL.get("id"), itemB -> itemB.get("isdefault"))).toString();
        logger.info("\u6307\u6807\u5236\u5b9a\u6d41\u7a0b\uff08WorkFlow.isdefault\uff09\u9ed8\u8ba4\u4fe1\u606f\u4e3a\uff1a{}", (Object)isdefault);
        this.initFlowNodeMap(flows);
        this.buildComboItem(flowMap, flows);
        this.addNodeCard();
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.chooseFirstCard();
    }

    private void chooseFirstCard() {
        CardEntry nodeCard = (CardEntry)this.getControl("entryentity");
        String lastSelectRowStr = this.getView().getPageCache().get("lastSelectRow");
        if (HRStringUtils.isNotEmpty((String)lastSelectRowStr)) {
            int lastSelectRow = Integer.parseInt(lastSelectRowStr);
            nodeCard.selectCard(Integer.valueOf(lastSelectRow));
        } else {
            nodeCard.selectCard(Integer.valueOf(0));
        }
        this.getView().getPageCache().remove("lastSelectRow");
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"flowcombo")) {
            String flowId = (String)this.getModel().getValue("flowcombo");
            IPageCache parentViewPageCache = this.getParentViewPageCache();
            if (null == parentViewPageCache) {
                return;
            }
            parentViewPageCache.put("currentSelectFlow", flowId);
            parentViewPageCache.remove("lastSelectRow");
            this.addNodeCard();
            this.chooseFirstCard();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Object source = evt.getSource();
        if (source instanceof CardEntry && HRStringUtils.equals((String)"entryentity", (String)((CardEntry)source).getKey())) {
            int lastSelectRow;
            int row = evt.getRow();
            DynamicObjectCollection nodeEntry = this.getModel().getEntryEntity("entryentity");
            IPageCache parentViewPageCache = this.getParentViewPageCache();
            if (parentViewPageCache == null || ObjectUtils.isEmpty((Object)nodeEntry)) {
                return;
            }
            String lastSelectRowStr = this.getView().getPageCache().get("lastSelectRow");
            if (!ObjectUtils.isEmpty((Object)lastSelectRowStr) && (lastSelectRow = Integer.parseInt(lastSelectRowStr)) == row) {
                return;
            }
            for (int i = 0; i < nodeEntry.size(); ++i) {
                this.getView().getModel().setValue("isselected", (Object)(row == i ? 1 : 0), i);
            }
            parentViewPageCache.put("lastSelectRow", String.valueOf(row));
            this.getView().getModel().setValue("isselected", (Object)Boolean.TRUE, row);
            Integer entrySeq = ObjectUtils.isEmpty((Object)nodeEntry) ? 0 : ((DynamicObject)nodeEntry.get(row)).getDynamicObject("flownode").getInt("entryseq");
            Object pkValue = ((DynamicObject)nodeEntry.get(row)).getDynamicObject("flownode").getPkValue();
            this.showRightList(pkValue, entrySeq);
        }
    }

    private void showRightList(Object pkValue, Integer seq) {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Object flowId = this.getModel().getValue("flowcombo");
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setBillFormId("epa_formulateroleqrylst");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("formulatorap");
        parameter.setCustomParam("activity", (Object)activityId);
        parameter.setCustomParam("flowDefId", flowId);
        parameter.setCustomParam("flownode", pkValue);
        parameter.setCustomParam("seq", (Object)seq);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void initFlowNodeMap(DynamicObject[] flows) {
        Map<Long, List> flowNodeMap = Arrays.stream(flows).collect(Collectors.toMap(flow -> flow.getLong("id"), flow -> {
            Long flowProcId = ((DynamicObject)flow.getDynamicObjectCollection("entryentity").get(0)).getLong("flowdefproc");
            DynamicObject flowProc = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFlowProcPkValue(flowProcId);
            return flowProc.getDynamicObjectCollection("nodeentry").stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }));
        String mapStr = JSONObject.toJSONString(flowNodeMap);
        this.getView().getPageCache().put(FLOW_NODE_MAP, mapStr);
    }

    private void buildComboItem(Map<Object, Long> flowMap, DynamicObject[] flows) {
        DynamicObject defaultFlow = Arrays.stream(flows).filter(dy -> dy.getBoolean("isdefault")).findFirst().orElse(null);
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        if (defaultFlow != null) {
            String name = defaultFlow.getString("name");
            Long count = flowMap.get(defaultFlow.getPkValue());
            String value = name + "\uff08" + count + "\uff09";
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(defaultFlow.getPkValue()));
            item.setCaption(new LocaleString(value));
            item.setValue(String.valueOf(defaultFlow.getPkValue()));
            combos.add(item);
        }
        Arrays.stream(flows).filter(dy -> !dy.getBoolean("isdefault")).forEach(dy -> {
            String name = dy.getString("name");
            Long count = (Long)flowMap.get(dy.getPkValue());
            String value = name + "\uff08" + count + "\uff09";
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(dy.getPkValue()));
            item.setCaption(new LocaleString(value));
            item.setValue(String.valueOf(dy.getPkValue()));
            combos.add(item);
        });
        ComboEdit comboEdit = (ComboEdit)this.getControl("flowcombo");
        comboEdit.setComboItems(combos);
        logger.info("\u6307\u6807\u5236\u5b9a\u6d41\u7a0b\u4e0b\u62c9\u6846-\u6d41\u7a0bid\u987a\u5e8f\u4e3a\uff1a{}", (Object)combos.stream().map(ComboItem::getId).collect(Collectors.toList()).toString());
        if (!ObjectUtils.isEmpty(combos)) {
            this.getModel().setValue("flowcombo", (Object)((ComboItem)combos.get(0)).getId());
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"EvalPersonList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
        }
        this.getModel().setValue("flowcombo", HRCollUtil.isNotEmpty(combos) ? ((ComboItem)combos.get(0)).getId() : Long.valueOf(0L));
    }

    public void pageRelease(EventObject e) {
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            parentView.getPageCache().remove("lastSelectRow");
            parentView.getPageCache().remove("currentSelectFlow");
        }
    }

    private void addNodeCard() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        this.dealWithSetter(setter);
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void dealWithSetter(TableValueSetter setter) {
        int seq = 1;
        setter.addField("flownode", new Object[0]);
        setter.addField("nodeseq", new Object[0]);
        setter.addField("nodeposition", new Object[0]);
        setter.addField("isselected", new Object[0]);
        String flowId = String.valueOf(this.getModel().getValue("flowcombo"));
        String mapStr = this.getView().getPageCache().get(FLOW_NODE_MAP);
        JSONObject jsonObject = JSONObject.parseObject((String)mapStr);
        Object nodes = jsonObject.get((Object)flowId);
        List nodeIds = JSONObject.parseArray((String)JSONObject.toJSONString((Object)nodes), Long.class);
        if (ObjectUtils.isEmpty((Object)nodeIds)) {
            return;
        }
        for (Long nodeId : nodeIds) {
            String position = null;
            if (seq == 1) {
                position = "top";
            } else if (nodeIds.indexOf(nodeId) == nodeIds.size() - 1) {
                position = "bottom";
            }
            setter.addRow(new Object[]{nodeId, seq, position, seq == 1});
            ++seq;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRStringUtils.equals((String)args.getOperateKey(), (String)"refresh")) {
            IPageCache parentViewPageCache = this.getParentViewPageCache();
            if (parentViewPageCache == null) {
                return;
            }
            String selectFlow = parentViewPageCache.get("currentSelectFlow");
            String selectRow = parentViewPageCache.get("lastSelectRow");
            if (!ObjectUtils.isEmpty((Object)selectFlow)) {
                this.getModel().setValue("flowcombo", (Object)selectFlow);
            }
            if (ObjectUtils.isEmpty((Object)selectRow)) {
                return;
            }
            CardEntry card = (CardEntry)this.getControl("entryentity");
            card.selectCard(Integer.valueOf(Integer.parseInt(selectRow)));
            parentViewPageCache.remove("lastSelectRow");
        }
    }

    private IPageCache getParentViewPageCache() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"EvalPersonList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
            return null;
        }
        return parentView.getPageCache();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        MessageBoxResult result;
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"closeView") && MessageBoxResult.Yes == (result = event.getResult())) {
            this.getView().close();
        }
    }
}

