/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.targetformulate;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.evaladjustment.ActEvalObjAdjApplicationService;
import kd.opmc.epa.business.domain.activity.service.AssessActivityDomainService;
import kd.opmc.epa.business.domain.activitymanage.enums.ProcessManageApEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActEvalObjPrintPaintDomainService;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.perfworkflow.service.PerfWorkFlowDomainService;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.formplugin.web.activitymanage.actevalobj.EvalObjBaseList;
import kd.opmc.epa.formplugin.web.utils.ActManageUtils;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.common.utils.OpmcPermissionUtils;

public class TargetFormulatedList
extends EvalObjBaseList {
    private static final AssessActivityDomainService ACTIVITY_DOMAIN_SERVICE = AssessActivityDomainService.getInstance();
    private static final ActEvalObjPrintPaintDomainService EVAL_OBJ_PRINT_PAINT_DOMAIN_SERVICE = ActEvalObjPrintPaintDomainService.getInstance();
    private static final String EPA_INDICATOR_SINGLE = "epa_indicator_single";
    private static final PerfWorkFlowDomainService PERF_WORK_FLOW_DOMAIN_SERVICE = PerfWorkFlowDomainService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY_SERVICE = ExecuteSchemeEntityService.getInstance();
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();
    private static final ActivityEvaluationObjectDomainService OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final ActEvalObjAdjApplicationService ACT_EVAL_OBJ_ADJ_APPLICATION_SERVICE = ActEvalObjAdjApplicationService.getInstance();
    Map<Long, List<DynamicObject>> ACT_RECORD_MAP = new HashMap<Long, List<DynamicObject>>(16);
    private static final String FORMULATE_FLOW_INFO = "formulateflowinfo";
    private Map<Long, String> EVALUATOR_MAP = new HashMap<Long, String>(16);
    private Map<Long, Long> EVAL_FLOW_MAP = new HashMap<Long, Long>(16);
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();

    public void setFormulateLowInfo(PackageDataEvent evt) {
        DynamicObject rowData;
        DynamicTextColumnDesc columnDesc;
        Object source = evt.getSource();
        if (source instanceof DynamicTextColumnDesc && FORMULATE_FLOW_INFO.equals((columnDesc = (DynamicTextColumnDesc)source).getKey()) && (rowData = evt.getRowData()) != null && !this.EVALUATOR_MAP.isEmpty()) {
            Long id = rowData.getLong("id");
            String formulator = this.EVALUATOR_MAP.get(this.EVAL_FLOW_MAP.get(id));
            evt.setFormatValue((Object)formulator);
        }
    }

    public void beforePackageData(BeforePackageDataEvent dataEvent) {
        DynamicObjectCollection pageData = dataEvent.getPageData();
        boolean selectedAllRows = ((ListModel)dataEvent.getSource()).isSelectedAllRows();
        if (!pageData.isEmpty() && !selectedAllRows) {
            this.EVAL_FLOW_MAP = new HashMap<Long, Long>(16);
            List actObjIds = pageData.stream().map(actObj -> actObj.getLong("id")).collect(Collectors.toList());
            this.ACT_RECORD_MAP = ACTIVITY_DOMAIN_SERVICE.queryActRecordByActId(actObjIds);
            Map objectMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryEvalObjById(actObjIds);
            ArrayList<Long> flowInsIds = new ArrayList<Long>(16);
            for (DynamicObject datum : pageData) {
                DynamicObject dynamicObject = (DynamicObject)objectMap.get(datum.getLong("id"));
                if (HRObjectUtils.isEmpty((Object)dynamicObject)) continue;
                this.EVAL_FLOW_MAP.put(datum.getLong("id"), dynamicObject.getLong("formulateflowins.id"));
                if (dynamicObject.getLong("formulateflow.id") == 0L) continue;
                flowInsIds.add(dynamicObject.getLong("formulateflowins.id"));
            }
            if (!flowInsIds.isEmpty()) {
                this.EVALUATOR_MAP = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getFlowInfo(flowInsIds);
            }
        }
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("indigroup.name".equals(fieldName)) {
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            List qFilters = args.getQfilters();
            qFilters.add(new QFilter("activity", "=", (Object)activityId));
        } else if ("formulateflow.name".equals(fieldName)) {
            List qFilters = args.getQfilters();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long activityId = (Long)customParams.get("activity");
            DynamicObject activityDy = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
            List ids = PERF_WORK_FLOW_DOMAIN_SERVICE.queryFlowById(activityDy.getLong("perfworkflow.id"), "1");
            if (CollectionUtils.isEmpty((Collection)ids)) {
                return;
            }
            qFilters.add(new QFilter("id", "in", (Object)ids));
        }
    }

    public void packageData(PackageDataEvent dataEvent) {
        Object source = dataEvent.getSource();
        if (source instanceof DynamicTextColumnDesc) {
            DynamicTextColumnDesc columnDesc = (DynamicTextColumnDesc)source;
            switch (columnDesc.getKey()) {
                case "formulatestartdate": {
                    this.setFormatValue("createtime", dataEvent);
                    break;
                }
                case "formulateenddate": {
                    this.setFormatValue("endTime", dataEvent);
                    break;
                }
                case "formulateflowinfo": {
                    this.setFormulateLowInfo(dataEvent);
                    break;
                }
            }
        }
    }

    private void setFormatValue(String fieldKey, PackageDataEvent dataEvent) {
        DynamicObject actEvalObj = dataEvent.getRowData();
        List<DynamicObject> actRecords = this.ACT_RECORD_MAP.get(actEvalObj.getLong("id"));
        if (ObjectUtils.isEmpty(actRecords)) {
            return;
        }
        DynamicObject record = actRecords.stream().filter(actRecord -> actRecord.getLong("assessnode") == AssessNodeStatusEnum.TARGET_FORMULATED.getNodeId().longValue()).filter(actRecord -> HRStringUtils.equals((String)actRecord.getString("nodeindex"), (String)ProcessManageApEnum.TARGET_FORMULATED.getLabId())).filter(actRecord -> HRStringUtils.equals((String)actRecord.getString("nodestatus"), (String)AssessNodeStatusEnum.TARGET_FORMULATED.getStatus())).findFirst().orElse(null);
        if (record == null) {
            return;
        }
        dataEvent.setFormatValue(record.get(fieldKey));
    }

    public void setFilter(SetFilterEvent filterEvent) {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        List objIds = ACT_EVAL_OBJ_ADJ_APPLICATION_SERVICE.queryFormulatedObjIdByActivityId(activityId);
        QFilter filter = new QFilter("id", "in", (Object)objIds);
        List qFilters = filterEvent.getQFilters();
        QFilter flowFilter = null;
        for (int index = 0; index < qFilters.size(); ++index) {
            QFilter qfiter = (QFilter)qFilters.get(index);
            if (!HRStringUtils.equals((String)qfiter.getProperty(), (String)"formulateflow.id")) continue;
            flowFilter = new QFilter("formulateflow.boid", qfiter.getCP(), qfiter.getValue());
            qFilters.remove(index);
            break;
        }
        if (!Objects.isNull(flowFilter)) {
            filterEvent.getQFilters().add(flowFilter);
        }
        filterEvent.getQFilters().add(filter);
        filterEvent.setOrderBy("modifytime desc");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("indicatorprint".equals(operateKey)) {
            Object[] selectedRows = this.getSelectedRows().getPrimaryKeyValues();
            if (selectedRows.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6253\u5370\u7684\u8bc4\u4f30\u5bf9\u8c61", (String)"TargetFormulatedList_0", (String)"opmc-epa-business", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (selectedRows.length > 100) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u6700\u591a\u6253\u5370100\u4efd\u8003\u6838\u8868\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TargetFormulatedList_1", (String)"opmc-epa-business", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("reset".equals(operateKey)) {
            this.beforeResetOp(args);
        }
    }

    private void beforeResetOp(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows;
        int size;
        AbstractOperate source = (AbstractOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        if (!HRStringUtils.equals((String)systemInvoke, (String)"true") && (size = (selectedRows = this.getSelectedRows()).size()) > 0) {
            String msg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u9009\u4e2d\u7684{0}\u4e2a\u5236\u5b9a\u5bf9\u8c61\u5c06\u9000\u56de\u81f3\u6307\u6807\u5236\u5b9a\u73af\u8282\u201c\u5f85\u5236\u5b9a\u201d\u72b6\u6001\uff0c\u540c\u65f6\u901a\u8fc7\u5236\u5b9a\u6d41\u7a0b\u5236\u5b9a\u7684\u6307\u6807\u5c06\u88ab\u4fdd\u7559\uff0c\u786e\u5b9a\u8981\u201c\u91cd\u7f6e\u201d\u5417\uff1f", (String)"TargetFormulatedList_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{size}));
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("reset", (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "refresh": {
                Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
                ActManageUtils.refreshFormulatedCount(this.getView(), activityId);
                break;
            }
            case "indicatorprint": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                this.handleIndicatorPrint();
                break;
            }
            case "reset": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "rollbacknode": {
                this.showRollBackNodeConfirm();
                break;
            }
            case "rollbackhandler": {
                this.showRollBackHandlerConfirm();
                break;
            }
        }
    }

    private void showRollBackNodeConfirm() {
        DynamicObjectCollection workEntryEntity;
        long perfWorkFlowId;
        DynamicObject workFlowDynObj;
        Object[] selectedRows = this.getSelectedRows().getPrimaryKeyValues();
        if (selectedRows.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9000\u56de\u7684\u8bc4\u4f30\u5bf9\u8c61", (String)"TargetFormulatedList_3", (String)"opmc-epa-business", (Object[])new Object[0]));
            return;
        }
        Object activityIdObj = this.getView().getFormShowParameter().getCustomParam("activity");
        Long activityId = 0L;
        if (activityIdObj instanceof Long) {
            activityId = (Long)activityIdObj;
        }
        if (activityId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TargetFormulatedList_4", (String)"opmc-epa-business", (Object[])new Object[0]));
            return;
        }
        DynamicObject activityDy = ACTIVITY_DOMAIN_SERVICE.loadSingle((Object)activityId);
        DynamicObject[] dynamicObjects = OBJECT_DOMAIN_SERVICE.queryActevalObjs(selectedRows);
        ArrayList<Long> flowIds = new ArrayList<Long>(16);
        ArrayList<String> errorMsg = new ArrayList<String>(16);
        Map<Object, Object> nodeNameMap = new HashMap(16);
        if (activityDy != null && (workFlowDynObj = PERF_WORK_FLOW_DOMAIN_SERVICE.loadSingleWorkFlow(perfWorkFlowId = activityDy.getLong("perfworkflow.id"))) != null && (workEntryEntity = workFlowDynObj.getDynamicObjectCollection("entryentity")) != null) {
            nodeNameMap = workEntryEntity.stream().collect(Collectors.toMap(data -> data.getDynamicObject("node").getLong("id"), data -> data.getString("customname"), (key1, key2) -> key2));
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject formulateFlow = dynamicObject.getDynamicObject("formulateflow");
            Long accessNode = dynamicObject.getLong("assessnode.id");
            String nodeStatus = dynamicObject.getString("nodestatus");
            if (accessNode == null || accessNode == 0L || HRStringUtils.isEmpty((String)nodeStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"{0} {1}\uff1a\u5f53\u524d\u4e0d\u5728\u6307\u6807\u5236\u5b9a\u7684\u5b8c\u6210\u9636\u6bb5\uff0c\u4e0d\u53ef\u9000\u56de\u5236\u5b9a\u3002", (String)"TargetFormulatedList_5", (String)"opmc-epa-business", (Object[])new Object[]{dynamicObject.getString("perffile.name"), dynamicObject.getString("perffile.billno")}));
                return;
            }
            if (!AssessNodeStatusEnum.TARGET_FORMULATED.getNodeId().equals(accessNode) || !AssessNodeStatusEnum.TARGET_FORMULATED.getStatus().equals(nodeStatus)) {
                String nodeErrMsg = ResManager.loadKDString((String)"{0} {1}\uff1a\u5f53\u524d\u5728{2}\u7684{3}\u9636\u6bb5\uff0c\u4e0d\u53ef\u9000\u56de\u5236\u5b9a\u3002", (String)"TargetFormulatedList_6", (String)"opmc-epa-business", (Object[])new Object[]{dynamicObject.getString("perffile.name"), dynamicObject.getString("perffile.billno"), nodeNameMap.get(accessNode), AssessNodeStatusEnum.getEnumByIdAndStatus((Long)accessNode, (String)nodeStatus).getText()});
                errorMsg.add(nodeErrMsg);
                if (formulateFlow != null) {
                    flowIds.add(formulateFlow.getLong("id"));
                    continue;
                }
                flowIds.add(0L);
                continue;
            }
            if (HRObjectUtils.isEmpty((Object)formulateFlow)) {
                errorMsg.add(ResManager.loadKDString((String)"{0} {1}\uff1a\u8be5\u5458\u5de5\u901a\u8fc7\u201c\u7edf\u4e00\u6d3e\u53d1\u201d\u5f62\u5f0f\u5236\u5b9a\u6307\u6807\uff0c\u65e0\u6cd5\u9000\u56de\uff0c\u53ef\u901a\u8fc7\u201c\u91cd\u7f6e\u5236\u5b9a\u6d41\u7a0b\u201d\u56de\u5230\u201c\u5f85\u5236\u5b9a\u201d\u73af\u8282\u7f16\u8f91\u3002", (String)"TargetFormulatedList_7", (String)"opmc-epa-business", (Object[])new Object[]{dynamicObject.getString("perffile.name"), dynamicObject.getString("perffile.billno")}));
                flowIds.add(0L);
                continue;
            }
            flowIds.add(formulateFlow.getLong("id"));
        }
        List collect = flowIds.stream().distinct().collect(Collectors.toList());
        if (collect.size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)" \u9700\u8981\u9009\u62e9\u540c\u4e00\u6d41\u7a0b\u4e0b\u7684\u5236\u5b9a\u5bf9\u8c61\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TargetFormulatedList_8", (String)"opmc-epa-business", (Object[])new Object[0]));
            return;
        }
        if (!errorMsg.isEmpty()) {
            if (errorMsg.size() > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u9000\u56de\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"TargetFormulatedList_9", (String)"opmc-epa-business", (Object[])new Object[]{selectedRows.length, 0, selectedRows.length}), String.join((CharSequence)"\n", errorMsg), MessageTypes.Default);
            } else {
                this.getView().showErrorNotification((String)errorMsg.get(0));
            }
            return;
        }
        List evalIds = Arrays.stream(dynamicObjects).map(dyc -> dyc.getLong("id")).collect(Collectors.toList());
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("actevalobj", evalIds);
        showParameter.setCustomParam("type", (Object)(evalIds.size() == 1 ? "0" : "1"));
        showParameter.setCustomParam("activityId", (Object)dynamicObjects[0].getLong("activity.id"));
        showParameter.setCustomParam("PROC_RU_ID", (Object)dynamicObjects[0].getLong("formulateflowins.id"));
        showParameter.setFormId("epa_rollbacknode");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "rollbacknode"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showRollBackHandlerConfirm() {
        DynamicObject[] workEntryEntity;
        long perfWorkFlowId;
        DynamicObject workFlowDynObj;
        Object[] selectedRows = this.getSelectedRows().getPrimaryKeyValues();
        if (selectedRows.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9000\u56de\u7684\u8bc4\u4f30\u5bf9\u8c61", (String)"TargetFormulatedList_3", (String)"opmc-epa-business", (Object[])new Object[0]));
            return;
        }
        if (selectedRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9000\u56de\u6307\u5b9a\u5236\u5b9a\u4eba\uff0c\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u5236\u5b9a\u5bf9\u8c61\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TargetFormulatedList_10", (String)"opmc-epa-business", (Object[])new Object[0]));
            return;
        }
        Object activityIdObj = this.getView().getFormShowParameter().getCustomParam("activity");
        Long activityId = 0L;
        if (activityIdObj instanceof Long) {
            activityId = (Long)activityIdObj;
        }
        if (activityId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TargetFormulatedList_4", (String)"opmc-epa-business", (Object[])new Object[0]));
            return;
        }
        DynamicObject activityDy = ACTIVITY_DOMAIN_SERVICE.loadSingle((Object)activityId);
        Map<Object, Object> nodeNameMap = new HashMap(16);
        if (activityDy != null && (workFlowDynObj = PERF_WORK_FLOW_DOMAIN_SERVICE.loadSingleWorkFlow(perfWorkFlowId = activityDy.getLong("perfworkflow.id"))) != null && (workEntryEntity = workFlowDynObj.getDynamicObjectCollection("entryentity")) != null) {
            nodeNameMap = workEntryEntity.stream().collect(Collectors.toMap(data -> data.getDynamicObject("node").getLong("id"), data -> data.getString("customname"), (key1, key2) -> key2));
        }
        DynamicObject[] dynamicObjects = OBJECT_DOMAIN_SERVICE.queryActevalObjs(selectedRows);
        ArrayList<Long> flowIds = new ArrayList<Long>(16);
        ArrayList<String> errorMsg = new ArrayList<String>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject formulateFlow = dynamicObject.getDynamicObject("formulateflow");
            Long accessNode = dynamicObject.getLong("assessnode.id");
            String nodeStatus = dynamicObject.getString("nodestatus");
            if (accessNode == null || accessNode == 0L || HRStringUtils.isEmpty((String)nodeStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"{0} {1}\uff1a\u5f53\u524d\u4e0d\u5728\u6307\u6807\u5236\u5b9a\u7684\u5b8c\u6210\u9636\u6bb5\uff0c\u4e0d\u53ef\u9000\u56de\u5236\u5b9a\u3002", (String)"TargetFormulatedList_5", (String)"opmc-epa-business", (Object[])new Object[]{dynamicObject.getString("perffile.name"), dynamicObject.getString("perffile.billno")}));
                return;
            }
            if (!AssessNodeStatusEnum.TARGET_FORMULATED.getNodeId().equals(accessNode) || !AssessNodeStatusEnum.TARGET_FORMULATED.getStatus().equals(nodeStatus)) {
                String nodeErrMsg = ResManager.loadKDString((String)"{0} {1}\uff1a\u5f53\u524d\u5728{2}\u7684{3}\u9636\u6bb5\uff0c\u4e0d\u53ef\u9000\u56de\u5236\u5b9a\u3002", (String)"TargetFormulatedList_6", (String)"opmc-epa-business", (Object[])new Object[]{dynamicObject.getString("perffile.name"), dynamicObject.getString("perffile.billno"), nodeNameMap.get(accessNode), AssessNodeStatusEnum.getEnumByIdAndStatus((Long)accessNode, (String)nodeStatus).getText()});
                errorMsg.add(nodeErrMsg);
                if (formulateFlow != null) {
                    flowIds.add(formulateFlow.getLong("id"));
                    continue;
                }
                flowIds.add(0L);
                continue;
            }
            if (HRObjectUtils.isEmpty((Object)formulateFlow)) {
                errorMsg.add(ResManager.loadKDString((String)"{0} {1}\uff1a\u8be5\u5458\u5de5\u901a\u8fc7\u201c\u7edf\u4e00\u6d3e\u53d1\u201d\u5f62\u5f0f\u5236\u5b9a\u6307\u6807\uff0c\u65e0\u6cd5\u9000\u56de\uff0c\u53ef\u901a\u8fc7\u201c\u91cd\u7f6e\u5236\u5b9a\u6d41\u7a0b\u201d\u56de\u5230\u201c\u5f85\u5236\u5b9a\u201d\u73af\u8282\u7f16\u8f91\u3002", (String)"TargetFormulatedList_7", (String)"opmc-epa-business", (Object[])new Object[]{dynamicObject.getString("perffile.name"), dynamicObject.getString("perffile.billno")}));
                flowIds.add(0L);
                continue;
            }
            flowIds.add(formulateFlow.getLong("id"));
        }
        List collect = flowIds.stream().distinct().collect(Collectors.toList());
        if (collect.size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)" \u9700\u8981\u9009\u62e9\u540c\u4e00\u6d41\u7a0b\u4e0b\u7684\u5236\u5b9a\u5bf9\u8c61\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TargetFormulatedList_8", (String)"opmc-epa-business", (Object[])new Object[0]));
            return;
        }
        if (!errorMsg.isEmpty()) {
            if (errorMsg.size() > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u9000\u56de\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"TargetFormulatedList_9", (String)"opmc-epa-business", (Object[])new Object[]{selectedRows.length, 0, selectedRows.length}), String.join((CharSequence)"\n", errorMsg), MessageTypes.Default);
            } else {
                this.getView().showErrorNotification((String)errorMsg.get(0));
            }
            return;
        }
        List evalIds = Arrays.stream(dynamicObjects).map(dyc -> dyc.getLong("id")).collect(Collectors.toList());
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("actevalobj", evalIds);
        showParameter.setCustomParam("activityId", (Object)dynamicObjects[0].getLong("activity.id"));
        showParameter.setCustomParam("PROC_RU_ID", (Object)dynamicObjects[0].getLong("formulateflowins.id"));
        showParameter.setFormId("epa_rollbackhandler");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "rollbackhandler"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map resultMap;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (HRStringUtils.equals((String)"rollbackhandler", (String)actionId)) {
            if (returnData == null) {
                return;
            }
            if (returnData instanceof Map) {
                resultMap = (Map)returnData;
                this.getView().showMessage((String)resultMap.get("title"), (String)resultMap.get("detail"), MessageTypes.Default);
                this.getView().invokeOperation("refresh");
            }
        }
        if (HRStringUtils.equals((String)"rollbacknode", (String)actionId)) {
            if (returnData == null) {
                return;
            }
            if (returnData instanceof Map) {
                resultMap = (Map)returnData;
                this.getView().showMessage((String)resultMap.get("title"), (String)resultMap.get("detail"), MessageTypes.Default);
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private void handleIndicatorPrint() {
        Object[] selectedRows = this.getSelectedRows().getPrimaryKeyValues();
        String previewUrl = EVAL_OBJ_PRINT_PAINT_DOMAIN_SERVICE.buildIndicatorPrintPdf(selectedRows);
        if (HRStringUtils.isEmpty((String)previewUrl)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"TargetFormulatedList_11", (String)"opmc-epa-business", (Object[])new Object[0]));
            return;
        }
        FormShowParameter para = new FormShowParameter();
        para.setFormId("epa_printpreview");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap reservedSpace = Maps.newHashMap();
        reservedSpace.put("reservedSpace", "true");
        para.getOpenStyle().setCustParam((Map)reservedSpace);
        para.setCustomParam("src", (Object)previewUrl);
        this.getView().showForm(para);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        String fieldName = event.getFieldName();
        if (HRStringUtils.equals((String)fieldName, (String)"perffile_name")) {
            args.setCancel(true);
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            baseShowParameter.setPkId(this.getFocusRowPkId());
            baseShowParameter.setFormId(EPA_INDICATOR_SINGLE);
            baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            baseShowParameter.setCustomParam("is_batch", (Object)"true");
            baseShowParameter.setCustomParam("from", (Object)"epa_targetformulated");
            baseShowParameter.setStatus(OperationStatus.VIEW);
            String pageId = "epa_targetformulated_" + this.getFocusRowPkId();
            baseShowParameter.setPageId(pageId);
            this.getView().showForm((FormShowParameter)baseShowParameter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (!MessageBoxResult.Yes.equals((Object)result)) {
            return;
        }
        switch (callBackId) {
            case "reset": {
                if (!this.checkActivityPermission()) break;
                OperateOption resetOp = OperateOption.create();
                resetOp.setVariableValue("systeminvoke", "true");
                resetOp.setVariableValue("OP_SOURCE", ProcessManageApEnum.TARGET_FORMULATED.getFormId());
                this.getView().invokeOperation("reset", resetOp);
                break;
            }
        }
    }

    private boolean checkActivityPermission() {
        boolean isPass = OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_activity", (String)"37LTQSOQE94P");
        if (!isPass) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8003\u6838\u6d3b\u52a8\u7684\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u6743\u9650", (String)"TargetFormulatedList_12", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
        return isPass;
    }
}

