/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.targetformulate;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.ProcessManageApEnum;
import kd.opmc.epa.business.domain.perfworkflow.service.PerfWorkFlowDomainService;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;
import kd.opmc.epa.common.enums.activitymanage.AssFormatEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.formplugin.web.activitymanage.actevalobj.EvalObjBaseList;
import kd.opmc.epa.formplugin.web.utils.ActManageUtils;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.common.utils.OpmcPermissionUtils;

public class TargetFormulatingList
extends EvalObjBaseList {
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY_SERVICE = ExecuteSchemeEntityService.getInstance();
    private static final ActivityEvaluationObjectApplicationService EVALUATION_OBJECT_APPLICATION_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();
    private Map<Long, Map<String, String>> CUR_NODE_MAP = new HashMap<Long, Map<String, String>>(16);
    private static final PerfWorkFlowDomainService PERF_WORK_FLOW_DOMAIN_SERVICE = PerfWorkFlowDomainService.getInstance();
    private static final String FORMULATE_PROCESS_AP = "formulateprocessap";
    private static final String FORMULATEP_ROCESS_AB = "formulateprocessab";
    private static final String FLOWRU_MONITOR = "flowrumonitor";
    private static final String PBS_FLOWRUMONITOR = "pbs_flowrumonitor";
    private static final String SEND_FORMULATETASK_AP = "sendformulatetaskap";
    private static final String SEND_FORMULATETASK_AB = "sendformulatetaskab";
    private static final String FORMULATE_FLOW_INFO = "formulateflowinfo";
    private Map<Long, String> EVALUATOR_MAP = new HashMap<Long, String>(16);
    private Map<Long, Long> EVAL_FLOW_MAP = new HashMap<Long, Long>(16);
    private static final String WAITTING_SEND = "waittingsend";
    private static final String WAITTING_IDS = "waittingIds";
    private List<Long> ACTOBJ_IDS = new ArrayList<Long>(10);

    public void setFormulateLowInfo(PackageDataEvent evt) {
        DynamicObject rowData;
        DynamicTextColumnDesc columnDesc;
        Object source = evt.getSource();
        if (source instanceof DynamicTextColumnDesc && FORMULATE_FLOW_INFO.equals((columnDesc = (DynamicTextColumnDesc)source).getKey()) && (rowData = evt.getRowData()) != null && !this.EVALUATOR_MAP.isEmpty()) {
            Long id = rowData.getLong("id");
            String formulator = this.EVALUATOR_MAP.get(this.EVAL_FLOW_MAP.get(id));
            evt.setFormatValue((Object)formulator);
        }
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{FORMULATE_PROCESS_AP, FORMULATEP_ROCESS_AB, SEND_FORMULATETASK_AP, SEND_FORMULATETASK_AB, FLOWRU_MONITOR});
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("indigroup.name".equals(fieldName)) {
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            List qFilters = args.getQfilters();
            qFilters.add(new QFilter("activity", "=", (Object)activityId));
        } else if ("formulateflow.name".equals(fieldName)) {
            List qFilters = args.getQfilters();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long activityId = (Long)customParams.get("activity");
            DynamicObject activityDy = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
            List ids = PERF_WORK_FLOW_DOMAIN_SERVICE.queryFlowById(activityDy.getLong("perfworkflow.id"), "1");
            if (CollectionUtils.isEmpty((Collection)ids)) {
                return;
            }
            qFilters.add(new QFilter("id", "in", (Object)ids));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "formulateprocessap": 
            case "formulateprocessab": {
                this.getView().invokeOperation("formulateprocess");
                break;
            }
            case "sendformulatetaskap": 
            case "sendformulatetaskab": {
                this.showSendFormulateTaskView();
                break;
            }
        }
    }

    private void jump2FlowrumonitorList() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setBillFormId(PBS_FLOWRUMONITOR);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long activityId = (Long)customParams.get("activity");
        parameter.setCustomParam("activityid", (Object)activityId);
        parameter.setHasRight(true);
        parameter.setCustomParam("flowType", (Object)"targetformulate");
        parameter.setPageId(PBS_FLOWRUMONITOR + this.getView().getPageId());
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showSendFormulateTaskView() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Map flowMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFormulatingFlowsMap(activityId);
        DynamicObject[] flows = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFlowByPkValue(flowMap.keySet());
        if (Objects.isNull(flows) || flows.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"TargetFormulatingList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        int nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        FormShowParameter baseShowParameter = new FormShowParameter();
        baseShowParameter.setFormId("epa_evaltaskmanage");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setPageId("epa_evaltaskmanage" + this.getView().getPageId());
        baseShowParameter.setCustomParam("activity", (Object)activityId);
        baseShowParameter.setCustomParam("nodeindex", (Object)nodeIndex);
        String caption = ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5236\u5b9a\u4efb\u52a1\u7ba1\u7406", (String)"TargetFormulatingList_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]), (String)"TargetFormulatingList_6", (String)"opmc-epa-formplugin").getLocaleValue();
        baseShowParameter.setCaption(caption);
        this.getView().showForm(baseShowParameter);
    }

    public void setFilter(SetFilterEvent filterEvent) {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        QFilter filter = new QFilter("activity", "=", (Object)activityId).and("nodestatus", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getStatus()).and("assessnode", "=", (Object)Long.valueOf(ProcessManageApEnum.TARGET_FORMULATING.getLabId())).and("nodeindex", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId());
        List qFilters = filterEvent.getQFilters();
        qFilters.add(filter);
        QFilter flowFilter = null;
        QFilter actIdFilter = null;
        for (QFilter qFilter : qFilters) {
            if (WAITTING_SEND.equals(qFilter.getProperty())) {
                Object value = qFilter.getValue();
                if (!(value instanceof String)) continue;
                String qcp = "1".equals(value) ? "in" : "not in";
                String ids = this.getView().getPageCache().get(WAITTING_IDS);
                List idList = JSONObject.parseArray((String)ids, Long.class);
                actIdFilter = new QFilter("id", qcp, (Object)idList);
                continue;
            }
            if (!HRStringUtils.equals((String)qFilter.getProperty(), (String)"formulateflow.id")) continue;
            flowFilter = new QFilter("formulateflow.boid", qFilter.getCP(), qFilter.getValue());
        }
        qFilters.removeIf(xf -> "formulateflow.id".equals(xf.getProperty()));
        qFilters.removeIf(xf -> WAITTING_SEND.equals(xf.getProperty()));
        if (!Objects.isNull(flowFilter)) {
            filterEvent.getQFilters().add(flowFilter);
        }
        if (!Objects.isNull(actIdFilter)) {
            qFilters.add(actIdFilter);
        }
    }

    public void beforePackageData(BeforePackageDataEvent dataEvent) {
        DynamicObjectCollection pageData = dataEvent.getPageData();
        boolean selectedAllRows = ((ListModel)dataEvent.getSource()).isSelectedAllRows();
        if (!pageData.isEmpty() && !selectedAllRows) {
            this.EVAL_FLOW_MAP = new HashMap<Long, Long>(16);
            List actObjIds = pageData.stream().map(actObj -> actObj.getLong("id")).collect(Collectors.toList());
            this.CUR_NODE_MAP = EVALUATION_OBJECT_APPLICATION_SERVICE.queryEvaluatingCurNodeByObjIds(actObjIds, AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId().longValue());
            Map objectMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryEvalObjById(actObjIds);
            ArrayList<Long> flowInsIds = new ArrayList<Long>(16);
            for (DynamicObject datum : pageData) {
                DynamicObject dynamicObject = (DynamicObject)objectMap.get(datum.getLong("id"));
                if (HRObjectUtils.isEmpty((Object)dynamicObject)) continue;
                this.EVAL_FLOW_MAP.put(datum.getLong("id"), dynamicObject.getLong("formulateflowins.id"));
                flowInsIds.add(dynamicObject.getLong("formulateflowins.id"));
            }
            if (!flowInsIds.isEmpty()) {
                this.EVALUATOR_MAP = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getFlowInfo(flowInsIds);
            }
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            this.ACTOBJ_IDS = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getWaittingSendByActivityId(activityId);
            this.getView().getPageCache().put(WAITTING_IDS, this.ACTOBJ_IDS.toString());
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        String assFormat = this.getAssFormat();
        if (HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.WEIGHTING.getCode())) {
            args.getListColumns().removeIf(column -> HRStringUtils.equals((String)column.getListFieldKey(), (String)"assscore"));
        } else if (HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.ADD_NEWER.getCode())) {
            args.getListColumns().removeIf(column -> HRStringUtils.equals((String)column.getListFieldKey(), (String)"assweight"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("formulateprocess".equals(operateKey)) {
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            boolean exists = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.isExistsFormulateMonitorEvaObjByActivityId(activityId);
            if (!exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u3002", (String)"TargetFormulatingList_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("reset".equals(operateKey)) {
            this.beforeResetOp(args);
        } else if ("urging".equals(operateKey)) {
            this.handleUrging(args);
        } else if (FLOWRU_MONITOR.equals(operateKey)) {
            this.jump2FlowrumonitorList();
        }
    }

    private void handleUrging(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows;
        int size;
        AbstractOperate source = (AbstractOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        if (!HRStringUtils.equals((String)systemInvoke, (String)"true") && (size = (selectedRows = this.getSelectedRows()).size()) > 0) {
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u4f60\u5df2\u7ecf\u9009\u62e9{0}\u4eba\uff0c\u70b9\u51fb\u201d\u50ac\u529e\u201c\u5c06\u53d1\u9001\u6d88\u606f\u7ed9\u5bf9\u5e94\u6267\u884c\u4e2d\u7684\u5904\u7406\u4eba\u3002\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u50ac\u529e\uff1f", (String)"TargetFormulatingList_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]), this.getSelectedRows().size(), size);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("urging", (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    private void beforeResetOp(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows;
        int size;
        AbstractOperate source = (AbstractOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        if (!HRStringUtils.equals((String)systemInvoke, (String)"true") && (size = (selectedRows = this.getSelectedRows()).size()) > 0) {
            String msg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u60a8\u5df2\u9009\u62e9{0}\u4eba\uff0c\u91cd\u7f6e\u540e\uff0c\u5236\u5b9a\u5bf9\u8c61\u5c06\u9000\u56de\u81f3\u5f85\u5236\u5b9a\uff0c\u901a\u8fc7\u5236\u5b9a\u6d41\u7a0b\u5236\u5b9a\u7684\u6307\u6807\u53ca\u624b\u52a8\u8bbe\u7f6e\u7684\u5236\u5b9a\u4eba\u5c06\u88ab\u4fdd\u7559\uff0c\u786e\u5b9a\u662f\u5426\u91cd\u7f6e\uff1f", (String)"TargetFormulatingList_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{size}));
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("reset", (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "formulateprocess": {
                this.showFormulateProcessPage();
                break;
            }
            case "refresh": {
                Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
                ActManageUtils.refreshFormulatedCount(this.getView(), activityId);
                break;
            }
            case "reset": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void showFormulateProcessPage() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        FormShowParameter baseShowParameter = new FormShowParameter();
        baseShowParameter.setFormId("epa_formulateprocess");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.EDIT);
        baseShowParameter.setPageId("epa_formulateprocess" + this.getView().getPageId());
        baseShowParameter.setCustomParam("activity", (Object)activityId);
        baseShowParameter.setCustomParam("objectscope", this.getView().getFormShowParameter().getCustomParam("objectscope"));
        this.getView().showForm(baseShowParameter);
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        Object source = evt.getSource();
        if (source instanceof DynamicTextColumnDesc) {
            DynamicTextColumnDesc columnDesc = (DynamicTextColumnDesc)source;
            Map<String, String> map = this.CUR_NODE_MAP.get(evt.getRowData().getLong("id"));
            switch (columnDesc.getKey()) {
                case "duration": {
                    if (map == null) break;
                    evt.setFormatValue((Object)map.get("duration"));
                    break;
                }
                case "currenthandler": {
                    if (map == null) break;
                    evt.setFormatValue((Object)map.get("currenthandler"));
                    break;
                }
                case "formulateflowinfo": {
                    this.setFormulateLowInfo(evt);
                    break;
                }
            }
        } else {
            String key = ((AbstractColumnDesc)evt.getSource()).getKey();
            if (WAITTING_SEND.equals(key)) {
                Long id = evt.getRowData().getLong("id");
                Integer value = this.ACTOBJ_IDS.contains(id) ? 1 : 0;
                evt.setFormatValue((Object)value);
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        String fieldName = event.getFieldName();
        if (HRStringUtils.equals((String)fieldName, (String)"perffile_name")) {
            args.setCancel(true);
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            baseShowParameter.setPkId(this.getFocusRowPkId());
            baseShowParameter.setFormId("epa_indicator_single");
            baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            baseShowParameter.setCustomParam("is_batch", (Object)"true");
            baseShowParameter.setCustomParam("from", (Object)"epa_targetformulating");
            baseShowParameter.setStatus(OperationStatus.VIEW);
            String pageId = "epa_targetformulating_" + this.getFocusRowPkId();
            baseShowParameter.setPageId(pageId);
            this.getView().showForm((FormShowParameter)baseShowParameter);
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String assFormat = this.getAssFormat();
        if (HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.WEIGHTING.getCode())) {
            args.getSchemeFilterColumns().removeIf(schemeFilter -> HRStringUtils.equals((String)schemeFilter.getFieldName(), (String)"assscore"));
        } else if (HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.ADD_NEWER.getCode())) {
            args.getSchemeFilterColumns().removeIf(schemeFilter -> HRStringUtils.equals((String)schemeFilter.getFieldName(), (String)"assweight"));
        }
    }

    private String getAssFormat() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        return ASSESS_ACTIVITY_APPLICATION_SERVICE.queryAssFormatByActId(activityId);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (!MessageBoxResult.Yes.equals((Object)result)) {
            return;
        }
        switch (callBackId) {
            case "reset": {
                if (!this.checkActivityPermission()) break;
                OperateOption resetOp = OperateOption.create();
                resetOp.setVariableValue("systeminvoke", "true");
                resetOp.setVariableValue("OP_SOURCE", ProcessManageApEnum.TARGET_FORMULATING.getFormId());
                this.getView().invokeOperation("reset", resetOp);
                break;
            }
            case "urging": {
                if (!this.checkActivityPermission()) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("systeminvoke", "true");
                this.getView().invokeOperation("urging", operateOption);
                break;
            }
        }
    }

    private boolean checkActivityPermission() {
        boolean isPass = OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_activity", (String)"37LTQSOQE94P");
        if (!isPass) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8003\u6838\u6d3b\u52a8\u7684\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u6743\u9650", (String)"TargetFormulatingList_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
        return isPass;
    }
}

