/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.targetformulate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.activity.enums.ActivityStatusEnum;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.indicator.entityservice.IndicatorGroupEntityService;
import kd.opmc.epa.business.domain.perfworkflow.service.PerfWorkFlowDomainService;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;
import kd.opmc.epa.business.task.CopyHisIndicatorTask;
import kd.opmc.epa.business.task.StartFormulateTask;
import kd.opmc.epa.business.task.UnifiedDistTask;
import kd.opmc.epa.business.utils.EvalObjUtils;
import kd.opmc.epa.common.enums.activitymanage.AssFormatEnum;
import kd.opmc.epa.common.utils.DispatchUtil;
import kd.opmc.epa.formplugin.web.activitymanage.actevalobj.EvalObjBaseList;
import kd.opmc.epa.formplugin.web.utils.ActManageUtils;
import kd.opmc.epa.formplugin.web.utils.AssignIndicatorPageUtils;
import kd.opmc.epa.formplugin.web.utils.permission.ProcessExecutePermissionUtils;

public class TobeFormulateList
extends EvalObjBaseList {
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ActivityEvaluationObjectDomainService OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY_SERVICE = ExecuteSchemeEntityService.getInstance();
    private static final ActivityEvaluationObjectEntityService ACTIVITY_EVALUATION_OBJECT_ENTITY = ActivityEvaluationObjectEntityService.getInstance();
    private static final IndicatorGroupEntityService INDICATOR_GROUP_ENTITY_SERVICE = new IndicatorGroupEntityService();
    private static final PerfWorkFlowDomainService PERF_WORK_FLOW_DOMAIN_SERVICE = PerfWorkFlowDomainService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final String SET_FORMULATOR_AP = "setformulatorap";
    private static final String SET_FORMULATOR_AB = "setformulatorab";
    private static final String GROUP_FORMULATE_AP = "groupformulateap";
    private static final String GROUP_FORMULATE_AB = "groupformulateab";
    private static final String FORMULATE_FLOW_INFO = "formulateflowinfo";
    private Map<Long, String> EVALUATOR_MAP = new HashMap<Long, String>(16);
    private final Map<Long, Long> EVAL_FLOW_MAP = new HashMap<Long, Long>(16);
    private static final String EPA_COPYHISINDECATOLISTF7 = "epa_copyhisindecatolistf7";
    private static final String EPA_COPYHISACTIVITY = "epa_copyhisactivity";

    public void beforePackageData(BeforePackageDataEvent event) {
        super.beforePackageData(event);
        DynamicObjectCollection pageData = event.getPageData();
        boolean selectedAllRows = ((ListModel)event.getSource()).isSelectedAllRows();
        if (!pageData.isEmpty() && !selectedAllRows) {
            List objIds = pageData.stream().map(actObj -> actObj.getLong("id")).collect(Collectors.toList());
            Map objectMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryEvalObjById(objIds);
            ArrayList<Long> flowInsIds = new ArrayList<Long>(16);
            for (DynamicObject datum : pageData) {
                DynamicObject dynamicObject = (DynamicObject)objectMap.get(datum.getLong("id"));
                if (HRObjectUtils.isEmpty((Object)dynamicObject)) continue;
                this.EVAL_FLOW_MAP.put(datum.getLong("id"), dynamicObject.getLong("formulateflowins.id"));
                flowInsIds.add(dynamicObject.getLong("formulateflowins.id"));
            }
            if (!flowInsIds.isEmpty()) {
                this.EVALUATOR_MAP = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getFlowInfo(flowInsIds);
            }
        }
    }

    public void packageData(PackageDataEvent evt) {
        DynamicObject rowData;
        DynamicTextColumnDesc columnDesc;
        super.packageData(evt);
        Object source = evt.getSource();
        if (source instanceof DynamicTextColumnDesc && FORMULATE_FLOW_INFO.equals((columnDesc = (DynamicTextColumnDesc)source).getKey()) && (rowData = evt.getRowData()) != null && !this.EVALUATOR_MAP.isEmpty()) {
            Long id = rowData.getLong("id");
            String formulator = this.EVALUATOR_MAP.get(this.EVAL_FLOW_MAP.get(id));
            evt.setFormatValue((Object)formulator);
        }
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{SET_FORMULATOR_AP, SET_FORMULATOR_AB, GROUP_FORMULATE_AP, GROUP_FORMULATE_AB});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (SET_FORMULATOR_AP.equals(source.getKey()) || SET_FORMULATOR_AB.equals(source.getKey())) {
            this.getView().invokeOperation("sethandler");
        } else if (GROUP_FORMULATE_AP.equals(source.getKey()) || GROUP_FORMULATE_AB.equals(source.getKey())) {
            this.getView().invokeOperation("indicatorgroupset");
        }
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("indigroup.name".equals(fieldName)) {
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            List qFilters = args.getQfilters();
            qFilters.add(new QFilter("activity", "=", (Object)activityId));
        } else if ("formulateflow.name".equals(fieldName)) {
            List qFilters = args.getQfilters();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long activityId = (Long)customParams.get("activity");
            DynamicObject activityDy = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
            List ids = PERF_WORK_FLOW_DOMAIN_SERVICE.queryFlowById(activityDy.getLong("perfworkflow.id"), "1");
            if (CollectionUtils.isEmpty((Collection)ids)) {
                return;
            }
            qFilters.add(new QFilter("id", "in", (Object)ids));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        String fieldName = event.getFieldName();
        if (HRStringUtils.equals((String)fieldName, (String)"perffile_name")) {
            args.setCancel(true);
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            baseShowParameter.setPkId(this.getFocusRowPkId());
            baseShowParameter.setFormId("epa_indicator_single");
            baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            baseShowParameter.setCustomParam("is_batch", (Object)"true");
            baseShowParameter.setCustomParam("from", (Object)"epa_tobetargetformulate");
            baseShowParameter.setStatus(OperationStatus.EDIT);
            String pageId = "epa_tobetargetformulate_" + this.getFocusRowPkId();
            baseShowParameter.setPageId(pageId);
            this.getView().showForm((FormShowParameter)baseShowParameter);
        }
    }

    public void setFilter(SetFilterEvent filterEvent) {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        QFilter filter = new QFilter("activity", "=", (Object)activityId).and("assessstaus", "=", (Object)AssessStausEnum.JOINED.getStatus());
        List qFilters = filterEvent.getQFilters();
        QFilter flowFilter = null;
        for (int index = 0; index < qFilters.size(); ++index) {
            QFilter qfiter = (QFilter)qFilters.get(index);
            if (!HRStringUtils.equals((String)qfiter.getProperty(), (String)"formulateflow.id")) continue;
            flowFilter = new QFilter("formulateflow.boid", qfiter.getCP(), qfiter.getValue());
            qFilters.remove(index);
            break;
        }
        if (!Objects.isNull(flowFilter)) {
            filterEvent.getQFilters().add(flowFilter);
        }
        filterEvent.getQFilters().add(filter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        String groupName = AssignIndicatorPageUtils.getIndicatorGroupMetaName();
        block7 : switch (operateKey) {
            case "groupsetting": {
                String isSystemInvoke = this.getView().getPageCache().get("systeminvoke");
                if (HRStringUtils.isEmpty((String)isSystemInvoke) || !HRStringUtils.equals((String)isSystemInvoke, (String)"true")) {
                    args.setCancel(true);
                    this.showGroupSettingPage();
                    break;
                }
                DynamicObject[] evalObjs = this.getEvaluationObjects();
                long count = Arrays.stream(evalObjs).filter(evalObj -> !ObjectUtils.isEmpty((Object)evalObj.getDynamicObject("indigroup"))).count();
                if (count > 0L) {
                    String msg = ResManager.loadKDString((String)"\u6240\u9009\u4e2d\u7684{0}\u4e2a\u5236\u5b9a\u5bf9\u8c61\uff0c\u5176\u4e2d{1}\u4e2a\u5bf9\u8c61\u5df2\u6709{2}\uff0c\u5982\u679c\u53d8\u66f4\uff0c\u539f\u6709\u5df2\u5236\u5b9a\u6307\u6807\u5c06\u66f4\u65b0\u4e3a\u65b0{3}\u7684\u6307\u6807\uff0c\u786e\u5b9a\u91cd\u65b0\u6307\u5b9a{4}\u5417\uff1f", (String)"TobeFormulateList_0", (String)"opmc-epa-formplugin", (Object[])new Object[]{this.getSelectedRows().size(), count, groupName, groupName, groupName});
                    this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
                    args.setCancel(true);
                }
                this.getView().getPageCache().put("systeminvoke", "false");
                source.getOption().setVariableValue("batchop_batchsize", "0");
                break;
            }
            case "changeprocess": {
                Object[] evaluationObjects = this.getEvaluationObjects();
                if (ObjectUtils.isEmpty((Object[])evaluationObjects)) {
                    return;
                }
                for (Object evaluationObj : evaluationObjects) {
                    String activityStatus = evaluationObj.getString("activity.activitystatus");
                    if (!HRStringUtils.equals((String)activityStatus, (String)AssessStausEnum.Exited.getStatus())) continue;
                    String errMsg = ResManager.loadKDString((String)"\u8003\u6838\u6d3b\u52a8\u5df2\u7ed3\u675f\uff0c\u8be5\u529f\u80fd\u4e0d\u53ef\u7528", (String)"TobeFormulateList_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(errMsg);
                    args.setCancel(true);
                    break block7;
                }
                break;
            }
            case "sethandler": {
                Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
                Object[] objects = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryToBeFormulateObjs(activityId);
                if (ObjectUtils.isEmpty((Object[])objects)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"TobeFormulateList_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                boolean allMatch = Arrays.stream(objects).allMatch(obj -> ObjectUtils.isEmpty((Object)obj.getDynamicObject("formulateflow")));
                if (!allMatch) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5217\u8868\u5236\u5b9a\u5bf9\u8c61\u5747\u65e0\u6307\u6807\u5236\u5b9a\u6d41\u7a0b\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u5236\u5b9a\u4eba\u3002", (String)"TobeFormulateList_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "groupdelete": {
                if (!HRStringUtils.isEmpty((String)this.getPageCache().get("groupdelete"))) break;
                args.setCancel(true);
                String msg = ResManager.loadKDString((String)"\u60a8\u5df2\u52fe\u9009{0}\u4e2a\u5236\u5b9a\u5bf9\u8c61\uff0c\u901a\u8fc7{1}\u7684\u6307\u6807\u6d3e\u53d1\u7684\u6307\u6807\u5c06\u88ab\u5220\u9664\uff0c\u786e\u5b9a\u64cd\u4f5c\u5417\uff1f", (String)"TobeFormulateList_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{this.getSelectedRows().size(), groupName});
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("groupdelete", (IFormPlugin)this));
                break;
            }
            case "copyhisindicator": {
                break;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Long[] evalObjectIdList = (Long[])Arrays.stream(selectedRows.getPrimaryKeyValues()).map(row -> Long.parseLong(row.toString())).toArray(Long[]::new);
        params.put("evalObjectIds", evalObjectIdList);
        int nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        params.put("nodeindex", nodeIndex);
        switch (operateKey) {
            case "groupdelete": {
                this.deleteIndicator();
                this.getView().getPageCache().remove("groupdelete");
                break;
            }
            case "indicatorgroupset": {
                this.showIndicatorGroupSetPage();
                break;
            }
            case "groupsetting": {
                this.groupSetting();
                break;
            }
            case "changeprocess": {
                Object[] evaluationObjectList = this.getEvaluationObjects();
                if (ObjectUtils.isEmpty((Object[])evaluationObjectList)) {
                    return;
                }
                DynamicObject activityDy = evaluationObjectList[0].getDynamicObject("activity");
                long perfworkflow = activityDy.getLong("perfworkflow.id");
                this.showAssFlowPage(perfworkflow);
                break;
            }
            case "refresh": {
                Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
                ActManageUtils.refreshFormulatedCount(this.getView(), activityId);
                break;
            }
            case "sethandler": {
                this.showSetHandlerPage();
                break;
            }
            case "unifieddist": {
                DispatchUtil.dispatch((AbstractFormPlugin)this, params, (String)UnifiedDistTask.class.getName(), (String)ResManager.loadKDString((String)"\u7edf\u4e00\u6d3e\u53d1", (String)"TobeFormulateList_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]), (boolean)false, (String)"unifieddist");
                break;
            }
            case "startprocess": {
                DispatchUtil.dispatch((AbstractFormPlugin)this, params, (String)StartFormulateTask.class.getName(), (String)ResManager.loadKDString((String)"\u542f\u52a8\u5236\u5b9a\u6d41\u7a0b", (String)"TobeFormulateList_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]), (boolean)true, (String)"startprocess");
                break;
            }
            case "copyhisindicator": {
                this.showCopyHisIndicate();
                break;
            }
        }
    }

    private void showCopyHisIndicate() {
        this.getPageCache().remove("copyhisindicator");
        Object[] evaluationObjects = this.getEvaluationObjects();
        if (HRArrayUtils.isEmpty((Object[])evaluationObjects)) {
            return;
        }
        Object dynamicObject = evaluationObjects[0];
        DynamicObject activity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)dynamicObject.getLong("activity.id"));
        if (HRObjectUtils.isEmpty((Object)activity)) {
            return;
        }
        QFilter qFilter = new QFilter("scheme", "=", (Object)activity.getLong("scheme.id"));
        qFilter.and("id", "!=", (Object)activity.getLong("id"));
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getListFilterParameter().setFilter(qFilter);
        listShowParameter.setBillFormId(EPA_COPYHISACTIVITY);
        listShowParameter.setFormId(EPA_COPYHISINDECATOLISTF7);
        listShowParameter.setCustomParam("selectIds", (Object)JSON.toJSONString((Object)this.getSelectedRows().getPrimaryKeyValues()));
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960");
        styleCss.setHeight("580");
        listShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "copyhisindicator"));
        listShowParameter.setLookUp(true);
        listShowParameter.setShowTitle(false);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void deleteIndicator() {
        Object[] evaluationObjectList = this.getEvaluationObjects();
        if (ObjectUtils.isEmpty((Object[])evaluationObjectList)) {
            return;
        }
        ArrayList<Object> successObj = new ArrayList<Object>(16);
        ArrayList<String> errorMsg = new ArrayList<String>(16);
        String groupName = AssignIndicatorPageUtils.getIndicatorGroupMetaName();
        for (Object dynamicObject : evaluationObjectList) {
            if (HRObjectUtils.isEmpty((Object)dynamicObject.getDynamicObject("indigroup"))) {
                errorMsg.add(ResManager.loadKDString((String)"{0} {1}\uff1a\u8be5\u5236\u5b9a\u5bf9\u8c61\u65e0{2}\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"TobeFormulateList_7", (String)"opmc-epa-formplugin", (Object[])new Object[]{dynamicObject.getString("perffile.name"), dynamicObject.getString("perffile.billno"), groupName}));
                continue;
            }
            if (!HRStringUtils.equals((String)dynamicObject.getString("assessstaus"), (String)AssessStausEnum.JOINED.getStatus())) {
                errorMsg.add(ResManager.loadKDString((String)"{0} {1}\uff1a\u5236\u5b9a\u5bf9\u8c61\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u5f85\u5236\u5b9a\u201d\uff0c\u4e0d\u80fd\u5220\u9664{2}\u3002", (String)"TobeFormulateList_8", (String)"opmc-epa-formplugin", (Object[])new Object[]{dynamicObject.getString("perffile.name"), dynamicObject.getString("perffile.billno"), groupName}));
                continue;
            }
            successObj.add(dynamicObject);
        }
        if (successObj.size() > 0) {
            EVALUATION_OBJECT_DOMAIN_SERVICE.deletePreinstallIndicator(successObj.stream().map(evalObj -> evalObj.getLong("id")).collect(Collectors.toList()));
        }
        if (evaluationObjectList.length == 1) {
            if (successObj.size() == 1) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664{0}\u6210\u529f\u3002", (String)"TobeFormulateList_9", (String)"opmc-epa-formplugin", (Object[])new Object[]{groupName}));
            }
            if (errorMsg.size() == 1) {
                this.getView().showErrorNotification((String)errorMsg.get(0));
            }
        } else {
            String title = ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u5220\u9664{1}\u6210\u529f{2}\u6761\uff0c\u5931\u8d25{3}\u6761", (String)"TobeFormulateList_10", (String)"opmc-epa-formplugin", (Object[])new Object[]{evaluationObjectList.length, groupName, successObj.size(), errorMsg.size()});
            String msg = String.join((CharSequence)"\n", errorMsg);
            this.getView().showMessage(title, msg, MessageTypes.Default);
        }
        IFormView parentView = this.getView().getParentView();
        this.getView().invokeOperation("refresh");
        parentView.sendFormAction(this.getView());
        this.getView().sendFormAction(parentView);
    }

    private void groupSetting() {
        Object[] evaluationObjectList = this.getEvaluationObjects();
        if (ObjectUtils.isEmpty((Object[])evaluationObjectList)) {
            return;
        }
        ArrayList<Object> successObj = new ArrayList<Object>(16);
        ArrayList<String> errorMsg = new ArrayList<String>(16);
        String groupName = AssignIndicatorPageUtils.getIndicatorGroupMetaName();
        for (Object dynamicObject : evaluationObjectList) {
            if (!HRStringUtils.equals((String)dynamicObject.getString("assessstaus"), (String)AssessStausEnum.JOINED.getStatus())) {
                errorMsg.add(ResManager.loadKDString((String)"{0} {1}\uff1a\u5236\u5b9a\u5bf9\u8c61\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u5f85\u5236\u5b9a\u201d\uff0c\u4e0d\u80fd\u6307\u5b9a{2}\u3002", (String)"TobeFormulateList_11", (String)"opmc-epa-formplugin", (Object[])new Object[]{dynamicObject.getString("perffile.name"), dynamicObject.getString("perffile.billno"), groupName}));
                continue;
            }
            successObj.add(dynamicObject);
        }
        if (successObj.size() > 0) {
            String indicatorGroupId = this.getView().getPageCache().get("indicatorGroupId");
            DynamicObject indiGroup = INDICATOR_GROUP_ENTITY_SERVICE.queryOne((Object)indicatorGroupId);
            OBJECT_DOMAIN_SERVICE.initEvalObjAssessTableFromIndicatorGroup(indiGroup, successObj.toArray(new DynamicObject[0]));
        }
        if (evaluationObjectList.length == 1) {
            if (successObj.size() == 1) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6307\u5b9a{0}\u6210\u529f", (String)"TobeFormulateList_12", (String)"opmc-epa-formplugin", (Object[])new Object[]{groupName}));
            }
            if (errorMsg.size() == 1) {
                this.getView().showErrorNotification((String)errorMsg.get(0));
            }
        } else {
            String title = ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u6307\u5b9a{1}\u6210\u529f{2}\u6761\uff0c\u5931\u8d25{3}\u6761", (String)"TobeFormulateList_13", (String)"opmc-epa-formplugin", (Object[])new Object[]{evaluationObjectList.length, groupName, successObj.size(), errorMsg.size()});
            String msg = String.join((CharSequence)"\n", errorMsg);
            this.getView().showMessage(title, msg, MessageTypes.Default);
        }
        IFormView parentView = this.getView().getParentView();
        this.getView().invokeOperation("refresh");
        parentView.sendFormAction(this.getView());
        this.getView().sendFormAction(parentView);
    }

    private void showSetHandlerPage() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        FormShowParameter baseShowParameter = new FormShowParameter();
        baseShowParameter.setFormId("epa_sethandler");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.EDIT);
        baseShowParameter.setPageId("epa_sethandler" + this.getView().getPageId());
        baseShowParameter.setCustomParam("activity", (Object)activityId);
        this.getView().showForm(baseShowParameter);
    }

    private void showAssFlowPage(long perfWorkFlowId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("epa_changeassgroupflow");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.getCustomParams().put("perfWorkFlowId", perfWorkFlowId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_changeassgroupflow"));
        this.getView().showForm(parameter);
    }

    private void showIndicatorGroupSetPage() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setPageId("indicatorgroup_page_id" + this.getView().getPageId());
        parameter.setFormId("epa_indicatorgroupset");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("activityid", (Object)activityId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "indicatorgroupset"));
        this.getView().showForm(parameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            switch (callBackId) {
                case "groupsetting": {
                    this.groupSetting();
                    break;
                }
                case "groupdelete": {
                    this.getPageCache().put("groupdelete", "true");
                    this.getView().invokeOperation("groupdelete");
                    break;
                }
                case "copyhisindicator": {
                    this.getPageCache().put("copyhisindicator", "true");
                    this.getView().invokeOperation("copyhisindicator");
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if ("copyhisindicator".equals(actionId) && returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)returnData;
            Object[] primaryKeyValues = listSelectedRowCollection.getPrimaryKeyValues();
            if (HRArrayUtils.isNotEmpty((Object[])primaryKeyValues)) {
                Long copyActId = (Long)primaryKeyValues[0];
                HashMap<String, String> params = new HashMap<String, String>(16);
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                params.put("evalObjectIds", SerializationUtils.serializeToBase64((Object)selectedRows.getPrimaryKeyValues()));
                params.put("copyActId", SerializationUtils.serializeToBase64((Object)copyActId));
                Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
                params.put("fromActId", SerializationUtils.serializeToBase64((Object)activityId));
                DispatchUtil.dispatch((AbstractFormPlugin)this, params, (String)CopyHisIndicatorTask.class.getName(), (String)ResManager.loadKDString((String)"\u590d\u5236\u5386\u53f2\u6307\u6807", (String)"TobeFormulateList_14", (String)"opmc-epa-formplugin", (Object[])new Object[0]), (boolean)true, (String)"copyhisindicatorback");
            }
            return;
        }
        Map<String, Object> returnMap = this.getReturnMap(returnData);
        if (returnMap == null) {
            return;
        }
        boolean permission = ProcessExecutePermissionUtils.checkPermission(this.getView());
        if (!permission) {
            return;
        }
        switch (actionId) {
            case "unifieddist": 
            case "startprocess": {
                this.taskCallBack(returnMap, "unifieddist");
                break;
            }
            case "epa_changeassgroupflow": {
                this.changeAssessGroupFLow(returnMap);
                break;
            }
            case "groupsetting": {
                String opKey = (String)returnMap.keySet().toArray()[0];
                if (opKey.equals("addgroup")) {
                    this.showIndicatorGroupSetPage();
                    break;
                }
                IPageCache pageCache = this.getView().getPageCache();
                pageCache.put("systeminvoke", "true");
                Long indicatorGroupId = (Long)returnMap.values().toArray()[0];
                pageCache.put("indicatorGroupId", String.valueOf(indicatorGroupId));
                this.getView().invokeOperation("groupsetting");
                break;
            }
            case "copyhisindicatorback": {
                this.showCopyHisIndicator(returnMap);
                break;
            }
        }
    }

    private void showCopyHisIndicator(Map<String, Object> resultMap) {
        if (!resultMap.containsKey("taskinfo")) {
            return;
        }
        JSONObject taskInfo = JSONObject.parseObject((String)String.valueOf(resultMap.get("taskinfo")));
        JSONObject resultDate = JSONObject.parseObject((String)((String)taskInfo.get((Object)"data")));
        List msGs = (List)resultDate.get((Object)"msgList");
        Integer success = (Integer)resultDate.get((Object)"success");
        Integer halfSuccess = (Integer)resultDate.get((Object)"halfsuccess");
        Integer fail = (Integer)resultDate.get((Object)"fail");
        Integer total = (Integer)resultDate.get((Object)"total");
        IFormView view = this.getView();
        String text = halfSuccess == null || halfSuccess == 0 ? ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u590d\u5236\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"TobeFormulateList_15", (String)"opmc-epa-formplugin", (Object[])new Object[]{total, success, fail}) : ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u590d\u5236\u6210\u529f{1}\u6761\uff0c\u90e8\u5206\u6210\u529f\u90e8\u5206\u5931\u8d25{2}\u6761\uff0c\u5931\u8d25{3}\u6761", (String)"TobeFormulateList_16", (String)"opmc-epa-formplugin", (Object[])new Object[]{total, success, halfSuccess, fail});
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("epa_indicatorcopyresult");
        formShowParameter.setCustomParam("title", (Object)text);
        formShowParameter.setCustomParam("msgs", (Object)JSON.toJSONString((Object)msGs));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setHasRight(true);
        this.getView().showForm(formShowParameter);
        view.invokeOperation("copyhisindicator_record");
        view.invokeOperation("refresh");
        view.sendFormAction(view);
    }

    private void changeAssessGroupFLow(Map<String, Object> returnMap) {
        Object[] evaluationObjects = this.getEvaluationObjects();
        if (ObjectUtils.isEmpty((Object[])evaluationObjects)) {
            return;
        }
        Long flowVid = (Long)returnMap.values().toArray()[0];
        ArrayList<String> errorMsg = new ArrayList<String>(16);
        ArrayList statusSuccessObj = Lists.newArrayList();
        for (Object evaluationObj : evaluationObjects) {
            String activityStatus = evaluationObj.getString("activity.activitystatus");
            String assessStatus = evaluationObj.getString("assessstaus");
            if (!HRStringUtils.equals((String)ActivityStatusEnum.EXECUTING.getValue(), (String)activityStatus) || !HRStringUtils.equals((String)AssessStausEnum.JOINED.getStatus(), (String)assessStatus)) {
                errorMsg.add(ResManager.loadKDString((String)"{0} {1}\uff1a\u5236\u5b9a\u5bf9\u8c61\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u5f85\u5236\u5b9a\u201d\uff0c\u4e0d\u80fd\u5207\u6362\u5236\u5b9a\u6d41\u7a0b", (String)"TobeFormulateList_17", (String)"opmc-epa-formplugin", (Object[])new Object[]{evaluationObj.getString("perffile.name"), evaluationObj.getString("perffile.billno")}));
                continue;
            }
            statusSuccessObj.add(evaluationObj);
        }
        Map objRefProInstMap = EvalObjUtils.preCreateProcessInstance((DynamicObject[])statusSuccessObj.toArray(new DynamicObject[0]), (Long)flowVid, (String)"1");
        ArrayList<Object> successObj = new ArrayList<Object>(16);
        for (Object evaluationObj : statusSuccessObj) {
            Object formulateFlowId = objRefProInstMap.get(evaluationObj.getLong("id"));
            if (!ObjectUtils.isEmpty(formulateFlowId)) {
                evaluationObj.set("formulateflow", (Object)flowVid);
                evaluationObj.set("formulateflowins", formulateFlowId);
            }
            successObj.add(evaluationObj);
        }
        if (successObj.size() > 0) {
            ACTIVITY_EVALUATION_OBJECT_ENTITY.save(successObj.toArray(new DynamicObject[0]));
        }
        if (evaluationObjects.length == 1) {
            if (successObj.size() == 1) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5207\u6362\u6210\u529f", (String)"TobeFormulateList_18", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
            if (errorMsg.size() == 1) {
                this.getView().showErrorNotification((String)errorMsg.get(0));
            }
        } else {
            String title = ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u5207\u6362\u6d41\u7a0b\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"TobeFormulateList_19", (String)"opmc-epa-formplugin", (Object[])new Object[]{evaluationObjects.length, successObj.size(), errorMsg.size()});
            String msg = String.join((CharSequence)"\n", errorMsg);
            this.getView().showMessage(title, msg, MessageTypes.Default);
        }
        IFormView parentView = this.getView().getParentView();
        this.getView().invokeOperation("refresh");
        parentView.sendFormAction(this.getView());
        this.getView().sendFormAction(parentView);
    }

    private static void updateEvalObjFlowInfo(Long flowVid, DynamicObject[] evalObjs, Map<Long, Long> objRefProInstMap) {
        for (DynamicObject evaluationObj : evalObjs) {
            Long formulateFlowId;
            String activityStatus = evaluationObj.getString("activity.activitystatus");
            String assessStatus = evaluationObj.getString("assessstaus");
            if (!HRStringUtils.equals((String)ActivityStatusEnum.EXECUTING.getValue(), (String)activityStatus) || !HRStringUtils.equals((String)AssessStausEnum.JOINED.getStatus(), (String)assessStatus) || ObjectUtils.isEmpty((Object)(formulateFlowId = objRefProInstMap.get(evaluationObj.getLong("id"))))) continue;
            evaluationObj.set("formulateflow", (Object)flowVid);
            evaluationObj.set("formulateflowins", (Object)formulateFlowId);
        }
    }

    private DynamicObject[] getEvaluationObjects() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Long[] evalObjectIdList = (Long[])Arrays.stream(selectedRows.getPrimaryKeyValues()).map(row -> Long.parseLong(row.toString())).toArray(Long[]::new);
        return EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvaluationObjectById(Arrays.asList(evalObjectIdList));
    }

    private void taskCallBack(Map<String, Object> returnMap, String type) {
        if (!returnMap.containsKey("taskinfo")) {
            return;
        }
        String taskInfoStr = (String)returnMap.get("taskinfo");
        if (StringUtils.isBlank((CharSequence)taskInfoStr)) {
            return;
        }
        TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
        if (!taskInfo.isTaskEnd()) {
            return;
        }
        String data = taskInfo.getData();
        if (HRStringUtils.isEmpty((String)data)) {
            return;
        }
        JSONObject resultDate = JSONObject.parseObject((String)data);
        if (!ObjectUtils.isEmpty((Object)resultDate)) {
            JSONObject message = (JSONObject)resultDate.get((Object)"data");
            String issuccess = (String)resultDate.get((Object)"issuccess");
            if ("0".equals(issuccess)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5168\u90e8\u6210\u529f", (String)"TobeFormulateList_20", (String)"opmc-epa-business", (Object[])new Object[0]));
            } else if ("1".equals(issuccess)) {
                this.getView().showMessage(String.valueOf(message.get((Object)"item1")), String.valueOf(message.get((Object)"item2")), MessageTypes.Default);
            } else if ("2".equals(issuccess)) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("epa_check_show");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                String exporturl = (String)resultDate.get((Object)"downloadurl");
                showParameter.setCustomParam("downloadurl", (Object)exporturl);
                showParameter.setCustomParam("opKey", resultDate.get((Object)"opKey"));
                this.getView().showForm(showParameter);
            }
            this.getView().invokeOperation("refresh");
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            ActManageUtils.refreshFormulatedCount(this.getView(), activityId);
        }
    }

    private Map<String, Object> getReturnMap(Object returnData) {
        if (returnData instanceof Map) {
            Map result = (Map)returnData;
            return result;
        }
        return null;
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        String assFormat = this.getAssFormat();
        if (HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.WEIGHTING.getCode())) {
            args.getListColumns().removeIf(column -> HRStringUtils.equals((String)column.getListFieldKey(), (String)"assscore"));
        } else if (HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.ADD_NEWER.getCode())) {
            args.getListColumns().removeIf(column -> HRStringUtils.equals((String)column.getListFieldKey(), (String)"assweight"));
        }
    }

    private String getAssFormat() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        return ASSESS_ACTIVITY_APPLICATION_SERVICE.queryAssFormatByActId(activityId);
    }

    private void showGroupSettingPage() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setBillFormId("epa_indicatorgroup_base");
        String groupName = AssignIndicatorPageUtils.getIndicatorGroupMetaName();
        String caption = ResManager.loadKDString((String)"\u6307\u5b9a{0}", (String)"TobeFormulateList_12", (String)"opmc-epa-formplugin", (Object[])new Object[]{groupName});
        showParameter.setCaption(caption);
        showParameter.setFormId("epa_indicatorf7");
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setLookUp(true);
        showParameter.setShowTitle(false);
        showParameter.setMultiSelect(false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "groupsetting"));
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        showParameter.setCustomParam("activityid", (Object)activityId);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(new QFilter("activity", "=", (Object)activityId));
        showParameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String assFormat = this.getAssFormat();
        if (HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.WEIGHTING.getCode())) {
            args.getSchemeFilterColumns().removeIf(schemeFilter -> HRStringUtils.equals((String)schemeFilter.getFieldName(), (String)"assscore"));
        } else if (HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.ADD_NEWER.getCode())) {
            args.getSchemeFilterColumns().removeIf(schemeFilter -> HRStringUtils.equals((String)schemeFilter.getFieldName(), (String)"assweight"));
        }
    }
}

