/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.assessrule;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.Tips;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.IDataModelListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.AssessRuleApplicationService;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.constants.AssessTabConstants;
import kd.opmc.epa.common.enums.assessrule.EvaSumLimit;
import kd.opmc.epa.common.enums.assessrule.EvalWayEnum;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.pbs.business.external.hrcs.IHRCSTipService;
import kd.opmc.pbs.business.tips.ShowConfigTipsUtils;

public class AssessFormEdit
extends HRDataBaseEdit
implements TabSelectListener,
RowClickEventListener,
IDataModelListener,
AssessRuleConstants,
AssessTabConstants {
    private static final Log LOGGER = LogFactory.getLog(AssessFormEdit.class);
    private static final AssessRuleApplicationService ASSESS_RULE_APP_SERVICE = AssessRuleApplicationService.getInstance();
    private static final IHRCSTipService IHRCS_TIP_SERVICE = IHRCSTipService.getInstance();
    private static final String EPA_PLUS_MINUS_CONF_VALIDATE = "epa_plusminusconfvalidate";
    private static final String BSED = "bsed";
    private static final String OPTION = "option";
    private static final String SHOW_HIS_VERSION = "showhisversion";
    private static final String BAR_DISABLE = "bar_disable";
    private static final String BAR_ENABLE = "bar_enable";
    private static final long SUM_AREA_FIELD_ID = 1539747497394589696L;
    private static final long WEIGHT_AREA_FIELD_ID = 1539295507585707008L;
    private static final long OLE_ID = 1539882034862772224L;
    private static final DistributeSessionlessCache CUSTOM_REGION_CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion");

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && ("epa_scheme".equals(parentView.getEntityId()) || "epa_activity".equals(parentView.getEntityId()))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tbmain"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{"bar_last", "bar_next", "addarea", "bar_save"});
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String formId = this.getView().getModel().getDataEntityType().getName();
        if (!HRBaseDataConfigUtil.getAudit((String)formId)) {
            this.getModel().setValue("status", (Object)"A");
        }
        List dirtyProperties = this.getModel().getDataEntity().getDataEntityState().GetDirtyProperties();
        for (IDataEntityProperty property : dirtyProperties) {
            int ordinal;
            if (HRStringUtils.equals((String)property.getName(), (String)"status")) {
                ordinal = property.getOrdinal();
                this.getModel().getDataEntity().getDataEntityState().setBizChanged(ordinal, false);
            }
            if (!HRStringUtils.equals((String)property.getName(), (String)"sumconfnew")) continue;
            ordinal = property.getOrdinal();
            this.getModel().getDataEntity().getDataEntityState().setBizChanged(ordinal, false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getPageCache().put("wizardTabIndex", "1");
        this.activeTab(Integer.parseInt("1"));
        String hisAction = (String)this.getView().getFormShowParameter().getCustomParam("his_action");
        if (HRStringUtils.equals((String)"open_insert_data_page", (String)hisAction) || HRStringUtils.equals((String)"open_insert_new_data_page", (String)hisAction)) {
            this.getModel().setValue("isfromchange", (Object)"1");
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", "scorecalcway", "numaccuracy", "scaletype"});
        }
        if (HRStringUtils.equals((String)"modify_data_page", (String)hisAction)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_revise"});
        }
        this.showTabButton();
        String option = (String)this.getView().getFormShowParameter().getCustomParam(OPTION);
        if (!HRStringUtils.equals((String)option, (String)SHOW_HIS_VERSION)) {
            this.getModel().setValue(BSED, (Object)HRDateTimeUtils.truncateDate((Date)new Date()));
        }
        this.showControlByScoreCalWay();
        this.getView().setVisible(Boolean.valueOf(EvaSumLimit.APPOINT_SUM_LIMIT.getValue().equals(this.getModel().getDataEntity().getString("evasumlimit"))), new String[]{"limitminscore", "limitmaxscore"});
        if (HRStringUtils.equals((String)"open_insert_data_page", (String)hisAction)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"evasumlimit", "limitmaxscore", "limitminscore"});
            String key = this.getView().getFormShowParameter().getCustomParams().get("currentDataId") + "-" + UserServiceHelper.getCurrentUserId() + "wizardTabIndex";
            if ("2".equals(CUSTOM_REGION_CACHE.get(key))) {
                Tab tab = (Tab)this.getControl("tabap");
                tab.activeTab("areapageap");
                CUSTOM_REGION_CACHE.remove(key);
            }
        }
        this.getModel().setDataChanged(false);
        this.setNameHashSet();
        this.initTips();
    }

    private void setNameHashSet() {
        HashSet nameHashSet = Sets.newHashSet();
        DynamicObjectCollection dynamicObjectCollection = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("areaconfentry");
        this.getAreaCustomName(nameHashSet, dynamicObjectCollection, "epa_customarea", "epa_customareaconf");
        this.getAreaCustomName(nameHashSet, dynamicObjectCollection, "epa_normindctrarea", "epa_normalconf");
        this.getAreaCustomName(nameHashSet, dynamicObjectCollection, "epa_plusminusarea", "epa_plusminusconf");
        this.getAreaCustomName(nameHashSet, dynamicObjectCollection, "epa_attacharea", "epa_attachconf");
        HRBaseServiceHelper sumServiceHelper = new HRBaseServiceHelper("epa_sumconf");
        long sumConfNewId = this.getModel().getDataEntity().getLong("sumconfnew");
        if (sumConfNewId > 0L) {
            DynamicObject sumConfDynObj = sumServiceHelper.loadSingle((Object)sumConfNewId);
            nameHashSet.add(sumConfDynObj.getString("areacustname"));
            this.getView().getPageCache().put("nameSet", nameHashSet.toString());
            return;
        }
        long sumConfId = this.getModel().getDataEntity().getLong("sumconf");
        if (sumConfId > 0L) {
            DynamicObject sumConfDynObj = sumServiceHelper.loadSingle((Object)sumConfId);
            nameHashSet.add(sumConfDynObj.getString("areacustname"));
            this.getView().getPageCache().put("nameSet", nameHashSet.toString());
        }
    }

    private void getAreaCustomName(HashSet<String> nameHashSet, DynamicObjectCollection dynamicObjectCollection, String number, String entityName) {
        DynamicObject[] ids;
        List idList = dynamicObjectCollection.stream().filter(dynamicObject -> dynamicObject.getString("areareg.number").equals(number)).map(dynamicObject -> dynamicObject.getLong("areaconfnew")).filter(id -> id > 0L).collect(Collectors.toList());
        if (idList.isEmpty()) {
            idList = dynamicObjectCollection.stream().filter(dynamicObject -> dynamicObject.getString("areareg.number").equals(number)).map(dynamicObject -> dynamicObject.getLong("areaconf")).collect(Collectors.toList());
        }
        HRBaseServiceHelper epaNormalServiceHelper = new HRBaseServiceHelper(entityName);
        for (DynamicObject dynamicObject2 : ids = epaNormalServiceHelper.query("areacustname", new QFilter("id", "in", idList).toArray())) {
            nameHashSet.add(dynamicObject2.getString("areacustname").trim());
        }
    }

    private void showTabButton() {
        IPageCache iPageCache = this.getPageCache();
        String index = iPageCache.get("wizardTabIndex");
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit", "bar_unsubmit"});
        String option = (String)this.getView().getFormShowParameter().getCustomParam(OPTION);
        if (HRStringUtils.equals((String)option, (String)SHOW_HIS_VERSION)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_DISABLE, BAR_ENABLE});
        }
        switch (index) {
            case "1": {
                this.tabOneShowView();
                break;
            }
            case "2": {
                this.tabTwoShowView();
                break;
            }
        }
    }

    private void tabOneShowView() {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        if (HRStringUtils.equals((String)"A", (String)dynamicObject.getString("status")) || HRStringUtils.equals((String)"B", (String)dynamicObject.getString("status"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit", "bar_unsubmit", "bar_last_btn", "exit", "bar_save", "tblclosehis"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_next_btn"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"exit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_next_btn", "bar_last_btn", "tblclosehis", "bar_last_btn_his", "bar_next_btn_his"});
        }
        if (HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam(OPTION)), (String)"insertdata_his") && HRStringUtils.equals((String)"A", (String)dynamicObject.getString("status"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_last_btn", "bar_last_btn_his", "bar_next_btn"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_next_btn_his"});
            Container tbmain = (Container)this.getView().getControl("tbmain");
            if (tbmain != null && !HRStringUtils.equals((String)"1", (String)this.getPageCache().get("bar_next_btn_his"))) {
                ArrayList items = Lists.newArrayListWithExpectedSize((int)16);
                BarItemAp refreshBtn = new BarItemAp();
                refreshBtn.setKey("bar_next_btn_his");
                refreshBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u4e0b\u4e00\u6b65", (String)"AssessFormEdit_0", (String)"opmc-pmd-formplugin", (Object[])new Object[0])));
                refreshBtn.setOperationKey("bar_next");
                items.add(refreshBtn.createControl());
                tbmain.insertControls(0, (List)items);
                this.getView().getPageCache().put("bar_next_btn_his", "1");
            }
        }
    }

    private void tabTwoShowView() {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        if (HRStringUtils.equals((String)"A", (String)dynamicObject.getString("status")) || HRStringUtils.equals((String)"B", (String)dynamicObject.getString("status"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit", "bar_unsubmit", "bar_next_btn", "exit", "tblclosehis", "bar_last_btn_his", "bar_next_btn_his"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_last_btn", "bar_save"});
            if (HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam(OPTION)), (String)"insertdata_his")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            }
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"exit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_next_btn", "bar_last_btn", "tblclosehis", "bar_last_btn_his", "bar_next_btn_his"});
        }
        if (HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam(OPTION)), (String)"insertdata_his") && HRStringUtils.equals((String)"A", (String)dynamicObject.getString("status"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_last_btn", "bar_next_btn_his", "bar_next_btn"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_last_btn_his"});
            Container tbmain = (Container)this.getView().getControl("tbmain");
            if (tbmain != null && !HRStringUtils.equals((String)"1", (String)this.getPageCache().get("bar_last_btn_his"))) {
                ArrayList items = Lists.newArrayListWithExpectedSize((int)16);
                BarItemAp refreshBtn = new BarItemAp();
                refreshBtn.setKey("bar_last_btn_his");
                refreshBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u4e0a\u4e00\u6b65", (String)"AssessFormEdit_1", (String)"opmc-pmd-formplugin", (Object[])new Object[0])));
                refreshBtn.setOperationKey("bar_last");
                items.add(refreshBtn.createControl());
                tbmain.insertControls(0, (List)items);
                this.getView().getPageCache().put("bar_last_btn_his", "1");
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String opKey = evt.getOperationKey();
        if (HRStringUtils.equals((String)"save", (String)opKey) || HRStringUtils.equals((String)"confirmchangenoaudit", (String)opKey) || HRStringUtils.equals((String)"confirmchange", (String)opKey)) {
            this.initDefaultConf();
            if (this.checkAreaConfEntry()) {
                evt.setCancel(true);
            }
            for (DynamicObject row : this.getModel().getEntryEntity("areaconfentry")) {
                Long areaConfNew;
                DynamicObject plusMinusConfigDy;
                boolean plusAndMinusIsZero;
                Long areaId = (Long)row.getDynamicObject("areareg").getPkValue();
                if (!areaId.equals(PLUS_MINUS_AREA_PK) || !(plusAndMinusIsZero = this.valPlusAndMinusIsZero(plusMinusConfigDy = ASSESS_RULE_APP_SERVICE.queryPlusMinusConfigByPk(areaConfNew = (Long)row.get("areaconfnew") == 0L ? (Long)row.get("areaconf") : (Long)row.get("areaconfnew"))))) continue;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u52a0\u51cf\u5206\u9879\u533a\uff1a\u53ef\u8bc4\u5206\u503c\u4e3a0\uff08\u8bc4\u5206\u4e0a\u4e0b\u9650\uff1a0~0\uff09\uff0c \u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58?", (String)"AssessFormEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("PlusMinusConfirmAction", (IFormPlugin)this));
                evt.setCancel(true);
                if (!HRStringUtils.equals((String)"confirmchangenoaudit", (String)opKey)) break;
                this.getPageCache().put(this.getView().getPageId(), "confirmchangenoaudit");
                break;
            }
        }
    }

    private void next() {
        IPageCache iPageCache = this.getPageCache();
        String index = iPageCache.get("wizardTabIndex");
        if (HRStringUtils.equals((String)index, (String)"2") && this.checkAreaConfEntry()) {
            this.showTabButton();
            return;
        }
        if (HRStringUtils.equals((String)index, (String)"1") && this.checkTabMustInput()) {
            this.showTabButton();
            return;
        }
        Integer next = Integer.parseInt(index) + 1;
        iPageCache.put("wizardTabIndex", String.valueOf(next));
        iPageCache.put("isClickNext", "yes");
        this.activeTab(next);
        this.showTabButton();
        this.copyArea();
        this.drawMiddleAreas();
    }

    private void setTabIndex(String key) {
        IPageCache iPageCache = this.getPageCache();
        switch (key) {
            case "basepageap": {
                iPageCache.put("wizardTabIndex", "1");
                break;
            }
            case "areapageap": {
                iPageCache.put("wizardTabIndex", "2");
                break;
            }
        }
    }

    private void last() {
        IPageCache iPageCache = this.getPageCache();
        String index = iPageCache.get("wizardTabIndex");
        if (HRStringUtils.equals((String)index, (String)"2") && this.checkAreaConfEntry()) {
            this.showTabButton();
            return;
        }
        Integer next = Integer.parseInt(index) - 1;
        iPageCache.put("wizardTabIndex", String.valueOf(next));
        this.activeTab(next);
        this.showTabButton();
    }

    private boolean checkAreaConfEntry() {
        if (this.getModel().getEntryEntity("areaconfentry").size() <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u7559\u81f3\u5c111\u4e2a\u6307\u6807\u533a\u57df\u3002", (String)"AssessFormEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).getLong("id") == 0L;
        }
        if (obj instanceof String) {
            return "".equals(obj.toString().trim());
        }
        if (obj instanceof OrmLocaleValue) {
            return ((OrmLocaleValue)obj).isEmpty() || "".equals(obj.toString().trim());
        }
        return false;
    }

    private boolean checkTabMustInput() {
        StringBuilder msg = new StringBuilder();
        for (String key : AssessTabConstants.BASE_PAGE_AP_MUST_INPUT) {
            FieldTip nameTip;
            if (this.isEmpty(this.getModel().getValue(key))) {
                String name = ((IDataEntityProperty)this.getModel().getDataEntityType().getProperties().get((Object)key)).getDisplayName().getLocaleValue();
                msg.append(MessageFormat.format("\"{0}\"\u3001", name));
                nameTip = this.showValidaTip(false, ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AssessFormEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]), key);
            } else {
                nameTip = this.showValidaTip(true, null, key);
            }
            this.getView().showFieldTip(nameTip);
        }
        if (!HRObjectUtils.isEmpty((Object)msg) && msg.length() > 0) {
            String msgStr = msg.toString();
            msg.replace(msgStr.length() - 1, msgStr.length(), "\u3002");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199{0}\u3002", (String)"AssessFormEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{msg.toString()}));
            return true;
        }
        return false;
    }

    private FieldTip showValidaTip(boolean isHide, String msg, String field) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setSuccess(isHide);
        fieldTip.setFieldKey(field);
        if (!isHide) {
            fieldTip.setTip(msg);
        }
        return fieldTip;
    }

    private void activeTab(Integer next) {
        Tab tab = (Tab)this.getControl("tabap");
        switch (String.valueOf(next)) {
            case "1": {
                tab.activeTab("basepageap");
                break;
            }
            case "2": {
                tab.activeTab("areapageap");
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if ("ScoreCalcWayConfirmAction".equals(event.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)event.getResult())) {
                Object scoreCalcWay = this.getModel().getValue("scorecalcway");
                this.setNormalConfigDefaultValueAfterConfirm(scoreCalcWay);
                if (ScoreCalcWayEnum.SUM.getValue().equals(scoreCalcWay)) {
                    this.getModel().setValue("consistentwitharea", (Object)"1");
                }
            } else {
                String scoreCalcWayOldCacheVal = this.getPageCache().get("scoreCalcWayOldCacheVal");
                this.getModel().beginInit();
                this.getModel().setValue("scorecalcway", (Object)scoreCalcWayOldCacheVal);
                this.getModel().endInit();
                this.getView().updateView("scorecalcway");
            }
            this.showControlByScoreCalWay();
        }
        if ("consistentConfirmAction".equals(event.getCallBackId()) && MessageBoxResult.Cancel.equals((Object)event.getResult())) {
            this.getModel().setValue("consistentwitharea", (Object)"0");
        }
        if ("PlusMinusConfirmAction".equals(event.getCallBackId()) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            this.getView().invokeOperation("save");
        }
    }

    private void setNormalConfigDefaultValueAfterConfirm(Object scoreCalcWay) {
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("areaconfentry");
        Object isCopy = this.getView().getFormShowParameter().getCustomParam("iscopy");
        Set normalAreaConfIdSet = Boolean.TRUE.equals(isCopy) ? collection.stream().filter(dynObj -> NORM_INDCTR_AREA_PK.longValue() == dynObj.getLong("areareg.id")).map(dynObj -> dynObj.getLong("areaconf")).collect(Collectors.toSet()) : collection.stream().filter(dynObj -> NORM_INDCTR_AREA_PK.longValue() == dynObj.getLong("areareg.id")).map(dynObj -> dynObj.getLong("areaconfnew")).collect(Collectors.toSet());
        DynamicObject[] normalConfDynObjArr = ASSESS_RULE_APP_SERVICE.queryNormalConfigByIds(normalAreaConfIdSet);
        ArrayList<DynamicObject> needUpdateDynObjList = new ArrayList<DynamicObject>(10);
        DynamicObject areaRegFieldBy = ASSESS_RULE_APP_SERVICE.getAreaRegFieldBy(1539295507585707008L);
        DynamicObject sumAreaRegFieldBy = ASSESS_RULE_APP_SERVICE.getAreaRegFieldBy(1539747497394589696L);
        for (DynamicObject dynObj2 : normalConfDynObjArr) {
            if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
                if (dynObj2.getBigDecimal("weight").compareTo(BigDecimal.ZERO) != 0) {
                    dynObj2.set("weight", (Object)BigDecimal.ZERO);
                    dynObj2.set("areascore", (Object)BigDecimal.ZERO);
                    needUpdateDynObjList.add(dynObj2);
                }
                DynamicObjectCollection confColl = dynObj2.getDynamicObjectCollection("entryentity");
                boolean needUpdateConf = false;
                for (DynamicObject next : confColl) {
                    if (next.getLong("areafield.id") != 1539747497394589696L) continue;
                    next.set("areafield", (Object)1539295507585707008L);
                    next.set("fieldcustname", areaRegFieldBy.get("name"));
                    needUpdateConf = true;
                }
                if (!needUpdateConf) continue;
                needUpdateDynObjList.add(dynObj2);
                continue;
            }
            if (dynObj2.getBigDecimal("areascore").compareTo(BigDecimal.ZERO) != 0) {
                dynObj2.set("areascore", (Object)BigDecimal.ZERO);
                dynObj2.set("weight", (Object)BigDecimal.ZERO);
                needUpdateDynObjList.add(dynObj2);
            }
            boolean needUpdateConf = false;
            DynamicObjectCollection confColl = dynObj2.getDynamicObjectCollection("entryentity");
            for (DynamicObject next : confColl) {
                if (next.getLong("areafield.id") != 1539295507585707008L) continue;
                next.set("areafield", (Object)1539747497394589696L);
                next.set("fieldcustname", sumAreaRegFieldBy.get("name"));
                needUpdateConf = true;
            }
            if (!needUpdateConf) continue;
            needUpdateDynObjList.add(dynObj2);
        }
        ASSESS_RULE_APP_SERVICE.updateNormalConfigArr(needUpdateDynObjList.toArray(new DynamicObject[0]));
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        super.propertyChanged(propertyChangedArgs);
        String fieldKey = propertyChangedArgs.getProperty().getName();
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        switch (fieldKey) {
            case "evalway": {
                boolean isScore = EvalWayEnum.SCORE == EvalWayEnum.getEvalWay((String)String.valueOf(changeData.getNewValue()));
                this.showFieldByEvalWay(isScore);
                break;
            }
            case "numaccuracy": {
                this.drawMiddleAreas();
                this.setSc();
                break;
            }
            case "sumperflevel": {
                this.changeSumPerfLevel(changeData);
                break;
            }
            case "scorecalcway": {
                if (changeData.getOldValue() != null && "yes".equals(this.getPageCache().get("isClickNext"))) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u5f97\u5206\u8ba1\u7b97\u65b9\u5f0f\uff0c\u8bc4\u4f30\u8868\u5355\u5e38\u89c4\u6307\u6807\u533a\u7684\u8bbe\u7f6e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u5207\u6362?", (String)"AssessFormEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ScoreCalcWayConfirmAction", (IFormPlugin)this));
                } else {
                    this.showControlByScoreCalWay();
                }
                if (changeData.getOldValue() != null) {
                    this.getPageCache().put("scoreCalcWayOldCacheVal", changeData.getOldValue().toString());
                }
                this.getPageCache().remove("isClickNext");
                break;
            }
            case "evasumlimit": {
                this.updateMustInputAndValueByExceed();
                break;
            }
            case "issupcalcsum": {
                if (this.getModel().getDataEntity().getBoolean("issupcalcsum")) break;
                this.getModel().setValue("sumperflevel", null);
                break;
            }
            case "consistentwitharea": {
                this.changeConsistent(changeData);
                break;
            }
        }
    }

    private void setSc() {
        int numAccuracy = 0;
        String numAccuracyStr = this.getModel().getDataEntity().getString("numaccuracy");
        try {
            numAccuracy = numAccuracyStr == null ? 0 : Integer.parseInt(numAccuracyStr);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        BigDecimal limtMaxRatioBefore = this.getModel().getDataEntity().getBigDecimal("limitmaxratio");
        if (limtMaxRatioBefore != null) {
            BigDecimal limitMaxRatioAfter = limtMaxRatioBefore.setScale(numAccuracy, RoundingMode.HALF_UP);
            this.getModel().setValue("limitmaxratio", (Object)limitMaxRatioAfter);
        }
        HashMap<String, Integer> pcScMap = new HashMap<String, Integer>(16);
        pcScMap.put("pc", numAccuracy + 13);
        pcScMap.put("sc", numAccuracy);
        HashMap<String, HashMap<String, Integer>> itemMap = new HashMap<String, HashMap<String, Integer>>(16);
        itemMap.put("item", pcScMap);
        this.getView().updateControlMetadata("limitmaxratio", itemMap);
    }

    private void changeConsistent(ChangeData changeData) {
        if ("0".equals(changeData.getOldValue()) && "1".equals(changeData.getNewValue())) {
            DynamicObject[] normalConfDynObjArr = this.getNormalConfDyn();
            Long id = this.getModel().getDataEntity().getLong("scoresystem.id");
            for (DynamicObject dynamicObject : normalConfDynObjArr) {
                if (id <= 0L || id.equals(dynamicObject.getLong("scoresystem.id"))) continue;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u533a\u57df\u5206\u5236\u4e0e\u6574\u5355\u5206\u5236\u4e0d\u4e00\u81f4\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\u4e3a\u4e00\u81f4\uff1f", (String)"AssessFormEdit_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("consistentConfirmAction", (IFormPlugin)this));
                return;
            }
        }
    }

    private DynamicObject[] getNormalConfDyn() {
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("areaconfentry");
        Set normalAreaConfIdSet = collection.stream().filter(dynObj -> NORM_INDCTR_AREA_PK.longValue() == dynObj.getLong("areareg.id")).map(dynObj -> dynObj.getLong("areaconf")).collect(Collectors.toSet());
        if (normalAreaConfIdSet.size() <= 0) {
            normalAreaConfIdSet = collection.stream().filter(dynObj -> NORM_INDCTR_AREA_PK.longValue() == dynObj.getLong("areareg.id")).map(dynObj -> dynObj.getLong("areaconfnew")).collect(Collectors.toSet());
        }
        return ASSESS_RULE_APP_SERVICE.queryNormalConfigByIds(normalAreaConfIdSet);
    }

    private void updateMustInputAndValueByExceed() {
        FieldEdit upperControl = (FieldEdit)this.getControl("limitmaxscore");
        FieldEdit lowerControl = (FieldEdit)this.getControl("limitminscore");
        if (EvaSumLimit.APPOINT_SUM_LIMIT.getValue().equals(this.getModel().getDataEntity().getString("evasumlimit"))) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"limitmaxscore", "limitminscore"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"limitmaxscore", "limitminscore"});
            upperControl.setMustInput(Boolean.TRUE.booleanValue());
            lowerControl.setMustInput(Boolean.TRUE.booleanValue());
            this.setWeightRatioVisible(Boolean.FALSE);
        } else if (EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(this.getModel().getDataEntity().getString("evasumlimit"))) {
            this.setWeightRatioVisible(Boolean.TRUE);
            this.getView().setEnable(Boolean.FALSE, new String[]{"limitmaxscore", "limitminscore"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"limitmaxscore", "limitminscore"});
            upperControl.setMustInput(Boolean.FALSE.booleanValue());
            lowerControl.setMustInput(Boolean.FALSE.booleanValue());
            this.getModel().setValue("limitmaxscore", null);
            this.getModel().setValue("limitminscore", null);
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"limitmaxscore", "limitminscore"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"limitmaxscore", "limitminscore"});
            upperControl.setMustInput(Boolean.FALSE.booleanValue());
            lowerControl.setMustInput(Boolean.FALSE.booleanValue());
            this.getModel().setValue("limitmaxscore", null);
            this.getModel().setValue("limitminscore", null);
            this.setWeightRatioVisible(Boolean.FALSE);
        }
        this.setTips("evasumlimit", this.getModel().getDataEntity());
    }

    private void setWeightRatioVisible(Boolean visible) {
        FieldEdit limitMaxRatioControl = (FieldEdit)this.getControl("limitmaxratio");
        this.getView().setEnable(visible, new String[]{"limitmaxratio"});
        this.getView().setVisible(visible, new String[]{"limitmaxratio"});
        limitMaxRatioControl.setMustInput(visible.booleanValue());
        if (visible.booleanValue()) {
            this.setSc();
        } else {
            this.getModel().setValue("limitmaxratio", null);
        }
    }

    private void showControlByScoreCalWay() {
        Object scoreCalWay = this.getModel().getValue("scorecalcway");
        ComboEdit comboEdit = (ComboEdit)this.getControl("consistentwitharea");
        ComboEdit evaSumLimitEdit = (ComboEdit)this.getControl("evasumlimit");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        ComboProp comboProp = (ComboProp)MetadataServiceHelper.getDataEntityType((String)"epa_assessform").findProperty("evasumlimit");
        List comboPropItems = comboProp.getComboItems();
        for (ValueMapItem valueMapItem : comboPropItems) {
            if (EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(valueMapItem.getValue()) && ScoreCalcWayEnum.SUM.getValue().equals(scoreCalWay)) continue;
            ComboItem item = new ComboItem();
            item.setCaption(valueMapItem.getName());
            item.setValue(valueMapItem.getValue());
            comboItems.add(item);
        }
        evaSumLimitEdit.setComboItems(comboItems);
        if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalWay)) {
            comboEdit.setMustInput(Boolean.TRUE.booleanValue());
            this.getView().setVisible(Boolean.TRUE, new String[]{"consistentwitharea"});
            if (!EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(this.getModel().getDataEntity().getString("evasumlimit"))) {
                this.setWeightRatioVisible(Boolean.FALSE);
            } else {
                this.setSc();
            }
        } else if (ScoreCalcWayEnum.SUM.getValue().equals(scoreCalWay)) {
            comboEdit.setMustInput(Boolean.FALSE.booleanValue());
            this.getView().setVisible(Boolean.FALSE, new String[]{"consistentwitharea"});
            this.setWeightRatioVisible(Boolean.FALSE);
            if (EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(this.getModel().getDataEntity().getString("evasumlimit"))) {
                this.getModel().setValue("evasumlimit", (Object)EvaSumLimit.NOT_LIMIT.getValue());
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"consistentwitharea"});
        }
    }

    private void updateMustInputByExceed(String controlKey, String allowExceed) {
        FieldEdit control = (FieldEdit)this.getControl(controlKey);
        if (this.getModel().getDataEntity().getBoolean(allowExceed)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{controlKey});
            control.setMustInput(true);
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{controlKey});
            control.setMustInput(false);
        }
    }

    private void changeSumPerfLevel(ChangeData changeData) {
        boolean isSumLevelClear;
        boolean isSumConfNull = (Long)this.getModel().getValue("sumconf") <= 0L && (Long)this.getModel().getValue("sumconfnew") <= 0L;
        boolean isSumLevelNew = changeData.getOldValue() == null && changeData.getNewValue() != null;
        boolean bl = isSumLevelClear = changeData.getOldValue() != null && changeData.getNewValue() == null;
        if (!isSumConfNull && (isSumLevelNew || isSumLevelClear)) {
            EvalWayEnum evalWayEnum = EvalWayEnum.getEvalWay((String)String.valueOf(this.getModel().getValue("evalway")));
            this.getModel().setValue("sumconfnew", (Object)ASSESS_RULE_APP_SERVICE.getDefaultSumConf(!HRObjectUtils.isEmpty((Object)changeData.getNewValue()), evalWayEnum));
            if (HRStringUtils.isNotEmpty((String)this.getPageCache().get("sumshowap"))) {
                this.drawSingleArea("sumshowap", "epa_sumarea", (Long)this.getModel().getValue("sumconfnew"), "confedit");
            }
        }
        if (changeData.getNewValue() != null) {
            Long scoreSystemId = this.getModel().getDataEntity().getLong("scoresystem.id");
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity().getDynamicObjectCollection("sumperflevel.scoremapentryentity");
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                if (!scoreSystemId.equals(((DynamicObject)dynamicObjectCollection.get(i)).getLong("scoresystem.id")) || scoreSystemId == 0L) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u5206\u5236\u5bf9\u5e94\u7684\u7b49\u7ea7\uff0c\u7ee9\u6548\u8bc4\u4f30\u65f6\u53ef\u6839\u636e\u8bc4\u5206\u81ea\u52a8\u5e26\u51fa\u5bf9\u5e94\u7684\u7b49\u7ea7\u3002", (String)"AssessFormEdit_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ef\u9009\u62e9\u5df2\u914d\u7f6e\u5206\u5236\u4e0e\u7b49\u7ea7\u6620\u5c04\u5173\u7cfb\u7684\u7ee9\u6548\u7b49\u7ea7\uff0c\u7ee9\u6548\u8bc4\u4f30\u65f6\u53ef\u6839\u636e\u8bc4\u5206\u81ea\u52a8\u8f6c\u6362\u5bf9\u5e94\u7b49\u7ea7\u3002", (String)"AssessFormEdit_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ef\u9009\u62e9\u5df2\u914d\u7f6e\u5206\u5236\u4e0e\u7b49\u7ea7\u6620\u5c04\u5173\u7cfb\u7684\u7ee9\u6548\u7b49\u7ea7\uff0c\u7ee9\u6548\u8bc4\u4f30\u65f6\u53ef\u6839\u636e\u8bc4\u5206\u81ea\u52a8\u8f6c\u6362\u5bf9\u5e94\u7b49\u7ea7\u3002", (String)"AssessFormEdit_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
    }

    private void showFieldByEvalWay(Boolean isScore) {
        this.getView().setVisible(isScore, new String[]{"scoresystem"});
        BasedataEdit scoreSystem = (BasedataEdit)this.getControl("scoresystem");
        scoreSystem.setMustInput(isScore.booleanValue());
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if ("areapageap".equals(tabKey)) {
            this.initDefaultConf();
            if (HRStringUtils.isEmpty((String)this.getPageCache().get("sumshowap"))) {
                this.drawAssessPage();
                this.getPageCache().put("sumshowap", "1");
            }
            this.setNameHashSet();
        }
        this.setTabIndex(tabKey);
        this.showTabButton();
    }

    private void drawAssessPage() {
        Long empInfoConfNew = (Long)this.getModel().getValue("empinfoconfnew");
        Long empInfoConf = (Long)this.getModel().getValue("empinfoconf");
        this.drawSingleArea("empinfoshowap", "epa_empinfoarea", empInfoConfNew > 0L ? empInfoConfNew : empInfoConf, empInfoConfNew > 0L ? "confedit" : "confadd");
        this.drawMiddleAreas();
        Long sumConfNew = (Long)this.getModel().getValue("sumconfnew");
        Long sumConf = (Long)this.getModel().getValue("sumconf");
        this.drawSingleArea("sumshowap", "epa_sumarea", sumConfNew > 0L ? sumConfNew : sumConf, sumConfNew > 0L ? "confedit" : "confadd");
    }

    private void initDefaultConf() {
        if (this.getModel().getDataEntity().getLong("sumconf") <= 0L && this.getModel().getDataEntity().getLong("sumconfnew") <= 0L) {
            EvalWayEnum evalWayEnum = EvalWayEnum.getEvalWay((String)String.valueOf(this.getModel().getValue("evalway")));
            this.getModel().setValue("empinfoconfnew", (Object)ASSESS_RULE_APP_SERVICE.getDefaultEmpInfoConf());
            this.getModel().setValue("sumconfnew", (Object)ASSESS_RULE_APP_SERVICE.getDefaultSumConf(!HRObjectUtils.isEmpty((Object)this.getModel().getValue("sumperflevel")), evalWayEnum));
            DynamicObjectCollection areaConfEntry = this.getModel().getEntryEntity("areaconfentry");
            DynamicObject normConf = areaConfEntry.addNew();
            normConf.set("areaconfnew", (Object)this.getAreaDefaultConf(NORM_INDCTR_AREA_PK, this.getModel().getValue("normdefname")));
            normConf.set("areareg", (Object)ASSESS_RULE_APP_SERVICE.queryAreaRegByPk(NORM_INDCTR_AREA_PK));
            DynamicObject plusMinusConf = areaConfEntry.addNew();
            DynamicObject plusMinusArea = ASSESS_RULE_APP_SERVICE.queryAreaRegByPk(PLUS_MINUS_AREA_PK);
            plusMinusConf.set("areaconfnew", (Object)this.getAreaDefaultConf(PLUS_MINUS_AREA_PK, plusMinusArea.get("name")));
            plusMinusConf.set("areareg", (Object)plusMinusArea);
            this.getModel().updateEntryCache(areaConfEntry);
        }
    }

    private void copyArea() {
        Object isCopy = this.getView().getFormShowParameter().getCustomParam("iscopy");
        String copyInitFlag = this.getPageCache().get("copyInitFlag");
        if (!Boolean.TRUE.equals(isCopy) || Boolean.TRUE.toString().equals(copyInitFlag)) {
            return;
        }
        this.copyEmpInfoArea();
        this.copyNormalAreaExcludeScoreSystem();
        this.copyAttachmentConfArea();
        this.copyCustomArea();
        this.copyPlusMinusArea();
        this.copySumConfArea();
        this.getPageCache().put("copyInitFlag", Boolean.TRUE.toString());
    }

    private void copyPlusMinusArea() {
        Object[] saveIdArr;
        DynamicObjectCollection areaConfEntryColl = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("areaconfentry");
        HashMap<Long, Integer> plusMinusAreaIdAndSeqMap = new HashMap<Long, Integer>(16);
        for (int seq = 0; seq < areaConfEntryColl.size(); ++seq) {
            DynamicObject areaConfDynObj = (DynamicObject)areaConfEntryColl.get(seq);
            long areaRegId = areaConfDynObj.getLong("areareg.id");
            if (PLUS_MINUS_AREA_PK != areaRegId) continue;
            plusMinusAreaIdAndSeqMap.put(areaConfDynObj.getLong("areaconf"), seq);
        }
        if (plusMinusAreaIdAndSeqMap.isEmpty()) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("epa_attachconf");
        DynamicObject[] areaFieldDynObjArr = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", plusMinusAreaIdAndSeqMap.keySet())});
        HashMap<Long, Long> areaConfIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, DynamicObject> areaConfIdAndDynObjMap = new HashMap<Long, DynamicObject>(16);
        long[] normalAreaIdArr = DB.genGlobalLongIds((int)areaFieldDynObjArr.length);
        for (int i = 0; i < areaFieldDynObjArr.length; ++i) {
            DynamicObject areaFieldDynObj = areaFieldDynObjArr[i];
            DynamicObject emptyDynamicObject = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)areaFieldDynObj, (DynamicObject)emptyDynamicObject);
            emptyDynamicObject.set("id", (Object)normalAreaIdArr[i]);
            areaConfIdMap.put(emptyDynamicObject.getLong("id"), areaFieldDynObj.getLong("id"));
            areaConfIdAndDynObjMap.put(areaFieldDynObj.getLong("id"), emptyDynamicObject);
        }
        if (areaConfIdAndDynObjMap.isEmpty()) {
            return;
        }
        for (Object savedAreaConfDynObj : saveIdArr = serviceHelper.save(areaConfIdAndDynObjMap.values().toArray(new DynamicObject[0]))) {
            DynamicObject dynObj = (DynamicObject)savedAreaConfDynObj;
            Long oldAreaConfId = (Long)areaConfIdMap.get(dynObj.getLong("id"));
            Integer seq = (Integer)plusMinusAreaIdAndSeqMap.get(oldAreaConfId);
            this.getModel().setValue("areaconf", (Object)dynObj.getLong("id"), seq.intValue());
        }
    }

    private void copyCustomArea() {
        Object[] saveIdArr;
        DynamicObjectCollection areaConfEntryColl = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("areaconfentry");
        HashMap<Long, Integer> customAreaIdAndSeqMap = new HashMap<Long, Integer>(16);
        for (int seq = 0; seq < areaConfEntryColl.size(); ++seq) {
            DynamicObject areaConfDynObj = (DynamicObject)areaConfEntryColl.get(seq);
            long areaRegId = areaConfDynObj.getLong("areareg.id");
            if (CUSTOM_AREA_PK != areaRegId) continue;
            customAreaIdAndSeqMap.put(areaConfDynObj.getLong("areaconf"), seq);
        }
        if (customAreaIdAndSeqMap.isEmpty()) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("epa_attachconf");
        DynamicObject[] areaFieldDynObjArr = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", customAreaIdAndSeqMap.keySet())});
        HashMap<Long, Long> areaConfIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, DynamicObject> areaConfIdAndDynObjMap = new HashMap<Long, DynamicObject>(16);
        long[] normalAreaIdArr = DB.genGlobalLongIds((int)areaFieldDynObjArr.length);
        for (int i = 0; i < areaFieldDynObjArr.length; ++i) {
            DynamicObject areaFieldDynObj = areaFieldDynObjArr[i];
            DynamicObject emptyDynamicObject = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)areaFieldDynObj, (DynamicObject)emptyDynamicObject);
            emptyDynamicObject.set("id", (Object)normalAreaIdArr[i]);
            areaConfIdMap.put(emptyDynamicObject.getLong("id"), areaFieldDynObj.getLong("id"));
            areaConfIdAndDynObjMap.put(areaFieldDynObj.getLong("id"), emptyDynamicObject);
        }
        if (areaConfIdAndDynObjMap.isEmpty()) {
            return;
        }
        for (Object savedAreaConfDynObj : saveIdArr = serviceHelper.save(areaConfIdAndDynObjMap.values().toArray(new DynamicObject[0]))) {
            DynamicObject dynObj = (DynamicObject)savedAreaConfDynObj;
            Long oldAreaConfId = (Long)areaConfIdMap.get(dynObj.getLong("id"));
            Integer seq = (Integer)customAreaIdAndSeqMap.get(oldAreaConfId);
            this.getModel().setValue("areaconf", (Object)dynObj.getLong("id"), seq.intValue());
        }
    }

    private void copyAttachmentConfArea() {
        Object[] saveIdArr;
        DynamicObjectCollection areaConfEntryColl = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("areaconfentry");
        HashMap<Long, Integer> attachmentAreaIdAndSeqMap = new HashMap<Long, Integer>(16);
        for (int seq = 0; seq < areaConfEntryColl.size(); ++seq) {
            DynamicObject areaConfDynObj = (DynamicObject)areaConfEntryColl.get(seq);
            long areaRegId = areaConfDynObj.getLong("areareg.id");
            if (ATTACH_AREA_PK != areaRegId) continue;
            attachmentAreaIdAndSeqMap.put(areaConfDynObj.getLong("areaconf"), seq);
        }
        if (attachmentAreaIdAndSeqMap.isEmpty()) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("epa_attachconf");
        DynamicObject[] areaFieldDynObjArr = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", attachmentAreaIdAndSeqMap.keySet())});
        HashMap<Long, Long> areaConfIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, DynamicObject> areaConfIdAndDynObjMap = new HashMap<Long, DynamicObject>(16);
        long[] normalAreaIdArr = DB.genGlobalLongIds((int)areaFieldDynObjArr.length);
        for (int i = 0; i < areaFieldDynObjArr.length; ++i) {
            DynamicObject areaFieldDynObj = areaFieldDynObjArr[i];
            DynamicObject emptyDynamicObject = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)areaFieldDynObj, (DynamicObject)emptyDynamicObject);
            emptyDynamicObject.set("id", (Object)normalAreaIdArr[i]);
            areaConfIdMap.put(emptyDynamicObject.getLong("id"), areaFieldDynObj.getLong("id"));
            areaConfIdAndDynObjMap.put(areaFieldDynObj.getLong("id"), emptyDynamicObject);
        }
        if (areaConfIdAndDynObjMap.isEmpty()) {
            return;
        }
        for (Object savedAreaConfDynObj : saveIdArr = serviceHelper.save(areaConfIdAndDynObjMap.values().toArray(new DynamicObject[0]))) {
            DynamicObject dynObj = (DynamicObject)savedAreaConfDynObj;
            Long oldAreaConfId = (Long)areaConfIdMap.get(dynObj.getLong("id"));
            Integer seq = (Integer)attachmentAreaIdAndSeqMap.get(oldAreaConfId);
            this.getModel().setValue("areaconf", (Object)dynObj.getLong("id"), seq.intValue());
        }
    }

    private void copyEmpInfoArea() {
        long empInfoConfId = this.getModel().getDataEntity().getLong("empinfoconf");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("epa_empinfoconf");
        DynamicObject areaFieldDynObj = serviceHelper.loadSingle((Object)empInfoConfId);
        DynamicObject emptyDynamicObject = serviceHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)areaFieldDynObj, (DynamicObject)emptyDynamicObject);
        Object savedEmpInfoDynObj = serviceHelper.saveOne(emptyDynamicObject);
        this.getModel().setValue("empinfoconfnew", (Object)((DynamicObject)savedEmpInfoDynObj).getLong("id"));
    }

    private void copyNormalAreaExcludeScoreSystem() {
        DynamicObjectCollection areaConfEntryColl = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("areaconfentry");
        HashMap<Long, Integer> normalAreaIdAndSeqMap = new HashMap<Long, Integer>(16);
        for (int seq = 0; seq < areaConfEntryColl.size(); ++seq) {
            DynamicObject areaConfDynObj = (DynamicObject)areaConfEntryColl.get(seq);
            long areaRegId = areaConfDynObj.getLong("areareg.id");
            if (NORM_INDCTR_AREA_PK != areaRegId) continue;
            normalAreaIdAndSeqMap.put(areaConfDynObj.getLong("areaconf"), seq);
        }
        if (normalAreaIdAndSeqMap.isEmpty()) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("epa_normalconf");
        DynamicObject[] areaFieldDynObjArr = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", normalAreaIdAndSeqMap.keySet())});
        Map<Object, Long> customNameConfIdMap = Arrays.stream(areaFieldDynObjArr).collect(Collectors.toMap(areaFieldDynObj -> areaFieldDynObj.get("areacustname"), areaFieldDynObj -> areaFieldDynObj.getLong("id")));
        String scoreCalcWayOldCacheVal = this.getPageCache().get("scoreCalcWayOldCacheVal");
        if (HRStringUtils.isNotEmpty((String)scoreCalcWayOldCacheVal)) {
            Object[] defaultNormalConfArr;
            ScoreCalcWayEnum scoreCalcWayEnum = ScoreCalcWayEnum.getScoreCalcWay((String)String.valueOf(this.getModel().getValue("scorecalcway")));
            EvalWayEnum evalWayEnum = EvalWayEnum.getEvalWay((String)String.valueOf(this.getModel().getValue("evalway")));
            DynamicObject assessFormDynObj = this.getModel().getDataEntity();
            List areaNameList = Arrays.stream(areaFieldDynObjArr).map(areaFieldDynObj -> areaFieldDynObj.get("areacustname")).collect(Collectors.toList());
            long[] normalAreaIdArr = DB.genGlobalLongIds((int)areaFieldDynObjArr.length);
            HashMap normalAreaNameAndNewIdMap = new HashMap(areaFieldDynObjArr.length);
            for (int i = 0; i < areaFieldDynObjArr.length; ++i) {
                Object t = areaNameList.get(i);
                long newNormalAreaId = normalAreaIdArr[i];
                normalAreaNameAndNewIdMap.put(newNormalAreaId, t);
            }
            for (Object object : defaultNormalConfArr = ASSESS_RULE_APP_SERVICE.getDefaultNormalConfArr(assessFormDynObj, normalAreaNameAndNewIdMap, scoreCalcWayEnum, evalWayEnum)) {
                DynamicObject dynObj = (DynamicObject)object;
                long defaultNormalConfId = dynObj.getLong("id");
                Object areaName = normalAreaNameAndNewIdMap.get(defaultNormalConfId);
                Long oldNormalAreaConfId = customNameConfIdMap.get(areaName);
                Integer seq = (Integer)normalAreaIdAndSeqMap.get(oldNormalAreaConfId);
                this.getModel().setValue("areaconf", (Object)dynObj.getLong("id"), seq.intValue());
            }
        } else {
            Object[] saveIdArr;
            HashMap<Long, Long> areaConfIdMap = new HashMap<Long, Long>(16);
            HashMap<Long, DynamicObject> areaConfIdAndDynObjMap = new HashMap<Long, DynamicObject>(16);
            long[] normalAreaIdArr = DB.genGlobalLongIds((int)areaFieldDynObjArr.length);
            for (int i = 0; i < areaFieldDynObjArr.length; ++i) {
                DynamicObject areaFieldDynObj2 = areaFieldDynObjArr[i];
                DynamicObject emptyDynamicObject = serviceHelper.generateEmptyDynamicObject();
                HashSet<String> ignoreCopyFieldSet = new HashSet<String>(4);
                ignoreCopyFieldSet.add("scoresystem");
                ignoreCopyFieldSet.add("scoresystem_id");
                HRDynamicObjectUtils.copy((DynamicObject)areaFieldDynObj2, (DynamicObject)emptyDynamicObject, ignoreCopyFieldSet);
                emptyDynamicObject.set("id", (Object)normalAreaIdArr[i]);
                areaConfIdMap.put(emptyDynamicObject.getLong("id"), areaFieldDynObj2.getLong("id"));
                areaConfIdAndDynObjMap.put(areaFieldDynObj2.getLong("id"), emptyDynamicObject);
            }
            if (areaConfIdAndDynObjMap.isEmpty()) {
                return;
            }
            for (Object object : saveIdArr = serviceHelper.save(areaConfIdAndDynObjMap.values().toArray(new DynamicObject[0]))) {
                DynamicObject dynObj = (DynamicObject)object;
                Long oldAreaConfId = (Long)areaConfIdMap.get(dynObj.getLong("id"));
                Integer n = (Integer)normalAreaIdAndSeqMap.get(oldAreaConfId);
                this.getModel().setValue("areaconf", (Object)dynObj.getLong("id"), n.intValue());
            }
        }
    }

    private void copySumConfArea() {
        HRBaseServiceHelper sumServiceHelper = new HRBaseServiceHelper("epa_sumconf");
        long sumConfId = this.getModel().getDataEntity().getLong("sumconf");
        DynamicObject sumConfDynObj = sumServiceHelper.loadSingle((Object)sumConfId);
        DynamicObject emptySumConfDynObj = sumServiceHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)sumConfDynObj, (DynamicObject)emptySumConfDynObj);
        Object sumPerfLevelObj = this.getModel().getDataEntity().get("sumperflevel");
        if (sumPerfLevelObj == null) {
            DynamicObjectCollection entryColl = emptySumConfDynObj.getDynamicObjectCollection("entryentity");
            entryColl.removeIf(next -> next.getLong("areafield.id") == 1539882034862772224L);
        }
        Object savedSumConfDynObj = sumServiceHelper.saveOne(emptySumConfDynObj);
        this.getModel().setValue("sumconf", (Object)((DynamicObject)savedSumConfDynObj).getLong("id"));
    }

    private void drawMiddleAreas() {
        DynamicObjectCollection areaConfigs = this.getModel().getEntryEntity("areaconfentry");
        int size = areaConfigs.size();
        FlexPanelAp areaShowAp = this.getShowAp("areashowap");
        int index = 0;
        for (DynamicObject row : areaConfigs) {
            String formId = row.getString("areareg.number");
            long areaConfNew = row.getLong("areaconfnew");
            long areaConf = row.getLong("areaconf");
            this.showArea(areaShowAp, index, areaConfNew > 0L ? areaConfNew : areaConf, formId, size, areaConfNew > 0L ? "confedit" : "confadd");
            ++index;
        }
        this.getView().updateControlMetadata(areaShowAp.getKey(), areaShowAp.createControl());
    }

    private FlexPanelAp getShowAp(String key) {
        return new HRFlexPanelAp.Builder(key).setDirection("column").setAlignItems("stretch").setJustifyContent("flex-start").setWrap(false).setGrow(1).setShrink(0).build();
    }

    private void drawSingleArea(String apKey, String formId, Long confId, String confType) {
        FlexPanelAp singleShowAp = this.getShowAp(apKey);
        String targetKey = singleShowAp.getKey() + System.currentTimeMillis();
        FlexPanelAp cardAp = new HRFlexPanelAp.Builder(targetKey).build();
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(formId);
        showParameter.setStatus(this.getAreaStatus());
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        showParameter.setCustomParam("confid", (Object)confId);
        showParameter.setCustomParam("conftype", (Object)confType);
        this.getView().showForm((FormShowParameter)showParameter);
        singleShowAp.getItems().add(cardAp);
        this.getView().updateControlMetadata(singleShowAp.getKey(), singleShowAp.createControl());
    }

    private OperationStatus getAreaStatus() {
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        String status = (String)this.getModel().getValue("status");
        if (OperationStatus.VIEW == operationStatus || !"A".equals(status)) {
            return OperationStatus.VIEW;
        }
        return OperationStatus.EDIT;
    }

    private void showArea(FlexPanelAp areaShowAp, int index, Long confId, String formId, int size, String confType) {
        String targetKey = areaShowAp.getKey() + System.currentTimeMillis();
        FlexPanelAp cardAp = new HRFlexPanelAp.Builder(targetKey).build();
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(formId);
        showParameter.setStatus(this.getAreaStatus());
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        showParameter.setCustomParam("confid", (Object)confId);
        showParameter.setCustomParam("index", (Object)index);
        showParameter.setCustomParam("size", (Object)size);
        showParameter.setCustomParam("scorecalcway", this.getModel().getValue("scorecalcway"));
        showParameter.setCustomParam("evalway", this.getModel().getValue("evalway"));
        showParameter.setCustomParam("numaccuracy", this.getModel().getValue("numaccuracy"));
        showParameter.setCustomParam("limitmaxratio", this.getModel().getValue("limitmaxratio"));
        showParameter.setCustomParam("evasumlimit", this.getModel().getValue("evasumlimit"));
        showParameter.setCustomParam("conftype", (Object)confType);
        this.getView().showForm((FormShowParameter)showParameter);
        areaShowAp.getItems().add(cardAp);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("addarea".equals(key)) {
            if (this.getModel().getEntryEntity("areaconfentry").size() >= 10) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6307\u6807\u533a\u6570\u91cf\u5df2\u8fbe\u4e0a\u965010\u4e2a\uff0c\u65e0\u6cd5\u518d\u6dfb\u52a0\u3002", (String)"AssessFormEdit_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            } else {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setStatus(OperationStatus.ADDNEW);
                formShowParameter.setFormId("epa_addareadlg");
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_addareadlg"));
                this.getView().showForm(formShowParameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        switch (actionId) {
            case "epa_normindctrarea": 
            case "epa_plusminusarea": 
            case "epa_attacharea": 
            case "epa_customarea": {
                this.changeAreaConf((Map)returnData);
                this.setNameHashSet();
                break;
            }
            case "epa_addareadlg": {
                if (returnData == null) break;
                this.addArea((DynamicObject)returnData);
                this.setNameHashSet();
                break;
            }
            case "epa_sumarea": {
                this.getModel().setValue("sumconfnew", returnData);
                this.drawSingleArea("sumshowap", "epa_sumarea", (Long)returnData, "confedit");
                this.setNameHashSet();
                break;
            }
            case "epa_empinfoarea": {
                this.getModel().setValue("empinfoconfnew", returnData);
                this.drawSingleArea("empinfoshowap", "epa_empinfoarea", (Long)returnData, "confedit");
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        if (HRStringUtils.equals((String)this.getPageCache().get(this.getView().getPageId()), (String)"confirmchangenoaudit")) {
            source.setOperateKey("confirmchangenoaudit");
            source.setType("donothing");
        }
        switch (source.getOperateKey()) {
            case "save": {
                this.validateSave();
                break;
            }
            case "submit": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                this.saveTempValue();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (!ObjectUtils.isEmpty((Object)args.getOperationResult()) && args.getOperationResult().isSuccess()) {
            String operateKey;
            switch (operateKey = args.getOperateKey()) {
                case "bar_last": {
                    this.last();
                    break;
                }
                case "bar_next": {
                    this.next();
                    break;
                }
                case "save": {
                    this.setSaveOperationView();
                    this.drawAssessPage();
                    break;
                }
                case "confirmchangenoaudit": {
                    this.validateSave();
                    this.setConfirmOperationView();
                    this.drawAssessPage();
                    this.getPageCache().put(this.getView().getPageId(), "");
                    break;
                }
                case "insertdata_his": {
                    if (!"2".equals(this.getPageCache().get("wizardTabIndex"))) break;
                    CUSTOM_REGION_CACHE.put(this.getModel().getDataEntity().getLong("boid") + "-" + UserServiceHelper.getCurrentUserId() + "wizardTabIndex", (Object)"2");
                    break;
                }
            }
        }
    }

    private void setSaveOperationView() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_last_btn"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"exit"});
    }

    private void setConfirmOperationView() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_last_btn", "bar_revise", "bar_next_btn", "bar_next_btn_his", "bar_last_btn_his"});
    }

    private void validateSave() {
        this.saveTempValue();
    }

    private void showPlusMinusValidateConfirm(IFormView parentView) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(EPA_PLUS_MINUS_CONF_VALIDATE);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EPA_PLUS_MINUS_CONF_VALIDATE));
        Map tipsMap = ShowConfigTipsUtils.getTipsByFormId((String)EPA_PLUS_MINUS_CONF_VALIDATE);
        showParameter.setCustomParam("tiptext", (Object)tipsMap);
        parentView.showForm(showParameter);
    }

    private boolean valPlusAndMinusIsZero(DynamicObject plusMinusConfigDy) {
        if (HRObjectUtils.isEmpty((Object)plusMinusConfigDy)) {
            return Boolean.FALSE;
        }
        BigDecimal pluslimit = plusMinusConfigDy.getBigDecimal("pluslimit");
        BigDecimal minuslimit = plusMinusConfigDy.getBigDecimal("minuslimit");
        if (!(null != pluslimit && pluslimit.compareTo(BigDecimal.ZERO) != 0 || null != minuslimit && minuslimit.compareTo(BigDecimal.ZERO) != 0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void saveTempValue() {
        Long sumConfNew;
        Long empInfoConfNew = (Long)this.getModel().getValue("empinfoconfnew");
        if (empInfoConfNew > 0L) {
            this.getModel().setValue("empinfoconf", (Object)empInfoConfNew);
        }
        if ((sumConfNew = (Long)this.getModel().getValue("sumconfnew")) > 0L) {
            this.getModel().setValue("sumconf", (Object)sumConfNew);
        }
        int index = 0;
        for (DynamicObject row : this.getModel().getEntryEntity("areaconfentry")) {
            Long areaConfNew = (Long)row.get("areaconfnew");
            if (areaConfNew > 0L) {
                this.getModel().setValue("areaconf", (Object)areaConfNew, index);
            }
            ++index;
        }
    }

    private void addArea(DynamicObject addConf) {
        DynamicObject areaReg = addConf.getDynamicObject("areareg");
        DynamicObjectCollection areaConfEntry = this.getModel().getEntryEntity("areaconfentry");
        DynamicObject conf = areaConfEntry.addNew();
        conf.set("areaconfnew", (Object)this.getAreaDefaultConf((Long)areaReg.getPkValue(), addConf.get("areacustname")));
        conf.set("areareg", (Object)areaReg);
        this.getModel().updateEntryCache(areaConfEntry);
        this.drawMiddleAreas();
    }

    private Long getAreaDefaultConf(Long areaRegPk, Object areaName) {
        if (NORM_INDCTR_AREA_PK.equals(areaRegPk)) {
            ScoreCalcWayEnum scoreCalcWayEnum = ScoreCalcWayEnum.getScoreCalcWay((String)String.valueOf(this.getModel().getValue("scorecalcway")));
            EvalWayEnum evalWayEnum = EvalWayEnum.getEvalWay((String)String.valueOf(this.getModel().getValue("evalway")));
            DynamicObject assessFormDynObj = this.getModel().getDataEntity();
            return ASSESS_RULE_APP_SERVICE.getDefaultNormalConf(assessFormDynObj, areaName, scoreCalcWayEnum, evalWayEnum);
        }
        if (PLUS_MINUS_AREA_PK.equals(areaRegPk)) {
            return ASSESS_RULE_APP_SERVICE.getDefaultPlusMinusConf(areaName);
        }
        if (ATTACH_AREA_PK.equals(areaRegPk)) {
            return ASSESS_RULE_APP_SERVICE.getDefaultAttachConf(areaName);
        }
        if (CUSTOM_AREA_PK.equals(areaRegPk)) {
            return ASSESS_RULE_APP_SERVICE.getDefaultCustomConf(areaName);
        }
        return null;
    }

    private void changeAreaConf(Map<String, Object> returnMap) {
        String opCode = (String)returnMap.get("opcode");
        int index = (Integer)returnMap.get("index");
        switch (opCode) {
            case "editarea": {
                this.getModel().setValue("areaconfnew", returnMap.get("confid"), index);
                break;
            }
            case "delarea": {
                this.getModel().deleteEntryRow("areaconfentry", index);
                break;
            }
            case "moveareaup": {
                this.getModel().moveEntryRowUp("areaconfentry", index);
                break;
            }
            case "moveareadown": {
                this.getModel().moveEntryRowDown("areaconfentry", index);
                break;
            }
        }
        this.drawMiddleAreas();
    }

    private void initTips() {
        this.setTips("limitmaxscore", this.getModel().getDataEntity());
        this.setTips("limitminscore", this.getModel().getDataEntity());
        this.setTips("evasumlimit", this.getModel().getDataEntity());
    }

    private void setTips(String key, DynamicObject dynamicObject) {
        List limitTips = IHRCS_TIP_SERVICE.getTips("epa_assessform", key, dynamicObject);
        String tipContent = "";
        if (!ObjectUtils.isEmpty((Object)limitTips) && StringUtils.isNotBlank((CharSequence)(tipContent = (String)limitTips.get(0)))) {
            HashMap<String, Tips> props = new HashMap<String, Tips>(16);
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString(tipContent));
            props.put("tips", tips);
            this.getView().updateControlMetadata(key, props);
        }
    }
}

