/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.assessrule;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.DBServiceHelper;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.common.constants.AssessProcessConstants;
import kd.opmc.epa.common.constants.FlowNodeConfigConstants;
import kd.opmc.epa.common.constants.PassNodeConstants;
import kd.opmc.epa.common.enums.assessrule.EvalProcessOperationEnum;
import kd.opmc.epa.formplugin.web.activitymanage.activity.DynamicPermssionConfigCacheUtils;
import kd.opmc.epa.formplugin.web.activitymanage.utils.ActivityTabsUtils;
import kd.opmc.epa.formplugin.web.utils.ChangeNodeNameUtils;
import kd.opmc.epa.formplugin.web.utils.permission.AssActivityPermissionUtils;
import kd.opmc.epa.formplugin.web.utils.permission.CheckWorkFlowPermissionUtils;
import kd.opmc.pbs.business.application.service.workflow.FlowDefProcApplicationService;
import kd.opmc.pbs.business.application.service.workflow.WorkFlowApplicationService;
import kd.opmc.pbs.business.domain.workflow.constants.FlowCheckConfigConstants;
import kd.opmc.pbs.business.domain.workflow.entityservice.WorkFlowEntityService;
import kd.opmc.pbs.business.domain.workflow.model.CheckFlowBo;
import kd.opmc.pbs.business.model.FlowDefProcBo;
import kd.opmc.pbs.business.model.FlowDefProcItemBo;
import kd.opmc.pbs.business.model.FlowNodeBo;
import kd.opmc.pbs.business.model.FlowNodeItemBo;
import kd.opmc.pbs.business.model.NodeRoleBo;
import kd.opmc.pbs.business.model.SendFlowControlBo;
import kd.opmc.pbs.common.constants.NodeTypeConstants;
import kd.opmc.pbs.common.constants.RoleTypeConstants;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;

public class AssessWorkflowEdit
extends HRDataBaseEdit
implements AssessProcessConstants,
FlowNodeConfigConstants {
    private static final Log LOGGER = LogFactory.getLog(AssessWorkflowEdit.class);
    private static final WorkFlowApplicationService WORK_FLOW_APPLICATION_SERVICE = WorkFlowApplicationService.getInstance();
    private static final FlowDefProcApplicationService FLOW_DEF_PROC_APPLICATION_SERVICE = FlowDefProcApplicationService.getInstance();
    private static final WorkFlowEntityService WORK_FLOW_ENTITY_SERVICE = WorkFlowEntityService.getInstance();
    private static final String CHECK_FLOW = "checkflow";
    private static final String WORKFLOW_ENTITY_NUMBER = "pbs_workflow";
    private static final String FLOW_ENTRY = "flowentry";
    private static final String PUBLISHED = "20";
    private static final String INDEX_FLOW_NODE = "indexflownode";
    private static final String FLOW_CONFIG_FLEX_AP = "flowconfigflexap";
    private static final String FLOW_CONTROL = "flowcontrol";
    private static final String BASEDATA_PROC_SIM = "flowdefprocs";
    private static final String BASEDATA_PROC_ITEMS = "flowdefprocitems";
    private static final String PAGE_ID = "pageId";
    private static final String CLOSED = "workFLowPageExit";
    private static final String CLICK = "click";
    private static final String DELETE = "delete";
    private static final String INIT = "init";
    private static final String ADD = "add";
    private static final String EDIT = "edit";
    private static final String COPY = "copy";
    private static final String EXAMINE_NODE_TYPE = "70";
    private static final String WORK_FLOW_PAGE_ID = "workFlowPageId";
    private static final String CLOSE_NODECONFIG = "closenodeconfig";
    private static final String OPEN_NODECONFIG = "opennodeconfig";
    private static final String CACHE_CHECKED = "checked";
    private static final String CACHE_FLOWDEFPROCBOS = "flowDefProcBos";
    private static final String CACHE_TYPE = "type";
    private static final String CANCEL_CHANGE = "cancelchange";

    public void beforeBindData(EventObject e) {
        long flowBoId;
        super.beforeBindData(e);
        BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        String workflowType = (String)baseShowParameter.getCustomParam("flowType");
        String flowOpType = (String)baseShowParameter.getCustomParam("flowOpType");
        LinkedList<FlowDefProcBo> flowDefProcs = new LinkedList<FlowDefProcBo>();
        long ruleId = Long.parseLong(baseShowParameter.getCustomParam("assessruleid").toString());
        this.getView().getPageCache().put("assessruleid", String.valueOf(ruleId));
        LinkedList<FlowDefProcItemBo> flowDefProcItems = new LinkedList<FlowDefProcItemBo>();
        Boolean tipRef = (Boolean)baseShowParameter.getCustomParam("tipRef");
        if (!OperationStatus.ADDNEW.equals((Object)baseShowParameter.getStatus())) {
            DynamicObject lastWorkflow;
            flowBoId = Long.parseLong(baseShowParameter.getPkId().toString());
            this.getView().getPageCache().put("flowid", String.valueOf(flowBoId));
            if (OperationStatus.VIEW.equals((Object)baseShowParameter.getStatus())) {
                List<Long> vids = Collections.singletonList(flowBoId);
                DynamicObject[] obj = WORK_FLOW_APPLICATION_SERVICE.getWorkflowsByVid(vids);
                lastWorkflow = ObjectUtils.isNotEmpty((Object)obj) ? obj[0] : WORK_FLOW_APPLICATION_SERVICE.getLastWorkflow(flowBoId);
            } else if (Boolean.TRUE.equals(tipRef)) {
                lastWorkflow = WORK_FLOW_APPLICATION_SERVICE.getWorkflowById(flowBoId);
                this.getView().getPageCache().put("flowid", String.valueOf(lastWorkflow.getLong("boid")));
            } else {
                lastWorkflow = WORK_FLOW_APPLICATION_SERVICE.getLastWorkflow(flowBoId);
            }
            this.getModel().setValue("name", (Object)lastWorkflow.getString("name"));
            this.getModel().setValue("ismatrix", (Object)lastWorkflow.getBoolean("ismatrix"));
            this.initFlowNodes(flowDefProcs, flowDefProcItems, lastWorkflow);
        } else if (HRStringUtils.equals((String)"flowcopy", (String)flowOpType)) {
            flowBoId = (Long)baseShowParameter.getCustomParam("flowId");
            DynamicObject lastWorkflow = WORK_FLOW_APPLICATION_SERVICE.getWorkflowById(flowBoId);
            this.initFlowNodes(flowDefProcs, flowDefProcItems, lastWorkflow);
            this.initCopyFlowDefProcItem(flowDefProcs, flowDefProcItems);
        } else {
            this.initFlowNode(flowDefProcs, workflowType);
            this.initFlowDefProcItem(flowDefProcs, flowDefProcItems);
        }
        String operateType = (String)this.getView().getFormShowParameter().getCustomParam("operateType");
        if (HRStringUtils.isEmpty((String)operateType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btncancel"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap"});
        }
        this.getView().getPageCache().put(FLOW_CONFIG_FLEX_AP, "invisible");
        this.getModel().setValue(BASEDATA_PROC_SIM, (Object)((Object)flowDefProcs).toString());
        this.getModel().setValue(BASEDATA_PROC_ITEMS, (Object)((Object)flowDefProcItems).toString());
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
    }

    private void initFlowNodes(List<FlowDefProcBo> flowDefProcs, List<FlowDefProcItemBo> flowDefProcItems, DynamicObject lastWorkflow) {
        DynamicObjectCollection entryEntity = lastWorkflow.getDynamicObjectCollection("entryentity");
        List procIds = entryEntity.stream().map(dynamicObject -> dynamicObject.getLong("flowdefproc")).collect(Collectors.toList());
        FLOW_DEF_PROC_APPLICATION_SERVICE.initFlowNode(flowDefProcs, flowDefProcItems, procIds);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        int type = 0;
        if (OperationStatus.VIEW.equals((Object)baseShowParameter.getStatus())) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            type = 1;
        } else if (OperationStatus.EDIT.equals((Object)baseShowParameter.getStatus())) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
        } else if (OperationStatus.ADDNEW.equals((Object)baseShowParameter.getStatus())) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.ADDNEW);
            type = 2;
        }
        this.getView().getPageCache().put("operationStatus", String.valueOf(type));
        this.putClosedPageCache();
        this.sendDateToCustomControl(type, INIT, "1,1", JSONArray.parseArray((String)this.getModel().getValue(BASEDATA_PROC_SIM).toString(), FlowDefProcBo.class), null);
    }

    private void sendDateToCustomControl(int type, String operate, String checked, List<FlowDefProcBo> data, String pageId) {
        this.sendDateToCustomControlWithFlag(type, operate, checked, data, pageId, Boolean.TRUE);
    }

    private void sendDateToCustomControlWithFlag(int type, String operate, String checked, List<FlowDefProcBo> data, String pageId, boolean flag) {
        SendFlowControlBo sendFlow = new SendFlowControlBo();
        CustomControl objOpAp = (CustomControl)this.getControl(FLOW_CONTROL);
        sendFlow.setType(type);
        sendFlow.setOperate(operate);
        sendFlow.setChecked(checked);
        sendFlow.setData(data);
        sendFlow.setTimeStamp(System.currentTimeMillis());
        sendFlow.setFlag(flag);
        objOpAp.setData((Object)sendFlow.toString());
        if (HRStringUtils.isNotEmpty((String)pageId)) {
            this.getView().getView(pageId).sendFormAction(this.getView());
        }
    }

    private void initFlowDefProcItem(List<FlowDefProcBo> flowDefProcs, List<FlowDefProcItemBo> flowDefProcItems) {
        for (FlowDefProcBo flowDefProc : flowDefProcs) {
            FlowDefProcItemBo flowDefProcItemBo = new FlowDefProcItemBo();
            flowDefProcItemBo.setFlowName(flowDefProc.getFlowName());
            flowDefProcItemBo.setFlowSeq(flowDefProc.getFlowSeq());
            flowDefProcItemBo.setIsMajorProc(flowDefProc.isMajorProc());
            flowDefProcItemBo.setIsMatrixProc(flowDefProc.isMatrixProc());
            flowDefProcItemBo.setWorkflowtype(flowDefProc.getWorkflowType());
            List nodes = flowDefProc.getNodes();
            LinkedList<FlowNodeItemBo> itemNodes = new LinkedList<FlowNodeItemBo>();
            for (FlowNodeBo node : nodes) {
                FlowNodeItemBo flowNodeItemBo = new FlowNodeItemBo();
                flowNodeItemBo.setIsLast(node.getIsLast());
                flowNodeItemBo.setIsMajorNode(flowDefProc.isMajorProc());
                flowNodeItemBo.setIsMatrixNode(flowDefProc.isMatrixProc());
                flowNodeItemBo.setNodeName(node.getNodeName());
                flowNodeItemBo.setNodeType(node.getNodeType());
                flowNodeItemBo.setNodeTypeCode(String.valueOf(node.getNodeTypeCode()));
                flowNodeItemBo.setNodeRoleList(Collections.singletonList(new NodeRoleBo().initNodeRole(node.getNodeSeq(), 1, node.getNodeType())));
                flowNodeItemBo.setNodeWeight(node.getNodeWeight());
                flowNodeItemBo.setNodeSeq(node.getNodeSeq());
                flowNodeItemBo.setHandlerType(RoleTypeConstants.EVAPLAN_CREATOR);
                if ("3".equals(flowDefProc.getWorkflowType())) {
                    flowNodeItemBo.setHandlerType(Long.valueOf(0L));
                }
                if (NodeTypeConstants.BATCH_ADJUSTSUMSCORE.equals(node.getNodeType())) {
                    flowNodeItemBo.setAdjusetScoreLowerlimit(BigDecimal.valueOf(-2L));
                    flowNodeItemBo.setAdjustScoreUplimit(BigDecimal.valueOf(2L));
                }
                itemNodes.add(flowNodeItemBo);
            }
            flowDefProcItemBo.setNodes(itemNodes);
            flowDefProcItems.add(flowDefProcItemBo);
        }
    }

    private void initCopyFlowDefProcItem(List<FlowDefProcBo> flowDefProcs, List<FlowDefProcItemBo> flowDefProcItems) {
        for (FlowDefProcItemBo flowDefProcItem : flowDefProcItems) {
            flowDefProcItem.setId(0L);
            List nodes = flowDefProcItem.getNodes();
            for (FlowNodeItemBo node : nodes) {
                node.setId(0L);
                node.getNodeRoleList().forEach(role -> {
                    role.setId(0L);
                    role.setFlag(RandomStringUtils.randomAlphanumeric((int)6));
                });
            }
        }
    }

    public void initFlowNode(List<FlowDefProcBo> flowDefProcs, String workflowType) {
        LinkedList<FlowNodeBo> nodes = new LinkedList<FlowNodeBo>();
        if (workflowType.equals("1")) {
            nodes.add(FlowNodeBo.getInitIndicatorFormulateNode());
            nodes.add(FlowNodeBo.getInitIndicatorAuditNode());
            nodes.add(FlowNodeBo.getInitIndicatorConfirmNode());
        } else if ("2".equals(workflowType)) {
            nodes.add(FlowNodeBo.getInitSelf());
            nodes.add(FlowNodeBo.getInitDirectSuperior());
            nodes.add(FlowNodeBo.getInitLeader());
        } else if ("3".equals(workflowType)) {
            nodes.add(FlowNodeBo.getInitInterviewWriteNode());
            nodes.add(FlowNodeBo.getInitInterviewAuditNode());
        }
        FlowDefProcBo flowDefProcBo = new FlowDefProcBo();
        flowDefProcBo.setFlowSeq(1);
        flowDefProcBo.setNodes(nodes);
        flowDefProcBo.setIsMajorProc(true);
        flowDefProcBo.setIsMatrixProc(false);
        flowDefProcBo.setFlowName(ResManager.loadKDString((String)"\u4e3b\u6d41\u7a0b", (String)"AssessWorkflowEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        flowDefProcBo.setWorkflowType(workflowType);
        flowDefProcs.add(flowDefProcBo);
    }

    public void customEvent(CustomEventArgs event) {
        super.customEvent(event);
        SendFlowControlBo sendFlow = (SendFlowControlBo)JSONObject.parseObject((String)event.getEventArgs(), SendFlowControlBo.class);
        String checked = sendFlow.getChecked();
        String operate = sendFlow.getOperate();
        int type = sendFlow.getType();
        List flowDefProcBos = sendFlow.getData();
        switch (operate) {
            case "click": {
                this.clickNode(checked, flowDefProcBos, type);
                this.getView().getPageCache().put(CACHE_CHECKED, checked);
                this.getView().getPageCache().put(CACHE_FLOWDEFPROCBOS, flowDefProcBos.toString());
                this.getView().getPageCache().put(CACHE_TYPE, String.valueOf(type));
                break;
            }
            case "add": {
                String[] flowNodeSeqArr;
                this.addNode(checked, type);
                if (!StringUtils.isEmpty((CharSequence)checked) && (flowNodeSeqArr = checked.split(",")).length > 1) {
                    int nodeSeq = Integer.parseInt(flowNodeSeqArr[1]) + 1;
                    this.getView().getPageCache().put(CACHE_CHECKED, flowNodeSeqArr[0] + "," + nodeSeq);
                }
                this.getView().getPageCache().put(CACHE_FLOWDEFPROCBOS, null);
                this.getView().getPageCache().put("addnodechange:" + ((BaseShowParameter)this.getView().getFormShowParameter()).getPkId(), "true");
                break;
            }
            case "copy": {
                this.copyNode(checked, type);
                break;
            }
            case "delete": {
                this.deleteNode(checked, type);
                this.getView().getPageCache().put("delnodechange:" + ((BaseShowParameter)this.getView().getFormShowParameter()).getPkId(), "true");
                break;
            }
        }
    }

    private void copyNode(String checked, int type) {
        if (HRStringUtils.isEmpty((String)checked) && !checked.contains(",")) {
            String msg = ResManager.loadKDString((String)"\u590d\u5236\u8282\u70b9\u5931\u8d25", (String)"AssessWorkflowEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        String[] checkedArray = checked.split(",");
        int flowIndex = Integer.parseInt(checkedArray[0]);
        int nodeIndex = Integer.parseInt(checkedArray[1]);
        List flowDefProcItems = JSONArray.parseArray((String)this.getModel().getValue(BASEDATA_PROC_ITEMS).toString(), FlowDefProcItemBo.class);
        List nodes = ((FlowDefProcItemBo)flowDefProcItems.get(flowIndex - 1)).getNodes();
        List<String> nodeNames = nodes.stream().map(FlowNodeItemBo::getNodeName).collect(Collectors.toList());
        FlowNodeItemBo flowNodeItemBo = (FlowNodeItemBo)nodes.get(nodeIndex - 1);
        FlowNodeItemBo newFlowNodeItem = (FlowNodeItemBo)SerializationUtils.clone((Serializable)flowNodeItemBo);
        Long nodeType = newFlowNodeItem.getNodeType();
        if (NodeTypeConstants.EVALUATE_AUDIT.equals(nodeType)) {
            String msg = ResManager.loadKDString((String)"\u590d\u5236\u8282\u70b9\u5931\u8d25\uff0c\u5ba1\u6838\u8282\u70b9\u53ea\u80fd\u6dfb\u52a0\u4e00\u4e2a\u3002", (String)"AssessWorkflowEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        newFlowNodeItem.setId(0L);
        newFlowNodeItem.setNodeOp(COPY);
        if (flowNodeItemBo.getId() == 0L) {
            newFlowNodeItem.setSourceNodeId(flowNodeItemBo.getSourceNodeId());
        } else {
            newFlowNodeItem.setSourceNodeId(flowNodeItemBo.getId());
        }
        newFlowNodeItem.getNodeRoleList().forEach(role -> {
            role.setId(0L);
            role.setFlag(RandomStringUtils.randomAlphanumeric((int)6));
            role.getConfjson().put("isgradelevel", (Object)Boolean.FALSE);
        });
        newFlowNodeItem.setNodeName(ChangeNodeNameUtils.changeNodeName(nodeNames, newFlowNodeItem.getNodeName(), false));
        ((FlowDefProcItemBo)flowDefProcItems.get(flowIndex - 1)).getNodes().add(nodeIndex, newFlowNodeItem);
        this.sortItemNodeSeq(((FlowDefProcItemBo)flowDefProcItems.get(flowIndex - 1)).getNodes());
        this.getModel().setValue(BASEDATA_PROC_ITEMS, (Object)flowDefProcItems.toString());
        List flowDefProcBos = JSONArray.parseArray((String)this.getModel().getValue(BASEDATA_PROC_SIM).toString(), FlowDefProcBo.class);
        FlowNodeBo flowNodeBo = (FlowNodeBo)((FlowDefProcBo)flowDefProcBos.get(flowIndex - 1)).getNodes().get(nodeIndex - 1);
        FlowNodeBo newFlowNodeBo = (FlowNodeBo)SerializationUtils.clone((Serializable)flowNodeBo);
        newFlowNodeBo.setNodeName(newFlowNodeItem.getNodeName());
        ((FlowDefProcBo)flowDefProcBos.get(flowIndex - 1)).getNodes().add(nodeIndex, newFlowNodeBo);
        this.sortNodeSeq(((FlowDefProcBo)flowDefProcBos.get(flowIndex - 1)).getNodes());
        this.getModel().setValue(BASEDATA_PROC_SIM, (Object)flowDefProcBos.toString());
        this.refreshNodeSeq(nodeIndex, 1);
        this.getView().setVisible(Boolean.TRUE, new String[]{FLOW_CONFIG_FLEX_AP});
        this.showNodeConfigPage(nodeNames, newFlowNodeItem, this.getOperationStatus(type), flowIndex, nodeIndex + 1);
        if ("invisible".equals(this.getView().getPageCache().get(FLOW_CONFIG_FLEX_AP))) {
            this.getView().getPageCache().put(FLOW_CONFIG_FLEX_AP, "visible");
        }
        ((FlowDefProcBo)flowDefProcBos.get(flowIndex - 1)).getNodes().removeIf(node -> nodeIndex + 1 != node.getNodeSeq());
        this.sendDateToCustomControl(type, COPY, checked, flowDefProcBos, null);
    }

    private void addNode(String checked, int type) {
        if (HRStringUtils.isEmpty((String)checked) && !checked.contains(",")) {
            String msg = ResManager.loadKDString((String)"\u6dfb\u52a0\u8282\u70b9\u5931\u8d25", (String)"AssessWorkflowEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        String[] checkedArray = checked.split(",");
        int flowIndex = Integer.parseInt(checkedArray[0]);
        int nodeIndex = Integer.parseInt(checkedArray[1]);
        List flowDefProcItems = JSONArray.parseArray((String)this.getModel().getValue(BASEDATA_PROC_ITEMS).toString(), FlowDefProcItemBo.class);
        FlowNodeItemBo flowNodeItemBo = new FlowNodeItemBo();
        flowNodeItemBo.setHandlerType(Long.valueOf(0L));
        flowNodeItemBo.setNodeRoleList(Collections.singletonList(new NodeRoleBo().initNodeRoleForAddNode(1, NodeTypeConstants.EVALUATE_SCORE)));
        List<String> nodeNames = ((FlowDefProcItemBo)flowDefProcItems.get(flowIndex - 1)).getNodes().stream().map(FlowNodeItemBo::getNodeName).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(nodeNames) && nodeNames.size() == 15) {
            String msg = ResManager.loadKDString((String)"\u8282\u70b9\u603b\u6570\u4e0d\u53ef\u8d85\u8fc715\u4e2a", (String)"AssessWorkflowEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        ((FlowDefProcItemBo)flowDefProcItems.get(flowIndex - 1)).getNodes().add(nodeIndex, flowNodeItemBo);
        this.sortItemNodeSeq(((FlowDefProcItemBo)flowDefProcItems.get(flowIndex - 1)).getNodes());
        this.getModel().setValue(BASEDATA_PROC_ITEMS, (Object)flowDefProcItems.toString());
        List flowDefProcBos = JSONArray.parseArray((String)this.getModel().getValue(BASEDATA_PROC_SIM).toString(), FlowDefProcBo.class);
        FlowNodeBo flowNodeBo = new FlowNodeBo();
        ((FlowDefProcBo)flowDefProcBos.get(flowIndex - 1)).getNodes().add(nodeIndex, flowNodeBo);
        this.sortNodeSeq(((FlowDefProcBo)flowDefProcBos.get(flowIndex - 1)).getNodes());
        this.getModel().setValue(BASEDATA_PROC_SIM, (Object)flowDefProcBos.toString());
        this.refreshNodeSeq(nodeIndex, 1);
        this.getView().setVisible(Boolean.TRUE, new String[]{FLOW_CONFIG_FLEX_AP});
        this.showNodeConfigPage(nodeNames, flowNodeItemBo, this.getOperationStatus(type), flowIndex, nodeIndex + 1);
        if ("invisible".equals(this.getView().getPageCache().get(FLOW_CONFIG_FLEX_AP))) {
            this.getView().getPageCache().put(FLOW_CONFIG_FLEX_AP, "visible");
        }
        ((FlowDefProcBo)flowDefProcBos.get(flowIndex - 1)).getNodes().removeIf(node -> nodeIndex + 1 != node.getNodeSeq());
        this.sendDateToCustomControl(type, ADD, checked, flowDefProcBos, null);
    }

    private void deleteNode(String checked, int type) {
        if (HRStringUtils.isEmpty((String)checked) && !checked.contains(",")) {
            String msg = ResManager.loadKDString((String)"\u5220\u9664\u8282\u70b9\u5931\u8d25", (String)"AssessWorkflowEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        String[] checkedArray = checked.split(",");
        int flowIndex = Integer.parseInt(checkedArray[0]);
        int nodeIndex = Integer.parseInt(checkedArray[1]);
        List flowDefProcItems = JSONArray.parseArray((String)this.getModel().getValue(BASEDATA_PROC_ITEMS).toString(), FlowDefProcItemBo.class);
        List nodeNames = ((FlowDefProcItemBo)flowDefProcItems.get(flowIndex - 1)).getNodes().stream().map(FlowNodeItemBo::getNodeName).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(nodeNames) && nodeNames.size() == 1) {
            this.sendDateToCustomControlWithFlag(type, DELETE, checked, null, null, Boolean.FALSE);
            String msg = ResManager.loadKDString((String)"\u6d41\u7a0b\u81f3\u5c11\u4fdd\u75591\u4e2a\u8282\u70b9", (String)"AssessWorkflowEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        ((FlowDefProcItemBo)flowDefProcItems.get(flowIndex - 1)).getNodes().remove(nodeIndex - 1);
        if (((FlowDefProcItemBo)flowDefProcItems.get(flowIndex - 1)).getWorkflowtype().equals("3") && !this.checkInterviewFlowNodeCanDelete((FlowDefProcItemBo)flowDefProcItems.get(flowIndex - 1))) {
            this.sendDateToCustomControlWithFlag(type, DELETE, checked, null, null, Boolean.FALSE);
            String msg = ResManager.loadKDString((String)"\u9762\u8c08\u6d41\u7a0b\u5fc5\u987b\u6709\u4e00\u4e2a\u586b\u5199\u8282\u70b9\u3002", (String)"AssessWorkflowEdit_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        this.sortItemNodeSeq(((FlowDefProcItemBo)flowDefProcItems.get(flowIndex - 1)).getNodes());
        this.getModel().setValue(BASEDATA_PROC_ITEMS, (Object)flowDefProcItems.toString());
        List flowDefProcBos = JSONArray.parseArray((String)this.getModel().getValue(BASEDATA_PROC_SIM).toString(), FlowDefProcBo.class);
        ((FlowDefProcBo)flowDefProcBos.get(flowIndex - 1)).getNodes().remove(nodeIndex - 1);
        this.sortNodeSeq(((FlowDefProcBo)flowDefProcBos.get(flowIndex - 1)).getNodes());
        this.getModel().setValue(BASEDATA_PROC_SIM, (Object)flowDefProcBos.toString());
        String nodePageId = this.getPageCache().get("nodePageId");
        if (HRStringUtils.isNotEmpty((String)nodePageId)) {
            String flowSeq = this.getView().getView(nodePageId).getPageCache().get("flowSeq");
            String nodeSeq = this.getView().getView(nodePageId).getPageCache().get("nodeSeq");
            if (String.valueOf(flowIndex).equals(flowSeq) && String.valueOf(nodeIndex).equals(nodeSeq)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLOW_CONFIG_FLEX_AP});
                this.getView().getPageCache().put(FLOW_CONFIG_FLEX_AP, "invisible");
            }
        }
        this.refreshNodeSeq(nodeIndex, -1);
        this.sendDateToCustomControl(type, DELETE, checked, null, null);
        String msg = ResManager.loadKDString((String)"\u5220\u9664\u8282\u70b9\u6210\u529f", (String)"AssessWorkflowEdit_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        this.getView().showSuccessNotification(msg);
    }

    private void clickNode(String checked, List<FlowDefProcBo> flowDefProcBos, int type) {
        if (HRStringUtils.isEmpty((String)checked)) {
            if ("visible".equals(this.getView().getPageCache().get(FLOW_CONFIG_FLEX_AP))) {
                this.sendDateToCustomControl(type, CLICK, checked, null, null);
            }
            this.getView().getPageCache().put(FLOW_CONFIG_FLEX_AP, "invisible");
        } else {
            if ("invisible".equals(this.getView().getPageCache().get(FLOW_CONFIG_FLEX_AP))) {
                this.sendDateToCustomControl(type, CLICK, checked, flowDefProcBos, null);
            }
            this.getView().getPageCache().put(FLOW_CONFIG_FLEX_AP, "visible");
            this.getView().setVisible(Boolean.TRUE, new String[]{FLOW_CONFIG_FLEX_AP});
            List flowDefProcItems = JSONArray.parseArray((String)this.getModel().getValue(BASEDATA_PROC_ITEMS).toString(), FlowDefProcItemBo.class);
            String[] checkedArray = checked.split(",");
            int flowIndex = Integer.parseInt(checkedArray[0]);
            int nodeIndex = Integer.parseInt(checkedArray[1]);
            List nodes = ((FlowDefProcItemBo)flowDefProcItems.get(flowIndex - 1)).getNodes();
            FlowNodeItemBo flowNodeItemBo = (FlowNodeItemBo)nodes.get(nodeIndex - 1);
            if (HRStringUtils.isEmpty((String)flowNodeItemBo.getNodeTypeCode()) && null != flowNodeItemBo.getNodeType() && !flowNodeItemBo.getNodeType().equals(0L)) {
                DynamicObject nodeTypeDyn = new HRBaseServiceHelper("pbs_nodetype").queryOne("id,number", (Object)flowNodeItemBo.getNodeType());
                flowNodeItemBo.setNodeTypeCode(nodeTypeDyn.getString("number"));
            }
            if (!CollectionUtils.isEmpty(flowDefProcBos) && !CollectionUtils.isEmpty((Collection)flowDefProcBos.get(0).getNodes())) {
                flowNodeItemBo.setIsLast(((FlowNodeBo)flowDefProcBos.get(0).getNodes().get(0)).getIsLast());
            }
            List<String> nodeNames = nodes.stream().map(FlowNodeItemBo::getNodeName).collect(Collectors.toList());
            this.showNodeConfigPage(nodeNames, flowNodeItemBo, this.getOperationStatus(type), flowIndex, nodeIndex);
        }
    }

    private void setRightFlexWidth() {
        HashMap<String, LocaleString> map = new HashMap<String, LocaleString>(16);
        String workflowtype = (String)this.getView().getFormShowParameter().getCustomParam("flowType");
        String width = "64%";
        if ("2".equals(workflowtype)) {
            width = "73%";
        }
        map.put("w", new LocaleString(width));
        this.getView().updateControlMetadata(FLOW_CONFIG_FLEX_AP, map);
    }

    private void refreshNodeSeq(int nodeIndex, int step) {
        int nodeSeq;
        String nodePageId = this.getPageCache().get("nodePageId");
        if (HRStringUtils.isNotEmpty((String)nodePageId) && (nodeSeq = Integer.parseInt(this.getView().getView(nodePageId).getPageCache().get("nodeSeq"))) > nodeIndex) {
            this.getView().getView(nodePageId).getPageCache().put("nodeSeq", String.valueOf(nodeSeq + step));
        }
    }

    private void sortItemNodeSeq(List<FlowNodeItemBo> nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            nodes.get(i).setNodeSeq(i + 1);
            if (i + 1 == nodes.size()) {
                nodes.get(i).setIsLast(true);
                continue;
            }
            nodes.get(i).setIsLast(false);
        }
    }

    private void sortNodeSeq(List<FlowNodeBo> nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            nodes.get(i).setNodeSeq(i + 1);
            if (i + 1 == nodes.size()) {
                nodes.get(i).setIsLast(true);
                continue;
            }
            nodes.get(i).setIsLast(false);
        }
    }

    private OperationStatus getOperationStatus(int type) {
        if (0 == type) {
            return OperationStatus.EDIT;
        }
        if (1 == type) {
            return OperationStatus.VIEW;
        }
        if (2 == type) {
            return OperationStatus.ADDNEW;
        }
        return this.getView().getFormShowParameter().getStatus();
    }

    private void showNodeConfigPage(List<String> nodeNames, FlowNodeItemBo flowNodeItemBo, OperationStatus value, int flowSeq, int nodeSeq) {
        this.setRightFlexWidth();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_nodeconfig");
        showParameter.setStatus(value);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(FLOW_CONFIG_FLEX_AP);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_nodeconfig"));
        showParameter.setCustomParam("flownode", (Object)flowNodeItemBo);
        showParameter.setCustomParam("flowSeq", (Object)flowSeq);
        showParameter.setCustomParam("nodeSeq", (Object)nodeSeq);
        showParameter.setCustomParam("nodeNames", (Object)nodeNames.toString());
        showParameter.setCustomParam("flowType", this.getView().getFormShowParameter().getCustomParam("flowType"));
        showParameter.setCustomParam("flowId", ((BaseShowParameter)this.getView().getFormShowParameter()).getPkId());
        this.getPageCache().put("nodePageId", showParameter.getPageId());
        this.getView().showForm(showParameter);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String fieldKey = args.getProperty().getName();
        if (BASEDATA_PROC_ITEMS.equals(fieldKey) || BASEDATA_PROC_SIM.equals(fieldKey)) {
            this.removeClosedPageCache();
            return;
        }
        if (INDEX_FLOW_NODE.equals(fieldKey) || "name".equals(fieldKey) || "ismatrix".equals(fieldKey)) {
            this.removeClosedPageCache();
        }
        if (INDEX_FLOW_NODE.equals(fieldKey)) {
            List flowDefProcItems = JSONArray.parseArray((String)this.getModel().getValue(BASEDATA_PROC_ITEMS).toString(), FlowDefProcItemBo.class);
            this.handleFlowDefProcItems(flowDefProcItems);
        }
    }

    private void handleFlowDefProcItems(List<FlowDefProcItemBo> flowDefProcItems) {
        JSONObject indexFlowNode = JSONObject.parseObject((String)String.valueOf(this.getModel().getValue(INDEX_FLOW_NODE)));
        if (HRObjectUtils.isEmpty((Object)indexFlowNode)) {
            return;
        }
        String flowNode = indexFlowNode.getString("flownode");
        Integer flowSeq = indexFlowNode.getInteger("flowSeq");
        Integer nodeSeq = indexFlowNode.getInteger("nodeSeq");
        FlowNodeItemBo newNode = (FlowNodeItemBo)JSONObject.parseObject((String)flowNode, FlowNodeItemBo.class);
        String pageId = indexFlowNode.getString(PAGE_ID);
        FlowNodeItemBo oldNode = (FlowNodeItemBo)flowDefProcItems.get(flowSeq - 1).getNodes().get(nodeSeq - 1);
        newNode.setId(oldNode.getId());
        for (NodeRoleBo newRole : newNode.getNodeRoleList()) {
            for (NodeRoleBo oldRole : oldNode.getNodeRoleList()) {
                if (!HRStringUtils.equals((String)newRole.getFlag(), (String)oldRole.getFlag())) continue;
                newRole.setId(oldRole.getId());
            }
        }
        oldNode = newNode;
        flowDefProcItems.get(flowSeq - 1).getNodes().set(nodeSeq - 1, oldNode);
        this.getModel().setValue(BASEDATA_PROC_ITEMS, (Object)flowDefProcItems.toString());
        List flowDefProcBos = JSONArray.parseArray((String)this.getModel().getValue(BASEDATA_PROC_SIM).toString(), FlowDefProcBo.class);
        FlowNodeBo flowNodeBo = (FlowNodeBo)((FlowDefProcBo)flowDefProcBos.get(flowSeq - 1)).getNodes().get(nodeSeq - 1);
        if (null != newNode.getNodeType() && !newNode.getNodeType().equals(0L)) {
            flowNodeBo.setNodeTypeName(((DynamicObject)FlowNodeBo.getNodeTypeNodeMap().get(newNode.getNodeType())).getString("name"));
        }
        flowNodeBo.setNodeName(newNode.getNodeName());
        flowNodeBo.setNodeWeight(newNode.getNodeWeight());
        flowNodeBo.setNodeType(newNode.getNodeType());
        flowNodeBo.setNodeTypeCode(newNode.getNodeTypeCode());
        this.getModel().setValue(BASEDATA_PROC_SIM, (Object)flowDefProcBos.toString());
        if (HRStringUtils.isNotEmpty((String)pageId)) {
            ((FlowDefProcBo)flowDefProcBos.get(flowSeq - 1)).getNodes().clear();
            ((FlowDefProcBo)flowDefProcBos.get(flowSeq - 1)).setNodes(Collections.singletonList(flowNodeBo));
            this.sendDateToCustomControl(0, EDIT, StringUtils.join((Object[])new Serializable[]{flowSeq, ",", nodeSeq}), flowDefProcBos, pageId);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"tipclose"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("epa_publishconfirm".equals(actionId) && !HRObjectUtils.isEmpty((Object)returnData)) {
            this.flowPublish((HashMap)returnData);
            String isFromActivity = (String)this.getView().getFormShowParameter().getCustomParam("isFromActivity");
            if ("true".equals(isFromActivity)) {
                this.getView().invokeOperation(CANCEL_CHANGE);
            }
        }
    }

    private void flowPublish(HashMap<String, Object> hashMap) {
        long flowId = Long.parseLong(String.valueOf(hashMap.get("flowid")));
        String flowDescription = String.valueOf(hashMap.get("flowdescription"));
        DynamicObject workflow = WORK_FLOW_APPLICATION_SERVICE.getLastWorkflow(flowId);
        if (HRStringUtils.equals((String)PUBLISHED, (String)workflow.getString("publishstatus"))) {
            return;
        }
        String changeStyle = this.getView().getPageCache().get("radiogroupfield" + flowId);
        if (HRStringUtils.equals((String)"1", (String)changeStyle)) {
            workflow.set("datastatus", (Object)EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus());
            WORK_FLOW_APPLICATION_SERVICE.save(workflow);
        }
        workflow.set("modifytime", (Object)new Date());
        workflow.set("datastatus", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
        workflow.set("publishstatus", (Object)20);
        workflow.set("changedescription", (Object)flowDescription);
        workflow.set("bsed", (Object)HRDateTimeUtils.truncateDate((Date)new Date()));
        boolean tipRef = (Boolean)this.getView().getFormShowParameter().getCustomParam("tipRef");
        HisResponse response = WORK_FLOW_APPLICATION_SERVICE.hisVersionChange(new DynamicObject[]{workflow}, WORKFLOW_ENTITY_NUMBER, false);
        if (EnumResponseCode.SUCCESS.getCode().equals(response.getCode())) {
            this.saveFlowEntry(flowId, "flowPublish");
            String msg = ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"AssessWorkflowEdit_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().getParentView().showSuccessNotification(msg);
            if (tipRef) {
                this.getView().getParentView().getPageCache().put("saveOrPublishFlag" + flowId, "1");
            }
            this.getView().getParentView().invokeOperation("refreshcard");
            this.getView().sendFormAction(this.getView().getParentView());
            String isFromActivity = (String)this.getView().getFormShowParameter().getCustomParam("isFromActivity");
            if (!"true".equals(isFromActivity)) {
                this.getView().close();
            }
        } else {
            String msg = ResManager.loadKDString((String)"\u53d1\u5e03\u5931\u8d25\u3002", (String)"AssessWorkflowEdit_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveFlow(String operateKey, long flowId) {
        LocalDateTime waitTime;
        String lock;
        LocalDateTime currentTime = LocalDateTime.now();
        do {
            waitTime = LocalDateTime.now();
        } while (!HRStringUtils.isEmpty((String)(lock = (String)HRAppCache.get((String)"epa").get(RequestContext.get().getCurrUserId() + "workflow_roleweight", String.class))) && waitTime.getSecond() - currentTime.getSecond() <= 4);
        String isFromActivity = (String)this.getView().getFormShowParameter().getCustomParam("isFromActivity");
        boolean tipRef = (Boolean)this.getView().getFormShowParameter().getCustomParam("tipRef");
        if (!"true".equals(isFromActivity) && !CheckWorkFlowPermissionUtils.checkPermission(this.getView(), this.getPermOpStatus())) {
            return false;
        }
        if ("true".equals(isFromActivity) && !AssActivityPermissionUtils.checkActivityPerfWorkflowPermission(this.getView())) {
            return false;
        }
        ArrayList<CheckFlowBo> checkFlowBos = new ArrayList<CheckFlowBo>(10);
        String workflowName = "";
        if (null != this.getView().getModel().getValue("name")) {
            workflowName = this.getView().getModel().getValue("name").toString();
        }
        try (TXHandle txHandle = TX.required();){
            List flowDefProcItems = JSONArray.parseArray((String)this.getModel().getValue(BASEDATA_PROC_ITEMS).toString(), FlowDefProcItemBo.class);
            List flowDefProcs = JSONArray.parseArray((String)this.getModel().getValue(BASEDATA_PROC_SIM).toString(), FlowDefProcBo.class);
            for (FlowDefProcItemBo flowDef : flowDefProcItems) {
                List nodes = flowDef.getNodes();
                BigDecimal nodeSumWeight = new BigDecimal("0.0");
                for (FlowNodeItemBo node : nodes) {
                    String nodeName = node.getNodeName();
                    if (HRStringUtils.isNotEmpty((String)nodeName) && nodeName.length() > 60) {
                        CheckFlowBo checkFlowBo = new CheckFlowBo(workflowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyNodeConf(), FlowCheckConfigConstants.getCheckInfoNodeNameMaxLength());
                        checkFlowBos.add(checkFlowBo);
                    }
                    List nodeRoleBoList = node.getNodeRoleList();
                    for (NodeRoleBo nodeRoleBo : nodeRoleBoList) {
                        String roleName = nodeRoleBo.getRoleName();
                        if (HRStringUtils.isNotEmpty((String)roleName) && roleName.length() > 60) {
                            CheckFlowBo checkFlowBo = new CheckFlowBo(workflowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyRoleConf(), FlowCheckConfigConstants.getCheckInfoRoleNameMaxLength());
                            checkFlowBos.add(checkFlowBo);
                        }
                        String cacheKey = this.getView().getPageId() + "ROLEWEIGHT" + node.getNodeSeq() + nodeRoleBo.getRoleSeq();
                        String roleWeight = this.getView().getPageCache().get(cacheKey);
                        if (!HRStringUtils.isEmpty((String)roleWeight)) {
                            nodeRoleBo.setRoleWeight(Double.parseDouble(roleWeight));
                        }
                        String leastHandlerCacheKey = this.getView().getPageId() + "LEASTHANDLER" + node.getNodeSeq() + nodeRoleBo.getRoleSeq();
                        String minumHandler = (String)HRAppCache.get((String)"epa").get(leastHandlerCacheKey, String.class);
                        if (HRStringUtils.isEmpty((String)minumHandler)) continue;
                        nodeRoleBo.setMinNum(Integer.parseInt(minumHandler));
                    }
                    nodeSumWeight = nodeSumWeight.add(new BigDecimal(node.getNodeWeight()));
                }
                if (nodeSumWeight.compareTo(new BigDecimal("100.0")) <= 0) continue;
                String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6240\u6709\u8282\u70b9\u6743\u91cd\u4e4b\u548c\u4e0d\u80fd\u8d85\u8fc7100%\u3002", (String)"AssessWorkflowEdit_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                boolean bl = false;
                return bl;
            }
            if (!CollectionUtils.isEmpty(checkFlowBos)) {
                String msg = ResManager.loadKDString((String)"\u6d41\u7a0b\u6821\u9a8c\u672a\u901a\u8fc7", (String)"AssessWorkflowEdit_12", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                this.showCheckFlow(checkFlowBos, this.getView(), "epa_checkflow");
                boolean flowDef = false;
                return flowDef;
            }
            if ("true".equals(isFromActivity)) {
                DynamicPermssionConfigCacheUtils.sourceNodeIdHandle(flowDefProcItems, this.getView().getParentView());
            }
            List procIds = FLOW_DEF_PROC_APPLICATION_SERVICE.saveFlowDefProc(flowDefProcItems);
            flowDefProcItems.clear();
            flowDefProcs.clear();
            FLOW_DEF_PROC_APPLICATION_SERVICE.initFlowNode(flowDefProcs, flowDefProcItems, procIds);
            this.getModel().setValue(BASEDATA_PROC_ITEMS, (Object)flowDefProcItems.toString());
            this.getModel().setValue(BASEDATA_PROC_SIM, (Object)flowDefProcs.toString());
            if (tipRef) {
                HisResponse<VersionChangeRespData> hisResponse = this.saveTempWorkFlow(flowId, flowDefProcItems, procIds);
                if (!EnumResponseCode.SUCCESS.getCode().equals(hisResponse.getCode())) {
                    throw new RuntimeException(hisResponse.getErrorMessage());
                }
                this.getView().getParentView().getPageCache().put("saveOrPublishFlag" + flowId, "1");
            } else {
                HisResponse<VersionChangeRespData> versionChangeRespDataHisResponse = this.saveWorkFlow(flowId, flowDefProcItems, procIds);
                if (!EnumResponseCode.SUCCESS.getCode().equals(versionChangeRespDataHisResponse.getCode())) {
                    throw new RuntimeException(versionChangeRespDataHisResponse.getErrorMessage());
                }
            }
            this.saveFlowEntry(flowId, "");
            if ("true".equals(isFromActivity)) {
                this.refreshBread(workflowName);
            }
            this.putClosedPageCache();
            if ("btnsave".equals(operateKey)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"AssessWorkflowEdit_13", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
            this.getView().getParentView().invokeOperation("refreshcard");
            this.getView().sendFormAction(this.getView().getParentView());
            boolean bl = true;
            return bl;
        }
    }

    private void refreshBread(String workflowName) {
        if (HRStringUtils.isEmpty((String)workflowName)) {
            return;
        }
        IDataModel parentModel = this.getView().getParentView().getModel();
        DynamicObjectCollection itemEntry = parentModel.getEntryEntity("itementryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)parentModel;
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("select", new Object[0]);
        setter.addField("textfield", new Object[0]);
        setter.addField("entryboiditem", new Object[0]);
        setter.addField("tabspageid", new Object[0]);
        for (int i = 0; i < itemEntry.size(); ++i) {
            DynamicObject item = (DynamicObject)itemEntry.get(i);
            String textfield = item.getString("textfield");
            if (i == itemEntry.size() - 1) {
                textfield = workflowName;
            }
            setter.addRow(new Object[]{item.get("select"), textfield, item.get("entryboiditem"), item.get("tabspageid")});
        }
        model.deleteEntryData("itementryentity");
        model.batchCreateNewEntryRow("itementryentity", setter);
        model.endInit();
        this.getView().getParentView().updateView("itementryentity");
    }

    protected OperationStatus getPermOpStatus() {
        boolean tipRef = (Boolean)this.getView().getFormShowParameter().getCustomParam("tipRef");
        boolean isStash = false;
        try {
            isStash = 0L != (Long)this.getView().getParentView().getModel().getValue("id");
        }
        catch (Exception exception) {
            // empty catch block
        }
        OperationStatus status = tipRef || isStash ? OperationStatus.EDIT : OperationStatus.ADDNEW;
        return status;
    }

    private HisResponse<VersionChangeRespData> saveWorkFlow(long flowId, List<FlowDefProcItemBo> flowDefProcItems, List<Long> procIds) {
        DynamicObject currentTempWorkflow = WORK_FLOW_APPLICATION_SERVICE.getChangeLastWorkflow(flowId);
        if (null != currentTempWorkflow) {
            this.copyTemp(currentTempWorkflow);
        }
        DynamicObject workflow = this.assembleWorkFlow(flowId, flowDefProcItems, procIds);
        return WORK_FLOW_APPLICATION_SERVICE.hisVersionChange(new DynamicObject[]{workflow}, WORKFLOW_ENTITY_NUMBER, false);
    }

    private HisResponse<VersionChangeRespData> saveTempWorkFlow(long flowId, List<FlowDefProcItemBo> flowDefProcItems, List<Long> procIds) {
        DynamicObject currentTempWorkflow = WORK_FLOW_APPLICATION_SERVICE.getChangeLastWorkflow(flowId);
        DynamicObject workflow = this.assembleWorkFlow(flowId, flowDefProcItems, procIds);
        long sourcevid = workflow.getLong("sourcevid");
        if (null != currentTempWorkflow) {
            this.copyTemp(currentTempWorkflow);
            currentTempWorkflow.set("name", workflow.get("name"));
            currentTempWorkflow.set("processinfo", workflow.get("processinfo"));
            currentTempWorkflow.set("nodenum", workflow.get("nodenum"));
            currentTempWorkflow.set("publishstatus", workflow.get("publishstatus"));
            currentTempWorkflow.set("bsed", workflow.get("bsed"));
            currentTempWorkflow.set("bsled", (Object)"");
            currentTempWorkflow.set("workflowtype", workflow.get("workflowtype"));
            currentTempWorkflow.set("entryentity", (Object)workflow.getDynamicObjectCollection("entryentity"));
        } else {
            currentTempWorkflow = workflow;
        }
        return WORK_FLOW_APPLICATION_SERVICE.hisVersionChange(new DynamicObject[]{currentTempWorkflow}, WORKFLOW_ENTITY_NUMBER, false);
    }

    private void copyTemp(DynamicObject currentTempWorkflow) {
        long flowId = currentTempWorkflow.getLong("id");
        String backupFlag = this.getView().getParentView().getPageCache().get("copyTempFlowId" + flowId);
        if (HRStringUtils.isEmpty((String)backupFlag)) {
            ArrayList<Long> flowIds = new ArrayList<Long>();
            flowIds.add(flowId);
            DynamicObject copyTempWorkflow = WORK_FLOW_APPLICATION_SERVICE.generateEmptyDynamicObject();
            DynamicObject[] copyTempflows = WORK_FLOW_APPLICATION_SERVICE.getCopyTempWorkflow(flowIds);
            if (copyTempflows.length > 0) {
                copyTempWorkflow = copyTempflows[0];
            }
            HashSet<String> ignoreKeys = new HashSet<String>(Collections.singletonList("bsled"));
            HRDynamicObjectUtils.copy((DynamicObject)currentTempWorkflow, (DynamicObject)copyTempWorkflow, ignoreKeys, (boolean)true);
            copyTempWorkflow.set("hisversion", (Object)"COPYTEMP");
            copyTempWorkflow.set("iscurrentversion", (Object)0);
            long currUserId = RequestContext.get().getCurrUserId();
            copyTempWorkflow.set("boid", (Object)currUserId);
            copyTempWorkflow.set("sourcevid", (Object)currentTempWorkflow.getLong("boid"));
            long[] workflowIds = DBServiceHelper.genLongIds((String)"t_pbs_workflow", (int)1);
            long[] flowEntryIds = DBServiceHelper.genLongIds((String)"t_pbs_workflowentry", (int)1);
            copyTempWorkflow.set("id", (Object)workflowIds[0]);
            for (DynamicObject aFlowEntry : copyTempWorkflow.getDynamicObjectCollection("entryentity")) {
                aFlowEntry.set("id", (Object)flowEntryIds[0]);
                aFlowEntry.set("entryboid", (Object)flowEntryIds[0]);
                aFlowEntry.set("flowdefproc", (Object)aFlowEntry.getLong("flowdefproc"));
            }
            WORK_FLOW_APPLICATION_SERVICE.save(copyTempWorkflow);
            long copyFlowId = copyTempWorkflow.getLong("id");
            this.getView().getParentView().getPageCache().put("copyTempFlowId" + flowId, String.valueOf(copyFlowId));
        }
    }

    private DynamicObject assembleWorkFlow(long flowId, List<FlowDefProcItemBo> flowDefProcItems, List<Long> procIds) {
        int nodeSum = 0;
        DynamicObject workflow = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = workflow.getDynamicObjectCollection("entryentity");
        entryEntity.clear();
        for (FlowDefProcItemBo flowDefProcItem : flowDefProcItems) {
            nodeSum += flowDefProcItem.getNodes().size();
        }
        DynamicObject[] workflowDyn = WorkFlowEntityService.getInstance().getCopyTempWorkflow(Collections.singletonList(flowId));
        if (workflowDyn.length < 1) {
            String DELETEENTRY_SQL = "delete from  %s  where fid = ?";
            String sql = String.format(DELETEENTRY_SQL, "t_pbs_workflowentry");
            Object[] params = new SqlParameter[]{new SqlParameter("fid", -5, (Object)flowId)};
            DB.execute((DBRoute)new DBRoute("opmc"), (String)sql, (Object[])params);
        }
        for (Long procId : procIds) {
            DynamicObject dyn = entryEntity.addNew();
            dyn.set("flowdefproc", (Object)procId);
        }
        List collect = flowDefProcItems.stream().filter(FlowDefProcItemBo::isMajorProc).collect(Collectors.toList());
        StringBuilder processInfo = new StringBuilder();
        List nodes = ((FlowDefProcItemBo)collect.get(0)).getNodes();
        DecimalFormat decimalFormat = new DecimalFormat("###.##");
        String workflowtype = (String)this.getView().getFormShowParameter().getCustomParam("flowType");
        for (int i = 0; i < nodes.size(); ++i) {
            FlowNodeItemBo flowNodeItem = (FlowNodeItemBo)nodes.get(i);
            if ("2".equals(workflowtype)) {
                if (NodeTypeConstants.BATCH_ADJUSTSUMSCORE.equals(flowNodeItem.getNodeType()) || NodeTypeConstants.EVALUATE_AUDIT.equals(flowNodeItem.getNodeType())) {
                    processInfo.append(StringUtils.defaultString((String)flowNodeItem.getNodeName()));
                } else {
                    processInfo.append(StringUtils.defaultString((String)flowNodeItem.getNodeName())).append('(').append(decimalFormat.format(flowNodeItem.getNodeWeight())).append("%)");
                }
            } else if ("1".equals(workflowtype) || "3".equals(workflowtype)) {
                processInfo.append(StringUtils.defaultString((String)flowNodeItem.getNodeName()));
            }
            if (i == nodes.size() - 1) continue;
            processInfo.append("->");
        }
        if (HRObjectUtils.isEmpty((Object)workflow)) {
            workflow.set("id", (Object)flowId);
        }
        workflow.set("processinfo", (Object)processInfo.toString());
        workflow.set("nodenum", (Object)nodeSum);
        workflow.set("publishstatus", (Object)"10");
        workflow.set("bsed", (Object)HRDateTimeUtils.truncateDate((Date)new Date()));
        workflow.set("workflowtype", (Object)workflowtype);
        return workflow;
    }

    public void removeFlowEntry(long flowId) {
        String isFromActivity = (String)this.getView().getFormShowParameter().getCustomParam("isFromActivity");
        if ("true".equals(isFromActivity)) {
            DynamicObjectCollection flowentry = this.getView().getParentView().getModel().getEntryEntity(FLOW_ENTRY);
            flowentry.removeIf(entry -> entry.getLong("flowid") == flowId);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getParentView().getModel();
            model.beginInit();
            TableValueSetter setter = this.getTableValueSetterFromActivity();
            for (DynamicObject entry2 : flowentry) {
                setter.addRow(new Object[]{entry2.get("flowid"), entry2.get("flowvid"), entry2.get("entryboidflow"), entry2.get("isdefaultflow"), entry2.get("isenable"), entry2.get("passnode"), entry2.get("isdelete"), entry2.get("ischange")});
            }
            model.deleteEntryData(FLOW_ENTRY);
            model.batchCreateNewEntryRow(FLOW_ENTRY, setter);
            model.endInit();
            this.getView().getParentView().updateView(FLOW_ENTRY);
            this.getView().getParentView().invokeOperation("refreshcard");
            this.getView().sendFormAction(this.getView().getParentView());
        } else {
            DynamicObjectCollection flowentry = this.getView().getParentView().getModel().getEntryEntity(FLOW_ENTRY);
            flowentry.removeIf(entry -> entry.getLong("flowid") == flowId);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getParentView().getModel();
            model.beginInit();
            TableValueSetter setter = this.getTableValueSetter();
            for (DynamicObject entry3 : flowentry) {
                setter.addRow(new Object[]{entry3.get("flowid"), entry3.get("flowvid"), entry3.get("isdefaultflow"), entry3.get("isenable"), entry3.get("passnode")});
            }
            model.deleteEntryData(FLOW_ENTRY);
            model.batchCreateNewEntryRow(FLOW_ENTRY, setter);
            model.endInit();
            this.getView().getParentView().updateView(FLOW_ENTRY);
            this.getView().getParentView().invokeOperation("refreshcard");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    protected TableValueSetter getTableValueSetterFromActivity() {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("flowid", new Object[0]);
        setter.addField("flowvid", new Object[0]);
        setter.addField("entryboidflow", new Object[0]);
        setter.addField("isdefaultflow", new Object[0]);
        setter.addField("isenable", new Object[0]);
        setter.addField("passnode", new Object[0]);
        setter.addField("isdelete", new Object[0]);
        setter.addField("ischange", new Object[0]);
        return setter;
    }

    protected TableValueSetter getTableValueSetter() {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("flowid", new Object[0]);
        setter.addField("flowvid", new Object[0]);
        setter.addField("isdefaultflow", new Object[0]);
        setter.addField("isenable", new Object[0]);
        setter.addField("passnode", new Object[0]);
        return setter;
    }

    public void saveFlowEntry(long flowId, String opType) {
        Optional<DynamicObject> first;
        IDataModel parentModel = this.getView().getParentView().getModel();
        DynamicObjectCollection flowentry = parentModel.getEntryEntity(FLOW_ENTRY);
        String workflowType = (String)this.getView().getFormShowParameter().getCustomParam("flowType");
        List flowIds = flowentry.stream().map(entry -> entry.getLong("flowid")).collect(Collectors.toList());
        boolean isNewFlow = flowIds.contains(flowId);
        boolean isDefault = (Boolean)this.getView().getFormShowParameter().getCustomParam("isdefault");
        DynamicObject workflow = WORK_FLOW_APPLICATION_SERVICE.getWorkflow(flowId);
        if (HRStringUtils.equals((String)"flowPublish", (String)opType) && this.checkDefaultFlow(workflowType)) {
            String publishStatus = workflow.getString("publishstatus");
            isDefault = HRStringUtils.equals((String)publishStatus, (String)PUBLISHED);
        }
        long flowVid = workflow.getLong("sourcevid");
        String isFromActivity = (String)this.getView().getFormShowParameter().getCustomParam("isFromActivity");
        if ("true".equals(isFromActivity) && flowVid == 0L) {
            flowVid = flowId;
        }
        Map<Long, Integer> flowIndexMap = flowentry.stream().collect(Collectors.toMap(dy -> dy.getLong("flowid"), dy -> dy.getInt("seq")));
        AbstractFormDataModel model = (AbstractFormDataModel)parentModel;
        model.beginInit();
        TableValueSetter setter = this.getTableValueSetter();
        if (!isNewFlow) {
            if ("2".equals(workflowType)) {
                setter.addRow(new Object[]{flowId, flowVid, isDefault, Boolean.TRUE, PassNodeConstants.EVALUATE_PERF});
            } else if ("1".equals(workflowType)) {
                setter.addRow(new Object[]{flowId, flowVid, isDefault, Boolean.TRUE, PassNodeConstants.SET_INDICATOR});
            } else if ("3".equals(workflowType)) {
                setter.addRow(new Object[]{flowId, flowVid, isDefault, Boolean.TRUE, PassNodeConstants.INTERVIEW_PERFORMANCE});
            }
        }
        model.batchCreateNewEntryRow(FLOW_ENTRY, setter);
        model.endInit();
        Integer seq = flowIndexMap.get(flowId);
        if (null != seq) {
            parentModel.setValue("flowvid", (Object)flowVid, seq - 1);
            parentModel.setValue("isdefaultflow", (Object)isDefault, seq - 1);
        }
        if ("true".equals(isFromActivity) && (first = flowentry.stream().filter(entry -> entry.getLong("flowid") == flowId).findFirst()).isPresent()) {
            DynamicObject flowEntry = first.get();
            flowEntry.set("ischange", (Object)Boolean.TRUE);
        }
        this.getView().getParentView().updateView(FLOW_ENTRY);
    }

    private boolean checkDefaultFlow(String workflowType) {
        long passnode = this.changeTypeToPassnode(workflowType);
        DynamicObjectCollection dynamicObjects = this.getView().getParentView().getModel().getEntryEntity(FLOW_ENTRY);
        List<Object> defaultFlow = new ArrayList(10);
        String isFromActivity = (String)this.getView().getFormShowParameter().getCustomParam("isFromActivity");
        defaultFlow = "true".equals(isFromActivity) ? dynamicObjects.stream().filter(dy -> dy.getLong("passnode") == passnode).filter(dy -> dy.getBoolean("isdefaultflow")).filter(dy -> !dy.getBoolean("isdelete")).collect(Collectors.toList()) : dynamicObjects.stream().filter(dy -> dy.getLong("passnode") == passnode).filter(dy -> dy.getBoolean("isdefaultflow")).collect(Collectors.toList());
        return defaultFlow.isEmpty();
    }

    private long changeTypeToPassnode(String workflowType) {
        long passnode = 0L;
        switch (workflowType) {
            case "1": {
                passnode = PassNodeConstants.SET_INDICATOR;
                break;
            }
            case "2": {
                passnode = PassNodeConstants.EVALUATE_PERF;
                break;
            }
            case "3": {
                passnode = PassNodeConstants.INTERVIEW_PERFORMANCE;
                break;
            }
        }
        return passnode;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String close = this.getView().getPageCache().get(CLOSED);
        this.getView().getModel().setDataChanged(false);
        if (!"1".equals(close) && !OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            e.setCancel(true);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"AssessWorkflowEdit_16", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"AssessWorkflowEdit_17", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"AssessWorkflowEdit_18", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, new ConfirmCallBackListener(CLOSED, (IFormPlugin)this), btnNameMaps);
            return;
        }
        if (null != this.getView().getParentView()) {
            this.getView().getParentView().getPageCache().remove(WORK_FLOW_PAGE_ID + this.getView().getPageId());
            if (this.getView().getFormShowParameter().getCustomParam("workFlowPageIdcacheKey") != null) {
                this.getView().getParentView().getPageCache().remove((String)this.getView().getFormShowParameter().getCustomParam("workFlowPageIdcacheKey"));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if (CLOSED.equals(callBackId) && MessageBoxResult.Yes == event.getResult()) {
            this.putClosedPageCache();
            String isFromActivity = (String)this.getView().getFormShowParameter().getCustomParam("isFromActivity");
            if (HRStringUtils.equals((String)"true", (String)isFromActivity)) {
                this.getView().getParentView().getPageCache().put("clickCardEntry", "true");
                ActivityTabsUtils.selectEntryEntityItem(this.getView(), this.getView().getParentView().getPageId(), 0);
                this.getView().getParentView().getPageCache().put("clickCardEntry", "false");
            } else {
                this.getView().close();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        long flowId = this.getFlowId();
        switch (operateKey) {
            case "checkflow": {
                ArrayList<CheckFlowBo> checkFlowBos = new ArrayList<CheckFlowBo>();
                this.frontCheck(checkFlowBos);
                DynamicObjectCollection flowEntry = this.getView().getParentView().getModel().getEntryEntity(FLOW_ENTRY);
                if (!WORK_FLOW_APPLICATION_SERVICE.validatorFlowData(flowEntry, flowId, checkFlowBos) || checkFlowBos.size() > 0) {
                    String msg = ResManager.loadKDString((String)"\u6d41\u7a0b\u6821\u9a8c\u672a\u901a\u8fc7", (String)"AssessWorkflowEdit_12", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(msg);
                    if ("2".equals(this.getView().getPageCache().get("operationStatus"))) {
                        this.removeFlowEntry(flowId);
                    }
                    this.showCheckFlow(checkFlowBos, this.getView(), "epa_checkflow");
                } else {
                    String msg = ResManager.loadKDString((String)"\u6d41\u7a0b\u6821\u9a8c\u901a\u8fc7", (String)"AssessWorkflowEdit_19", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                    this.getView().showSuccessNotification(msg);
                }
                this.changeDataStatus();
                break;
            }
            case "publish": {
                this.confirmPublish(flowId);
                this.changeDataStatus();
                break;
            }
            case "btnsave": {
                this.saveFlow(operateKey, flowId);
                this.getView().getPageCache().put("operationStatus", "0");
                this.getModel().setValue("status", (Object)"A");
                break;
            }
        }
    }

    private void changeDataStatus() {
        boolean tipRef = (Boolean)this.getView().getFormShowParameter().getCustomParam("tipRef");
        if (tipRef) {
            this.getView().getPageCache().put("operationStatus", "0");
            this.getModel().setValue("status", (Object)"A");
        }
    }

    private void frontCheck(List<CheckFlowBo> checkFlowBos) {
        List flowDefProcItems = JSONArray.parseArray((String)this.getModel().getValue(BASEDATA_PROC_ITEMS).toString(), FlowDefProcItemBo.class);
        List nodes = ((FlowDefProcItemBo)flowDefProcItems.get(0)).getNodes();
        String lowLimitFlag = "0";
        String upLimitFlag = "0";
        for (FlowNodeItemBo nodeItemBo : nodes) {
            if (!"2".equals(((FlowDefProcItemBo)flowDefProcItems.get(0)).getWorkflowtype()) || !NodeTypeConstants.BATCH_ADJUSTSUMSCORE.equals(nodeItemBo.getNodeType())) continue;
            lowLimitFlag = this.getView().getPageCache().get("adjusetscorelowerlimit" + nodeItemBo.getNodeSeq());
            upLimitFlag = this.getView().getPageCache().get("adjustscoreuplimit" + nodeItemBo.getNodeSeq());
            if ((null == upLimitFlag || !upLimitFlag.equals("1")) && (null == lowLimitFlag || !lowLimitFlag.equals("1"))) continue;
            String workflowName = "";
            if (null != this.getView().getModel().getValue("name")) {
                workflowName = this.getView().getModel().getValue("name").toString();
            }
            CheckFlowBo adjustCheckFlowBo = new CheckFlowBo(workflowName, FlowCheckConfigConstants.getCheckTypeNode(), ResManager.loadKDString((String)nodeItemBo.getNodeName(), (String)"AssessWorkflowEdit_26", (String)"opmc-epa-formplugin", (Object[])new Object[0]), FlowCheckConfigConstants.getCheckClassifyNodeConf(), FlowCheckConfigConstants.checkAdjustScore());
            checkFlowBos.add(adjustCheckFlowBo);
            break;
        }
    }

    private void putClosedPageCache() {
        this.getView().getPageCache().put(CLOSED, "1");
        this.getView().getPageCache().saveChanges();
    }

    private void removeClosedPageCache() {
        this.getView().getPageCache().remove(CLOSED);
        this.getView().getPageCache().saveChanges();
    }

    private void confirmPublish(long flowId) {
        DynamicObject workflow = WORK_FLOW_APPLICATION_SERVICE.getLastWorkflow(flowId);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_publishconfirm");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_publishconfirm"));
        showParameter.setCustomParam("flowname", (Object)workflow.getString("name"));
        showParameter.setCustomParam("assessruleid", (Object)this.getView().getPageCache().get("assessruleid"));
        showParameter.setCustomParam("flowid", (Object)workflow.getLong("boid"));
        Boolean ref = (Boolean)this.getView().getFormShowParameter().getCustomParam("tipRef");
        showParameter.setCustomParam("tipRef", (Object)ref);
        showParameter.setHasRight(Boolean.TRUE.booleanValue());
        this.getView().showForm(showParameter);
        String operateType = (String)this.getView().getFormShowParameter().getCustomParam("operateType");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        long flowId = this.getFlowId();
        switch (operateKey) {
            case "publish": {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    LOGGER.error((Throwable)e1);
                }
                if (this.saveFlow(operateKey, flowId)) {
                    ArrayList<CheckFlowBo> checkFlowBos = new ArrayList<CheckFlowBo>();
                    this.frontCheck(checkFlowBos);
                    DynamicObjectCollection flowEntry = this.getView().getParentView().getModel().getEntryEntity(FLOW_ENTRY);
                    if (!WORK_FLOW_APPLICATION_SERVICE.validatorFlowData(flowEntry, flowId, checkFlowBos) || checkFlowBos.size() > 0) {
                        String msg = ResManager.loadKDString((String)"\u6d41\u7a0b\u6821\u9a8c\u672a\u901a\u8fc7\uff0c\u53d1\u5e03\u5931\u8d25\u3002", (String)"AssessWorkflowEdit_21", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                        this.getView().showTipNotification(msg);
                        if ("2".equals(this.getView().getPageCache().get("operationStatus"))) {
                            this.removeFlowEntry(flowId);
                        }
                        this.showCheckFlow(checkFlowBos, this.getView(), "epa_checkflow");
                        args.setCancel(true);
                        return;
                    }
                    String operateType = (String)this.getView().getFormShowParameter().getCustomParam("operateType");
                    if (EvalProcessOperationEnum.COPY != EvalProcessOperationEnum.getOperation((String)operateType) && EvalProcessOperationEnum.EDIT != EvalProcessOperationEnum.getOperation((String)operateType) && EvalProcessOperationEnum.DEFAULT != EvalProcessOperationEnum.getOperation((String)operateType)) break;
                    DynamicObject workflow = WORK_FLOW_ENTITY_SERVICE.getWorkflowById(flowId);
                    Long procDefId = workflow.getDynamicObjectCollection("entryentity").isEmpty() ? 0L : ((DynamicObject)workflow.getDynamicObjectCollection("entryentity").get(0)).getLong("flowdefproc");
                    DynamicPermssionConfigCacheUtils.dynamicPermssionConfigCacheHandle(flowId, procDefId, this.getView().getParentView());
                    break;
                }
                args.setCancel(true);
                break;
            }
            case "checkflow": {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    LOGGER.error((Throwable)e1);
                }
                if (this.saveFlow(operateKey, flowId)) break;
                args.setCancel(true);
                break;
            }
            case "closenodeconfig": {
                this.sendDateToCustomControl(2, CLICK, null, null, null);
                args.setCancel(true);
                break;
            }
            case "opennodeconfig": {
                String type = this.getView().getPageCache().get(CACHE_TYPE);
                String checked = this.getView().getPageCache().get(CACHE_CHECKED);
                if (StringUtils.isEmpty((CharSequence)checked)) {
                    checked = "1,1";
                }
                String flowDefProcBos = this.getView().getPageCache().get(CACHE_FLOWDEFPROCBOS);
                List data = JSONArray.parseArray((String)flowDefProcBos, FlowDefProcBo.class);
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
                this.clickNode(checked, data, Integer.parseInt(type == null ? "2" : type));
                args.setCancel(true);
                break;
            }
            case "cancelchange": {
                this.getView().getParentView().getPageCache().put("clickCardEntry", "true");
                boolean isClose = ActivityTabsUtils.selectEntryEntityItem(this.getView(), this.getView().getParentView().getPageId(), 0);
                this.getView().getParentView().getPageCache().put("clickCardEntry", "false");
                if (isClose) break;
                args.setCancel(true);
                break;
            }
        }
    }

    private long getFlowId() {
        if (StringUtils.isNotEmpty((CharSequence)this.getView().getPageCache().get("flowid"))) {
            return Long.parseLong(this.getView().getPageCache().get("flowid"));
        }
        long flowId = ORM.create().genLongId(WORKFLOW_ENTITY_NUMBER);
        this.getView().getPageCache().put("flowid", String.valueOf(flowId));
        return flowId;
    }

    public void showCheckFlow(List<CheckFlowBo> checkFlowBos, IFormView view, String entityNumber) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(entityNumber);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, entityNumber));
        showParameter.setCustomParam("checkFlowBos", checkFlowBos);
        view.showForm(showParameter);
    }

    private boolean checkInterviewFlowNodeCanDelete(FlowDefProcItemBo flowDefProcItem) {
        List flowNodeItemBoList = flowDefProcItem.getNodes();
        if (!CollectionUtils.isEmpty((Collection)flowNodeItemBoList)) {
            for (FlowNodeItemBo flowNodeItemBo : flowNodeItemBoList) {
                if (null == flowNodeItemBo.getNodeType() || !flowNodeItemBo.getNodeType().equals(NodeTypeConstants.INTERVIEW_WRITE)) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }
}

