/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.assessrule;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.common.constants.FlowNodeConfigConstants;
import kd.opmc.epa.common.constants.PassNodeConstants;
import kd.opmc.epa.formplugin.web.utils.ChangeNodeNameUtils;
import kd.opmc.pbs.business.application.service.workflow.FlowDefProcApplicationService;
import kd.opmc.pbs.business.model.FlowDefProcItemBo;
import kd.opmc.pbs.business.model.FlowNodeBo;
import kd.opmc.pbs.business.model.FlowNodeItemBo;
import kd.opmc.pbs.business.model.FlowUserBo;
import kd.opmc.pbs.business.model.NodeRoleBo;
import kd.opmc.pbs.business.tips.ShowConfigTipsUtils;
import kd.opmc.pbs.common.constants.NodeTypeConstants;
import kd.opmc.pbs.common.constants.RoleTypeConstants;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class FlowNodeConfigPlugin
extends HRDataBaseEdit
implements FlowNodeConfigConstants,
AfterF7SelectListener,
BeforeF7SelectListener {
    private static final FlowDefProcApplicationService FLOW_DEF_PROC_APPLICATION_SERVICE = FlowDefProcApplicationService.getInstance();
    private static final Log LOG = LogFactory.getLog(FlowNodeConfigPlugin.class);
    private static final String FLOW_NODE = "flownode";
    private static final String NODE_NAME = "nodename";
    private static final String NODE_TYPE = "nodetype";
    private static final String NODE_WEIGHT = "nodeweight";
    private static final String FLOW_TYPE = "flowType";
    private static final String FLOW_INDICATOR = "1";
    private static final String APPROVER = "approver";
    private static final String SUBSTITUTE = "substitute";
    private static final String DESIGNEE2 = "designee2";
    private static final String DESIGNEE = "designee";
    private static final String CROSSCORE = "crossscore";
    private static final String SUPPORTTOTALSCORE = "supporttotalscore";
    private static final String ISCOPY = "iscopy";
    private static final String COPYPERSON = "copyperson";
    private static final String COPYAPPOINTPERSON = "copyappointperson";
    private static final String MANUALOP = "manualop";
    private static final String SAVEAUDITJUMP = "sameauditjump";
    private static final String SAMEJUMP = "samejump";
    private static final Integer TEN = 10;
    private static final String ADJUSETSCORELOWERLIMIT = "adjusetscorelowerlimit";
    private static final String ADJUSTSCOREUPLIMIT = "adjustscoreuplimit";
    private static final String INDEX_NODE_ROLE = "indexnoderole";
    private static final String INDEX_FLOW_NODE = "indexflownode";
    private static final String PAGE_ID = "pageId";
    private static final String ROLE_PAGE_IDS = "rolePageIds";
    private static final String NODE_NAMES = "nodeNames";
    private static final String NODE_ROLE = "noderole";
    private static final String COPYAPPOINTADMINORG = "copyappointadminorg";
    private static final String COPYAPPOINTPOS = "copyappointpos";
    private static final String SUBSTITUEAPPOINTPOS = "appointpos";
    private static final String SUBSTITUEAPPOINTADMINORG = "adminorg";
    private static final String NODETYPECANCELFLAG = "nodeTypeCancelFlag";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"addrole"});
        this.addClickListeners(new String[]{"addplus"});
        this.addClickListeners(new String[]{"openall"});
        this.addClickListeners(new String[]{"closeall"});
        BasedataEdit nodetypeEdit = (BasedataEdit)this.getView().getControl(NODE_TYPE);
        nodetypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit substituteEdit = (BasedataEdit)this.getView().getControl(SUBSTITUTE);
        substituteEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit designee2 = (BasedataEdit)this.getView().getControl(DESIGNEE2);
        designee2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit handlers = (BasedataEdit)this.getView().getControl("handlers");
        handlers.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        handlers.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit copypersonEdit = (BasedataEdit)this.getView().getControl(COPYPERSON);
        copypersonEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        long appointment;
        List multiUserOrPost;
        super.beforeBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        OperationStatus status = parameter.getStatus();
        FlowNodeItemBo flowNode = (FlowNodeItemBo)JSONObject.parseObject((String)parameter.getCustomParam(FLOW_NODE).toString(), FlowNodeItemBo.class);
        String flowType = (String)parameter.getCustomParam(FLOW_TYPE);
        if (null == flowNode.getNodeType() || flowNode.getNodeType().equals(0L)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap51", "adjustflex", "nodeweightflex", "flexpanelap71", "flexpanelap2", "flexpanelap20", "otherap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap51", "adjustflex", "nodeweightflex", "flexpanelap71", "flexpanelap2", "flexpanelap20", "otherap"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"openorcloseap"});
        this.getView().getPageCache().put("flowSeq", parameter.getCustomParam("flowSeq").toString());
        this.getView().getPageCache().put("nodeSeq", parameter.getCustomParam("nodeSeq").toString());
        this.getView().getPageCache().put(NODE_NAMES, parameter.getCustomParam(NODE_NAMES).toString());
        this.getModel().setValue(NODE_NAME, (Object)flowNode.getNodeName());
        this.getModel().setValue(NODE_WEIGHT, (Object)flowNode.getNodeWeight());
        this.getModel().setValue(NODE_TYPE, (Object)flowNode.getNodeType());
        this.getModel().setValue(SUBSTITUTE, (Object)flowNode.getHandlerType());
        if (RoleTypeConstants.APPOINT_DEPHEADER.equals(flowNode.getHandlerType())) {
            this.getModel().setValue(SUBSTITUEAPPOINTADMINORG, (Object)flowNode.getAppointment());
        } else if (RoleTypeConstants.APPOINTOR.equals(flowNode.getHandlerType())) {
            multiUserOrPost = flowNode.getMultiUserOrPost();
            if (multiUserOrPost.isEmpty()) {
                appointment = flowNode.getAppointment();
                multiUserOrPost.add(appointment);
            }
            this.getModel().setValue(DESIGNEE2, (Object)flowNode.getMultiUserOrPost().toArray());
            if (CollectionUtils.isNotEmpty((Collection)flowNode.getUserBoList())) {
                this.getModel().setValue("handlers", (Object)flowNode.getUserBoList().stream().map(FlowUserBo::getDepempId).toArray());
            }
        } else if (RoleTypeConstants.APPOINT_POSITION.equals(flowNode.getHandlerType())) {
            multiUserOrPost = flowNode.getMultiUserOrPost();
            if (multiUserOrPost.isEmpty()) {
                appointment = flowNode.getAppointment();
                multiUserOrPost.add(appointment);
            }
            this.getModel().setValue(SUBSTITUEAPPOINTPOS, (Object)flowNode.getMultiUserOrPost().toArray());
        }
        if (NodeTypeConstants.BATCH_ADJUSTSUMSCORE.equals(flowNode.getNodeType()) || NodeTypeConstants.EVALUATE_AUDIT.equals(flowNode.getNodeType()) || NodeTypeConstants.INTERVIEW_AUDIT.equals(flowNode.getNodeType())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"addroleap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"openorcloseap"});
        }
        List nodeRoleList = flowNode.getNodeRoleList();
        for (NodeRoleBo nodeRole : nodeRoleList) {
            if (HRStringUtils.isEmpty((String)nodeRole.getFlag())) {
                nodeRole.setFlag(RandomStringUtils.randomAlphanumeric((int)6));
            }
            this.buildShowAp(nodeRole, status);
        }
        if (nodeRoleList.size() > 1) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"closeall", "openorcloseap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"openall"});
        }
        this.getModel().setValue(FLOW_NODE, (Object)flowNode.toString());
        this.getModel().setValue(CROSSCORE, (Object)(flowNode.isCrossScore() ? FLOW_INDICATOR : "0"));
        this.getModel().setValue(SUPPORTTOTALSCORE, (Object)flowNode.isSupportTotalScore());
        this.getModel().setValue(ISCOPY, (Object)flowNode.isCopy());
        this.getModel().setValue(COPYPERSON, (Object)flowNode.getCopyPerson());
        if (RoleTypeConstants.APPOINT_DEPHEADER.equals(flowNode.getCopyPerson())) {
            this.getModel().setValue(COPYAPPOINTADMINORG, (Object)flowNode.getCopyAppointPerson());
        } else if (RoleTypeConstants.APPOINTOR.equals(flowNode.getCopyPerson())) {
            this.getModel().setValue(COPYAPPOINTPERSON, (Object)flowNode.getCopyAppointPerson());
        } else if (RoleTypeConstants.APPOINT_POSITION.equals(flowNode.getCopyPerson())) {
            this.getModel().setValue(COPYAPPOINTPOS, (Object)flowNode.getCopyAppointPerson());
        }
        this.getModel().setValue(MANUALOP, (Object)(flowNode.isManualop() ? "2" : FLOW_INDICATOR));
        this.getModel().setValue(SAVEAUDITJUMP, (Object)flowNode.isSameauditjump());
        this.getModel().setValue(SAMEJUMP, (Object)flowNode.isSameauditjump());
        if (flowNode.isCrossScore()) {
            this.getModel().setValue(SUPPORTTOTALSCORE, (Object)Boolean.FALSE);
            this.getView().setEnable(Boolean.FALSE, new String[]{SUPPORTTOTALSCORE});
            this.getView().setEnable(Boolean.FALSE, new String[]{MANUALOP, SAMEJUMP});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{SUPPORTTOTALSCORE});
            this.getView().setEnable(Boolean.TRUE, new String[]{MANUALOP, SAMEJUMP});
        }
        String isSetLowerlimitNull = this.getView().getParentView().getPageCache().get("ISSETNULLadjusetscorelowerlimit" + flowNode.getNodeSeq());
        if (null != flowNode.getAdjusetScoreLowerlimit() && (flowNode.getAdjusetScoreLowerlimit().compareTo(new BigDecimal(0)) != 0 || flowNode.getAdjusetScoreLowerlimit().compareTo(new BigDecimal(0)) == 0 && null == isSetLowerlimitNull)) {
            this.getModel().setValue(ADJUSETSCORELOWERLIMIT, (Object)flowNode.getAdjusetScoreLowerlimit());
        } else if (null != isSetLowerlimitNull && FLOW_INDICATOR.equals(isSetLowerlimitNull)) {
            this.getModel().setValue(ADJUSETSCORELOWERLIMIT, null);
        }
        String isSetUplimitNull = this.getView().getParentView().getPageCache().get("ISSETNULLadjustscoreuplimit" + flowNode.getNodeSeq());
        if (null != flowNode.getAdjustScoreUplimit() && (flowNode.getAdjustScoreUplimit().compareTo(new BigDecimal(0)) != 0 || flowNode.getAdjustScoreUplimit().compareTo(new BigDecimal(0)) == 0 && null == isSetUplimitNull)) {
            this.getModel().setValue(ADJUSTSCOREUPLIMIT, (Object)flowNode.getAdjustScoreUplimit());
        } else if (null != isSetUplimitNull && FLOW_INDICATOR.equals(isSetUplimitNull)) {
            this.getModel().setValue(ADJUSTSCOREUPLIMIT, null);
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"nodeclose"});
        this.getView().getParentView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().setVisible(Boolean.FALSE, new String[]{SAVEAUDITJUMP});
        this.getView().setVisible(Boolean.FALSE, new String[]{SAMEJUMP});
        this.getView().setVisible(Boolean.FALSE, new String[]{"handlers"});
        if (HRStringUtils.equals((String)flowType, (String)FLOW_INDICATOR) || HRStringUtils.equals((String)flowType, (String)"3")) {
            Label label = (Label)this.getView().getControl("labelap6");
            label.setText(ResManager.loadKDString((String)"\u5f53\u89d2\u8272\u6709\u591a\u4e2a\u5904\u7406\u4eba\u65f6\uff0c\u4ee5\u7b2c\u4e00\u4e2a\u63d0\u4ea4\u7684\u4e3a\u51c6\u3002", (String)"FlowNodeConfigPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            if (NodeTypeConstants.INDICATOR_AUDIT.equals(flowNode.getNodeType())) {
                label.setText(ResManager.loadKDString((String)"\u6d41\u51fa\u89c4\u5219\u4e0e\u88ab\u66ff\u4ee3\u89d2\u8272\u7684\u6d41\u51fa\u89c4\u5219\u4fdd\u6301\u4e00\u81f4\u3002", (String)"FlowNodeConfigPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.TRUE, new String[]{SAVEAUDITJUMP});
            }
        } else {
            if (NodeTypeConstants.EVALUATE_SCORE.equals(flowNode.getNodeType()) || NodeTypeConstants.BATCH_EVALUSUMSCORE.equals(flowNode.getNodeType())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{SAMEJUMP});
            }
            if (NodeTypeConstants.EVALUATE_SCORE.equals(flowNode.getNodeType()) || NodeTypeConstants.BATCH_EVALUSUMSCORE.equals(flowNode.getNodeType())) {
                Label label = (Label)this.getView().getControl("labelap6");
                label.setText(ResManager.loadKDString((String)"\u6d41\u51fa\u89c4\u5219\u4e0e\u88ab\u66ff\u4ee3\u89d2\u8272\u7684\u6d41\u51fa\u89c4\u5219\u4fdd\u6301\u4e00\u81f4\u3002", (String)"FlowNodeConfigPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
        }
        this.changeWidthByWork(flowType, flowNode.getNodeType());
        this.switchDeleteIconDisplay();
    }

    private void changeWidthByWork(String flowType, Long nodeType) {
        HashMap map = new HashMap(16);
        String width = "49%";
        if (flowType.equals("2")) {
            if (NodeTypeConstants.EVALUATE_SCORE.equals(nodeType)) {
                width = "34%";
            } else if (NodeTypeConstants.BATCH_EVALUSUMSCORE.equals(nodeType)) {
                width = "45%";
            } else if (NodeTypeConstants.BATCH_ADJUSTSUMSCORE.equals(nodeType)) {
                width = "34%";
            }
        } else {
            HashMap s = new HashMap(16);
            HashMap<String, String> m = new HashMap<String, String>(16);
            m.put("r", "0px");
            s.put("m", m);
            map.put("s", s);
        }
        map.put("w", new LocaleString(width));
        map.put("minwidth", new LocaleString("214px"));
        this.getView().updateControlMetadata(NODE_NAME, map);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (OperationStatus.VIEW.equals((Object)parameter.getStatus())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{NODE_NAME, NODE_WEIGHT, NODE_TYPE, APPROVER, DESIGNEE, SUBSTITUTE, DESIGNEE2});
            this.getView().setVisible(Boolean.FALSE, new String[]{"addroleap"});
        }
        this.initTips();
        Boolean iscopy = (Boolean)this.getModel().getValue(ISCOPY);
        if (!iscopy.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{COPYPERSON});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{COPYPERSON});
        }
        String workflowType = (String)this.getView().getFormShowParameter().getCustomParam(FLOW_TYPE);
        if (FLOW_INDICATOR.equals(workflowType) || "3".equals(workflowType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"nodeweightflex", "crossscoreap", "addroleap", "openorcloseap", SUPPORTTOTALSCORE, "flexpanelap21", ISCOPY, COPYPERSON, COPYAPPOINTPERSON, COPYAPPOINTPOS, COPYAPPOINTADMINORG});
        }
        if (HRStringUtils.equals((String)workflowType, (String)"3")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"manualopflex"});
        }
    }

    protected void initTips() {
        Map tipsMap = ShowConfigTipsUtils.getTipsByFormId((String)"epa_nodeconfig");
        tipsMap.forEach((key, value) -> {
            if (0 == value.size()) {
                return;
            }
            HashMap<String, Tips> textProps = new HashMap<String, Tips>(16);
            Tips textTips = new Tips();
            textTips.setType("text");
            textTips.setContent(new LocaleString(value.toArray(new String[0])[0]));
            textProps.put("tips", textTips);
            this.getView().updateControlMetadata(key, textProps);
        });
    }

    private void buildShowAp(NodeRoleBo nodeRole, OperationStatus status) {
        Container contentAp = (Container)this.getControl("coreinfoap");
        ArrayList<Map> controls = new ArrayList<Map>();
        FlexPanelAp cardAp = new HRFlexPanelAp.Builder("coreinfoap" + DBServiceHelper.genStringId()).build();
        Map control = cardAp.createControl();
        controls.add(control);
        this.showFlexPanelAp(cardAp, nodeRole, status);
        contentAp.addControls(controls);
    }

    private void showFlexPanelAp(FlexPanelAp cardAp, NodeRoleBo nodeRole, OperationStatus status) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_noderoleconfig");
        showParameter.setStatus(status);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(cardAp.getKey());
        showParameter.setCustomParam("flag", (Object)nodeRole.getFlag());
        showParameter.setCustomParam(NODE_ROLE, (Object)nodeRole);
        String rolePageIds = StringUtils.strip((String)this.getView().getPageCache().get(ROLE_PAGE_IDS), (String)"[]");
        ArrayList list = new ArrayList(5);
        if (HRStringUtils.isNotEmpty((String)rolePageIds)) {
            list = Lists.newArrayList((Object[])StringUtils.strip((String)rolePageIds.replace(" ", "")).split(","));
        }
        if (!list.contains(showParameter.getPageId())) {
            list.add(showParameter.getPageId());
            this.getView().getPageCache().put(ROLE_PAGE_IDS, list.toString());
        }
        showParameter.setCustomParam(FLOW_TYPE, this.getView().getFormShowParameter().getCustomParam(FLOW_TYPE));
        showParameter.setCustomParam("nodeWeight", this.getModel().getValue(NODE_WEIGHT));
        showParameter.setCustomParam("flowId", this.getView().getFormShowParameter().getCustomParam("flowId"));
        this.getView().showForm(showParameter);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "addrole": 
            case "addplus": {
                FlowNodeItemBo flowNode = this.getFlowNode();
                List nodeRoleList = flowNode.getNodeRoleList();
                if (TEN <= nodeRoleList.size()) {
                    String msg = ResManager.loadKDString((String)"\u5355\u4e2a\u8282\u70b9\u7684\u89d2\u8272\u603b\u6570\u4e0d\u53ef\u8d85\u8fc710\u4e2a", (String)"FlowNodeConfigPlugin_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(msg);
                    return;
                }
                NodeRoleBo nodeRoleBo = new NodeRoleBo().initNodeRole(0, nodeRoleList.size() + 1, NodeTypeConstants.EVALUATE_SCORE);
                nodeRoleBo.setRoleType(Long.valueOf(0L));
                nodeRoleBo.setRoleName("");
                nodeRoleList.add(nodeRoleBo);
                this.buildShowAp(nodeRoleBo, OperationStatus.ADDNEW);
                this.getModel().setValue(FLOW_NODE, (Object)flowNode.toString());
                this.getView().getPageCache().put(PAGE_ID, this.getView().getPageId());
                this.sendNodeDataToParentPage(flowNode.toString());
                this.getView().setVisible(Boolean.TRUE, new String[]{"closeall", "openorcloseap"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"openall"});
                this.switchDeleteIconDisplay();
                break;
            }
            case "openall": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"closeall", "openorcloseap"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"openall"});
                this.switchAllRolePanelDisplay("roleopen");
                break;
            }
            case "closeall": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"openall", "openorcloseap"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"closeall"});
                this.switchAllRolePanelDisplay("roleclose");
                break;
            }
        }
    }

    private void switchDeleteIconDisplay() {
        ArrayList<String> rolePageIdList = this.getRolePageIdList();
        for (String rolePageId : rolePageIdList) {
            IFormView view = this.getView().getView(rolePageId);
            view.setVisible(Boolean.valueOf(rolePageIdList.size() > 1), new String[]{"deleteicon"});
            this.getView().sendFormAction(view);
        }
    }

    private ArrayList<String> getRolePageIdList() {
        String rolePageIds = StringUtils.strip((String)this.getView().getPageCache().get(ROLE_PAGE_IDS), (String)"[]");
        return Lists.newArrayList((Object[])StringUtils.strip((String)rolePageIds.replace(" ", "")).split(","));
    }

    private void switchAllRolePanelDisplay(String click) {
        ArrayList<String> rolePageIdList = this.getRolePageIdList();
        for (String rolePageId : rolePageIdList) {
            IFormView view = this.getView().getView(rolePageId);
            if (null == view) continue;
            view.invokeOperation(click);
            this.getView().sendFormAction(view);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    private void changeRoleConfig(String currPageId, NodeRoleBo currNodeRole, List<NodeRoleBo> nodeRoleList) {
        String rolePageIds = StringUtils.strip((String)this.getView().getPageCache().get(ROLE_PAGE_IDS), (String)"[]");
        List rolePageIdList = Lists.newArrayList((Object[])StringUtils.strip((String)rolePageIds.replace(" ", "")).split(",")).stream().filter(pageId -> !HRStringUtils.equals((String)currPageId, (String)pageId)).collect(Collectors.toList());
        JSONObject currConfJson = currNodeRole.getConfjson();
        Boolean isEvaluateNext = currConfJson.getBoolean("isevaluatenext");
        Boolean isGradeNext = currConfJson.getBoolean("isgradenext");
        Boolean isGradeLevel = currConfJson.getBoolean("isgradelevel");
        Boolean isScoreNext = currConfJson.getBoolean("isscorenext");
        boolean sameFlag = false;
        for (String pageId2 : rolePageIdList) {
            if (null == this.getView().getView(pageId2)) continue;
            NodeRoleBo nodeRole = (NodeRoleBo)JSONObject.parseObject((String)this.getView().getView(pageId2).getModel().getValue(NODE_ROLE).toString(), NodeRoleBo.class);
            JSONObject confJson = nodeRole.getConfjson();
            if (!HRStringUtils.equals((String)pageId2, (String)currPageId) && isGradeLevel.booleanValue()) {
                this.getView().getView(pageId2).getModel().setValue("isgradelevel", (Object)Boolean.FALSE);
                confJson.put("isgradelevel", (Object)Boolean.FALSE);
            }
            if (!HRStringUtils.equals((String)pageId2, (String)currPageId) && nodeRole.getTurnoverSort() == currNodeRole.getTurnoverSort()) {
                sameFlag = true;
                if (isEvaluateNext.booleanValue() || currNodeRole.isTurnoversortChange()) {
                    this.getView().getView(pageId2).getModel().setValue("isevaluatenext", (Object)Boolean.FALSE);
                    confJson.put("isevaluatenext", (Object)Boolean.FALSE);
                }
                if (isGradeNext.booleanValue() || currNodeRole.isTurnoversortChange()) {
                    this.getView().getView(pageId2).getModel().setValue("isgradenext", (Object)Boolean.FALSE);
                    confJson.put("isgradenext", (Object)Boolean.FALSE);
                }
                if (isScoreNext.booleanValue() || currNodeRole.isTurnoversortChange()) {
                    this.getView().getView(pageId2).getModel().setValue("isscorenext", (Object)Boolean.FALSE);
                    confJson.put("isscorenext", (Object)Boolean.FALSE);
                }
                this.getView().getView(pageId2).getModel().setValue(NODE_ROLE, (Object)nodeRole.toString());
                nodeRoleList.set(nodeRoleList.indexOf(nodeRoleList.stream().filter(role -> role.getFlag().equals(nodeRole.getFlag())).findFirst().get()), nodeRole);
            }
            this.getView().getView(currPageId).sendFormAction(this.getView().getView(pageId2));
        }
        if (currNodeRole.isTurnoversortChange() && sameFlag) {
            this.getView().getView(currPageId).getModel().setValue("isevaluatenext", (Object)Boolean.FALSE);
            this.getView().getView(currPageId).getModel().setValue("isgradenext", (Object)Boolean.FALSE);
            this.getView().getView(currPageId).getModel().setValue("isscorenext", (Object)Boolean.FALSE);
            currConfJson.put("isevaluatenext", (Object)Boolean.FALSE);
            currConfJson.put("isgradenext", (Object)Boolean.FALSE);
            currConfJson.put("isscorenext", (Object)Boolean.FALSE);
            currNodeRole.setTurnoversortChange(Boolean.FALSE.booleanValue());
            this.getView().getView(currPageId).getModel().setValue(NODE_ROLE, (Object)currNodeRole.toString());
        } else if (currNodeRole.isTurnoversortChange()) {
            currNodeRole.setTurnoversortChange(Boolean.FALSE.booleanValue());
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String fieldKey = args.getProperty().getName();
        if (HRStringUtils.equals((String)FLOW_NODE, (String)fieldKey) || HRStringUtils.equals((String)"handlers", (String)fieldKey)) {
            return;
        }
        FlowNodeItemBo flowNode = this.getFlowNode();
        switch (fieldKey) {
            case "indexnoderole": {
                JSONObject confJson;
                Boolean isgradelevel;
                JSONObject indexNodeRole = JSONObject.parseObject((String)String.valueOf(this.getView().getModel().getValue(INDEX_NODE_ROLE)));
                String flag = indexNodeRole.getString("flag");
                String pageId = indexNodeRole.getString(PAGE_ID);
                NodeRoleBo nodeRole = (NodeRoleBo)JSONObject.parseObject((String)indexNodeRole.getString(NODE_ROLE), NodeRoleBo.class);
                List nodeRoleList = flowNode.getNodeRoleList();
                if (HRObjectUtils.isEmpty((Object)nodeRole)) {
                    nodeRoleList.removeIf(role -> role.getFlag().equals(flag));
                    String rolePageIds = StringUtils.strip((String)this.getView().getPageCache().get(ROLE_PAGE_IDS), (String)"[]");
                    String[] split = rolePageIds.split(", ");
                    List pageIdList = Arrays.stream(split).filter(dy -> !dy.equals(pageId)).collect(Collectors.toList());
                    this.getView().getPageCache().put(ROLE_PAGE_IDS, pageIdList.toString());
                } else {
                    this.changeRoleConfig(pageId, nodeRole, nodeRoleList);
                    nodeRoleList.set(nodeRoleList.indexOf(nodeRoleList.stream().filter(role -> role.getFlag().equals(flag)).findFirst().get()), nodeRole);
                }
                this.refreshRoleWeightCache(flowNode, nodeRoleList);
                flowNode.setNodeRoleList(nodeRoleList);
                this.getModel().setValue(FLOW_NODE, (Object)flowNode.toString());
                this.sendNodeDataToParentPage(flowNode.toString());
                if (HRObjectUtils.isEmpty((Object)nodeRole) || null == nodeRole.getConfjson() || !(isgradelevel = (confJson = nodeRole.getConfjson()).getBoolean("isgradelevel")).booleanValue()) break;
                List flowDefProcItems2 = JSONArray.parseArray((String)this.getView().getParentView().getModel().getValue("flowdefprocitems").toString(), FlowDefProcItemBo.class);
                for (FlowDefProcItemBo flowDefProcItem : flowDefProcItems2) {
                    for (FlowNodeItemBo node : flowDefProcItem.getNodes()) {
                        for (NodeRoleBo roleBo : node.getNodeRoleList()) {
                            if (HRStringUtils.equals((String)roleBo.getFlag(), (String)nodeRole.getFlag()) || nodeRole.isTurnoversortChange()) continue;
                            JSONObject json = roleBo.getConfjson();
                            json.put("isgradelevel", (Object)Boolean.FALSE);
                        }
                    }
                }
                this.getView().getParentView().getModel().setValue("flowdefprocitems", (Object)flowDefProcItems2.toString());
                this.getView().getView(pageId).sendFormAction(this.getView().getParentView());
                break;
            }
            case "nodename": {
                String nodeName = this.getModel().getValue(NODE_NAME).toString();
                if (nodeName.contains("\"")) {
                    nodeName = nodeName.replaceAll("\"", "");
                }
                flowNode.setNodeName(nodeName);
                this.getView().getPageCache().put(PAGE_ID, this.getView().getPageId());
                break;
            }
            case "nodetype": {
                DynamicObject oldeNodeType;
                String nodeTypeCancelFlag = this.getView().getPageCache().get(NODETYPECANCELFLAG);
                DynamicObject nodeTypeDo = this.getModel().getDataEntity().getDynamicObject(NODE_TYPE);
                if (FLOW_INDICATOR.equals(nodeTypeCancelFlag)) {
                    flowNode.setNodeType(Long.valueOf(nodeTypeDo.getLong("id")));
                    this.getView().getPageCache().put(NODETYPECANCELFLAG, "0");
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"nodeweightflex", "flexpanelap51", "adjustflex", "flexpanelap71", "flexpanelap2", "flexpanelap20", "otherap"});
                if (null == nodeTypeDo) {
                    flowNode.setNodeType(Long.valueOf(0L));
                }
                if (null != (oldeNodeType = (DynamicObject)args.getChangeSet()[0].getOldValue())) {
                    this.getView().getPageCache().put("curnodeOldVal", oldeNodeType.getString("id"));
                }
                String workflowType = (String)this.getView().getParentView().getFormShowParameter().getCustomParam(FLOW_TYPE);
                List roleList = flowNode.getNodeRoleList();
                if (!HRObjectUtils.isEmpty((Object)oldeNodeType) && workflowType.equals("2") && !ObjectUtils.isEmpty((Object)roleList)) {
                    String msg = ResManager.loadKDString((String)"\u5207\u6362\u8282\u70b9\u7c7b\u578b\u914d\u7f6e\u6570\u636e\u5c06\u4f1a\u6e05\u7a7a\uff0c\u786e\u5b9a\u5207\u6362\uff1f", (String)"FlowNodeConfigPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Save, new ConfirmCallBackListener(NODE_TYPE, (IFormPlugin)this));
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap51", "adjustflex", "nodeweightflex", "flexpanelap71", "flexpanelap2", "flexpanelap20", "otherap"});
                    this.dealSwitchNodeType(nodeTypeDo, flowNode);
                }
                if (this.getView().getFormShowParameter().getCustomParam("flowId") != null && nodeTypeDo != null && oldeNodeType != null && oldeNodeType.getLong("id") != nodeTypeDo.getLong("id")) {
                    this.getView().getParentView().getPageCache().put("nodetypechange:" + this.getView().getFormShowParameter().getCustomParam("flowId"), "true");
                }
                this.changeWidthByWork(workflowType, flowNode.getNodeType());
                break;
            }
            case "nodeweight": {
                flowNode.setNodeWeight(Double.parseDouble(this.getModel().getValue(NODE_WEIGHT).toString()));
                this.handleRoleViewByNodeWeight(flowNode.getNodeWeight());
                this.getView().getPageCache().put(PAGE_ID, this.getView().getPageId());
                break;
            }
            case "approver": {
                if (HRObjectUtils.isEmpty((Object)this.getModel().getValue(APPROVER))) break;
                Long approver = Long.valueOf(this.getModel().getValue(APPROVER).toString());
                flowNode.setHandlerType(approver);
                break;
            }
            case "designee": {
                if (HRObjectUtils.isEmpty((Object)this.getModel().getValue(DESIGNEE))) break;
                long designee = ((DynamicObject)this.getModel().getValue(DESIGNEE)).getLong("id");
                flowNode.setAppointment(designee);
                break;
            }
            case "substitute": {
                if (!HRObjectUtils.isEmpty((Object)this.getModel().getValue(SUBSTITUTE))) {
                    Long substitute = ((DynamicObject)this.getModel().getValue(SUBSTITUTE)).getLong("id");
                    flowNode.setHandlerType(substitute);
                    if (RoleTypeConstants.APPOINTOR.equals(substitute)) {
                        DynamicObjectCollection appointposColl;
                        if (null != this.getModel().getValue(SUBSTITUEAPPOINTADMINORG)) {
                            this.getModel().setValue(SUBSTITUEAPPOINTADMINORG, null);
                        }
                        if (!(appointposColl = (DynamicObjectCollection)this.getModel().getValue(SUBSTITUEAPPOINTPOS)).isEmpty()) {
                            this.getModel().setValue(SUBSTITUEAPPOINTPOS, null);
                        }
                    } else if (RoleTypeConstants.APPOINT_POSITION.equals(substitute)) {
                        DynamicObjectCollection userColl;
                        if (null != this.getModel().getValue(SUBSTITUEAPPOINTADMINORG)) {
                            this.getModel().setValue(SUBSTITUEAPPOINTADMINORG, null);
                        }
                        if (!(userColl = (DynamicObjectCollection)this.getModel().getValue(DESIGNEE2)).isEmpty()) {
                            this.getModel().setValue(DESIGNEE2, null);
                        }
                    } else if (RoleTypeConstants.APPOINT_DEPHEADER.equals(substitute)) {
                        DynamicObjectCollection userColl;
                        DynamicObjectCollection appointposColl = (DynamicObjectCollection)this.getModel().getValue(SUBSTITUEAPPOINTPOS);
                        if (!appointposColl.isEmpty()) {
                            this.getModel().setValue(SUBSTITUEAPPOINTPOS, null);
                        }
                        if (!(userColl = (DynamicObjectCollection)this.getModel().getValue(DESIGNEE2)).isEmpty()) {
                            this.getModel().setValue(DESIGNEE2, null);
                        }
                    } else {
                        DynamicObjectCollection userColl;
                        DynamicObjectCollection appointposColl;
                        if (null != this.getModel().getValue(SUBSTITUEAPPOINTADMINORG)) {
                            this.getModel().setValue(SUBSTITUEAPPOINTADMINORG, null);
                        }
                        if (!(appointposColl = (DynamicObjectCollection)this.getModel().getValue(SUBSTITUEAPPOINTPOS)).isEmpty()) {
                            this.getModel().setValue(SUBSTITUEAPPOINTPOS, null);
                        }
                        if (!(userColl = (DynamicObjectCollection)this.getModel().getValue(DESIGNEE2)).isEmpty()) {
                            this.getModel().setValue(DESIGNEE2, null);
                        }
                    }
                } else {
                    flowNode.setHandlerType(Long.valueOf(0L));
                }
                flowNode.setMultiUserOrPost(new ArrayList(10));
                break;
            }
            case "crossscore": {
                boolean crossscore = HRStringUtils.equals((String)this.getModel().getDataEntity().getString(CROSSCORE), (String)FLOW_INDICATOR);
                flowNode.setCrossScore(crossscore);
                String currPageId = this.getView().getPageId();
                String rolePageIds = StringUtils.strip((String)this.getView().getPageCache().get(ROLE_PAGE_IDS), (String)"[]");
                String[] split = rolePageIds.split(", ");
                List pageIdList = Arrays.stream(split).collect(Collectors.toList());
                for (String rolePage : pageIdList) {
                    IFormView roleView = this.getView().getView(rolePage);
                    roleView.setVisible(Boolean.valueOf(!crossscore), new String[]{"flexpanelap1811", "flexpanelap1821", "flexpanelap18211", "flexpanelap18111"});
                    this.getView().getView(currPageId).sendFormAction(roleView);
                }
                if (crossscore) {
                    this.getModel().setValue(SUPPORTTOTALSCORE, (Object)Boolean.FALSE);
                    this.getView().setEnable(Boolean.FALSE, new String[]{SUPPORTTOTALSCORE});
                    this.getView().setEnable(Boolean.FALSE, new String[]{MANUALOP});
                    this.getModel().setValue(MANUALOP, (Object)FLOW_INDICATOR);
                    flowNode.setManualop(false);
                    this.getModel().setValue(SAMEJUMP, (Object)Boolean.FALSE);
                    flowNode.setSameauditjump(Boolean.FALSE.booleanValue());
                    this.getView().setEnable(Boolean.FALSE, new String[]{SAMEJUMP});
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{SUPPORTTOTALSCORE});
                    this.getView().setEnable(Boolean.TRUE, new String[]{MANUALOP});
                    this.getView().setEnable(Boolean.TRUE, new String[]{SAMEJUMP});
                }
                if (this.getView().getFormShowParameter().getCustomParam("flowId") == null) break;
                this.getView().getParentView().getPageCache().put("crossscorechange:" + this.getView().getFormShowParameter().getCustomParam("flowId"), "true");
                break;
            }
            case "supporttotalscore": {
                boolean supporttotalscore = (Boolean)this.getModel().getValue(SUPPORTTOTALSCORE);
                flowNode.setSupportTotalScore(supporttotalscore);
                if (supporttotalscore) {
                    this.getModel().setValue(CROSSCORE, (Object)Boolean.FALSE);
                    this.getView().setEnable(Boolean.FALSE, new String[]{CROSSCORE});
                    break;
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{CROSSCORE});
                break;
            }
            case "iscopy": {
                boolean iscopy = (Boolean)this.getModel().getValue(ISCOPY);
                if (!iscopy) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{COPYPERSON, COPYAPPOINTPERSON, COPYAPPOINTADMINORG, COPYAPPOINTPOS});
                } else {
                    List flowDefProcItems = JSONArray.parseArray((String)this.getView().getParentView().getModel().getValue("flowdefprocitems").toString(), FlowDefProcItemBo.class);
                    FlowDefProcItemBo flowDefProcItemBo = (FlowDefProcItemBo)flowDefProcItems.get(0);
                    List nodes = flowDefProcItemBo.getNodes();
                    for (FlowNodeItemBo node : nodes) {
                        if (flowNode.getNodeSeq() != node.getNodeSeq()) continue;
                        if (String.valueOf(node.getId()).equals(String.valueOf(flowNode.getId()))) {
                            this.getView().getModel().setValue(COPYPERSON, (Object)flowNode.getCopyPerson());
                            this.getView().getModel().setValue(COPYAPPOINTPERSON, (Object)flowNode.getCopyAppointPerson());
                            this.getView().getModel().setValue(COPYAPPOINTADMINORG, (Object)flowNode.getCopyAppointAdminOrg());
                            this.getView().getModel().setValue(COPYAPPOINTPOS, (Object)flowNode.getCopyAppointPos());
                            continue;
                        }
                        this.getModel().beginInit();
                        Long copyPerson = String.valueOf(node.getCopyPerson()).equals("0") ? null : Long.valueOf(node.getCopyPerson());
                        Long copyAppointPerson = String.valueOf(node.getCopyAppointPerson()).equals("0") ? null : Long.valueOf(node.getCopyAppointPerson());
                        this.getView().getModel().setValue(COPYPERSON, (Object)copyPerson);
                        this.getView().getModel().setValue(COPYAPPOINTPERSON, (Object)copyAppointPerson);
                        this.getView().getModel().setValue(COPYAPPOINTADMINORG, (Object)copyAppointPerson);
                        this.getView().getModel().setValue(COPYAPPOINTPOS, (Object)copyAppointPerson);
                        flowNode.setCopyPerson(copyPerson == null ? 0L : copyPerson);
                        flowNode.setCopyAppointAdminOrg(copyAppointPerson == null ? 0L : copyAppointPerson);
                        flowNode.setCopyAppointPos(copyAppointPerson == null ? 0L : copyAppointPerson);
                        this.getModel().endInit();
                    }
                    if (RoleTypeConstants.APPOINTOR.equals(flowNode.getCopyPerson())) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{COPYAPPOINTPERSON});
                        this.getView().updateView(COPYAPPOINTPERSON);
                    } else if (RoleTypeConstants.APPOINT_POSITION.equals(flowNode.getCopyPerson())) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{COPYAPPOINTPOS});
                        this.getView().updateView(COPYAPPOINTPOS);
                    } else if (RoleTypeConstants.APPOINT_DEPHEADER.equals(flowNode.getCopyPerson())) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{COPYAPPOINTADMINORG});
                        this.getView().updateView(COPYAPPOINTADMINORG);
                    }
                    this.getView().setVisible(Boolean.TRUE, new String[]{COPYPERSON});
                    this.getView().updateView(COPYPERSON);
                }
                flowNode.setCopy(iscopy);
                break;
            }
            case "copyperson": {
                if (HRObjectUtils.isEmpty((Object)this.getModel().getValue(COPYPERSON))) break;
                long copyperson = ((DynamicObject)this.getModel().getValue(COPYPERSON)).getLong("id");
                flowNode.setCopyPerson(copyperson);
                if (RoleTypeConstants.APPOINTOR.equals(copyperson)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{COPYAPPOINTPERSON});
                    this.getView().updateView(COPYAPPOINTPERSON);
                    break;
                }
                if (RoleTypeConstants.APPOINT_POSITION.equals(copyperson)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{COPYAPPOINTPOS});
                    this.getView().updateView(COPYAPPOINTPOS);
                    break;
                }
                if (!RoleTypeConstants.APPOINT_DEPHEADER.equals(copyperson)) break;
                this.getView().setVisible(Boolean.TRUE, new String[]{COPYAPPOINTADMINORG});
                this.getView().updateView(COPYAPPOINTADMINORG);
                break;
            }
            case "copyappointperson": {
                long copyappointperson = ((DynamicObject)this.getModel().getValue(COPYAPPOINTPERSON)).getLong("id");
                flowNode.setCopyAppointPerson(copyappointperson);
                break;
            }
            case "manualop": {
                boolean manualop = HRStringUtils.equals((String)this.getModel().getValue(MANUALOP).toString(), (String)"2");
                flowNode.setManualop(manualop);
                if (!this.getModel().getDataEntity().getBoolean(CROSSCORE)) break;
                flowNode.setCrossScore(this.getModel().getDataEntity().getBoolean(CROSSCORE));
                break;
            }
            case "sameauditjump": {
                boolean sameauditjump = Boolean.parseBoolean(this.getModel().getValue(SAVEAUDITJUMP).toString());
                flowNode.setSameauditjump(sameauditjump);
                break;
            }
            case "samejump": {
                boolean sameJump = Boolean.parseBoolean(this.getModel().getValue(SAMEJUMP).toString());
                flowNode.setSameauditjump(sameJump);
                break;
            }
            case "adjusetscorelowerlimit": {
                String initFlag = this.getView().getPageCache().get(ADJUSETSCORELOWERLIMIT + flowNode.getNodeSeq());
                if (HRStringUtils.equals((String)FLOW_INDICATOR, (String)initFlag)) break;
                BigDecimal oldValue = (BigDecimal)args.getChangeSet()[0].getOldValue();
                BigDecimal lowerMinLimit = new BigDecimal(-999);
                BigDecimal lowerMaxLimit = new BigDecimal(0);
                if (null != this.getModel().getValue(ADJUSETSCORELOWERLIMIT) && null != this.getModel().getValue(ADJUSTSCOREUPLIMIT)) {
                    BigDecimal scoreLowLimit = (BigDecimal)this.getModel().getValue(ADJUSETSCORELOWERLIMIT);
                    BigDecimal scoreUpLimitTemp = (BigDecimal)this.getModel().getValue(ADJUSTSCOREUPLIMIT);
                    if (scoreLowLimit.compareTo(lowerMinLimit) < 0 || scoreLowLimit.compareTo(lowerMaxLimit) > 0) {
                        this.getModel().setValue(ADJUSETSCORELOWERLIMIT, (Object)oldValue);
                        flowNode.setAdjusetScoreLowerlimit(oldValue);
                        String scoreTips = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650\u8303\u56f4\uff1a[-999\uff0c0]", (String)"FlowNodeConfigPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                        this.getView().showTipNotification(scoreTips);
                        return;
                    }
                    if (scoreLowLimit.compareTo(lowerMaxLimit) == 0 && scoreUpLimitTemp.compareTo(scoreLowLimit) == 0) {
                        String scoreTips = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u4e0b\u9650\u4e0d\u80fd\u90fd\u4e3a0", (String)"FlowNodeConfigPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                        this.getView().showTipNotification(scoreTips);
                    } else {
                        this.getView().getParentView().getPageCache().remove(ADJUSETSCORELOWERLIMIT + flowNode.getNodeSeq());
                        this.getView().getParentView().getPageCache().remove(ADJUSTSCOREUPLIMIT + flowNode.getNodeSeq());
                    }
                    flowNode.setAdjusetScoreLowerlimit(scoreLowLimit);
                    break;
                }
                if (null == this.getModel().getValue(ADJUSETSCORELOWERLIMIT)) {
                    this.getModel().setValue(ADJUSETSCORELOWERLIMIT, (Object)oldValue);
                    flowNode.setAdjusetScoreLowerlimit(oldValue);
                    String scoreTips = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650\u8303\u56f4\uff1a[-999\uff0c0]", (String)"FlowNodeConfigPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(scoreTips);
                    return;
                }
                flowNode.setAdjusetScoreLowerlimit((BigDecimal)this.getModel().getValue(ADJUSETSCORELOWERLIMIT));
                this.getView().getParentView().getPageCache().remove("ISSETNULLadjusetscorelowerlimit" + flowNode.getNodeSeq());
                this.getView().getParentView().getPageCache().put(ADJUSETSCORELOWERLIMIT + flowNode.getNodeSeq(), FLOW_INDICATOR);
                break;
            }
            case "adjustscoreuplimit": {
                String initUpFlag = this.getView().getPageCache().get(ADJUSTSCOREUPLIMIT + flowNode.getNodeSeq());
                if (HRStringUtils.equals((String)FLOW_INDICATOR, (String)initUpFlag)) break;
                BigDecimal upOldValue = (BigDecimal)args.getChangeSet()[0].getOldValue();
                BigDecimal upMinLimit = new BigDecimal("0");
                BigDecimal upMaxLimit = new BigDecimal("999");
                if (null != this.getModel().getValue(ADJUSETSCORELOWERLIMIT) && null != this.getModel().getValue(ADJUSTSCOREUPLIMIT)) {
                    BigDecimal scoreLowLimitTemp = (BigDecimal)this.getModel().getValue(ADJUSETSCORELOWERLIMIT);
                    BigDecimal scoreUpLimit = (BigDecimal)this.getModel().getValue(ADJUSTSCOREUPLIMIT);
                    if (scoreUpLimit.compareTo(upMinLimit) < 0 || scoreUpLimit.compareTo(upMaxLimit) > 0) {
                        this.getModel().setValue(ADJUSTSCOREUPLIMIT, (Object)upOldValue);
                        flowNode.setAdjustScoreUplimit(upOldValue);
                        String scoreTips = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650\u8303\u56f4\uff1a[0,999]", (String)"FlowNodeConfigPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                        this.getView().showTipNotification(scoreTips);
                        return;
                    }
                    if (scoreUpLimit.compareTo(upMinLimit) == 0 && scoreUpLimit.compareTo(scoreLowLimitTemp) == 0) {
                        String scoreTips = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u4e0b\u9650\u4e0d\u80fd\u90fd\u4e3a0", (String)"FlowNodeConfigPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                        this.getView().showTipNotification(scoreTips);
                    } else {
                        this.getView().getParentView().getPageCache().remove(ADJUSETSCORELOWERLIMIT + flowNode.getNodeSeq());
                        this.getView().getParentView().getPageCache().remove(ADJUSTSCOREUPLIMIT + flowNode.getNodeSeq());
                    }
                    flowNode.setAdjustScoreUplimit(scoreUpLimit);
                    break;
                }
                if (null == this.getModel().getValue(ADJUSTSCOREUPLIMIT)) {
                    this.getModel().setValue(ADJUSTSCOREUPLIMIT, (Object)upOldValue);
                    flowNode.setAdjustScoreUplimit(upOldValue);
                    String scoreTips = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650\u8303\u56f4\uff1a[0,999]", (String)"FlowNodeConfigPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(scoreTips);
                    return;
                }
                flowNode.setAdjustScoreUplimit((BigDecimal)this.getModel().getValue(ADJUSTSCOREUPLIMIT));
                this.getView().getParentView().getPageCache().remove("ISSETNULLadjustscoreuplimit" + flowNode.getNodeSeq());
                break;
            }
            case "copyappointadminorg": {
                if (null == this.getModel().getValue(COPYAPPOINTADMINORG)) break;
                long copyAppointAdminOrg = ((DynamicObject)this.getModel().getValue(COPYAPPOINTADMINORG)).getLong("id");
                flowNode.setCopyAppointAdminOrg(copyAppointAdminOrg);
                flowNode.setCopyAppointPerson(copyAppointAdminOrg);
                break;
            }
            case "copyappointpos": {
                if (null == this.getModel().getValue(COPYAPPOINTPOS)) break;
                long copyAppointPos = ((DynamicObject)this.getModel().getValue(COPYAPPOINTPOS)).getLong("id");
                flowNode.setCopyAppointPos(copyAppointPos);
                flowNode.setCopyAppointPerson(copyAppointPos);
                break;
            }
            case "adminorg": {
                if (null == this.getModel().getValue(SUBSTITUEAPPOINTADMINORG)) break;
                long adminorg = ((DynamicObject)this.getModel().getValue(SUBSTITUEAPPOINTADMINORG)).getLong("id");
                flowNode.setAppointment(adminorg);
                break;
            }
            case "designee2": {
                DynamicObjectCollection userColl = (DynamicObjectCollection)this.getModel().getValue(DESIGNEE2);
                if (userColl.size() > 20) {
                    String maxUserTips = ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u6dfb\u52a020\u4e2a\u6307\u5b9a\u4eba", (String)"FlowNodeConfigPlugin_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(maxUserTips);
                    DynamicObjectCollection oldValues = (DynamicObjectCollection)args.getChangeSet()[0].getOldValue();
                    this.getModel().setValue(DESIGNEE2, (Object)this.getOldValArr(oldValues));
                    return;
                }
                this.setAppointmentList(flowNode, userColl);
                break;
            }
            case "appointpos": {
                DynamicObjectCollection postColl = (DynamicObjectCollection)this.getModel().getValue(SUBSTITUEAPPOINTPOS);
                if (postColl.size() > 10) {
                    String maxPostTips = ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u6dfb\u52a010\u4e2a\u5c97\u4f4d", (String)"FlowNodeConfigPlugin_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(maxPostTips);
                    DynamicObjectCollection oldValues = (DynamicObjectCollection)args.getChangeSet()[0].getOldValue();
                    this.getModel().setValue(SUBSTITUEAPPOINTPOS, (Object)this.getOldValArr(oldValues));
                    return;
                }
                this.setAppointmentList(flowNode, postColl);
                break;
            }
        }
        if (!fieldKey.equals(INDEX_NODE_ROLE)) {
            this.getModel().setValue(FLOW_NODE, (Object)flowNode.toString());
            this.sendNodeDataToParentPage(flowNode.toString());
        }
    }

    private void refreshRoleWeightCache(FlowNodeItemBo flowNode, List<NodeRoleBo> nodeRoleList) {
        String oldCacheKey = this.getView().getParentView().getPageId() + "ROLEWEIGHT" + flowNode.getNodeSeq();
        Map all = this.getView().getParentView().getPageCache().getAll();
        List allOldRoleCache = all.keySet().stream().filter(s -> s.startsWith(oldCacheKey)).collect(Collectors.toList());
        this.getView().getParentView().getPageCache().batchRemove(allOldRoleCache);
        for (int seq = 0; seq < nodeRoleList.size(); ++seq) {
            NodeRoleBo nodeRole = nodeRoleList.get(seq);
            nodeRole.setRoleSeq(seq + 1);
            String cacheKey = this.getView().getParentView().getPageId() + "ROLEWEIGHT" + flowNode.getNodeSeq() + nodeRole.getRoleSeq();
            this.getView().getParentView().getPageCache().put(cacheKey, String.valueOf(nodeRole.getRoleWeight()));
        }
    }

    private Object[] getOldValArr(DynamicObjectCollection entryentity) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        if (!entryentity.isEmpty()) {
            for (DynamicObject dynamicObject : entryentity) {
                ids.add(dynamicObject.getLong("fbasedataid_id"));
            }
        }
        return ids.toArray();
    }

    private void setAppointmentList(FlowNodeItemBo flowNode, DynamicObjectCollection entryentity) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        if (!entryentity.isEmpty()) {
            for (DynamicObject dynamicObject : entryentity) {
                long depempId = dynamicObject.getLong("fbasedataid_id");
                ids.add(depempId);
            }
        }
        flowNode.setMultiUserOrPost(ids);
        if (CollectionUtils.isEmpty(ids)) {
            flowNode.setUserBoList(Collections.emptyList());
        }
    }

    protected FlowNodeItemBo getFlowNode() {
        FlowNodeItemBo flowNodeItemBo = (FlowNodeItemBo)JSONObject.parseObject((String)this.getView().getModel().getValue(FLOW_NODE).toString(), FlowNodeItemBo.class);
        if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("nodeSeq"))) {
            flowNodeItemBo.setNodeSeq(Integer.parseInt(this.getPageCache().get("nodeSeq")));
        }
        return flowNodeItemBo;
    }

    private String fillInNodeName(Long nodeTypeId) {
        String nodeNames = this.getView().getPageCache().get(NODE_NAMES);
        if (HRStringUtils.isEmpty((String)nodeNames)) {
            return null;
        }
        String nodeName = ((DynamicObject)FlowNodeBo.getNodeTypeNodeMap().get(nodeTypeId)).getString("name");
        ArrayList nodeNameList = Lists.newArrayList((Object[])StringUtils.strip((String)nodeNames, (String)"[]").replace(" ", "").split(","));
        return ChangeNodeNameUtils.changeNodeName(nodeNameList, nodeName, Boolean.TRUE);
    }

    private void sendNodeDataToParentPage(String flowNodeStr) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("flowSeq", (Object)this.getView().getPageCache().get("flowSeq"));
        jsonObject.put("nodeSeq", (Object)this.getView().getPageCache().get("nodeSeq"));
        jsonObject.put(FLOW_NODE, (Object)flowNodeStr);
        jsonObject.put(PAGE_ID, (Object)this.getView().getPageCache().get(PAGE_ID));
        this.getView().getParentView().getModel().setValue(INDEX_FLOW_NODE, (Object)jsonObject);
        this.getView().sendFormAction(this.getView().getParentView());
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        String fieldKey = ((Control)evt.getSource()).getKey();
        if ("handlers".equals(fieldKey)) {
            ArrayList ids;
            Map userIdMap;
            DynamicObjectCollection entryentity = this.getModel().getDataEntity().getDynamicObjectCollection("handlers");
            HashSet<Long> idSet = new HashSet<Long>(16);
            ArrayList<FlowUserBo> userBos = new ArrayList<FlowUserBo>(10);
            if (!entryentity.isEmpty()) {
                for (DynamicObject dynamicObject : entryentity) {
                    long depempId = dynamicObject.getLong("fbasedataid_id");
                    long personId = dynamicObject.getDynamicObject("fbasedataid").getLong("person_id");
                    idSet.add(personId);
                    FlowUserBo userBo = new FlowUserBo();
                    userBo.setUserId(Long.valueOf(personId));
                    userBo.setDepempId(Long.valueOf(depempId));
                    userBos.add(userBo);
                }
            }
            if (null != (userIdMap = FLOW_DEF_PROC_APPLICATION_SERVICE.getUserIdsByPersonIds(ids = new ArrayList(idSet))) && !userIdMap.isEmpty()) {
                if (userIdMap.size() < ids.size()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5904\u7406\u4eba\u5728\u5e73\u53f0\u8d26\u53f7\u5b58\u5728\u5f02\u5e38\uff0c\u6dfb\u52a0\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FlowNodeConfigPlugin_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                }
                List<FlowUserBo> newBos = userBos.stream().filter(bo -> userIdMap.containsKey(bo.getUserId())).collect(Collectors.toList());
                newBos.forEach(bo -> bo.setUserId((Long)userIdMap.get(bo.getUserId())));
                FlowNodeItemBo flowNode = this.getFlowNode();
                flowNode.setUserBoList(newBos);
                this.getModel().setValue(FLOW_NODE, (Object)flowNode.toString());
                this.sendNodeDataToParentPage(flowNode.toString());
                this.getModel().setValue("handlers", (Object)newBos.stream().map(FlowUserBo::getDepempId).toArray());
                this.getModel().setValue(DESIGNEE2, (Object)userIdMap.values().toArray());
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u5904\u7406\u4eba\u5728\u5e73\u53f0\u8d26\u53f7\u5b58\u5728\u5f02\u5e38\uff0c\u6dfb\u52a0\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FlowNodeConfigPlugin_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("handlers", null);
                this.getModel().setValue(DESIGNEE2, null);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propertyName;
        switch (propertyName = e.getProperty().getName()) {
            case "nodetype": {
                e.getCustomQFilters().add(this.getQFilterForEvaNodeType());
                break;
            }
            case "substitute": 
            case "copyperson": {
                e.getCustomQFilters().add(this.getQFilterForRoleType());
                break;
            }
            case "designee2": {
                e.setCancel(true);
                BasedataEdit control = (BasedataEdit)this.getView().getControl("handlers");
                control.click();
                break;
            }
            case "handlers": {
                FormShowParameter formShowParameter = e.getFormShowParameter();
                formShowParameter.setCustomParam("showeffect", (Object)"0");
                break;
            }
            case "appointpos": {
                e.getCustomQFilters().add(this.getQFilterForMultiUserOrPost(SUBSTITUEAPPOINTPOS));
                break;
            }
        }
    }

    private QFilter getQFilterForMultiUserOrPost(String field) {
        DynamicObjectCollection userColl = (DynamicObjectCollection)this.getModel().getValue(field);
        List ids = userColl.stream().map(dyn -> dyn.getLong("fbasedataid_id")).collect(Collectors.toList());
        return new QFilter("id", "not in", ids);
    }

    private QFilter getQFilterForEvaNodeType() {
        String workflowType = (String)this.getView().getParentView().getFormShowParameter().getCustomParam(FLOW_TYPE);
        QFilter qFilter = null;
        String flowdefProcitems = this.getView().getParentView().getModel().getValue("flowdefprocitems").toString();
        List flowDefProcItems = JSONArray.parseArray((String)flowdefProcitems, FlowDefProcItemBo.class);
        FlowNodeItemBo flowNode = this.getFlowNode();
        if (workflowType.equals("2")) {
            qFilter = new QFilter("passessnode.id", "=", (Object)PassNodeConstants.EVALUATE_PERF);
            HashMap<Long, Integer> nodeSortMap = new HashMap<Long, Integer>(16);
            nodeSortMap.put(NodeTypeConstants.EVALUATE_SCORE, 1);
            nodeSortMap.put(NodeTypeConstants.BATCH_EVALUSUMSCORE, 2);
            nodeSortMap.put(NodeTypeConstants.BATCH_ADJUSTSUMSCORE, 3);
            qFilter.and("id", "in", this.getNodeIdTypeSet(flowDefProcItems, flowNode, nodeSortMap));
        } else if (workflowType.equals(FLOW_INDICATOR)) {
            qFilter = new QFilter("passessnode.id", "=", (Object)PassNodeConstants.SET_INDICATOR);
            HashMap<Long, Integer> nodeSortMap = new HashMap<Long, Integer>(16);
            nodeSortMap.put(NodeTypeConstants.INDICATOR_FORMULATE, 1);
            nodeSortMap.put(NodeTypeConstants.INDICATOR_AUDIT, 2);
            nodeSortMap.put(NodeTypeConstants.INDICATOR_CONFIRM, 3);
            qFilter.and("id", "in", this.getNodeIdTypeSet(flowDefProcItems, flowNode, nodeSortMap));
        } else if (workflowType.equals("3")) {
            qFilter = new QFilter("passessnode.id", "=", (Object)PassNodeConstants.INTERVIEW_PERFORMANCE);
            HashMap<Long, Integer> nodeSortMap = new HashMap<Long, Integer>(16);
            nodeSortMap.put(NodeTypeConstants.INTERVIEW_WRITE, 1);
            nodeSortMap.put(NodeTypeConstants.INTERVIEW_AUDIT, 2);
            qFilter.and("id", "in", this.getNodeIdTypeSet(flowDefProcItems, flowNode, nodeSortMap));
        }
        return qFilter;
    }

    private List<Long> getNodeIdTypeSet(List<FlowDefProcItemBo> flowDefProcItems, FlowNodeItemBo flowNode, Map<Long, Integer> nodeSortMap) {
        ArrayList<Long> nodeTypeIdSet = new ArrayList<Long>(10);
        int maxSeq = 0;
        int minSeq = 0;
        for (FlowDefProcItemBo flowDefProcItemBo : flowDefProcItems) {
            FlowNodeItemBo preFlowNodeBo;
            if (flowNode.getNodeSeq() == 1 && flowDefProcItemBo.getNodes().size() > 1) {
                minSeq = 0;
                FlowNodeItemBo nextFlowNodeBo = this.getNextNodeTypeNotnullNode(flowNode.getNodeSeq(), flowDefProcItemBo.getNodes());
                if (null == nextFlowNodeBo || nextFlowNodeBo.getNodeType().equals(0L)) continue;
                maxSeq = nodeSortMap.get(nextFlowNodeBo.getNodeType());
                continue;
            }
            if (flowNode.getIsLast() && flowDefProcItemBo.getNodes().size() > 1) {
                maxSeq = nodeSortMap.size();
                preFlowNodeBo = this.getPreNodeTypeNotnullNode(flowNode.getNodeSeq(), flowDefProcItemBo.getNodes());
                if (null == preFlowNodeBo || preFlowNodeBo.getNodeType().equals(0L)) continue;
                minSeq = nodeSortMap.get(preFlowNodeBo.getNodeType());
                continue;
            }
            preFlowNodeBo = this.getPreNodeTypeNotnullNode(flowNode.getNodeSeq(), flowDefProcItemBo.getNodes());
            FlowNodeItemBo nextFlowNodeBo = this.getNextNodeTypeNotnullNode(flowNode.getNodeSeq(), flowDefProcItemBo.getNodes());
            if (null != nextFlowNodeBo && !nextFlowNodeBo.getNodeType().equals(0L)) {
                maxSeq = nodeSortMap.get(nextFlowNodeBo.getNodeType());
            }
            if (null == preFlowNodeBo || preFlowNodeBo.getNodeType().equals(0L)) continue;
            minSeq = nodeSortMap.get(preFlowNodeBo.getNodeType());
        }
        if (maxSeq == 0 && minSeq > 0) {
            for (Map.Entry entry : nodeSortMap.entrySet()) {
                if ((Integer)entry.getValue() < minSeq) continue;
                nodeTypeIdSet.add((Long)entry.getKey());
            }
        } else if (minSeq == 0 && maxSeq > 0) {
            for (Map.Entry entry : nodeSortMap.entrySet()) {
                if ((Integer)entry.getValue() > maxSeq) continue;
                nodeTypeIdSet.add((Long)entry.getKey());
            }
        } else if (minSeq > 0 && maxSeq > 0) {
            for (Map.Entry entry : nodeSortMap.entrySet()) {
                if ((Integer)entry.getValue() < minSeq || (Integer)entry.getValue() > maxSeq) continue;
                nodeTypeIdSet.add((Long)entry.getKey());
            }
        } else {
            for (Map.Entry entry : nodeSortMap.entrySet()) {
                nodeTypeIdSet.add((Long)entry.getKey());
            }
        }
        return NodeTypeConstants.EVALUATE_AUDIT.equals(flowNode.getNodeType()) ? nodeTypeIdSet : this.checkAuditCount(flowDefProcItems, nodeTypeIdSet);
    }

    private List<Long> checkAuditCount(List<FlowDefProcItemBo> flowDefProcItems, List<Long> nodeTypeIdSet) {
        for (FlowDefProcItemBo flowDefProc : flowDefProcItems) {
            List nodes = flowDefProc.getNodes();
            for (FlowNodeItemBo node : nodes) {
                if (!NodeTypeConstants.EVALUATE_AUDIT.equals(node.getNodeType())) continue;
                nodeTypeIdSet.remove(NodeTypeConstants.EVALUATE_AUDIT);
            }
        }
        return nodeTypeIdSet;
    }

    protected FlowNodeItemBo getPreNodeTypeNotnullNode(int nodeSeq, List<FlowNodeItemBo> flowNodeBoList) {
        FlowNodeItemBo flowNodeBo = null;
        for (FlowNodeItemBo nodeBo : flowNodeBoList) {
            if (nodeSeq - 1 < 1) {
                return flowNodeBo;
            }
            if (nodeBo.getNodeSeq() != nodeSeq - 1 || null == nodeBo.getNodeType() || nodeBo.getNodeType().equals(0L)) continue;
            flowNodeBo = nodeBo;
            return nodeBo;
        }
        return this.getPreNodeTypeNotnullNode(nodeSeq - 1, flowNodeBoList);
    }

    protected FlowNodeItemBo getNextNodeTypeNotnullNode(int nodeSeq, List<FlowNodeItemBo> flowNodeBoList) {
        FlowNodeItemBo flowNodeBo = null;
        for (FlowNodeItemBo nodeBo : flowNodeBoList) {
            if (nodeSeq + 1 > flowNodeBoList.size()) {
                return flowNodeBo;
            }
            if (nodeBo.getNodeSeq() != nodeSeq + 1 || null == nodeBo.getNodeType() || nodeBo.getNodeType().equals(0L)) continue;
            flowNodeBo = nodeBo;
            return nodeBo;
        }
        return this.getNextNodeTypeNotnullNode(nodeSeq + 1, flowNodeBoList);
    }

    private void handleNodeRoleView(IFormView view, Long nodeType, String workflowType) {
        if (workflowType.equals("2")) {
            if (nodeType.equals(NodeTypeConstants.EVALUATE_AUDIT) || nodeType.equals(NodeTypeConstants.BATCH_ADJUSTSUMSCORE)) {
                view.setVisible(Boolean.FALSE, new String[]{"flexpanelap13", "flexpanelap11", "flexpanelap12", "flexpanelap16", "flexpanelap19", "flexpanelap2", "flexpanelap1", "openorclose"});
                view.setVisible(Boolean.FALSE, new String[]{"deleteicon"});
            } else {
                view.setVisible(Boolean.TRUE, new String[]{"flexpanelap", "flexpanelap15", "flexpanelap13", "flexpanelap11", "flexpanelap12", "flexpanelap16", "flexpanelap19", "flexpanelap2", "flexpanelap1"});
                view.setVisible(Boolean.TRUE, new String[]{"deleteicon"});
            }
            if (nodeType.equals(NodeTypeConstants.EVALUATE_SCORE) || nodeType.equals(NodeTypeConstants.BATCH_EVALUSUMSCORE)) {
                view.setVisible(Boolean.FALSE, new String[]{"roletypelabel"});
            } else {
                view.setVisible(Boolean.TRUE, new String[]{"roletypelabel"});
            }
            view.setVisible(Boolean.valueOf(nodeType.equals(NodeTypeConstants.BATCH_ADJUSTSUMSCORE)), new String[]{"flexpanelap19"});
        } else if (workflowType.equals(FLOW_INDICATOR) || workflowType.equals("3")) {
            view.setVisible(Boolean.FALSE, new String[]{"flexpanelap13", "flexpanelap11", "flexpanelap12", "flexpanelap16", "flexpanelap1", "flexpanelap19", "flexauditcanedit", "openorclose"});
            if (nodeType.equals(NodeTypeConstants.INDICATOR_AUDIT) || nodeType.equals(NodeTypeConstants.INTERVIEW_AUDIT)) {
                view.setVisible(Boolean.TRUE, new String[]{"flexauditcanedit", "outflowruleap", "flexpanelap1", "outflowrule"});
                if (nodeType.equals(NodeTypeConstants.INTERVIEW_AUDIT)) {
                    view.getModel().setValue("outflowrule", (Object)"10");
                } else {
                    view.getModel().setValue("outflowrule", (Object)"30");
                }
                view.setEnable(Boolean.TRUE, new String[]{"outflowrule"});
            }
            if (nodeType.equals(NodeTypeConstants.EVALUATE_SCORE) || nodeType.equals(NodeTypeConstants.BATCH_EVALUSUMSCORE)) {
                view.setVisible(Boolean.FALSE, new String[]{"roletypelabel"});
            } else {
                view.setVisible(Boolean.TRUE, new String[]{"roletypelabel"});
            }
            if (nodeType.equals(NodeTypeConstants.INDICATOR_AUDIT)) {
                view.setVisible(Boolean.TRUE, new String[]{"flexauditcanedit", "flexpanelap1"});
                view.setVisible(Boolean.FALSE, new String[]{"roletypelabel"});
            }
            if (nodeType.equals(NodeTypeConstants.INTERVIEW_AUDIT)) {
                view.setVisible(Boolean.FALSE, new String[]{"roletypelabel"});
            }
        }
        if (NodeTypeConstants.EVALUATE_SCORE.equals(nodeType)) {
            view.setVisible(Boolean.FALSE, new String[]{"roletypelabel"});
        }
        this.changeBcAndMarginLeftStyle(view, nodeType, workflowType);
    }

    private void changeBcAndMarginLeftStyle(IFormView view, Long nodeType, String workflowType) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        HashMap map = new HashMap(16);
        HashMap<String, LocaleString> leasthandlerMap = new HashMap<String, LocaleString>(16);
        HashMap<String, LocaleString> roleTypeMap = new HashMap<String, LocaleString>(16);
        HashMap<String, LocaleString> roleTypeWidthMap = new HashMap<String, LocaleString>(16);
        HashMap s = new HashMap(16);
        HashMap<String, String> m = new HashMap<String, String>(16);
        HashMap names = new HashMap(16);
        HashMap<String, String> namem = new HashMap<String, String>(16);
        String width = "38%";
        String height = "80px";
        String roleTypeWidth = "214px";
        if (nodeType.equals(NodeTypeConstants.BATCH_ADJUSTSUMSCORE) || workflowType.equals(FLOW_INDICATOR) || workflowType.equals("3")) {
            fieldMap.put("bc", "white");
            m.put("l", "0px");
            namem.put("r", "0px");
            width = "49%";
            view.setVisible(Boolean.FALSE, new String[]{"roleweightflex", "turnoversort"});
            if (nodeType.equals(NodeTypeConstants.BATCH_ADJUSTSUMSCORE)) {
                width = "60%";
            }
        } else {
            roleTypeWidth = "183px";
            height = "66px";
            fieldMap.put("bc", "#F3F5F8");
            m.put("l", "30px");
            namem.put("r", "40px");
            view.setVisible(Boolean.TRUE, new String[]{"roleweightflex", "roleweight", "percent", "turnoversort"});
        }
        view.updateControlMetadata("coreinfoap", fieldMap);
        s.put("m", m);
        map.put("s", s);
        view.updateControlMetadata("infopanelap", map);
        HashMap roleNameMap = new HashMap(16);
        names.put("m", namem);
        roleNameMap.put("s", names);
        roleNameMap.put("w", new LocaleString(width));
        roleTypeMap.put("h", new LocaleString(height));
        roleTypeWidthMap.put("w", new LocaleString(roleTypeWidth));
        view.updateControlMetadata("rolename", roleNameMap);
        view.updateControlMetadata("roleflexpanel", roleTypeMap);
        view.updateControlMetadata("roletype", roleTypeWidthMap);
        view.updateControlMetadata("outflowrule", roleTypeWidthMap);
        leasthandlerMap.put("w", new LocaleString(width));
        view.updateControlMetadata("leasthandler", leasthandlerMap);
    }

    private void sendNodeDataToRolePage(IFormView view, NodeRoleBo nodeRole) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("flag", (Object)view.getPageCache().get("flag"));
        jsonObject.put(PAGE_ID, (Object)view.getPageId());
        jsonObject.put(NODE_ROLE, (Object)nodeRole.toString());
        this.getView().getModel().setValue(INDEX_NODE_ROLE, (Object)jsonObject);
        this.getView().sendFormAction(this.getView());
        this.getView().sendFormAction(view);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult resultValue = messageBoxClosedEvent.getResult();
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap51", "adjustflex", "nodeweightflex", "flexpanelap71", "flexpanelap2", "flexpanelap20", "otherap"});
        if (HRStringUtils.equals((String)actionId, (String)NODE_TYPE) && resultValue.getValue() == MessageBoxResult.Yes.getValue()) {
            FlowNodeItemBo flowNode = this.getFlowNode();
            DynamicObject nodeTypeDo = this.getModel().getDataEntity().getDynamicObject(NODE_TYPE);
            if (MessageBoxResult.Yes.equals((Object)resultValue)) {
                this.dealSwitchNodeType(nodeTypeDo, flowNode);
                this.getModel().setValue(FLOW_NODE, (Object)flowNode.toString());
                this.sendNodeDataToParentPage(flowNode.toString());
            } else {
                this.getView().getPageCache().put(NODETYPECANCELFLAG, FLOW_INDICATOR);
                this.getModel().setValue(NODE_TYPE, (Object)this.getView().getPageCache().get("curnodeOldVal"));
                this.getView().updateView("flexpanelap5");
            }
        } else {
            this.getView().getPageCache().put(NODETYPECANCELFLAG, FLOW_INDICATOR);
            this.getModel().setValue(NODE_TYPE, (Object)this.getView().getPageCache().get("curnodeOldVal"));
            String nodeType = this.getView().getPageCache().get("curnodeOldVal");
            String workflowType = (String)this.getView().getParentView().getFormShowParameter().getCustomParam(FLOW_TYPE);
            this.changeWidthByWork(workflowType, Long.parseLong(nodeType));
        }
    }

    private void dealSwitchNodeType(DynamicObject nodeTypeDo, FlowNodeItemBo flowNode) {
        if (null == nodeTypeDo) {
            flowNode.setNodeType(Long.valueOf(0L));
            this.getView().setVisible(Boolean.FALSE, new String[]{"nodeweightflex"});
            return;
        }
        this.initNodePageForSwitchNodeType(flowNode, nodeTypeDo);
        this.dealSwitchNodeView(flowNode);
        String rolePageIds = StringUtils.strip((String)this.getView().getPageCache().get(ROLE_PAGE_IDS), (String)"[]");
        ArrayList rolePageIdList = Lists.newArrayList((Object[])StringUtils.strip((String)rolePageIds.replace(" ", "")).split(","));
        String workflowType = (String)this.getView().getParentView().getFormShowParameter().getCustomParam(FLOW_TYPE);
        int rolePageIndex = 0;
        for (String rolePageId : rolePageIdList) {
            IFormView view = this.getView().getView(rolePageId);
            if (++rolePageIndex > 1) {
                view.invokeOperation("deleteicon");
                this.getView().sendFormAction(view);
                continue;
            }
            NodeRoleBo nodeRole = (NodeRoleBo)JSONObject.parseObject((String)view.getModel().getValue(NODE_ROLE).toString(), NodeRoleBo.class);
            this.initRolePageForSwitchNodeType(view, flowNode.getNodeType(), nodeRole);
            flowNode.setNodeRoleList(Collections.singletonList(nodeRole));
            this.handleNodeRoleView(view, flowNode.getNodeType(), workflowType);
            this.getView().getPageCache().put(ROLE_PAGE_IDS, Collections.singletonList(view.getPageId()).toString());
            this.sendNodeDataToRolePage(view, nodeRole);
            this.sendNodeDataToParentPage(flowNode.toString());
        }
        this.changeWidthByWork(workflowType, flowNode.getNodeType());
        this.switchDeleteIconDisplay();
        this.getView().getPageCache().put(PAGE_ID, this.getView().getPageId());
    }

    private void dealSwitchNodeView(FlowNodeItemBo flowNode) {
        if (NodeTypeConstants.BATCH_ADJUSTSUMSCORE.equals(flowNode.getNodeType()) || NodeTypeConstants.EVALUATE_AUDIT.equals(flowNode.getNodeType()) || NodeTypeConstants.INTERVIEW_AUDIT.equals(flowNode.getNodeType())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"addroleap", "openorcloseap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"addroleap"});
        }
    }

    private void initNodePageForSwitchNodeType(FlowNodeItemBo flowNode, DynamicObject nodeTypeDo) {
        String oldNodeName = flowNode.getNodeName();
        if (null != flowNode.getNodeType() && 0L != flowNode.getNodeType()) {
            oldNodeName = ((DynamicObject)FlowNodeBo.getNodeTypeNodeMap().get(flowNode.getNodeType())).getString("name");
        }
        flowNode.setNodeType(Long.valueOf(nodeTypeDo.getLong("id")));
        flowNode.setNodeTypeCode(nodeTypeDo.getString("number"));
        if (StringUtils.isBlank((CharSequence)flowNode.getNodeName()) || ChangeNodeNameUtils.checkNodeName(flowNode.getNodeName(), oldNodeName)) {
            flowNode.setNodeName(this.fillInNodeName(flowNode.getNodeType()));
        }
        if (NodeTypeConstants.BATCH_ADJUSTSUMSCORE.equals(flowNode.getNodeType())) {
            flowNode.setAdjusetScoreLowerlimit(new BigDecimal("-2.00"));
            flowNode.setAdjustScoreUplimit(new BigDecimal("2.00"));
        } else {
            flowNode.setAdjusetScoreLowerlimit(null);
            flowNode.setAdjustScoreUplimit(null);
        }
        flowNode.setNodeWeight(0.0);
        flowNode.setCrossScore(Boolean.FALSE.booleanValue());
        flowNode.setSupportTotalScore(Boolean.FALSE.booleanValue());
        flowNode.setCopy(Boolean.FALSE.booleanValue());
        flowNode.setHandlerType(Long.valueOf(0L));
        this.getView().getModel().setValue(SUBSTITUTE, null);
        flowNode.setManualop(Boolean.FALSE.booleanValue());
        flowNode.setSameauditjump(Boolean.FALSE.booleanValue());
        flowNode.setMultiUserOrPost(new ArrayList(10));
        this.getView().getModel().setValue(NODE_NAME, (Object)flowNode.getNodeName());
        this.getView().getModel().setValue(NODE_WEIGHT, (Object)flowNode.getNodeWeight());
        this.getView().getModel().setValue(CROSSCORE, (Object)"0");
        this.getView().getModel().setValue(SUPPORTTOTALSCORE, (Object)Boolean.FALSE);
        this.getView().getModel().setValue(ISCOPY, (Object)Boolean.FALSE);
        this.getView().getModel().setValue(MANUALOP, (Object)FLOW_INDICATOR);
        this.getView().getModel().setValue(SAVEAUDITJUMP, (Object)Boolean.FALSE);
        this.getView().getModel().setValue(SAMEJUMP, (Object)Boolean.FALSE);
        this.getView().getPageCache().put(ADJUSTSCOREUPLIMIT + flowNode.getNodeSeq(), FLOW_INDICATOR);
        this.getView().getPageCache().put(ADJUSETSCORELOWERLIMIT + flowNode.getNodeSeq(), FLOW_INDICATOR);
        this.getView().getModel().setValue(ADJUSTSCOREUPLIMIT, (Object)flowNode.getAdjustScoreUplimit());
        this.getView().getModel().setValue(ADJUSETSCORELOWERLIMIT, (Object)flowNode.getAdjusetScoreLowerlimit());
        this.getView().getPageCache().remove(ADJUSTSCOREUPLIMIT + flowNode.getNodeSeq());
        this.getView().getPageCache().remove(ADJUSETSCORELOWERLIMIT + flowNode.getNodeSeq());
        this.getView().getParentView().getPageCache().remove(ADJUSTSCOREUPLIMIT + flowNode.getNodeSeq());
        this.getView().getParentView().getPageCache().remove(ADJUSETSCORELOWERLIMIT + flowNode.getNodeSeq());
        this.getView().setVisible(Boolean.FALSE, new String[]{SAVEAUDITJUMP});
        String workflowType = (String)this.getView().getFormShowParameter().getCustomParam(FLOW_TYPE);
        Label labelap6 = (Label)this.getView().getControl("labelap6");
        if (NodeTypeConstants.INDICATOR_AUDIT.equals(flowNode.getNodeType()) || NodeTypeConstants.EVALUATE_SCORE.equals(flowNode.getNodeType()) || NodeTypeConstants.BATCH_EVALUSUMSCORE.equals(flowNode.getNodeType())) {
            labelap6.setText(ResManager.loadKDString((String)"\u6d41\u51fa\u89c4\u5219\u4e0e\u88ab\u66ff\u4ee3\u89d2\u8272\u7684\u6d41\u51fa\u89c4\u5219\u4fdd\u6301\u4e00\u81f4\u3002", (String)"FlowNodeConfigPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            labelap6.setText(ResManager.loadKDString((String)"\u5f53\u89d2\u8272\u6709\u591a\u4e2a\u5904\u7406\u4eba\u65f6\uff0c\u4ee5\u7b2c\u4e00\u4e2a\u63d0\u4ea4\u7684\u4e3a\u51c6\u3002", (String)"FlowNodeConfigPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
        if (FLOW_INDICATOR.equals(workflowType) && NodeTypeConstants.INDICATOR_AUDIT.equals(flowNode.getNodeType())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{SAVEAUDITJUMP});
        }
        if (FLOW_INDICATOR.equals(workflowType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SAMEJUMP});
        } else if ("2".equals(workflowType)) {
            if (NodeTypeConstants.EVALUATE_SCORE.equals(flowNode.getNodeType()) || NodeTypeConstants.BATCH_EVALUSUMSCORE.equals(flowNode.getNodeType())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{SAMEJUMP});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{SAMEJUMP});
            }
        }
    }

    private void initRolePageForSwitchNodeType(IFormView view, Long nodeType, NodeRoleBo nodeRole) {
        nodeRole.setTurnoverSort(1);
        if (nodeType.equals(NodeTypeConstants.BATCH_ADJUSTSUMSCORE) || nodeType.equals(NodeTypeConstants.INDICATOR_FORMULATE) || nodeType.equals(NodeTypeConstants.INDICATOR_CONFIRM) || nodeType.equals(NodeTypeConstants.INTERVIEW_AUDIT)) {
            nodeRole.setOutFlow("10");
        } else {
            nodeRole.setOutFlow("30");
        }
        nodeRole.setMinNum(5);
        nodeRole.setRoleSeq(1);
        nodeRole.setRoleWeight(100.0);
        nodeRole.setRoleType(Long.valueOf(0L));
        nodeRole.setRoleName("");
        if (nodeType.equals(NodeTypeConstants.INTERVIEW_AUDIT)) {
            nodeRole.setReviewercanedit(Boolean.TRUE.booleanValue());
            view.getPageCache().put("outflow" + view.getPageId(), nodeRole.getOutFlow());
            view.getPageCache().put("reviewercanedit" + view.getPageId(), nodeRole.isReviewercanedit() ? FLOW_INDICATOR : "2");
            view.getModel().setValue("reviewercanedit", (Object)Boolean.TRUE);
        }
        JSONObject jsonStr = nodeRole.getConfjson();
        jsonStr.put("isscoreconfig", (Object)Boolean.TRUE);
        jsonStr.put("isscoredesc", (Object)Boolean.FALSE);
        jsonStr.put("isscorenext", (Object)Boolean.FALSE);
        jsonStr.put("isgradeedit", (Object)Boolean.FALSE);
        jsonStr.put("isgradecompute", (Object)Boolean.TRUE);
        jsonStr.put("isgradelevel", (Object)Boolean.FALSE);
        jsonStr.put("isevaluatenext", (Object)Boolean.FALSE);
        jsonStr.put("isgradenext", (Object)Boolean.FALSE);
        jsonStr.put("isevaluate", (Object)Boolean.FALSE);
        jsonStr.put("totalrating", (Object)"A");
        jsonStr.put("secondF7", (Object)"");
        view.getModel().setValue(NODE_ROLE, (Object)nodeRole.toString());
        view.getModel().setValue("turnoversort", (Object)nodeRole.getTurnoverSort());
        view.getModel().setValue("outflowrule", (Object)nodeRole.getOutFlow());
        view.getModel().setValue("leasthandler", (Object)nodeRole.getMinNum());
        view.getModel().setValue("roleweight", (Object)nodeRole.getRoleWeight());
        view.getModel().setValue("totalrating", (Object)"A");
        view.getModel().setValue("isscoreconfig", (Object)Boolean.TRUE);
        view.getModel().setValue("isscoredesc", (Object)Boolean.FALSE);
        view.getModel().setValue("isscorenext", (Object)Boolean.FALSE);
        view.getModel().setValue("isgradeedit", (Object)Boolean.FALSE);
        view.getModel().setValue("isgradecompute", (Object)Boolean.TRUE);
        view.getModel().setValue("isgradelevel", (Object)Boolean.FALSE);
        view.getModel().setValue("isgradenext", (Object)Boolean.FALSE);
        view.getModel().setValue("isevaluate", (Object)Boolean.FALSE);
        view.getModel().setValue("isevaluatenext", (Object)Boolean.FALSE);
        view.getModel().setValue("evaviewperm", (Object)"10");
        view.getModel().setValue("ishideevaname", (Object)Boolean.FALSE);
        view.getModel().setValue(DESIGNEE2, (Object)"");
        view.getModel().setValue(SUBSTITUEAPPOINTPOS, (Object)"");
        view.getModel().setValue(SUBSTITUEAPPOINTADMINORG, (Object)"");
        view.getModel().setValue("roletype", (Object)"");
        view.getModel().setValue("rolename", null);
    }

    private QFilter getQFilterForRoleType() {
        String workflowType = (String)this.getView().getFormShowParameter().getCustomParam(FLOW_TYPE);
        QFilter qFilter = null;
        if (workflowType.equals("2")) {
            qFilter = new QFilter("processtype", "like", (Object)"%B%");
        } else if (workflowType.equals(FLOW_INDICATOR)) {
            qFilter = new QFilter("processtype", "like", (Object)"%A%");
        } else if (workflowType.equals("3")) {
            qFilter = new QFilter("processtype", "like", (Object)"%F%");
        }
        return qFilter;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "nodeopen": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap", "nodeclose"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"nodeopen"});
                break;
            }
            case "nodeclose": {
                this.getView().getParentView().setVisible(Boolean.FALSE, new String[]{"flowconfigflexap"});
                this.getView().getParentView().getPageCache().put("flowconfigflexap", "invisible");
                this.getView().getParentView().invokeOperation("closenodeconfig");
                this.getView().getParentView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
                this.getView().sendFormAction(this.getView().getParentView());
                break;
            }
        }
    }

    private void handleRoleViewByNodeWeight(double nodeWeight) {
        String rolePageIds = StringUtils.strip((String)this.getView().getPageCache().get(ROLE_PAGE_IDS), (String)"[]");
        ArrayList rolePageIdList = Lists.newArrayList((Object[])StringUtils.strip((String)rolePageIds.replace(" ", "")).split(","));
        for (String rolePageId : rolePageIdList) {
            IFormView view = this.getView().getView(rolePageId);
            if (nodeWeight > 0.0) {
                view.getModel().setValue("isscoreconfig", (Object)Boolean.TRUE);
                view.setEnable(Boolean.FALSE, new String[]{"scoreconfig", "isscoreconfig"});
            } else {
                view.setEnable(Boolean.TRUE, new String[]{"scoreconfig", "isscoreconfig"});
            }
            this.getView().sendFormAction(view);
        }
    }
}

