/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.assessrule;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.common.constants.FlowNodeConfigConstants;
import kd.opmc.pbs.business.application.service.workflow.FlowDefProcApplicationService;
import kd.opmc.pbs.business.model.FlowNodeItemBo;
import kd.opmc.pbs.business.model.FlowUserBo;
import kd.opmc.pbs.business.model.NodeRoleBo;
import kd.opmc.pbs.business.tips.ShowConfigTipsUtils;
import kd.opmc.pbs.common.constants.NodeTypeConstants;
import kd.opmc.pbs.common.constants.RoleTypeConstants;
import org.apache.commons.lang3.StringUtils;

public class NodeRoleConfigPlugin
extends HRDataBaseEdit
implements FlowNodeConfigConstants,
AfterF7SelectListener,
BeforeF7SelectListener {
    private static final FlowDefProcApplicationService FLOW_DEF_PROC_APPLICATION_SERVICE = FlowDefProcApplicationService.getInstance();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"evaluatenext", "noevaluatenext", "evaluate", "noevaluate", "gradenext", "nogradenext", "gradelevel", "nogradelevel", "nogradecompute", "gradecompute", "nogradeedit", "gradeedit", "noscorenext", "scorenext", "noscoredesc", "scoredesc", "noscoreconfig", "scoreconfig", "viewdetail"});
        this.addClickListeners(new String[]{"deleteicon"});
        BasedataEdit roletypeEdit = (BasedataEdit)this.getView().getControl("roletype");
        roletypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit designee2 = (BasedataEdit)this.getView().getControl("designee2");
        designee2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit handlers = (BasedataEdit)this.getView().getControl("handlers");
        handlers.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        handlers.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        NodeRoleBo nodeRole = this.getNodeRoleBo();
        if (null == nodeRole || "deleteicon".equals(key)) {
            return;
        }
        JSONObject jsonStr = nodeRole.getConfjson();
        switch (key) {
            case "evaluatenext": {
                this.getModel().setValue("isevaluatenext", (Object)Boolean.FALSE);
                jsonStr.put("isevaluatenext", (Object)Boolean.FALSE);
                break;
            }
            case "noevaluatenext": {
                this.getModel().setValue("isevaluatenext", (Object)Boolean.TRUE);
                jsonStr.put("isevaluatenext", (Object)Boolean.TRUE);
                break;
            }
            case "evaluate": {
                this.getModel().setValue("isevaluate", (Object)Boolean.FALSE);
                jsonStr.put("isevaluate", (Object)Boolean.FALSE);
                break;
            }
            case "noevaluate": {
                this.getModel().setValue("isevaluate", (Object)Boolean.TRUE);
                jsonStr.put("isevaluate", (Object)Boolean.TRUE);
                break;
            }
            case "gradenext": {
                this.getModel().setValue("isgradenext", (Object)Boolean.FALSE);
                jsonStr.put("isgradenext", (Object)Boolean.FALSE);
                break;
            }
            case "nogradenext": {
                this.getModel().setValue("isgradenext", (Object)Boolean.TRUE);
                jsonStr.put("isgradenext", (Object)Boolean.TRUE);
                break;
            }
            case "gradelevel": {
                this.getModel().setValue("isgradelevel", (Object)Boolean.FALSE);
                jsonStr.put("isgradelevel", (Object)Boolean.FALSE);
                break;
            }
            case "nogradelevel": {
                this.getModel().setValue("isgradelevel", (Object)Boolean.TRUE);
                jsonStr.put("isgradelevel", (Object)Boolean.TRUE);
                break;
            }
            case "gradecompute": {
                this.getModel().setValue("isgradecompute", (Object)Boolean.FALSE);
                jsonStr.put("isgradecompute", (Object)Boolean.FALSE);
                break;
            }
            case "nogradecompute": {
                this.getModel().setValue("isgradecompute", (Object)Boolean.TRUE);
                jsonStr.put("isgradecompute", (Object)Boolean.TRUE);
                break;
            }
            case "gradeedit": {
                this.getModel().setValue("isgradeedit", (Object)Boolean.FALSE);
                jsonStr.put("isgradeedit", (Object)Boolean.FALSE);
                break;
            }
            case "nogradeedit": {
                this.getModel().setValue("isgradeedit", (Object)Boolean.TRUE);
                jsonStr.put("isgradeedit", (Object)Boolean.TRUE);
                break;
            }
            case "scorenext": {
                jsonStr.put("isscorenext", (Object)Boolean.FALSE);
                this.getModel().setValue("isscorenext", (Object)Boolean.FALSE);
                break;
            }
            case "noscorenext": {
                this.getModel().setValue("isscorenext", (Object)Boolean.TRUE);
                jsonStr.put("isscorenext", (Object)Boolean.TRUE);
                break;
            }
            case "scoredesc": {
                this.getModel().setValue("isscoredesc", (Object)Boolean.FALSE);
                jsonStr.put("isscoredesc", (Object)Boolean.FALSE);
                break;
            }
            case "noscoredesc": {
                this.getModel().setValue("isscoredesc", (Object)Boolean.TRUE);
                jsonStr.put("isscoredesc", (Object)Boolean.TRUE);
                break;
            }
            case "scoreconfig": {
                this.getModel().setValue("isscoreconfig", (Object)Boolean.FALSE);
                jsonStr.put("isscoreconfig", (Object)Boolean.FALSE);
                break;
            }
            case "noscoreconfig": {
                this.getModel().setValue("isscoreconfig", (Object)Boolean.TRUE);
                jsonStr.put("isscoreconfig", (Object)Boolean.TRUE);
                break;
            }
            case "viewdetail": {
                this.showRoleTypePage(OperationStatus.VIEW);
                break;
            }
        }
        if (!("editicon".equals(key) || "copyicon".equals(key) || "roleopen".equals(key) || "roleclose".equals(key))) {
            this.getModel().setValue("noderole", (Object)nodeRole.toString());
            this.sendRoleDataToParentPage(nodeRole.toString());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        FlowNodeItemBo flowNode = (FlowNodeItemBo)JSONObject.parseObject((String)this.getView().getParentView().getModel().getValue("flownode").toString(), FlowNodeItemBo.class);
        switch (operateKey) {
            case "deleteicon": {
                List nodeRoleList = flowNode.getNodeRoleList();
                if (1 == nodeRoleList.size()) {
                    String msg = ResManager.loadKDString((String)"\u6bcf\u4e2a\u8282\u70b9\u81f3\u5c11\u62e5\u6709\u4e00\u6761\u89d2\u8272\u914d\u7f6e\uff0c\u4e0d\u53ef\u5220\u9664", (String)"NodeRoleConfigPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(msg);
                    return;
                }
                if (2 == nodeRoleList.size()) {
                    this.getView().getParentView().setVisible(Boolean.FALSE, new String[]{"openorcloseap"});
                    this.switchDeleteIconDisplay();
                }
                this.getModel().setValue("noderole", null);
                this.sendRoleDataToParentPage(null);
                this.getView().close();
                this.disableWeightAndSort();
                break;
            }
            case "editicon": {
                this.showRoleTypePage(OperationStatus.EDIT);
                break;
            }
            case "roleopen": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap", "outflowruleap", "roleclose"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"roleopen"});
                break;
            }
            case "roleclose": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"roleopen"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"roleclose", "flexpanelap", "outflowruleap"});
                break;
            }
        }
    }

    private void switchDeleteIconDisplay() {
        String rolePageIds = StringUtils.strip((String)this.getView().getParentView().getPageCache().get("rolePageIds"), (String)"[]");
        ArrayList rolePageIdList = Lists.newArrayList((Object[])StringUtils.strip((String)rolePageIds.replace(" ", "")).split(","));
        for (String rolePageId : rolePageIdList) {
            IFormView view = this.getView().getView(rolePageId);
            view.setVisible(Boolean.FALSE, new String[]{"deleteicon"});
            this.getView().sendFormAction(view);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    protected void initTips() {
        String workflowType = (String)this.getView().getFormShowParameter().getCustomParam("flowType");
        Map tipsMap = ShowConfigTipsUtils.getTipsByFormId((String)"epa_noderoleconfig");
        tipsMap.forEach((tipskey, value) -> {
            if (0 == value.size()) {
                return;
            }
            HashMap<String, Tips> textProps = new HashMap<String, Tips>(16);
            Tips textTips = new Tips();
            textTips.setType("text");
            textTips.setContent(new LocaleString(value.toArray(new String[0])[0]));
            if ("designee2".equals(tipskey)) {
                int tipSize = value.size();
                if (workflowType.equals("3")) {
                    if (value.toArray(new String[0])[0].contains("#1")) {
                        textTips.setContent(new LocaleString(value.toArray(new String[0])[0].replaceFirst("#1", "")));
                    } else if (tipSize > 1) {
                        textTips.setContent(new LocaleString(value.toArray(new String[0])[1].replaceFirst("#1", "")));
                    }
                } else if (!value.toArray(new String[0])[0].contains("#1")) {
                    textTips.setContent(new LocaleString(value.toArray(new String[0])[0]));
                } else if (tipSize > 1) {
                    textTips.setContent(new LocaleString(value.toArray(new String[0])[1]));
                }
            }
            if ("labelap311".equals(tipskey)) {
                tipskey = "outflowrule";
            }
            textProps.put("tips", textTips);
            this.getView().updateControlMetadata(tipskey, textProps);
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        NodeRoleBo nodeRole = (NodeRoleBo)JSONObject.parseObject((String)parameter.getCustomParam("noderole").toString(), NodeRoleBo.class);
        if (null == nodeRole.getRoleType()) {
            nodeRole.setRoleType(Long.valueOf(0L));
        }
        this.getModel().setValue("noderole", (Object)nodeRole.toString());
        String flag = (String)parameter.getCustomParam("flag");
        this.getView().getPageCache().put("flag", flag);
        this.getModel().setValue("roleweight", (Object)nodeRole.getRoleWeight());
        this.getModel().setValue("turnoversort", (Object)(nodeRole.getTurnoverSort() == 0 ? 1 : nodeRole.getTurnoverSort()));
        this.getView().setVisible(Boolean.FALSE, new String[]{"roleopen"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"roleclose"});
        this.showPageRoleType(nodeRole);
        this.getView().setVisible(Boolean.FALSE, new String[]{"handlers"});
        this.renderRole(nodeRole);
        this.showOutFlow(String.valueOf(nodeRole.getRoleType()));
        this.hideItemForAdjustSumcore(this.getView().getParentView());
        String flowType = (String)this.getView().getFormShowParameter().getCustomParam("flowType");
        if (flowType.equals("1")) {
            this.dealRoleItemForIndicatorWf(nodeRole.getRoleType());
        } else if (flowType.equals("2")) {
            this.dealRoleItemForEvaluateWf(nodeRole.getRoleType());
        } else if (flowType.equals("3")) {
            this.dealRoleItemForInterviewWf(nodeRole.getRoleType());
        }
        BigDecimal nodeWeight = (BigDecimal)parameter.getCustomParam("nodeWeight");
        if (nodeWeight.compareTo(new BigDecimal("0")) > 0) {
            this.getView().getModel().setValue("isscoreconfig", (Object)Boolean.TRUE);
            this.getView().setEnable(Boolean.FALSE, new String[]{"scoreconfig", "isscoreconfig"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"scoreconfig", "isscoreconfig"});
        }
        FlowNodeItemBo flowNode = (FlowNodeItemBo)JSONObject.parseObject((String)this.getView().getParentView().getModel().getValue("flownode").toString(), FlowNodeItemBo.class);
        if (null != flowNode.getNodeType() && flowNode.getNodeType().equals(NodeTypeConstants.INDICATOR_AUDIT)) {
            this.getView().getModel().setValue("reviewercanedit", (Object)(nodeRole.isReviewercanedit() ? "1" : "2"));
            if (nodeRole.isReviewercanedit() && !flowNode.getNodeType().equals(NodeTypeConstants.INTERVIEW_AUDIT)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"outflowrule"});
            }
        }
        if (null != flowNode.getNodeType() && flowNode.getNodeType().equals(NodeTypeConstants.INTERVIEW_AUDIT)) {
            this.dealOutflowruleFormInterviewAuditNode(nodeRole);
        }
    }

    private void dealOutflowruleFormInterviewAuditNode(NodeRoleBo nodeRole) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("outflowrule");
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(2);
        ComboItem item1 = new ComboItem();
        item1.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ee5\u7b2c\u4e00\u4e2a\u63d0\u4ea4\u4eba\u4e3a\u51c6", (String)"NodeRoleConfigPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        item1.setValue("10");
        comboItemList.add(item1);
        ComboItem item2 = new ComboItem();
        item2.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8\u53c2\u4e0e", (String)"NodeRoleConfigPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        item2.setValue("30");
        comboItemList.add(item2);
        comboEdit.setComboItems(comboItemList);
        this.getView().getModel().setValue("reviewercanedit", (Object)(nodeRole.isReviewercanedit() ? "1" : "2"));
        this.getView().getModel().setValue("outflowrule", (Object)nodeRole.getOutFlow());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (OperationStatus.VIEW.equals((Object)parameter.getStatus())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"roleweight", "outflowrule", "leasthandler", "totalrating", "evaluatenext", "noevaluatenext", "evaluate", "noevaluate", "gradenext", "nogradenext", "gradelevel", "nogradelevel", "nogradecompute", "gradecompute", "nogradeedit", "gradeedit", "noscorenext", "scorenext", "noscoredesc", "scoredesc", "noscoreconfig", "scoreconfig"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"editicon", "deleteicon", "copyicon"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"viewdetail"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"viewdetail"});
        }
        FlowNodeItemBo flowNode = (FlowNodeItemBo)JSONObject.parseObject((String)this.getView().getParentView().getModel().getValue("flownode").toString(), FlowNodeItemBo.class);
        if (NodeTypeConstants.BATCH_ADJUSTSUMSCORE.equals(flowNode.getNodeType())) {
            Label label = (Label)this.getView().getControl("roletypelabel");
            label.setText(ResManager.loadKDString((String)"\u5f53\u89d2\u8272\u6709\u591a\u4e2a\u5904\u7406\u4eba\u65f6\uff0c\u4ee5\u7b2c\u4e00\u4e2a\u63d0\u4ea4\u7684\u4e3a\u51c6\u3002", (String)"NodeRoleConfigPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
        this.getView().setVisible(Boolean.valueOf(!flowNode.isCrossScore()), new String[]{"flexpanelap1811", "flexpanelap1821", "flexpanelap18211", "flexpanelap18111"});
        List nodeRoleList = flowNode.getNodeRoleList();
        if (nodeRoleList != null) {
            this.disableWeightAndSort();
            this.setAppointposMustInput();
        }
        this.initTips();
        this.getModel().setDataChanged(false);
    }

    private void disableWeightAndSort() {
        String rolePageIds = StringUtils.strip((String)this.getView().getParentView().getPageCache().get("rolePageIds"), (String)"[]");
        ArrayList rolePageIdList = Lists.newArrayList((Object[])StringUtils.strip((String)rolePageIds.replace(" ", "")).split(","));
        boolean enable = rolePageIdList.size() != 1;
        for (String rolePageId : rolePageIdList) {
            IFormView view = this.getView().getView(rolePageId);
            view.setEnable(Boolean.valueOf(enable), new String[]{"roleweight", "turnoversort"});
            this.getView().sendFormAction(view);
        }
        if (rolePageIdList.size() == 1) {
            IFormView view = this.getView().getView((String)rolePageIdList.get(0));
            view.getModel().setValue("roleweight", (Object)100);
            view.getModel().setValue("turnoversort", (Object)1);
            this.getView().sendFormAction(view);
        }
    }

    private void setAppointposMustInput() {
        long roleTypeId;
        if (null != this.getModel().getValue("roletype") && RoleTypeConstants.APPOINT_POSITION.equals(roleTypeId = ((DynamicObject)this.getModel().getValue("roletype")).getLong("id"))) {
            MulBasedataEdit appointposCtrl = (MulBasedataEdit)this.getControl("appointpos");
            appointposCtrl.setMustInput(true);
        }
    }

    private void renderRole(NodeRoleBo nodeRole) {
        JSONObject jsonStr = nodeRole.getConfjson();
        this.getModel().setValue("isscoreconfig", (Object)jsonStr.getBoolean("isscoreconfig"));
        this.getModel().setValue("isscoredesc", (Object)jsonStr.getBoolean("isscoredesc"));
        this.getModel().setValue("isscorenext", (Object)jsonStr.getBoolean("isscorenext"));
        this.getModel().setValue("isgradeedit", (Object)jsonStr.getBoolean("isgradeedit"));
        this.getModel().setValue("isgradecompute", (Object)jsonStr.getBoolean("isgradecompute"));
        this.getModel().setValue("isgradelevel", (Object)jsonStr.getBoolean("isgradelevel"));
        this.getModel().setValue("isevaluate", (Object)jsonStr.getBoolean("isevaluate"));
        this.getModel().setValue("isevaluatenext", (Object)jsonStr.getBoolean("isevaluatenext"));
        this.getModel().setValue("isgradenext", (Object)jsonStr.getBoolean("isgradenext"));
        this.getModel().setValue("totalrating", (Object)jsonStr.getString("totalrating"));
        this.getModel().setValue("outflowrule", (Object)nodeRole.getOutFlow());
        this.getModel().setValue("leasthandler", (Object)nodeRole.getMinNum());
    }

    private void showRoleTypePage(OperationStatus operationStatus) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_roletype");
        showParameter.setStatus(operationStatus);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_roletype"));
        showParameter.setCustomParam("noderole", this.getModel().getValue("noderole"));
        showParameter.setCustomParam("flowType", this.getView().getFormShowParameter().getCustomParam("flowType"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        NodeRoleBo nodeRoleBo = (NodeRoleBo)closedCallBackEvent.getReturnData();
        if (null != nodeRoleBo) {
            this.showOutFlow(String.valueOf(nodeRoleBo.getRoleType()));
            this.showPageRoleType(nodeRoleBo);
            this.getModel().setValue("noderole", (Object)nodeRoleBo.toString());
            this.sendRoleDataToParentPage(nodeRoleBo.toString());
        }
    }

    private void showOutFlow(String roleType) {
        if (HRStringUtils.equals((String)"10", (String)roleType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"outflowruleap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"outflowruleap"});
        }
    }

    private void showPageRoleType(NodeRoleBo nodeRoleBo) {
        long secondF7;
        List multiUserOrPost;
        String rolename = nodeRoleBo.getRoleName() == null || "null".equals(nodeRoleBo.getRoleName()) ? "" : nodeRoleBo.getRoleName();
        this.getModel().setValue("rolename", (Object)rolename);
        this.getModel().setValue("roletype", (Object)nodeRoleBo.getRoleType());
        Long roleType = nodeRoleBo.getRoleType();
        if (roleType.equals(RoleTypeConstants.APPOINTOR)) {
            multiUserOrPost = nodeRoleBo.getMultiUserOrPost();
            if (multiUserOrPost.isEmpty()) {
                secondF7 = nodeRoleBo.getSecondF7();
                multiUserOrPost.add(secondF7);
            }
            this.getModel().setValue("designee2", (Object)nodeRoleBo.getMultiUserOrPost().toArray());
            if (CollectionUtils.isNotEmpty((Collection)nodeRoleBo.getUserBoList())) {
                this.getModel().setValue("handlers", (Object)nodeRoleBo.getUserBoList().stream().map(FlowUserBo::getDepempId).toArray());
            }
        }
        if (roleType.equals(RoleTypeConstants.APPOINT_POSITION)) {
            multiUserOrPost = nodeRoleBo.getMultiUserOrPost();
            if (multiUserOrPost.isEmpty()) {
                secondF7 = nodeRoleBo.getSecondF7();
                multiUserOrPost.add(secondF7);
            }
            this.getModel().setValue("appointpos", (Object)nodeRoleBo.getMultiUserOrPost().toArray());
        }
        if (roleType.equals(RoleTypeConstants.APPOINT_DEPHEADER)) {
            this.getModel().setValue("adminorg", (Object)nodeRoleBo.getSecondF7());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propertyName;
        switch (propertyName = e.getProperty().getName()) {
            case "roletype": {
                e.getCustomQFilters().add(this.getQFilterForRoleType());
                break;
            }
            case "designee2": {
                e.setCancel(true);
                BasedataEdit control = (BasedataEdit)this.getView().getControl("handlers");
                control.click();
                break;
            }
            case "handlers": {
                FormShowParameter formShowParameter = e.getFormShowParameter();
                formShowParameter.setCustomParam("showeffect", (Object)"0");
                break;
            }
            case "appointpos": {
                e.getCustomQFilters().add(this.getQFilterForMultiUserOrPost("appointpos"));
                break;
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        String fieldKey = ((Control)evt.getSource()).getKey();
        if ("handlers".equals(fieldKey)) {
            ArrayList ids;
            Map userIdMap;
            DynamicObjectCollection entryentity = this.getModel().getDataEntity().getDynamicObjectCollection("handlers");
            HashSet<Long> idSet = new HashSet<Long>(16);
            ArrayList<FlowUserBo> userBos = new ArrayList<FlowUserBo>(10);
            if (!entryentity.isEmpty()) {
                for (DynamicObject dynamicObject : entryentity) {
                    long depempId = dynamicObject.getLong("fbasedataid_id");
                    long personId = dynamicObject.getDynamicObject("fbasedataid").getLong("person_id");
                    idSet.add(personId);
                    FlowUserBo userBo = new FlowUserBo();
                    userBo.setUserId(Long.valueOf(personId));
                    userBo.setDepempId(Long.valueOf(depempId));
                    userBos.add(userBo);
                }
            }
            if (null != (userIdMap = FLOW_DEF_PROC_APPLICATION_SERVICE.getUserIdsByPersonIds(ids = new ArrayList(idSet))) && !userIdMap.isEmpty()) {
                if (userIdMap.size() < ids.size()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5904\u7406\u4eba\u5728\u5e73\u53f0\u8d26\u53f7\u5b58\u5728\u5f02\u5e38\uff0c\u6dfb\u52a0\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"NodeRoleConfigPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                }
                List<FlowUserBo> newBos = userBos.stream().filter(bo -> userIdMap.containsKey(bo.getUserId())).collect(Collectors.toList());
                newBos.forEach(bo -> bo.setUserId((Long)userIdMap.get(bo.getUserId())));
                NodeRoleBo nodeRole = this.getNodeRoleBo();
                nodeRole.setUserBoList(newBos);
                this.getModel().setValue("noderole", (Object)nodeRole.toString());
                this.sendRoleDataToParentPage(nodeRole.toString());
                this.getModel().setValue("handlers", (Object)newBos.stream().map(FlowUserBo::getDepempId).toArray());
                this.getModel().setValue("designee2", (Object)userIdMap.values().toArray());
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u5904\u7406\u4eba\u5728\u5e73\u53f0\u8d26\u53f7\u5b58\u5728\u5f02\u5e38\uff0c\u6dfb\u52a0\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"NodeRoleConfigPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("handlers", null);
                this.getModel().setValue("designee2", null);
            }
        }
    }

    private QFilter getQFilterForMultiUserOrPost(String field) {
        DynamicObjectCollection userColl = (DynamicObjectCollection)this.getModel().getValue(field);
        List ids = userColl.stream().map(dyn -> dyn.getLong("fbasedataid_id")).collect(Collectors.toList());
        return new QFilter("id", "not in", ids);
    }

    private QFilter getQFilterForRoleType() {
        String workflowType = (String)this.getView().getFormShowParameter().getCustomParam("flowType");
        QFilter qFilter = null;
        if (workflowType.equals("2")) {
            qFilter = new QFilter("processtype", "like", (Object)"%B%");
        } else if (workflowType.equals("1")) {
            qFilter = new QFilter("processtype", "like", (Object)"%A%");
        } else if (workflowType.equals("3")) {
            qFilter = new QFilter("processtype", "like", (Object)"%F%");
        }
        return qFilter;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String fieldKey = args.getProperty().getName();
        if (HRStringUtils.equals((String)"noderole", (String)fieldKey) || HRStringUtils.equals((String)"handlers", (String)fieldKey)) {
            return;
        }
        NodeRoleBo nodeRole = this.getNodeRoleBo();
        JSONObject confJson = nodeRole.getConfjson();
        FlowNodeItemBo flowNode = (FlowNodeItemBo)JSONObject.parseObject((String)this.getView().getParentView().getModel().getValue("flownode").toString(), FlowNodeItemBo.class);
        switch (fieldKey) {
            case "roleweight": {
                HRAppCache.get((String)"epa").put(RequestContext.get().getCurrUserId() + "workflow_roleweight", (Object)"1");
                nodeRole.setRoleWeight(Double.parseDouble(this.getModel().getValue("roleweight").toString()));
                String cacheKey = this.getView().getParentView().getParentView().getPageId() + "ROLEWEIGHT" + flowNode.getNodeSeq() + nodeRole.getRoleSeq();
                this.getView().getParentView().getParentView().getPageCache().put(cacheKey, String.valueOf(nodeRole.getRoleWeight()));
                HRAppCache.get((String)"epa").remove(RequestContext.get().getCurrUserId() + "workflow_roleweight");
                break;
            }
            case "totalrating": {
                confJson.put("totalrating", this.getModel().getValue("totalrating"));
                break;
            }
            case "outflowrule": {
                nodeRole.setOutFlow(String.valueOf(this.getModel().getValue("outflowrule")));
                String outflowKey = "outflow" + this.getView().getPageId();
                if (StringUtils.isEmpty((CharSequence)this.getView().getPageCache().get(outflowKey))) break;
                nodeRole.setOutFlow(this.getView().getPageCache().get(outflowKey));
                this.getModel().beginInit();
                this.getModel().setValue("outflowrule", (Object)nodeRole.getOutFlow());
                this.getModel().endInit();
                this.getView().getPageCache().remove(outflowKey);
                this.dealOutflowruleFormInterviewAuditNode(nodeRole);
                break;
            }
            case "leasthandler": {
                if (!HRObjectUtils.isEmpty((Object)this.getModel().getValue("leasthandler"))) {
                    int leasthandler = Integer.parseInt(this.getModel().getValue("leasthandler").toString());
                    nodeRole.setMinNum(leasthandler);
                } else {
                    nodeRole.setMinNum(0);
                }
                String leastHandlerCacheKey = this.getView().getParentView().getParentView().getPageId() + "LEASTHANDLER" + flowNode.getNodeSeq() + nodeRole.getRoleSeq();
                HRAppCache.get((String)"epa").put(leastHandlerCacheKey, (Object)String.valueOf(nodeRole.getMinNum()));
                break;
            }
            case "turnoversort": {
                Integer oldValue = Integer.parseInt(args.getChangeSet()[0].getOldValue().toString());
                Integer newValue = Integer.parseInt(args.getChangeSet()[0].getNewValue().toString());
                if (!oldValue.equals(newValue)) {
                    nodeRole.setTurnoversortChange(Boolean.TRUE.booleanValue());
                }
                nodeRole.setTurnoverSort(Integer.parseInt(this.getModel().getValue("turnoversort").toString()));
                break;
            }
            case "reviewercanedit": {
                boolean reviewercanedit = HRStringUtils.equals((String)this.getModel().getDataEntity().getString("reviewercanedit"), (String)"1");
                nodeRole.setReviewercanedit(reviewercanedit);
                if (null == flowNode.getNodeType() || flowNode.getNodeType().equals(NodeTypeConstants.INTERVIEW_AUDIT)) {
                    String reviewercaneditKey = "reviewercanedit" + this.getView().getPageId();
                    if (StringUtils.isEmpty((CharSequence)this.getView().getPageCache().get(reviewercaneditKey))) break;
                    nodeRole.setReviewercanedit((this.getView().getPageCache().get(reviewercaneditKey).equals("1") ? Boolean.TRUE : Boolean.FALSE).booleanValue());
                    this.getModel().beginInit();
                    this.getModel().setValue("reviewercanedit", (Object)(nodeRole.isReviewercanedit() ? "1" : "2"));
                    this.getModel().endInit();
                    this.getView().getPageCache().remove(reviewercaneditKey);
                    break;
                }
                if (reviewercanedit) {
                    nodeRole.setOutFlow("10");
                    this.getModel().setValue("outflowrule", (Object)nodeRole.getOutFlow());
                    this.getView().setEnable(Boolean.FALSE, new String[]{"outflowrule"});
                } else {
                    nodeRole.setOutFlow("30");
                    this.getModel().setValue("outflowrule", (Object)nodeRole.getOutFlow());
                    this.getView().setEnable(Boolean.TRUE, new String[]{"outflowrule"});
                }
                if (this.getView().getFormShowParameter().getCustomParam("flowId") == null) break;
                this.getView().getParentView().getParentView().getPageCache().put("reviewercaneditchange:" + this.getView().getFormShowParameter().getCustomParam("flowId"), "true");
                break;
            }
            case "rolename": {
                if (null != this.getModel().getValue("rolename")) {
                    String inputRoleName = this.getModel().getDataEntity().getString("rolename");
                    if (inputRoleName.contains("\"")) {
                        inputRoleName = inputRoleName.replaceAll("\"", "");
                    }
                    nodeRole.setRoleName(inputRoleName);
                    if (null == this.getModel().getValue("roletype")) break;
                    String roleName = ((DynamicObject)this.getModel().getValue("roletype")).getString("name");
                    if (roleName.contains("\"")) {
                        roleName = roleName.replaceAll("\"", "");
                    }
                    if (!HRStringUtils.equals((String)inputRoleName, (String)roleName)) break;
                    long roleTypeId = ((DynamicObject)this.getModel().getValue("roletype")).getLong("id");
                    nodeRole.setRoleType(Long.valueOf(roleTypeId));
                    break;
                }
                nodeRole.setRoleName("");
                break;
            }
            case "roletype": {
                if (null != this.getModel().getValue("roletype")) {
                    long roleTypeId = ((DynamicObject)this.getModel().getValue("roletype")).getLong("id");
                    nodeRole.setRoleType(Long.valueOf(roleTypeId));
                    if (HRStringUtils.isEmpty((String)this.getModel().getDataEntity().getString("rolename"))) {
                        String roleName = ((DynamicObject)this.getModel().getValue("roletype")).getString("name");
                        this.getModel().setValue("rolename", (Object)roleName);
                        nodeRole.setRoleName(roleName);
                    }
                    if (RoleTypeConstants.APPOINTOR.equals(roleTypeId)) {
                        if (null != this.getModel().getValue("adminorg")) {
                            this.getModel().setValue("adminorg", null);
                        }
                        if (null != this.getModel().getValue("appointpos")) {
                            this.getModel().setValue("appointpos", null);
                        }
                    } else if (RoleTypeConstants.APPOINT_POSITION.equals(roleTypeId)) {
                        if (null != this.getModel().getValue("adminorg")) {
                            this.getModel().setValue("adminorg", null);
                        }
                        if (null != this.getModel().getValue("designee2")) {
                            this.getModel().setValue("designee2", null);
                        }
                    } else if (RoleTypeConstants.APPOINT_DEPHEADER.equals(roleTypeId)) {
                        if (null != this.getModel().getValue("appointpos")) {
                            this.getModel().setValue("appointpos", null);
                        }
                        if (null != this.getModel().getValue("designee2")) {
                            this.getModel().setValue("designee2", null);
                        }
                    } else {
                        if (null != this.getModel().getValue("adminorg")) {
                            this.getModel().setValue("adminorg", null);
                        }
                        if (null != this.getModel().getValue("appointpos")) {
                            this.getModel().setValue("appointpos", null);
                        }
                        if (null != this.getModel().getValue("designee2")) {
                            this.getModel().setValue("designee2", null);
                        }
                    }
                    nodeRole.setSecondF7(0L);
                    this.changeRoleWidthStyle(roleTypeId, flowNode.getNodeType());
                    break;
                }
                nodeRole.setRoleType(Long.valueOf(0L));
                nodeRole.setSecondF7(0L);
                this.changeRoleWidthStyle(0L, flowNode.getNodeType());
                break;
            }
            case "designee2": {
                DynamicObjectCollection userColl = (DynamicObjectCollection)this.getModel().getValue("designee2");
                if (userColl.size() > 20) {
                    String maxUserTips = ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u6dfb\u52a020\u4e2a\u6307\u5b9a\u4eba", (String)"NodeRoleConfigPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(maxUserTips);
                    DynamicObjectCollection oldValues = (DynamicObjectCollection)args.getChangeSet()[0].getOldValue();
                    this.getModel().setValue("designee2", (Object)this.getOldValArr(oldValues));
                    return;
                }
                this.setF7List(nodeRole, "designee2");
                break;
            }
            case "appointpos": {
                DynamicObjectCollection postColl = (DynamicObjectCollection)this.getModel().getValue("appointpos");
                if (postColl.size() > 10) {
                    String maxPostTips = ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u6dfb\u52a010\u4e2a\u5c97\u4f4d", (String)"NodeRoleConfigPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(maxPostTips);
                    DynamicObjectCollection oldValues = (DynamicObjectCollection)args.getChangeSet()[0].getOldValue();
                    this.getModel().setValue("appointpos", (Object)this.getOldValArr(oldValues));
                    return;
                }
                this.setF7List(nodeRole, "appointpos");
                break;
            }
            case "adminorg": {
                this.setSecondF7(nodeRole);
                break;
            }
        }
        if (!("isscorenext".equals(fieldKey) || "isevaluatenext".equals(fieldKey) || "isgradenext".equals(fieldKey) || "isgradelevel".equals(fieldKey))) {
            this.getModel().setValue("noderole", (Object)nodeRole.toString());
            this.sendRoleDataToParentPage(nodeRole.toString());
        }
    }

    private NodeRoleBo getNodeRoleBo() {
        return (NodeRoleBo)JSONObject.parseObject((String)this.getModel().getValue("noderole").toString(), NodeRoleBo.class);
    }

    private Object[] getOldValArr(DynamicObjectCollection entryentity) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        if (!entryentity.isEmpty()) {
            for (DynamicObject dynamicObject : entryentity) {
                ids.add(dynamicObject.getLong("fbasedataid_id"));
            }
        }
        return ids.toArray();
    }

    private void setF7List(NodeRoleBo nodeRole, String fieldVal) {
        DynamicObjectCollection entryentity = (DynamicObjectCollection)this.getModel().getValue(fieldVal);
        ArrayList<Long> ids = new ArrayList<Long>(10);
        if (!entryentity.isEmpty()) {
            for (DynamicObject dynamicObject : entryentity) {
                long depempId = dynamicObject.getLong("fbasedataid_id");
                ids.add(depempId);
            }
        }
        nodeRole.setMultiUserOrPost(ids);
        if (CollectionUtils.isEmpty(ids)) {
            nodeRole.setUserBoList(Collections.emptyList());
        }
    }

    private void setSecondF7(NodeRoleBo nodeRole) {
        if (null != this.getModel().getValue("adminorg")) {
            nodeRole.setSecondF7(((DynamicObject)this.getModel().getValue("adminorg")).getLong("id"));
        } else {
            nodeRole.setSecondF7(0L);
        }
    }

    private void changeRoleWidthStyle(long roleType, long nodeType) {
        HashMap roleNameMap = new HashMap(16);
        HashMap<String, LocaleString> roleTypeWidthMap = new HashMap<String, LocaleString>(16);
        HashMap<String, LocaleString> roleTypeMap = new HashMap<String, LocaleString>(16);
        HashMap<String, LocaleString> leasthandlerMap = new HashMap<String, LocaleString>(16);
        HashMap<String, LocaleString> map = new HashMap<String, LocaleString>(16);
        HashMap s = new HashMap(16);
        HashMap<String, String> m = new HashMap<String, String>(16);
        String width = "49%";
        String otherWidth = "20%";
        String guessWhat = "";
        String height = "66px";
        String roleTypeWidth = "214px";
        if (nodeType == 0L) {
            String oldVal = this.getView().getParentView().getPageCache().get("curnodeOldVal");
            if (HRStringUtils.isEmpty((String)oldVal)) {
                return;
            }
            nodeType = Long.parseLong(oldVal);
        }
        if (NodeTypeConstants.INDICATOR_FORMULATE.equals(nodeType) || NodeTypeConstants.INDICATOR_AUDIT.equals(nodeType) || NodeTypeConstants.INDICATOR_CONFIRM.equals(nodeType) || NodeTypeConstants.BATCH_ADJUSTSUMSCORE.equals(nodeType) || NodeTypeConstants.INTERVIEW_AUDIT.equals(nodeType) || NodeTypeConstants.INTERVIEW_WRITE.equals(nodeType)) {
            if (!NodeTypeConstants.INDICATOR_AUDIT.equals(nodeType)) {
                height = "80px";
            }
            if (RoleTypeConstants.APPOINTOR.equals(roleType) || RoleTypeConstants.APPOINT_POSITION.equals(roleType) || RoleTypeConstants.APPOINT_DEPHEADER.equals(roleType)) {
                width = "34%";
                otherWidth = "25%";
                if (RoleTypeConstants.APPOINTOR.equals(roleType)) {
                    guessWhat = "designee2";
                } else if (RoleTypeConstants.APPOINT_POSITION.equals(roleType)) {
                    guessWhat = "appointpos";
                } else if (RoleTypeConstants.APPOINT_DEPHEADER.equals(roleType)) {
                    guessWhat = "adminorg";
                }
            } else if (NodeTypeConstants.BATCH_ADJUSTSUMSCORE.equals(nodeType)) {
                width = "60%";
            }
            m.put("r", "0px");
        } else {
            width = "20%";
            otherWidth = "19%";
            roleTypeWidth = "183px";
            if (RoleTypeConstants.APPOINTOR.equals(roleType)) {
                guessWhat = "designee2";
            } else if (RoleTypeConstants.APPOINT_POSITION.equals(roleType)) {
                guessWhat = "appointpos";
            } else if (RoleTypeConstants.APPOINT_DEPHEADER.equals(roleType)) {
                guessWhat = "adminorg";
            } else {
                otherWidth = "20%";
                width = "35%";
            }
            m.put("r", "40px");
        }
        s.put("m", m);
        roleNameMap.put("s", s);
        roleNameMap.put("w", new LocaleString(width));
        leasthandlerMap.put("w", new LocaleString(width));
        this.getView().updateControlMetadata("rolename", roleNameMap);
        this.getView().updateControlMetadata("leasthandler", leasthandlerMap);
        roleTypeMap.put("h", new LocaleString(height));
        roleTypeWidthMap.put("w", new LocaleString(roleTypeWidth));
        this.getView().updateControlMetadata("roleflexpanel", roleTypeMap);
        this.getView().updateControlMetadata("roletype", roleTypeWidthMap);
        this.getView().updateControlMetadata("outflowrule", roleTypeWidthMap);
        if (HRStringUtils.isNotEmpty((String)guessWhat)) {
            map.put("w", new LocaleString(otherWidth));
            this.getView().updateControlMetadata(guessWhat, map);
            this.getView().updateControlMetadata("leasthandler", map);
        }
    }

    private void sendRoleDataToParentPage(String nodeRoleStr) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("flag", (Object)this.getView().getPageCache().get("flag"));
        jsonObject.put("pageId", (Object)this.getView().getPageId());
        jsonObject.put("noderole", (Object)nodeRoleStr);
        this.getView().getParentView().getModel().setValue("indexnoderole", (Object)jsonObject);
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void hideItemForAdjustSumcore(IFormView view) {
        FlowNodeItemBo flowNode = (FlowNodeItemBo)JSONObject.parseObject((String)view.getModel().getValue("flownode").toString(), FlowNodeItemBo.class);
        if (null != flowNode.getNodeType() && flowNode.getNodeType().equals(NodeTypeConstants.BATCH_ADJUSTSUMSCORE)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"roleweight", "percent", "turnoversort", "flexpanelap17", "openorclose", "flexpanelap11", "flexpanelap12", "flexpanelap16", "flexpanelap1"});
        }
    }

    private void dealRoleItemForIndicatorWf(long roleType) {
        FlowNodeItemBo flowNode = (FlowNodeItemBo)JSONObject.parseObject((String)this.getView().getParentView().getModel().getValue("flownode").toString(), FlowNodeItemBo.class);
        this.getView().setVisible(Boolean.TRUE, new String[]{"roletypelabel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"roleweight", "percent", "turnoversort", "flexpanelap17", "openorclose", "flexpanelap11", "flexpanelap12", "flexpanelap16", "flexpanelap1", "flexpanelap19", "flexauditcanedit", "deleteicon"});
        if (null == flowNode.getNodeType()) {
            return;
        }
        if (flowNode.getNodeType().equals(NodeTypeConstants.INDICATOR_FORMULATE)) {
            // empty if block
        }
        if (flowNode.getNodeType().equals(NodeTypeConstants.INDICATOR_AUDIT)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexauditcanedit", "flexpanelap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"roletypelabel"});
        }
        if (flowNode.getNodeType().equals(NodeTypeConstants.INDICATOR_CONFIRM)) {
            // empty if block
        }
        this.changeBcAndMarginLeftStyle(roleType, flowNode.getNodeType());
    }

    private void dealRoleItemForInterviewWf(long roleType) {
        FlowNodeItemBo flowNode = (FlowNodeItemBo)JSONObject.parseObject((String)this.getView().getParentView().getModel().getValue("flownode").toString(), FlowNodeItemBo.class);
        this.getView().setVisible(Boolean.TRUE, new String[]{"roletypelabel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"roleweight", "percent", "turnoversort", "flexpanelap17", "openorclose", "flexpanelap11", "flexpanelap12", "flexpanelap16", "flexpanelap1", "flexpanelap19", "flexauditcanedit", "deleteicon"});
        if (null == flowNode.getNodeType()) {
            return;
        }
        if (flowNode.getNodeType().equals(NodeTypeConstants.INTERVIEW_AUDIT)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexauditcanedit", "flexpanelap1", "outflowruleap", "outflowrule"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"roletypelabel"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"outflowrule"});
        }
        this.changeBcAndMarginLeftStyle(roleType, flowNode.getNodeType());
    }

    private void dealRoleItemForEvaluateWf(long roleType) {
        FlowNodeItemBo flowNode = (FlowNodeItemBo)JSONObject.parseObject((String)this.getView().getParentView().getModel().getValue("flownode").toString(), FlowNodeItemBo.class);
        this.getView().setVisible(Boolean.TRUE, new String[]{"roletypelabel"});
        if (null == flowNode.getNodeType()) {
            return;
        }
        if (flowNode.getNodeType().equals(NodeTypeConstants.EVALUATE_AUDIT)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"roleweight", "percent", "turnoversort", "flexpanelap17", "openorclose", "flexpanelap11", "flexpanelap12", "flexpanelap16", "flexpanelap19", "deleteicon"});
        } else if (flowNode.getNodeType().equals(NodeTypeConstants.BATCH_ADJUSTSUMSCORE)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"openorclose", "deleteicon"});
            this.dealEvaviewperm(true);
        } else {
            this.dealEvaviewperm(false);
            this.getModel().setValue("evaviewperm", (Object)"");
        }
        if (flowNode.getNodeType().equals(NodeTypeConstants.EVALUATE_SCORE) || flowNode.getNodeType().equals(NodeTypeConstants.BATCH_EVALUSUMSCORE)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"outflowruleap", "flexpanelap1", "flexpanelap2", "flexpanelap3", "flexpanelap4"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"roletypelabel"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"roletypelabel"});
        }
        if (flowNode.getNodeType().equals(NodeTypeConstants.BATCH_ADJUSTSUMSCORE)) {
            this.changeBcAndMarginLeftStyle(roleType, flowNode.getNodeType());
        } else {
            this.changeRoleWidthStyle(roleType, flowNode.getNodeType());
        }
    }

    private void changeBcAndMarginLeftStyle(long roleType, long nodeType) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("bc", "white");
        this.getView().updateControlMetadata("coreinfoap", fieldMap);
        HashMap map = new HashMap();
        HashMap s = new HashMap();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("l", "0px");
        s.put("m", m);
        map.put("s", s);
        this.getView().updateControlMetadata("infopanelap", map);
        this.changeRoleWidthStyle(roleType, nodeType);
    }

    private void dealEvaviewperm(boolean flag) {
        this.getView().setVisible(Boolean.valueOf(flag), new String[]{"flexpanelap19"});
        ComboEdit evaviewperm = (ComboEdit)this.getControl("evaviewperm");
        evaviewperm.setMustInput(flag);
    }
}

