/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.assessrule;

import java.text.DecimalFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.common.enums.assessrule.EvalProcessOperationEnum;
import kd.opmc.pbs.business.application.service.workflow.WorkFlowApplicationService;
import kd.opmc.pbs.business.tips.ShowConfigTipsUtils;

public class PublishConfirmPlugin
extends HRDataBaseEdit {
    private static final WorkFlowApplicationService WORK_FLOW_APPLICATION_SERVICE = WorkFlowApplicationService.getInstance();
    String EPA_SAVEFLOW_CONFIRM = "epa_saveflowconfirm";
    private static final String CANCEL_CHANGE = "cancelchange";
    private static final String OP_BTNQUIT = "btnquit";
    private static final String FROM_CARDPAGE = "cardPage";
    private static final String FROM_WORKFLOW = "workFlow";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        long flowId = (Long)showParameter.getCustomParam("flowid");
        DynamicObject workflowVersion = WORK_FLOW_APPLICATION_SERVICE.getWorkflowVersion(flowId);
        String flowVersion = "V0001";
        if (HRObjectUtils.isEmpty((Object)workflowVersion)) {
            this.getModel().setValue("flowversion", (Object)flowVersion);
        } else {
            String version = workflowVersion.getString("hisversion");
            if (HRStringUtils.isNotEmpty((String)version)) {
                DecimalFormat decimalFormat = new DecimalFormat("0000");
                flowVersion = "V" + decimalFormat.format(Integer.parseInt(version.split("V")[1]) + 1);
            }
            this.getModel().setValue("flowversion", (Object)flowVersion);
        }
        this.getModel().setValue("flowname", showParameter.getCustomParam("flowname"));
        this.getModel().setValue("assessruleid", showParameter.getCustomParam("assessruleid"));
        this.getModel().setValue("flowid", showParameter.getCustomParam("flowid"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        HashMap<Object, Object> returnDataMap = new HashMap<Object, Object>(3);
        if ("confirm".equals(operateKey)) {
            returnDataMap.put("flowid", this.getModel().getValue("flowid"));
            returnDataMap.put("assessruleid", this.getModel().getValue("assessruleid"));
            returnDataMap.put("flowdescription", this.getModel().getValue("flowdescription"));
            this.doAfterPublicFlow(returnDataMap);
        }
    }

    private void doAfterPublicFlow(HashMap<Object, Object> returnDataMap) {
        String operateType = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("operateType");
        if (EvalProcessOperationEnum.COPY == EvalProcessOperationEnum.getOperation((String)operateType)) {
            this.confirmSaveFlow(returnDataMap, FROM_WORKFLOW);
        } else if (EvalProcessOperationEnum.EDIT == EvalProcessOperationEnum.getOperation((String)operateType)) {
            if (HRStringUtils.equals((String)"true", (String)this.getView().getParentView().getPageCache().get("nodetypechange:" + this.getModel().getValue("flowid"))) || HRStringUtils.equals((String)"true", (String)this.getView().getParentView().getPageCache().get("reviewercaneditchange:" + this.getModel().getValue("flowid"))) || HRStringUtils.equals((String)"true", (String)this.getView().getParentView().getPageCache().get("addnodechange:" + this.getModel().getValue("flowid"))) || HRStringUtils.equals((String)"true", (String)this.getView().getParentView().getPageCache().get("delnodechange:" + this.getModel().getValue("flowid"))) || HRStringUtils.equals((String)"true", (String)this.getView().getParentView().getPageCache().get("crossscorechange:" + this.getModel().getValue("flowid")))) {
                this.confirmSaveFlow(returnDataMap, FROM_WORKFLOW);
            } else {
                this.getView().returnDataToParent(returnDataMap);
                this.getView().close();
            }
        } else {
            DynamicObject workflow = WORK_FLOW_APPLICATION_SERVICE.getWorkflow(((Long)this.getView().getFormShowParameter().getCustomParam("flowid")).longValue());
            if (workflow.getLong("sourceflowid") != 0L) {
                this.confirmSaveFlow(returnDataMap, FROM_CARDPAGE);
            } else {
                this.getView().returnDataToParent(returnDataMap);
                this.getView().close();
            }
        }
    }

    private void confirmSaveFlow(HashMap<Object, Object> returnDataMap, String fromWhere) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(this.EPA_SAVEFLOW_CONFIRM);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.EPA_SAVEFLOW_CONFIRM));
        Map tipsMap = ShowConfigTipsUtils.getTipsByFormId((String)this.EPA_SAVEFLOW_CONFIRM);
        showParameter.setCustomParam("tipRef", (Object)tipsMap);
        showParameter.setCustomParam("fromWhere", (Object)fromWhere);
        showParameter.setCustomParam("returnDataMap", returnDataMap);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String operateType = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("operateType");
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)this.EPA_SAVEFLOW_CONFIRM, (String)actionId)) {
            HashMap<String, Object> returnDataMap = new HashMap<String, Object>(3);
            returnDataMap.put("flowid", this.getModel().getValue("flowid"));
            returnDataMap.put("assessruleid", this.getModel().getValue("assessruleid"));
            returnDataMap.put("flowdescription", this.getModel().getValue("flowdescription"));
            this.getView().returnDataToParent(returnDataMap);
            if (!(HRStringUtils.equals((String)OP_BTNQUIT, (String)this.getView().getPageCache().get(this.getView().getPageId())) || EvalProcessOperationEnum.COPY != EvalProcessOperationEnum.getOperation((String)operateType) && EvalProcessOperationEnum.EDIT != EvalProcessOperationEnum.getOperation((String)operateType))) {
                this.getView().getParentView().invokeOperation(CANCEL_CHANGE);
            }
            this.getView().close();
        }
    }
}

