/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.assessrule;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.pbs.business.model.NodeRoleBo;
import kd.opmc.pbs.business.tips.ShowConfigTipsUtils;
import kd.opmc.pbs.common.constants.RoleTypeConstants;

public class RoleTypePlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String ROLE_TYPE = "roletype";
    private static final String ORG_TYPE = "orgtype";
    private static final String NAME = "name";
    private static final String SUPERIOR_TYPE = "superiortype";
    private static final String ISSAME_ORG = "issameorg";
    private static final String ADMIN_ORG = "adminorg";
    private static final String PROJECT_TEAM = "projectteam";
    private static final String POSITION = "position";
    private static final String CONFIRM = "confirm";
    private static final String NODE_ROLE = "noderole";
    private static final String EPA_ROLETYPE = "epa_roletype";
    private static final String ROLE_NAME = "rolename";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit roletypeEdit = (BasedataEdit)this.getView().getControl(ROLE_TYPE);
        roletypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BasedataEdit adminOrg = (BasedataEdit)this.getView().getControl(ADMIN_ORG);
        adminOrg.setMustInput(true);
        this.getModel().setDataChanged(false);
        this.initTips();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object nodeRole = parameter.getCustomParam(NODE_ROLE);
        if (!HRObjectUtils.isEmpty((Object)nodeRole)) {
            NodeRoleBo nodeRoleBo = (NodeRoleBo)JSONObject.parseObject((String)nodeRole.toString(), NodeRoleBo.class);
            this.initRoleType(nodeRoleBo);
            this.getModel().setValue(NODE_ROLE, (Object)nodeRoleBo.toString());
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String fieldKey = args.getProperty().getName();
        if (fieldKey.equals(ROLE_TYPE) && null != this.getModel().getValue(ROLE_TYPE)) {
            String roleName = ((DynamicObject)this.getModel().getValue(ROLE_TYPE)).getString(NAME);
            this.getModel().setValue(ROLE_NAME, (Object)roleName);
        }
    }

    private void initRoleType(NodeRoleBo nodeRoleBo) {
        Long roleType = nodeRoleBo.getRoleType();
        this.getModel().setValue(ROLE_TYPE, (Object)roleType);
        this.getModel().setValue(ROLE_NAME, (Object)(nodeRoleBo.getRoleName().equals("null") ? "" : nodeRoleBo.getRoleName()));
        if (roleType.equals(RoleTypeConstants.APPOINTOR)) {
            this.getModel().setValue(NAME, (Object)nodeRoleBo.getSecondF7());
        }
        if (roleType.equals(RoleTypeConstants.APPOINT_POSITION)) {
            this.getModel().setValue(POSITION, (Object)nodeRoleBo.getSecondF7());
        }
        if (roleType.equals(RoleTypeConstants.APPOINT_DEPHEADER)) {
            this.getModel().setValue(ADMIN_ORG, (Object)nodeRoleBo.getSecondF7());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (CONFIRM.equals(operateKey)) {
            this.confirmRoleData();
        }
    }

    private void confirmRoleData() {
        NodeRoleBo nodeRole = (NodeRoleBo)JSONObject.parseObject((String)this.getModel().getValue(NODE_ROLE).toString(), NodeRoleBo.class);
        Long roleType = ((DynamicObject)this.getModel().getValue(ROLE_TYPE)).getLong("id");
        String roleName = this.getModel().getDataEntity().getString(ROLE_NAME);
        nodeRole.setRoleType(roleType);
        nodeRole.setRoleName(roleName);
        if (RoleTypeConstants.APPOINTOR.equals(roleType) && null != (DynamicObject)this.getModel().getValue(NAME)) {
            nodeRole.setSecondF7(((DynamicObject)this.getModel().getValue(NAME)).getLong("id"));
        }
        if (RoleTypeConstants.APPOINT_POSITION.equals(roleType) && null != (DynamicObject)this.getModel().getValue(POSITION)) {
            nodeRole.setSecondF7(((DynamicObject)this.getModel().getValue(POSITION)).getLong("id"));
        }
        if (RoleTypeConstants.APPOINT_DEPHEADER.equals(roleType) && null != (DynamicObject)this.getModel().getValue(ADMIN_ORG)) {
            nodeRole.setSecondF7(((DynamicObject)this.getModel().getValue(ADMIN_ORG)).getLong("id"));
        }
        this.getView().returnDataToParent((Object)nodeRole);
        this.getView().close();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propertyName;
        switch (propertyName = e.getProperty().getName()) {
            case "roletype": {
                e.getCustomQFilters().add(this.getQFilterForRoleType());
                break;
            }
        }
    }

    private QFilter getQFilterForRoleType() {
        String workflowType = (String)this.getView().getFormShowParameter().getCustomParam("flowType");
        QFilter qFilter = null;
        if (workflowType.equals("2")) {
            qFilter = new QFilter("processtype", "like", (Object)"%B%");
        } else if (workflowType.equals("1")) {
            qFilter = new QFilter("processtype", "like", (Object)"%A%");
        }
        return qFilter;
    }

    protected void initTips() {
        Map tipsMap = ShowConfigTipsUtils.getTipsByFormId((String)EPA_ROLETYPE);
        tipsMap.forEach((key, value) -> {
            if (0 == value.size()) {
                return;
            }
            HashMap<String, Tips> textProps = new HashMap<String, Tips>(16);
            Tips textTips = new Tips();
            textTips.setType("text");
            textTips.setContent(new LocaleString(value.toArray(new String[0])[0]));
            textProps.put("tips", textTips);
            this.getView().updateControlMetadata(key, textProps);
        });
    }
}

