/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.assessrule.areaconfig;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.common.constants.AreaConfigConstants;
import kd.opmc.epa.common.utils.EntryOpUtil;

public abstract class AbstractMiddleConfigEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
AreaConfigConstants {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit areaField = (BasedataEdit)this.getControl("areaclickfield");
        areaField.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (!this.getLockField().contains(((DynamicObject)entryEntity.get(i)).getString("areafield.number"))) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"ismustinput"});
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        super.propertyChanged(propertyChangedArgs);
        String fieldKey = propertyChangedArgs.getProperty().getName();
        Object newValue = propertyChangedArgs.getChangeSet()[0].getNewValue();
        if (newValue == null) {
            return;
        }
        if ("areaclickfield".equals(fieldKey)) {
            for (DynamicObject selectRow : (DynamicObjectCollection)newValue) {
                DynamicObject areaField = selectRow.getDynamicObject("fbasedataid");
                this.addFields(areaField);
            }
        }
    }

    protected void addFields(DynamicObject areaField) {
        int index = this.getModel().createNewEntryRow("entryentity");
        this.getModel().setValue("areafield", (Object)areaField, index);
        this.getModel().setValue("fieldcustname", areaField.get("name"), index);
        this.getModel().setValue("proptype", (Object)areaField.getString("proptype"), index);
        this.getModel().setValue("fieldlength", (Object)areaField.getInt("max"), index);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = args.getOperateKey()) {
            case "addfield": {
                DynamicObjectCollection selectFields = (DynamicObjectCollection)this.getModel().getValue("areaclickfield");
                selectFields.clear();
                BasedataEdit areaField = (BasedataEdit)this.getControl("areaclickfield");
                areaField.click();
                break;
            }
            case "movetop": {
                EntryOpUtil.moveTop((IFormView)this.getView(), (String)"entryentity");
                break;
            }
            case "movebottom": {
                EntryOpUtil.moveBottom((IFormView)this.getView(), (String)"entryentity");
                break;
            }
            case "save": {
                this.getView().returnDataToParent(this.getModel().getDataEntity().getPkValue());
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String f7Name = beforeF7SelectEvent.getProperty().getName();
        if ("areaclickfield".equals(f7Name)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            ArrayList<String> numberList = new ArrayList<String>(entryEntity.size());
            for (DynamicObject row : entryEntity) {
                numberList.add(row.getString("areafield.number"));
            }
            QFilter qFilter = new QFilter("number", "not in", numberList);
            beforeF7SelectEvent.addCustomQFilter(qFilter);
        }
    }

    protected abstract Set<String> getLockField();
}

