/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.assessrule.areaconfig;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.opmc.epa.business.application.service.AssessRuleApplicationService;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.assessrule.AdjustTypeEnum;
import kd.opmc.epa.common.enums.assessrule.EvalWayEnum;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.epa.formplugin.web.assessrule.areaconfig.AbstractMiddleConfigEdit;
import kd.opmc.epa.formplugin.web.assessrule.areaedit.DrawAreaUtils;
import kd.opmc.epa.formplugin.web.utils.HashSetToStringUtils;

public class NormalConfigEdit
extends AbstractMiddleConfigEdit
implements AssessRuleConstants {
    private static final Set<String> CANNOT_DEL_FIELD_SET = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"indctrname", "weight", "indctrscore", "evalscore", "evalmode"}));
    private static final Set<String> LOCK_FIELD_SET = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"indctrname", "weight", "indctrscore", "evalscore", "evaldesc"}));
    private static final AssessRuleApplicationService ASSESS_RULE_APP_SERVICE = AssessRuleApplicationService.getInstance();

    @Override
    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.showFieldByAllowEval();
        this.visibleByScoreCalWay();
        boolean isAllowEval = this.getModel().getDataEntity().getBoolean("isalloweval");
        if (!isAllowEval) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"reversepoints"});
        }
        this.setControlScale();
        this.setScoreSystemMustInputByScoreCalcWay();
        this.getView().getPageCache().put("oriname", this.getModel().getDataEntity().getString("areacustname"));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject areaFieldRegDynObj = (DynamicObject)entryEntity.get(i);
            this.getModel().setValue("proptype", (Object)areaFieldRegDynObj.getString("areafield.proptype"), i);
            this.getModel().setValue("fieldlength", (Object)areaFieldRegDynObj.getInt("areafield.max"), i);
        }
        this.getModel().setDataChanged(false);
    }

    private void setScoreSystemMustInputByScoreCalcWay() {
        String consistentArea;
        String entityId;
        Object scoreCalcWay = this.getView().getFormShowParameter().getCustomParam("scorecalcway");
        if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
            Object consistentWithArea = this.getView().getFormShowParameter().getCustomParam("consistentwitharea");
            if ("0".equals(consistentWithArea)) {
                BasedataEdit basedataEdit = (BasedataEdit)this.getControl("scoresystem");
                basedataEdit.setMustInput(true);
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"scoresystem"});
            }
        }
        if (StringUtils.endsWith((CharSequence)(entityId = this.getView().getParentView().getParentView().getEntityId()), (CharSequence)"epa_assessform") && StringUtils.endsWith((CharSequence)"1", (CharSequence)(consistentArea = this.getView().getParentView().getParentView().getModel().getDataEntity().getString("consistentwitharea")))) {
            this.getView().getModel().setValue("scoresystem", (Object)this.getView().getParentView().getParentView().getModel().getDataEntity().getDynamicObject("scoresystem"));
        }
    }

    public void beforeClosed(BeforeClosedEvent closedEvent) {
        super.beforeClosed(closedEvent);
        String consistentArea = this.getView().getParentView().getParentView().getModel().getDataEntity().getString("consistentwitharea");
        if (StringUtils.endsWith((CharSequence)"1", (CharSequence)consistentArea)) {
            DynamicObject dyo = this.getModel().getDataEntity(true);
            DynamicProperty scoreSystemProp = dyo.getDynamicObjectType().getProperty("scoresystem_id");
            dyo.getDataEntityState().setBizChanged(scoreSystemProp.getOrdinal(), false);
        }
    }

    private void setControlScale() {
        this.getView().updateControlMetadata("areascore", DrawAreaUtils.getPcScItemMap(this.getView().getFormShowParameter()));
        this.getView().updateControlMetadata("upperscore", DrawAreaUtils.getPcScItemMap(this.getView().getFormShowParameter()));
        this.getView().updateControlMetadata("lowerscore", DrawAreaUtils.getPcScItemMap(this.getView().getFormShowParameter()));
        this.getView().updateControlMetadata("weight", DrawAreaUtils.getPcScopeItemMap(this.getView().getFormShowParameter()));
    }

    private void visibleByScoreCalWay() {
        Object customParam = this.getView().getFormShowParameter().getCustomParam("scorecalcway");
        if (ScoreCalcWayEnum.WEIGHT.getValue().equals(customParam)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"areascore"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"scoresystem", "weight", "reversepoints"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"scoresystem", "weight"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"areascore", "reversepoints"});
        }
    }

    private void showFieldByAllowEval() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        ScoreCalcWayEnum scoreCalcWayEnum = ScoreCalcWayEnum.getScoreCalcWay((String)((String)formShowParameter.getCustomParam("scorecalcway")));
        EvalWayEnum evalWayEnum = EvalWayEnum.getEvalWay((String)((String)formShowParameter.getCustomParam("evalway")));
        Boolean isAllowEval = (Boolean)this.getModel().getValue("isalloweval");
        Boolean isShowAreaScore = ScoreCalcWayEnum.SUM == scoreCalcWayEnum && EvalWayEnum.SCORE == evalWayEnum && isAllowEval != false;
        this.getView().setVisible(isShowAreaScore, new String[]{"areascore"});
        Boolean isShowForcedControl = EvalWayEnum.SCORE == evalWayEnum && isAllowEval != false;
        this.getView().setVisible(isShowForcedControl, new String[]{"isforcedcontrol", "ispartin"});
        Boolean isForcedControl = (Boolean)this.getModel().getValue("isforcedcontrol");
        this.setControlFieldMustInput(isShowForcedControl != false && isForcedControl != false);
        if (!this.getModel().getDataEntity().getBoolean("isalloweval")) {
            if (ScoreCalcWayEnum.WEIGHT == scoreCalcWayEnum) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"isforcedcontrol", "weight"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"isforcedcontrol", "areascore"});
            }
        } else if (ScoreCalcWayEnum.WEIGHT == scoreCalcWayEnum) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"ispartin", "scoresystem", "weight", "reversepoints"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"ispartin", "areascore", "reversepoints"});
        }
        String adjustType = this.getModel().getDataEntity().getString("adjusttype");
        if (AdjustTypeEnum.NORMAL.getValue().equals(adjustType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"upperscore", "lowerscore"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"upperscore", "lowerscore"});
        }
    }

    private void setDefaultStateByAllowEval(boolean isAllowEval) {
        if (isAllowEval) {
            this.getModel().setValue("reversepoints", (Object)Boolean.FALSE);
            this.getView().setVisible(Boolean.TRUE, new String[]{"upperscore", "lowerscore", "adjusttype"});
            this.getModel().setValue("adjusttype", (Object)AdjustTypeEnum.NORMAL.getValue());
            this.getView().getModel().setValue("upperscore", (Object)BigDecimal.ZERO);
            this.getView().getModel().setValue("lowerscore", (Object)BigDecimal.ZERO);
        } else {
            this.getModel().setValue("reversepoints", (Object)Boolean.FALSE);
            this.getView().setVisible(Boolean.FALSE, new String[]{"ispartin", "weight", "reversepoints"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"upperscore", "lowerscore", "adjusttype"});
            this.getModel().setValue("adjusttype", null);
            this.getView().getModel().setValue("upperscore", (Object)BigDecimal.ZERO);
            this.getView().getModel().setValue("lowerscore", (Object)BigDecimal.ZERO);
        }
    }

    private void setControlFieldMustInput(boolean isMustInput) {
        FieldEdit areaScore = (FieldEdit)this.getControl("areascore");
        areaScore.setMustInput(isMustInput);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        super.propertyChanged(propertyChangedArgs);
        String fieldKey = propertyChangedArgs.getProperty().getName();
        Object newValue = propertyChangedArgs.getChangeSet()[0].getNewValue();
        if (newValue == null) {
            return;
        }
        switch (fieldKey) {
            case "isforcedcontrol": {
                this.setControlFieldMustInput((Boolean)newValue);
                break;
            }
            case "isalloweval": {
                this.setDefaultStateByAllowEval((Boolean)newValue);
                this.showFieldByAllowEval();
                this.changeEvalRelatedField();
                if (((Boolean)newValue).booleanValue()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5207\u6362\u5f00\u5173\u5c06\u5f71\u54cd\u8be5\u533a\u57df\u662f\u5426\u53c2\u4e0e\u8bc4\u5206/\u8bc4\u7ea7\u53ca\u76f8\u5173\u914d\u7f6e\u53c2\u6570\u3002", (String)"NormalConfigEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                break;
            }
            case "adjusttype": {
                this.setAdjustTypeWithScore(newValue);
                break;
            }
            case "upperscore": {
                this.checkUpperScoreValue();
                break;
            }
            case "lowerscore": {
                this.checkLowerScoreValue();
                break;
            }
            case "reversepoints": {
                this.updateViewByReversePoints(newValue);
                break;
            }
        }
    }

    private void updateViewByReversePoints(Object value) {
        if (((Boolean)value).booleanValue()) {
            this.getView().getModel().setValue("adjusttype", (Object)AdjustTypeEnum.NORMAL.getValue());
        } else {
            this.getView().getModel().setValue("adjusttype", null);
        }
    }

    @Override
    protected Set<String> getLockField() {
        return LOCK_FIELD_SET;
    }

    private void changeEvalRelatedField() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        ScoreCalcWayEnum scoreCalcWayEnum = ScoreCalcWayEnum.getScoreCalcWay((String)((String)formShowParameter.getCustomParam("scorecalcway")));
        EvalWayEnum evalWayEnum = EvalWayEnum.getEvalWay((String)((String)formShowParameter.getCustomParam("evalway")));
        ArrayList<String> numberList = new ArrayList<String>(3);
        if (ScoreCalcWayEnum.WEIGHT == scoreCalcWayEnum || EvalWayEnum.LEVEL == evalWayEnum) {
            numberList.add("weight");
        }
        if (EvalWayEnum.SCORE == evalWayEnum) {
            numberList.add("evalscore");
            if (ScoreCalcWayEnum.SUM == scoreCalcWayEnum) {
                numberList.add("indctrscore");
            }
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List areaFieldNumberList = entryEntity.stream().map(dynObj -> dynObj.getString("areafield.number")).collect(Collectors.toList());
        numberList.addAll(areaFieldNumberList);
        DynamicObject[] fields = ASSESS_RULE_APP_SERVICE.queryRelatedFields(NORM_INDCTR_AREA_PK, numberList);
        this.getModel().deleteEntryData("entryentity");
        for (DynamicObject fieldDynObj : fields) {
            if (!this.getModel().getDataEntity().getBoolean("isalloweval") && "evalscore".equals(fieldDynObj.getString("number"))) continue;
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("areafield", (Object)fieldDynObj, index);
            this.getModel().setValue("fieldcustname", fieldDynObj.get("name"), index);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        if ("deleteentry".equals(source.getOperateKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] rowsIndex = entryGrid.getSelectRows();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (int index : rowsIndex) {
                if (!CANNOT_DEL_FIELD_SET.contains(((DynamicObject)entryEntity.get(index)).getString("areafield.number"))) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u3001\u201c\u6743\u91cd\uff08%\uff09\u201d\u3001\u201c\u5206\u503c\u201d\u3001\u201c\u8bc4\u4f30\u5f97\u5206\u201d\u3001\u201c\u8bc4\u5206\u65b9\u5f0f\u201d\u4e3a\u5fc5\u9009\u5b57\u6bb5\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"NormalConfigEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if ("save".equals(source.getOperateKey())) {
            String nameString;
            Set<String> nameSet;
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String name = dataEntity.getString("areacustname");
            if (!StringUtils.equals((CharSequence)name, (CharSequence)this.getView().getPageCache().get("oriname")) && (nameSet = HashSetToStringUtils.getHashSet(nameString = this.getView().getParentView().getParentView().getPageCache().get("nameSet"))).contains(name)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc4\u4f30\u8868\u5355\u533a\u57df\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\u3002", (String)"NormalConfigEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(Boolean.TRUE.booleanValue());
            }
            String adjustType = dataEntity.getString("adjusttype");
            BigDecimal upperScore = dataEntity.getBigDecimal("upperscore");
            BigDecimal lowerScore = dataEntity.getBigDecimal("lowerscore");
            if (AdjustTypeEnum.NORMAL.getValue().equals(adjustType) && dataEntity.getBoolean("reversepoints") && upperScore.compareTo(lowerScore) <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u8c03\u6574\u5206\u4e0a\u9650\u201d\u5e94\u5927\u4e8e\u201c\u8c03\u6574\u5206\u4e0b\u9650\u201d\u3002", (String)"NormalConfigEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(Boolean.TRUE.booleanValue());
            }
            OperateOption option = source.getOption();
            Object maxScore = this.getView().getFormShowParameter().getCustomParam("maxScore");
            Object scoreCalcWay = this.getView().getFormShowParameter().getCustomParam("scorecalcway");
            Object limitMaRatio = this.getView().getFormShowParameter().getCustomParam("limitmaxratio");
            Object accuracy = this.getView().getFormShowParameter().getCustomParam("numaccuracy");
            Object evaSumLimit = this.getView().getFormShowParameter().getCustomParam("evasumlimit");
            option.setVariableValue("maxScore", String.valueOf(maxScore));
            option.setVariableValue("scorecalcway", String.valueOf(scoreCalcWay));
            option.setVariableValue("limitmaxratio", String.valueOf(limitMaRatio));
            option.setVariableValue("numaccuracy", String.valueOf(accuracy));
            option.setVariableValue("evasumlimit", String.valueOf(evaSumLimit));
        }
    }

    private void setAdjustTypeWithScore(Object newValue) {
        if (AdjustTypeEnum.NORMAL.getValue().equals(newValue)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"upperscore", "lowerscore"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"upperscore", "lowerscore"});
            this.getView().getModel().setValue("upperscore", (Object)BigDecimal.ZERO);
            this.getView().getModel().setValue("lowerscore", (Object)BigDecimal.ZERO);
        } else if (AdjustTypeEnum.CUSTOM.getValue().equals(newValue)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"upperscore", "lowerscore"});
        }
    }

    private void checkUpperScoreValue() {
        BigDecimal areaScore = (BigDecimal)this.getView().getFormShowParameter().getCustomParam("maxScore");
        BigDecimal upperScore = this.getView().getModel().getDataEntity().getBigDecimal("upperscore");
        if (upperScore.compareTo(areaScore) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u8c03\u6574\u5206\u4e0a\u9650\u201d\u5e94\u5c0f\u4e8e\u8bc4\u5206\u5206\u5236\u201c\u57fa\u51c6\u6700\u9ad8\u5206\u201d\u3002", (String)"NormalConfigEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.getView().getModel().setValue("upperscore", (Object)BigDecimal.ZERO);
        }
    }

    private void checkLowerScoreValue() {
        BigDecimal upperScore;
        BigDecimal areaScore = (BigDecimal)this.getView().getFormShowParameter().getCustomParam("maxScore");
        BigDecimal lowerScore = this.getView().getModel().getDataEntity().getBigDecimal("lowerscore");
        if (lowerScore.compareTo(upperScore = this.getView().getModel().getDataEntity().getBigDecimal("upperscore")) == 0 && lowerScore.compareTo(new BigDecimal("0")) == 0) {
            return;
        }
        if (lowerScore.compareTo(upperScore) >= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u8c03\u6574\u5206\u4e0b\u9650\u201d\u5e94\u5c0f\u4e8e\u201c\u8c03\u6574\u5206\u4e0a\u9650\u201d\u3002", (String)"NormalConfigEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.getView().getModel().setValue("lowerscore", (Object)BigDecimal.ZERO);
            return;
        }
        if (lowerScore.compareTo(areaScore.negate()) < 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u8c03\u6574\u5206\u4e0b\u9650\u201d\u5e94\u9ad8\u4e8e\u8bc4\u5206\u5206\u5236\u201c\u57fa\u51c6\u6700\u9ad8\u5206\u201d\u7684\u76f8\u53cd\u6570\u3002\uff08\u5982\uff1a\u57fa\u51c6\u6700\u9ad8\u5206\u4e3a100\u5206\uff0c\u5219\u8c03\u6574\u5206\u4e0b\u9650\uff0c\u5e94\u9ad8\u4e8e-100\u5206\u3002\uff09", (String)"NormalConfigEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.getView().getModel().setValue("lowerscore", (Object)BigDecimal.ZERO);
        }
    }
}

