/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.assessrule.areaconfig;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.opmc.epa.formplugin.web.assessrule.areaconfig.AbstractMiddleConfigEdit;
import kd.opmc.epa.formplugin.web.assessrule.areaedit.DrawAreaUtils;
import kd.opmc.epa.formplugin.web.utils.HashSetToStringUtils;

public class PlusMinusConfigEdit
extends AbstractMiddleConfigEdit {
    private static final Set<String> CANNOT_DEL_FIELD_SET = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"indctrname", "evalscore", "subscoremin", "addscoremax"}));
    private static final Set<String> LOCK_FIELD_SET = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"indctrname", "evalscore", "evaldesc"}));

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPrecisionScale();
        this.getView().getPageCache().put("oriname", this.getModel().getDataEntity().getString("areacustname"));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject areaFieldRegDynObj = (DynamicObject)entryEntity.get(i);
            this.getModel().setValue("proptype", (Object)areaFieldRegDynObj.getString("areafield.proptype"), i);
            this.getModel().setValue("fieldlength", (Object)areaFieldRegDynObj.getInt("areafield.max"), i);
        }
        this.getModel().setDataChanged(false);
    }

    private void setPrecisionScale() {
        Map<String, Object> itemMap = DrawAreaUtils.getPcScItemMap(this.getView().getFormShowParameter());
        this.getView().updateControlMetadata("pluslimit", itemMap);
        this.getView().updateControlMetadata("minuslimit", itemMap);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String nameString;
        Set<String> nameSet;
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String name = this.getModel().getDataEntity().getString("areacustname");
        if ("deleteentry".equals(source.getOperateKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] rowsIndex = entryGrid.getSelectRows();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (int index : rowsIndex) {
                if (!CANNOT_DEL_FIELD_SET.contains(((DynamicObject)entryEntity.get(index)).getString("areafield.number"))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u3001\u201c\u8bc4\u4f30\u5f97\u5206\u201d\u3001\u201c\u52a0\u5206\u4e0a\u9650\u201d\u3001\u201c\u6263\u5206\u4e0b\u9650\u201d\u4e3a\u5fc5\u9009\u5b57\u6bb5\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"PlusMinusConfigEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)source.getOperateKey(), (CharSequence)"donothing") && !StringUtils.equals((CharSequence)name, (CharSequence)this.getView().getPageCache().get("oriname")) && (nameSet = HashSetToStringUtils.getHashSet(nameString = this.getView().getParentView().getParentView().getPageCache().get("nameSet"))).contains(name)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc4\u4f30\u8868\u5355\u533a\u57df\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\u3002", (String)"PlusMinusConfigEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(Boolean.TRUE.booleanValue());
        }
        if (StringUtils.equals((CharSequence)source.getOperateKey(), (CharSequence)"donothing")) {
            boolean plusAndMinusIsZero = this.valPlusAndMinusIsZero();
            if (plusAndMinusIsZero) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u52a0\u51cf\u5206\u9879\u533a\uff1a\u53ef\u8bc4\u5206\u503c\u4e3a0\uff08\u8bc4\u5206\u4e0a\u4e0b\u9650\uff1a0~0\uff09\uff0c \u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58?", (String)"PlusMinusConfigEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("PlusMinusConfirmAction", (IFormPlugin)this));
            } else {
                this.getView().invokeOperation("save");
            }
        }
    }

    private boolean valPlusAndMinusIsZero() {
        BigDecimal pluslimit = (BigDecimal)this.getModel().getValue("pluslimit");
        BigDecimal minuslimit = (BigDecimal)this.getModel().getValue("minuslimit");
        if (!(null != pluslimit && pluslimit.compareTo(BigDecimal.ZERO) != 0 || null != minuslimit && minuslimit.compareTo(BigDecimal.ZERO) != 0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    protected Set<String> getLockField() {
        return LOCK_FIELD_SET;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if ("PlusMinusConfirmAction".equals(event.getCallBackId()) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            this.getView().invokeOperation("save");
        }
    }
}

