/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.assessrule.areaedit;

import java.util.EventObject;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.field.AttachmentEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.opmc.epa.business.application.service.AssessRuleApplicationService;
import kd.opmc.epa.formplugin.web.assessrule.areaedit.DrawAreaUtils;
import kd.opmc.epa.formplugin.web.assessrule.areaedit.MiddleAreaParentEdit;

public class CustomAreaEdit
extends MiddleAreaParentEdit {
    private static final AssessRuleApplicationService ASSESS_RULE_APP_SERVICE = AssessRuleApplicationService.getInstance();
    private static final String[] CUSTOM_AREA_ALL_FIELDS = new String[]{"customfield1", "customfield2", "customfield3", "customfield8", "customfield5", "customfield6", "customfield7", "customfield4", "customfield9", "customfield10"};
    private static final String[] CUSTOM_AREA_TEXT_FIELDS = new String[]{"customfield1", "customfield2", "customfield3", "customfield8", "customfield5", "customfield6", "customfield7"};
    private static final String[] CUSTOM_AREA_FILE_FIELDS = new String[]{"customfield4", "customfield9", "customfield10"};

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = ASSESS_RULE_APP_SERVICE.queryCustomConfigByPk(confId);
        DrawAreaUtils.setCustomAreaFieldNameByConf(args, conf);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long confId = this.getConfId(this.getView().getFormShowParameter());
        DynamicObject conf = ASSESS_RULE_APP_SERVICE.queryCustomConfigByPk(confId);
        DynamicObject model = this.getModel().getDataEntity();
        model.set("description", conf.get("description"));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (OperationStatus.VIEW == formShowParameter.getStatus()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"areaopap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"areaviewap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"areaviewap"});
        }
        this.getView().setVisible(Boolean.FALSE, CUSTOM_AREA_ALL_FIELDS);
        Long confId = this.getConfId(this.getView().getFormShowParameter());
        DynamicObject conf = ASSESS_RULE_APP_SERVICE.queryCustomConfigByPk(confId);
        DynamicObjectCollection collection = conf.getDynamicObjectCollection("entryentity");
        int textCount = 0;
        int fileCount = 0;
        for (int i = 0; i < collection.size(); ++i) {
            OrmLocaleValue ormLocaleValue;
            String number;
            DynamicObject tmpDy = (DynamicObject)collection.get(i);
            if ("1".equals(tmpDy.get("fieldtype"))) {
                number = CUSTOM_AREA_TEXT_FIELDS[textCount];
                this.getView().setVisible(Boolean.TRUE, new String[]{number});
                TextEdit textEdit = (TextEdit)this.getView().getControl(number);
                ormLocaleValue = (OrmLocaleValue)tmpDy.get("fieldcustname");
                textEdit.setCaption(new LocaleString(ormLocaleValue.getLocaleValue()));
                ++textCount;
                continue;
            }
            if (!"0".equals(tmpDy.get("fieldtype"))) continue;
            number = CUSTOM_AREA_FILE_FIELDS[fileCount];
            this.getView().setVisible(Boolean.TRUE, new String[]{number});
            AttachmentEdit attachmentEdit = (AttachmentEdit)this.getView().getControl(number);
            ormLocaleValue = (OrmLocaleValue)tmpDy.get("fieldcustname");
            attachmentEdit.setCaption(new LocaleString(ormLocaleValue.getLocaleValue()));
            ++fileCount;
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if ("editarea".equals(key) || "view".equals(key)) {
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("epa_customareaconf");
            if ("editarea".equals(key)) {
                showParameter.setStatus(OperationStatus.EDIT);
            } else if ("view".equals(key)) {
                showParameter.setStatus(OperationStatus.VIEW);
            }
            showParameter.setPkId((Object)this.getConfId(formShowParameter));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "epa_customarea");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private Long getConfId(FormShowParameter formShowParameter) {
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        if ("confedit".equals(formShowParameter.getCustomParam("conftype"))) {
            return confId;
        }
        return ASSESS_RULE_APP_SERVICE.copyCustomConfigByPk(confId);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (returnData != null && "epa_customarea".equals(actionId)) {
            this.setReturnData("editarea", (Long)returnData);
        }
    }
}

