/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.assessrule.areaedit;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginFilter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.entity.commonfield.TextAreaField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.container.FieldgroupPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.domain.evaluating.entity.ContentFieldEntryEvaDto;
import kd.opmc.epa.business.domain.evaluating.entity.EvalFieldEnterBo;
import kd.opmc.epa.common.constants.AreaFieldConstants;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.formplugin.web.assessrule.areaedit.extpoint.DrawAreaStyleService;
import kd.opmc.epa.formplugin.web.assessrule.areaedit.extpoint.impl.DrawAreaStyleServiceImpl;
import kd.opmc.pbs.common.enums.FieldTypeEnum;

public class DrawAreaUtils
implements AreaFieldConstants {
    private static final String ALL_LOCK_STR = "new,edit,view,submit,audit";
    private static final String NORMAL_LOCK_STR = "view,submit,audit";
    public static final String LOCK_STR = "new,edit,view,submit,audit";
    private static final Set<String> validateNumberFiled = Sets.newHashSet((Object[])new String[]{"qualitytarget", "qualitydare", "qualitybase", "qualityres"});

    public static void drawArea(LoadCustomControlMetasArgs args, DynamicObject conf) {
        DrawAreaUtils.setAreaNameByConfDynObj(args, conf);
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryentity");
        for (DynamicObject fieldInfo : entryEntity) {
            EntryFieldAp entryFieldAp = new EntryFieldAp();
            String fieldKey = fieldInfo.getString("areafield.number");
            entryFieldAp.setId(fieldKey);
            entryFieldAp.setKey(fieldKey);
            entryFieldAp.isFireUpdEvt();
            entryFieldAp.setName(new LocaleString(fieldInfo.getString("fieldcustname")));
            entryFieldAp.setField(DrawAreaUtils.assembleField(fieldInfo, (FormShowParameter)args.getSource()));
            entryAp.getItems().add(entryFieldAp);
        }
        HashMap<String, String> mapEntry = new HashMap<String, String>(16);
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        args.getItems().add(mapEntry);
    }

    private static void setAreaNameByConfDynObj(LoadCustomControlMetasArgs args, DynamicObject conf) {
        Object customName = conf.get("areacustname");
        HashMap<String, Object> mapAreaName = new HashMap<String, Object>(16);
        mapAreaName.put("id", "lblareaname");
        mapAreaName.put("caption", customName);
        args.getItems().add(mapAreaName);
    }

    public static void setCustomAreaFieldNameByConf(LoadCustomControlMetasArgs args, DynamicObject conf) {
        DrawAreaUtils.setAreaNameByConfDynObj(args, conf);
        DynamicObjectCollection collection = conf.getDynamicObjectCollection("entryentity");
        Map<String, Object> areaFieldNumberAndNameMap = collection.stream().collect(Collectors.toMap(dyn -> dyn.getString("areafield.number"), dyn -> dyn.get("fieldcustname")));
        for (Map.Entry<String, Object> entry : areaFieldNumberAndNameMap.entrySet()) {
            HashMap<String, Object> mapAreaName = new HashMap<String, Object>(4);
            mapAreaName.put("id", entry.getKey());
            mapAreaName.put("caption", entry.getValue());
            args.getItems().add(mapAreaName);
        }
    }

    private static Field assembleField(DynamicObject fieldInfo, FormShowParameter formShowParameter) {
        int numAccuracy = Integer.parseInt((String)formShowParameter.getCustomParam("numaccuracy"));
        DynamicObject areaField = fieldInfo.getDynamicObject("areafield");
        Field field = DrawAreaUtils.createField(areaField, numAccuracy);
        String fieldKey = areaField.getString("number");
        field.setId(fieldKey);
        field.setKey(fieldKey);
        field.setName(new LocaleString(fieldInfo.getString("fieldcustname")));
        field.setMustInput(areaField.getBoolean("ismustinput"));
        return field;
    }

    private static Field assembleGenField(DynamicObject fieldInfo, FormShowParameter formShowParameter, boolean isOutWeight) {
        int numAccuracy = Integer.parseInt((String)formShowParameter.getCustomParam("numaccuracy"));
        DynamicObject areaField = fieldInfo.getDynamicObject("areafield");
        Field field = DrawAreaUtils.createGenField(areaField, numAccuracy, isOutWeight);
        String fieldKey = areaField.getString("number");
        field.setId(fieldKey);
        field.setKey(fieldKey);
        field.setName(new LocaleString(fieldInfo.getString("fieldcustname")));
        field.setMustInput(areaField.getBoolean("ismustinput"));
        return field;
    }

    private static Field assembleField(DynamicObject fieldInfo, FormShowParameter formShowParameter, Boolean mustInput) {
        int numAccuracy = Integer.parseInt((String)formShowParameter.getCustomParam("numaccuracy"));
        DynamicObject areaField = fieldInfo.getDynamicObject("areafield");
        Field field = DrawAreaUtils.createField(areaField, numAccuracy);
        String fieldKey = HRStringUtils.trim((String)areaField.getString("number"));
        field.setId(fieldKey);
        field.setKey(fieldKey);
        field.setName(new LocaleString(fieldInfo.getString("fieldcustname")));
        field.setMustInput(mustInput.booleanValue());
        return field;
    }

    private static Field assembleGenField(DynamicObject fieldInfo, FormShowParameter formShowParameter, Boolean mustInput, boolean isOutWeight) {
        int numAccuracy = Integer.parseInt((String)formShowParameter.getCustomParam("numaccuracy"));
        DynamicObject areaField = fieldInfo.getDynamicObject("areafield");
        Field field = DrawAreaUtils.createGenField(areaField, numAccuracy, isOutWeight);
        String fieldKey = areaField.getString("number");
        field.setId(fieldKey);
        field.setKey(fieldKey);
        field.setName(new LocaleString(fieldInfo.getString("fieldcustname")));
        field.setMustInput(mustInput.booleanValue());
        return field;
    }

    private static void setStyle(FieldAp fieldAp, DynamicObject fieldInfo) {
        DrawAreaStyleServiceImpl drawAreaStyleService = new DrawAreaStyleServiceImpl();
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)drawAreaStyleService, DrawAreaStyleService.class, (String)"kd.opmc.epa.formplugin.web.assessrule.areaedit.extpoint.DrawAreaStyleService.setStyle", (PluginFilter)null);
        proxy.callReplaceIfPresent(validate -> validate.setStyle(fieldAp, fieldInfo));
    }

    private static Field createField(DynamicObject areaField, int numAccuracy) {
        FieldTypeEnum fieldTypeEnum = FieldTypeEnum.getFieldPropEnum((String)areaField.getString("proptype"));
        int max = areaField.getInt("max");
        int min = areaField.getInt("min");
        String dataScope = areaField.getString("datascope");
        switch (fieldTypeEnum) {
            case MuliLangText: {
                MuliLangTextField muliLangTextField = new MuliLangTextField();
                muliLangTextField.setMutiLine(false);
                muliLangTextField.setMaxLength(max);
                muliLangTextField.setMinLength(min);
                return muliLangTextField;
            }
            case TextAreaProp: {
                TextAreaField textAreaField = new TextAreaField();
                textAreaField.setMaxLength(max);
                textAreaField.setMinLength(min);
                return textAreaField;
            }
            case MuliLangGlTextProp: {
                MuliLangTextField mumuliLangTextField = new MuliLangTextField();
                mumuliLangTextField.setMutiLine(true);
                mumuliLangTextField.setMaxLength(max);
                mumuliLangTextField.setMinLength(min);
                return mumuliLangTextField;
            }
            case LargeTextProp: {
                MuliLangTextField lamuliLangTextField = new MuliLangTextField();
                lamuliLangTextField.setMutiLine(true);
                lamuliLangTextField.setMaxLength(max);
                lamuliLangTextField.setMinLength(min);
                return lamuliLangTextField;
            }
            case Text: {
                TextField textField = new TextField();
                textField.setMaxLength(max);
                textField.setMinLength(min);
                return textField;
            }
            case Combo: {
                ComboField comboField = new ComboField();
                String key = areaField.getString("number");
                if (HRStringUtils.equals((String)key, (String)"evaltype")) {
                    DrawAreaUtils.addItem(comboField, ResManager.loadKDString((String)"\u5b9a\u6027", (String)"DrawAreaUtils_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]), "10");
                    DrawAreaUtils.addItem(comboField, ResManager.loadKDString((String)"\u5b9a\u91cf", (String)"DrawAreaUtils_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]), "20");
                }
                if (HRStringUtils.equals((String)key, (String)"evalmode")) {
                    DrawAreaUtils.addItem(comboField, ResManager.loadKDString((String)"\u8bc4\u5206", (String)"DrawAreaUtils_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]), "10");
                    DrawAreaUtils.addItem(comboField, ResManager.loadKDString((String)"\u540e\u53f0\u5f55\u5165", (String)"DrawAreaUtils_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]), "20");
                }
                return comboField;
            }
            case Date: {
                return new DateField();
            }
            case Boolean: {
                return new CheckBoxField();
            }
            case Decimal: {
                DecimalField decimalField = new DecimalField();
                decimalField.setPrecision(numAccuracy + 13);
                decimalField.setScale(numAccuracy);
                decimalField.setDataScope(dataScope);
                decimalField.setZeroShow(true);
                return decimalField;
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5b57\u6bb5\u7c7b\u578b\u672a\u77e5\u3002", (String)"DrawAreaUtils_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
    }

    private static Field createGenField(DynamicObject areaField, int numAccuracy, boolean isOutWeight) {
        FieldTypeEnum fieldTypeEnum = FieldTypeEnum.getFieldPropEnum((String)areaField.getString("proptype"));
        int max = areaField.getInt("max");
        int min = areaField.getInt("min");
        String dataScope = areaField.getString("datascope");
        switch (fieldTypeEnum) {
            case MuliLangText: {
                MuliLangTextField muliLangTextField = new MuliLangTextField();
                muliLangTextField.setMutiLine(false);
                muliLangTextField.setMaxLength(max);
                muliLangTextField.setMinLength(min);
                return muliLangTextField;
            }
            case TextAreaProp: {
                TextAreaField textAreaField = new TextAreaField();
                textAreaField.setMaxLength(max);
                textAreaField.setMinLength(min);
                return textAreaField;
            }
            case MuliLangGlTextProp: {
                MuliLangTextField mumuliLangTextField = new MuliLangTextField();
                mumuliLangTextField.setMutiLine(true);
                mumuliLangTextField.setMaxLength(max);
                mumuliLangTextField.setMinLength(min);
                return mumuliLangTextField;
            }
            case LargeTextProp: {
                MuliLangTextField lamuliLangTextField = new MuliLangTextField();
                lamuliLangTextField.setMutiLine(true);
                lamuliLangTextField.setMaxLength(max);
                lamuliLangTextField.setMinLength(min);
                return lamuliLangTextField;
            }
            case Text: {
                TextField textField = new TextField();
                textField.setMaxLength(max);
                textField.setMinLength(min);
                return textField;
            }
            case Combo: {
                ComboField comboField = new ComboField();
                String key = areaField.getString("number");
                if (HRStringUtils.equals((String)key, (String)"evaltype")) {
                    DrawAreaUtils.addItem(comboField, ResManager.loadKDString((String)"\u5b9a\u6027", (String)"DrawAreaUtils_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]), "10");
                    DrawAreaUtils.addItem(comboField, ResManager.loadKDString((String)"\u5b9a\u91cf", (String)"DrawAreaUtils_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]), "20");
                }
                if (HRStringUtils.equals((String)key, (String)"evalmode")) {
                    DrawAreaUtils.addItem(comboField, ResManager.loadKDString((String)"\u8bc4\u5206", (String)"DrawAreaUtils_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]), "10");
                    DrawAreaUtils.addItem(comboField, ResManager.loadKDString((String)"\u540e\u53f0\u5f55\u5165", (String)"DrawAreaUtils_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]), "20");
                }
                return comboField;
            }
            case Date: {
                return new DateField();
            }
            case Boolean: {
                return new CheckBoxField();
            }
            case Decimal: {
                DecimalField decimalField = new DecimalField();
                decimalField.setPrecision(numAccuracy + 13);
                decimalField.setScale(numAccuracy);
                String dKey = areaField.getString("number");
                if (HRStringUtils.equals((String)dKey, (String)"evasumlimit") && !isOutWeight) {
                    decimalField.setDataScope(dataScope);
                }
                decimalField.setZeroShow(true);
                return decimalField;
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5b57\u6bb5\u7c7b\u578b\u672a\u77e5\u3002", (String)"DrawAreaUtils_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
    }

    private static void addItem(ComboField comboField, String caption, String value) {
        ComboItem comboItem = new ComboItem();
        comboItem.setCaption(new LocaleString(caption));
        comboItem.setValue(value);
        comboField.getItems().add(comboItem);
    }

    public static BaseShowParameter getConfShowParam(String formId, Long pkId, CloseCallBack closeCallBack) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(formId);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setPkId((Object)pkId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(closeCallBack);
        return showParameter;
    }

    public static Map<String, Object> getPcScItemMap(FormShowParameter formShowParameter) {
        int numAccuracy = Integer.parseInt((String)formShowParameter.getCustomParam("numaccuracy"));
        HashMap<String, Integer> pcScMap = new HashMap<String, Integer>(16);
        pcScMap.put("pc", numAccuracy + 13);
        pcScMap.put("sc", numAccuracy);
        HashMap<String, Object> itemMap = new HashMap<String, Object>(16);
        itemMap.put("item", pcScMap);
        return itemMap;
    }

    public static Map<String, Object> getPcScopeItemMap(FormShowParameter formShowParameter) {
        int numAccuracy = Integer.parseInt((String)formShowParameter.getCustomParam("numaccuracy"));
        Object limitMaxRatioObj = formShowParameter.getCustomParam("limitmaxratio");
        BigDecimal hundredRatio = new BigDecimal(100);
        BigDecimal limitMaxRatioBD = new BigDecimal(100);
        if (limitMaxRatioObj instanceof BigDecimal) {
            limitMaxRatioBD = (BigDecimal)formShowParameter.getCustomParam("limitmaxratio");
        } else if (limitMaxRatioObj instanceof String) {
            String limitMaxRatioStr = (String)formShowParameter.getCustomParam("limitmaxratio");
            limitMaxRatioBD = new BigDecimal(limitMaxRatioStr);
        }
        if (limitMaxRatioBD.compareTo(hundredRatio) < 0) {
            limitMaxRatioBD = hundredRatio;
        }
        HashMap<String, Object> pcScMap = new HashMap<String, Object>(16);
        pcScMap.put("pc", numAccuracy + 13);
        pcScMap.put("sc", numAccuracy);
        pcScMap.put("min", 0);
        pcScMap.put("max", limitMaxRatioBD.doubleValue());
        pcScMap.put("minm", "[");
        pcScMap.put("maxm", "]");
        HashMap<String, Object> itemMap = new HashMap<String, Object>(16);
        itemMap.put("item", pcScMap);
        return itemMap;
    }

    public static Map<String, Object> getPcScopeItemMapFromStr(FormShowParameter formShowParameter) {
        BigDecimal limitMaxRatioStrBD;
        String limitMaxRatioStr;
        Object limitMaxRatioObj = formShowParameter.getCustomParam("limitmaxratio");
        BigDecimal limitMaxRatioBD = new BigDecimal(100);
        if (limitMaxRatioObj instanceof String && (limitMaxRatioStr = (String)limitMaxRatioObj) != "" && (limitMaxRatioStrBD = new BigDecimal(limitMaxRatioStr)).compareTo(limitMaxRatioBD) > 0) {
            limitMaxRatioBD = limitMaxRatioStrBD;
        }
        int numAccuracy = Integer.parseInt((String)formShowParameter.getCustomParam("numaccuracy"));
        HashMap<String, Object> pcScMap = new HashMap<String, Object>(16);
        pcScMap.put("pc", numAccuracy + 13);
        pcScMap.put("sc", numAccuracy);
        pcScMap.put("min", 0);
        pcScMap.put("max", limitMaxRatioBD.doubleValue());
        pcScMap.put("minm", "[");
        pcScMap.put("maxm", "]");
        HashMap<String, Object> itemMap = new HashMap<String, Object>(16);
        itemMap.put("item", pcScMap);
        return itemMap;
    }

    public static Map<String, Object> getAddScoreMap(FormShowParameter formShowParameter) {
        int numAccuracy = Integer.parseInt((String)formShowParameter.getCustomParam("numaccuracy"));
        HashMap<String, Object> pcScMap = new HashMap<String, Object>(16);
        pcScMap.put("pc", numAccuracy + 13);
        pcScMap.put("sc", numAccuracy);
        pcScMap.put("min", 0);
        pcScMap.put("minm", "[");
        pcScMap.put("maxm", ")");
        HashMap<String, Object> itemMap = new HashMap<String, Object>(16);
        itemMap.put("item", pcScMap);
        return itemMap;
    }

    public static Map<String, Object> getSubScoreMap(FormShowParameter formShowParameter) {
        int numAccuracy = Integer.parseInt((String)formShowParameter.getCustomParam("numaccuracy"));
        HashMap<String, Object> pcScMap = new HashMap<String, Object>(16);
        pcScMap.put("pc", numAccuracy + 13);
        pcScMap.put("sc", numAccuracy);
        pcScMap.put("max", 0);
        pcScMap.put("minm", "(");
        pcScMap.put("maxm", "]");
        HashMap<String, Object> itemMap = new HashMap<String, Object>(16);
        itemMap.put("item", pcScMap);
        return itemMap;
    }

    public static void customDrawArea(LoadCustomControlMetasArgs args, DynamicObject conf, String[] ignoreField, Long areaReg) {
        EntryAp entryAp = DrawAreaUtils.createEntryAp(args, conf, ignoreField, areaReg);
        HashMap<String, String> mapEntry = new HashMap<String, String>(16);
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        mapEntry.put("selchexkbox", (String)entryAp.createControl().get("selchexkbox"));
        args.getItems().add(mapEntry);
    }

    private static EntryAp createEntryAp(LoadCustomControlMetasArgs args, DynamicObject conf, String[] ignoreField, Long areaReg) {
        DrawAreaUtils.setAreaNameByConfDynObj(args, conf);
        Set notLoadFiled = Arrays.stream(ignoreField).collect(Collectors.toSet());
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryentity");
        entryAp.setShowSeq(true);
        FormShowParameter param = (FormShowParameter)args.getSource();
        if (param.getStatus() != OperationStatus.VIEW) {
            entryAp.setShowSelChexkbox(true);
        }
        entryAp.setMulti(true);
        for (DynamicObject fieldInfo : entryEntity) {
            EntryFieldAp entryFieldAp = new EntryFieldAp();
            String fieldKey = fieldInfo.getString("areafield.number");
            if (notLoadFiled.contains(fieldKey)) continue;
            entryFieldAp.setId(fieldKey);
            entryFieldAp.setKey(fieldKey);
            if (HRStringUtils.equals((String)fieldKey, (String)"indctrname") || HRStringUtils.equals((String)fieldKey, (String)"keyactname")) {
                entryFieldAp.setHyperlink(true);
            }
            entryFieldAp.isFireUpdEvt();
            entryFieldAp.setLock("new,edit,view,submit,audit");
            entryFieldAp.setNoDisplayScaleZero(false);
            entryFieldAp.setName(new LocaleString(fieldInfo.getString("fieldcustname")));
            entryFieldAp.setField(DrawAreaUtils.assembleField(fieldInfo, (FormShowParameter)args.getSource()));
            entryAp.getItems().add(entryFieldAp);
        }
        if (areaReg.equals(AssessRuleConstants.NORM_INDCTR_AREA_PK)) {
            DrawAreaUtils.nomalExtendField(conf, entryAp, (FormShowParameter)args.getSource());
        } else if (areaReg.equals(AssessRuleConstants.PLUS_MINUS_AREA_PK)) {
            DrawAreaUtils.addIsEditableFieldAp(entryAp);
        }
        return entryAp;
    }

    private static EntryAp createEntryAp(LoadCustomControlMetasArgs args, DynamicObject conf, String[] ignoreField, Long areaReg, List<ContentFieldEntryEvaDto> fieldEntryEvaDtos) {
        DrawAreaUtils.setAreaNameByConfDynObj(args, conf);
        Set notLoadFiled = Arrays.stream(ignoreField).collect(Collectors.toSet());
        Map<Long, ContentFieldEntryEvaDto> filePermMap = DrawAreaUtils.change2PermMap(fieldEntryEvaDtos);
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryentity");
        entryAp.setShowSeq(true);
        FormShowParameter param = (FormShowParameter)args.getSource();
        if (param.getStatus() != OperationStatus.VIEW) {
            entryAp.setShowSelChexkbox(true);
        }
        entryAp.setMulti(true);
        for (DynamicObject fieldInfo : entryEntity) {
            long areaFieldId;
            ContentFieldEntryEvaDto permFileDto;
            EntryFieldAp entryFieldAp = new EntryFieldAp();
            String fieldKey = fieldInfo.getString("areafield.number");
            if (notLoadFiled.contains(fieldKey) || (permFileDto = filePermMap.get(areaFieldId = fieldInfo.getLong("areafield.id"))) == null || !permFileDto.getFieldDisplayItem().booleanValue()) continue;
            entryFieldAp.setId(fieldKey);
            entryFieldAp.setKey(fieldKey);
            if (HRStringUtils.equals((String)fieldKey, (String)"indctrname") || HRStringUtils.equals((String)fieldKey, (String)"keyactname")) {
                entryFieldAp.setHyperlink(true);
            }
            entryFieldAp.isFireUpdEvt();
            entryFieldAp.setLock("new,edit,view,submit,audit");
            entryFieldAp.setNoDisplayScaleZero(false);
            entryFieldAp.setName(new LocaleString(fieldInfo.getString("fieldcustname")));
            entryFieldAp.setField(DrawAreaUtils.assembleField(fieldInfo, (FormShowParameter)args.getSource(), permFileDto.getFieldMustInputItem()));
            entryAp.getItems().add(entryFieldAp);
        }
        if (areaReg.equals(AssessRuleConstants.NORM_INDCTR_AREA_PK)) {
            DrawAreaUtils.nomalExtendFieldNoIsEditAble(conf, entryAp, (FormShowParameter)args.getSource());
        }
        return entryAp;
    }

    private static Map<Long, ContentFieldEntryEvaDto> change2PermMap(List<ContentFieldEntryEvaDto> fieldEntryEvaDtos) {
        HashMap<Long, ContentFieldEntryEvaDto> filePermMap = new HashMap<Long, ContentFieldEntryEvaDto>(16);
        if (fieldEntryEvaDtos != null) {
            for (ContentFieldEntryEvaDto fieldEntryEvaDto : fieldEntryEvaDtos) {
                if (fieldEntryEvaDto == null) continue;
                filePermMap.put(fieldEntryEvaDto.getAreaFieldId(), fieldEntryEvaDto);
            }
        }
        return filePermMap;
    }

    private static void removeCustomeField(Set<String> notLoadFiled) {
        if (notLoadFiled != null) {
            Iterator<String> iterator = notLoadFiled.iterator();
            while (iterator.hasNext()) {
                String fieldKeyNumber = iterator.next();
                if (fieldKeyNumber == null || !fieldKeyNumber.startsWith("customfiled") && !fieldKeyNumber.equals("customfield")) continue;
                iterator.remove();
            }
        }
    }

    private static void addSubExtendFieldNoIsEditable(EntryAp entryAp, FormShowParameter formShowParameter) {
        int numAccuracy = Integer.parseInt((String)formShowParameter.getCustomParam("numaccuracy"));
        entryAp.getItems().add(DrawAreaUtils.createDecimalField("subscoremin", ResManager.loadKDString((String)"\u6263\u5206\u4e0b\u9650", (String)"DrawAreaUtils_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]), numAccuracy));
        entryAp.getItems().add(DrawAreaUtils.createDecimalField("addscoremax", ResManager.loadKDString((String)"\u52a0\u5206\u4e0a\u9650", (String)"DrawAreaUtils_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]), numAccuracy));
    }

    private static void addSubExtendField(EntryAp entryAp, FormShowParameter formShowParameter) {
        int numAccuracy = Integer.parseInt((String)formShowParameter.getCustomParam("numaccuracy"));
        entryAp.getItems().add(DrawAreaUtils.createDecimalField("subscoremin", ResManager.loadKDString((String)"\u6263\u5206\u4e0b\u9650", (String)"DrawAreaUtils_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]), numAccuracy));
        entryAp.getItems().add(DrawAreaUtils.createDecimalField("addscoremax", ResManager.loadKDString((String)"\u52a0\u5206\u4e0a\u9650", (String)"DrawAreaUtils_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]), numAccuracy));
        entryAp.getItems().add(DrawAreaUtils.createIsEditableFieldAp());
    }

    private static void nomalExtendFieldNoIsEditAble(DynamicObject conf, EntryAp entryAp, FormShowParameter formShowParameter) {
        int numAccuracy = Integer.parseInt((String)formShowParameter.getCustomParam("numaccuracy"));
        boolean isAllowEval = conf.getBoolean("reversepoints");
        if (isAllowEval) {
            entryAp.getItems().add(DrawAreaUtils.createDecimalField("minevalscore", ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650", (String)"DrawAreaUtils_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]), numAccuracy));
            entryAp.getItems().add(DrawAreaUtils.createDecimalField("maxevalscore", ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650", (String)"DrawAreaUtils_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]), numAccuracy));
        }
    }

    private static void nomalExtendField(DynamicObject conf, EntryAp entryAp, FormShowParameter formShowParameter) {
        int numAccuracy = Integer.parseInt((String)formShowParameter.getCustomParam("numaccuracy"));
        boolean isAllowEval = conf.getBoolean("reversepoints");
        if (isAllowEval) {
            entryAp.getItems().add(DrawAreaUtils.createDecimalField("minevalscore", ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650", (String)"DrawAreaUtils_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]), numAccuracy));
            entryAp.getItems().add(DrawAreaUtils.createDecimalField("maxevalscore", ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650", (String)"DrawAreaUtils_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]), numAccuracy));
        }
        EntryFieldAp entryFieldAp = DrawAreaUtils.createIsEditableFieldAp();
        entryAp.getItems().add(entryFieldAp);
    }

    private static void addIsEditableFieldAp(EntryAp entryAp) {
        entryAp.getItems().add(DrawAreaUtils.createIsEditableFieldAp());
    }

    private static EntryFieldAp createIsEditableFieldAp() {
        String isEditAble = "iseditable";
        String isEditAbleName = ResManager.loadKDString((String)"\u5141\u8bb8\u4fee\u6539", (String)"DrawAreaUtils_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        return DrawAreaUtils.crateCheckBoxEntryFieldAp(isEditAble, isEditAbleName);
    }

    private static EntryFieldAp crateCheckBoxEntryFieldAp(String filedKey, String filedName) {
        EntryFieldAp entryFieldAp = new EntryFieldAp();
        entryFieldAp.setId(filedKey);
        entryFieldAp.setKey(filedKey);
        entryFieldAp.setLock("new,edit,view,submit,audit");
        entryFieldAp.isFireUpdEvt();
        entryFieldAp.setName(new LocaleString(filedName));
        ComboField isEditAbleField = new ComboField();
        DrawAreaUtils.addItem(isEditAbleField, ResManager.loadKDString((String)"\u662f", (String)"DrawAreaUtils_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]), "1");
        DrawAreaUtils.addItem(isEditAbleField, ResManager.loadKDString((String)"\u5426", (String)"DrawAreaUtils_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]), "0");
        isEditAbleField.setId(filedKey);
        isEditAbleField.setKey(filedKey);
        isEditAbleField.setName(new LocaleString(filedName));
        entryFieldAp.setField((Field)isEditAbleField);
        return entryFieldAp;
    }

    private static EntryFieldAp createDecimalField(String key, String name, int numAccuracy) {
        EntryFieldAp entryFieldAp = new EntryFieldAp();
        entryFieldAp.setId(key);
        entryFieldAp.setKey(key);
        entryFieldAp.isFireUpdEvt();
        entryFieldAp.setNoDisplayScaleZero(false);
        entryFieldAp.setLock("new,edit,view,submit,audit");
        entryFieldAp.setName(new LocaleString(name));
        DecimalField decimalField = new DecimalField();
        decimalField.setPrecision(numAccuracy + 13);
        decimalField.setScale(numAccuracy);
        decimalField.setId(key);
        decimalField.setKey(key);
        decimalField.setZeroShow(true);
        decimalField.setName(new LocaleString(name));
        entryFieldAp.setField((Field)decimalField);
        return entryFieldAp;
    }

    public static void drawIndicatorField(LoadCustomControlMetasArgs args, DynamicObject conf, String[] ignoreField) {
        FieldgroupPanelAp fieldOfRuleAp = new FieldgroupPanelAp();
        fieldOfRuleAp.setKey("fieldofruleap");
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        Set notLoadFiled = Arrays.stream(ignoreField).collect(Collectors.toSet());
        for (DynamicObject fieldInfo : entryEntity) {
            String fieldKey = fieldInfo.getString("areafield.number");
            if (notLoadFiled.contains(fieldKey)) continue;
            FieldAp fieldAp = new FieldAp();
            fieldAp.setId(fieldKey);
            fieldAp.setKey(fieldKey);
            fieldAp.setName(new LocaleString(fieldInfo.getString("fieldcustname")));
            if (validateNumberFiled.contains(fieldKey)) {
                fieldAp.setFireUpdEvt(true);
            }
            fieldAp.setNoDisplayScaleZero(false);
            fieldAp.setField(DrawAreaUtils.assembleField(fieldInfo, (FormShowParameter)args.getSource()));
            DrawAreaUtils.setStyle(fieldAp, fieldInfo);
            fieldOfRuleAp.getItems().add(fieldAp);
        }
        HashMap<String, String> mapEntry = new HashMap<String, String>(16);
        mapEntry.put("id", fieldOfRuleAp.getKey());
        mapEntry.put("items", (String)fieldOfRuleAp.createControl().get("items"));
        args.getItems().add(mapEntry);
    }

    public static void drawGenIndicatorField(LoadCustomControlMetasArgs args, DynamicObject conf, String[] ignoreField, boolean isOutWeight) {
        FieldgroupPanelAp fieldOfRuleAp = new FieldgroupPanelAp();
        fieldOfRuleAp.setKey("fieldofruleap");
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        Set notLoadFiled = Arrays.stream(ignoreField).collect(Collectors.toSet());
        for (DynamicObject fieldInfo : entryEntity) {
            String fieldKey = fieldInfo.getString("areafield.number");
            if (notLoadFiled.contains(fieldKey)) continue;
            FieldAp fieldAp = new FieldAp();
            fieldAp.setId(fieldKey);
            fieldAp.setKey(fieldKey);
            fieldAp.setName(new LocaleString(fieldInfo.getString("fieldcustname")));
            if (validateNumberFiled.contains(fieldKey)) {
                fieldAp.setFireUpdEvt(true);
            }
            fieldAp.setNoDisplayScaleZero(false);
            fieldAp.setField(DrawAreaUtils.assembleGenField(fieldInfo, (FormShowParameter)args.getSource(), isOutWeight));
            DrawAreaUtils.setStyle(fieldAp, fieldInfo);
            fieldOfRuleAp.getItems().add(fieldAp);
        }
        HashMap<String, String> mapEntry = new HashMap<String, String>(16);
        mapEntry.put("id", fieldOfRuleAp.getKey());
        mapEntry.put("items", (String)fieldOfRuleAp.createControl().get("items"));
        args.getItems().add(mapEntry);
    }

    public static void drawIndicatorField(LoadCustomControlMetasArgs args, DynamicObject conf, String[] ignoreField, Long areaReg, List<ContentFieldEntryEvaDto> fieldEntryEvaDtos) {
        FieldgroupPanelAp fieldOfRuleAp = new FieldgroupPanelAp();
        fieldOfRuleAp.setKey("fieldofruleap");
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        Set notLoadFiled = Arrays.stream(ignoreField).collect(Collectors.toSet());
        Map<Long, ContentFieldEntryEvaDto> filePermMap = DrawAreaUtils.change2PermMap(fieldEntryEvaDtos);
        for (DynamicObject fieldInfo : entryEntity) {
            long areaFieldId;
            ContentFieldEntryEvaDto permFileDto;
            String fieldKey = HRStringUtils.trim((String)fieldInfo.getString("areafield.number"));
            if (notLoadFiled.contains(fieldKey) || (permFileDto = filePermMap.get(areaFieldId = fieldInfo.getLong("areafield.id"))) == null || !permFileDto.getFieldDisplayItem().booleanValue()) continue;
            FieldAp fieldAp = new FieldAp();
            fieldAp.setId(fieldKey);
            fieldAp.setKey(fieldKey);
            fieldAp.setName(new LocaleString(fieldInfo.getString("fieldcustname")));
            fieldAp.setLock(permFileDto.getFieldModifyItem() != false ? NORMAL_LOCK_STR : "new,edit,view,submit,audit");
            if (validateNumberFiled.contains(fieldKey)) {
                fieldAp.setFireUpdEvt(true);
            }
            fieldAp.setNoDisplayScaleZero(false);
            fieldAp.setField(DrawAreaUtils.assembleField(fieldInfo, (FormShowParameter)args.getSource(), permFileDto.getFieldMustInputItem()));
            DrawAreaUtils.setStyle(fieldAp, fieldInfo);
            fieldOfRuleAp.getItems().add(fieldAp);
        }
        HashMap<String, String> mapEntry = new HashMap<String, String>(16);
        mapEntry.put("id", fieldOfRuleAp.getKey());
        mapEntry.put("items", (String)fieldOfRuleAp.createControl().get("items"));
        args.getItems().add(mapEntry);
    }

    public static void drawGenIndicatorField(LoadCustomControlMetasArgs args, DynamicObject conf, String[] ignoreField, Long areaReg, List<ContentFieldEntryEvaDto> fieldEntryEvaDtos, boolean isOutWeight) {
        FieldgroupPanelAp fieldOfRuleAp = new FieldgroupPanelAp();
        fieldOfRuleAp.setKey("fieldofruleap");
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        Set notLoadFiled = Arrays.stream(ignoreField).collect(Collectors.toSet());
        Map<Long, ContentFieldEntryEvaDto> filePermMap = DrawAreaUtils.change2PermMap(fieldEntryEvaDtos);
        for (DynamicObject fieldInfo : entryEntity) {
            long areaFieldId;
            ContentFieldEntryEvaDto permFileDto;
            String fieldKey = fieldInfo.getString("areafield.number");
            if (notLoadFiled.contains(fieldKey) || (permFileDto = filePermMap.get(areaFieldId = fieldInfo.getLong("areafield.id"))) == null || !permFileDto.getFieldDisplayItem().booleanValue()) continue;
            FieldAp fieldAp = new FieldAp();
            fieldAp.setId(fieldKey);
            fieldAp.setKey(fieldKey);
            fieldAp.setName(new LocaleString(fieldInfo.getString("fieldcustname")));
            fieldAp.setLock(permFileDto.getFieldModifyItem() != false ? NORMAL_LOCK_STR : "new,edit,view,submit,audit");
            if (validateNumberFiled.contains(fieldKey)) {
                fieldAp.setFireUpdEvt(true);
            }
            fieldAp.setNoDisplayScaleZero(false);
            fieldAp.setField(DrawAreaUtils.assembleField(fieldInfo, (FormShowParameter)args.getSource(), permFileDto.getFieldMustInputItem()));
            DrawAreaUtils.setStyle(fieldAp, fieldInfo);
            fieldOfRuleAp.getItems().add(fieldAp);
        }
        HashMap<String, String> mapEntry = new HashMap<String, String>(16);
        mapEntry.put("id", fieldOfRuleAp.getKey());
        mapEntry.put("items", (String)fieldOfRuleAp.createControl().get("items"));
        args.getItems().add(mapEntry);
    }

    public static void customDrawAreaOfAssignIndicator(LoadCustomControlMetasArgs args, DynamicObject conf, String[] ignoreField, Long areaReg) {
        EntryAp entryAp = DrawAreaUtils.createEntryAp(args, conf, ignoreField, areaReg);
        entryAp.getItems().add(DrawAreaUtils.crateCheckBoxEntryFieldAp("ispreinstall", ResManager.loadKDString((String)"\u662f\u5426\u9884\u8bbe\u6307\u6807", (String)"DrawAreaUtils_8", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        HashMap<String, String> mapEntry = new HashMap<String, String>(16);
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        mapEntry.put("selchexkbox", (String)entryAp.createControl().get("selchexkbox"));
        args.getItems().add(mapEntry);
    }

    public static void customDrawAreaOfAssignIndicatorNoIsPreAll(LoadCustomControlMetasArgs args, DynamicObject conf, String[] ignoreField, Long areaReg, List<ContentFieldEntryEvaDto> fieldEntryEvaDtos) {
        EntryAp entryAp = ObjectUtils.isEmpty(fieldEntryEvaDtos) ? DrawAreaUtils.createEntryAp(args, conf, ignoreField, areaReg) : DrawAreaUtils.createEntryAp(args, conf, new String[0], areaReg, fieldEntryEvaDtos);
        HashMap<String, String> mapEntry = new HashMap<String, String>(16);
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        mapEntry.put("selchexkbox", (String)entryAp.createControl().get("selchexkbox"));
        args.getItems().add(mapEntry);
    }

    public static void initAssessFormConfigOfEvaluation(IFormView view, DynamicObject conf, Map<String, String> assessFormFieldMap, EvalFieldEnterBo evalFieldEnterBo) {
        HashMap<String, String> filedMap = new HashMap<String, String>(assessFormFieldMap);
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        for (DynamicObject fieldInfo : entryEntity) {
            String fieldKey = fieldInfo.getString("areafield.number");
            String fieldAp = (String)filedMap.remove(fieldKey);
            if (StringUtils.isEmpty((CharSequence)fieldAp)) continue;
            view.setVisible(Boolean.TRUE, new String[]{fieldAp});
        }
        String[] notConfField = filedMap.values().toArray(new String[0]);
        for (int i = 0; i < notConfField.length; ++i) {
            String fieldAp = notConfField[i];
            view.setVisible(Boolean.FALSE, new String[]{fieldAp});
        }
        view.updateControlMetadata("soe", DrawAreaUtils.getPcScItemMap(view.getFormShowParameter()));
        view.updateControlMetadata("ssr", DrawAreaUtils.getPcScItemMap(view.getFormShowParameter()));
        view.updateControlMetadata("ssrec", DrawAreaUtils.getPcScItemMap(view.getFormShowParameter()));
        HashMap<String, LocaleString> props = new HashMap<String, LocaleString>(16);
        props.put("text", new LocaleString(conf.getString("areacustname")));
        evalFieldEnterBo.setAreacustname(conf.getString("areacustname"));
        view.updateControlMetadata("conentpanel", props);
    }

    public static void setTipsAndAreaTitleOFAttach(IFormView view, DynamicObject conf, EvalFieldEnterBo evalFieldEnterBo) {
        Label titleLable = (Label)view.getControl("areatitle");
        String areCustName = conf.getString("areacustname");
        titleLable.setText(areCustName);
        Tips tips = new Tips();
        tips.setTitle(null);
        tips.setShowIcon(true);
        tips.setIconClassName("kdfont kdfont-gengduo2");
        tips.setType("text");
        tips.setTriggerType("hover");
        tips.setPlace("right");
        tips.setContent(new LocaleString(conf.getString("description")));
        titleLable.addTips(tips);
        evalFieldEnterBo.setAreacustname(areCustName);
    }

    public static void initRuleConfigOfEvaluationNew(IFormView view, DynamicObject conf, Map<String, String> ruleFiledMap, EvalFieldEnterBo evalFieldEnterBo) {
        view.updateControlMetadata("soe", DrawAreaUtils.getPcScItemMap(view.getFormShowParameter()));
        view.updateControlMetadata("ssr", DrawAreaUtils.getPcScItemMap(view.getFormShowParameter()));
        view.updateControlMetadata("ssrec", DrawAreaUtils.getPcScItemMap(view.getFormShowParameter()));
        Label titleLable = (Label)view.getControl("areatitle");
        String areCustName = conf.getString("areacustname");
        titleLable.setText(areCustName);
        Tips tips = new Tips();
        tips.setTitle(null);
        tips.setShowIcon(true);
        tips.setIconClassName("kdfont kdfont-gengduo2");
        tips.setType("text");
        tips.setTriggerType("hover");
        tips.setPlace("right");
        tips.setContent(new LocaleString(conf.getString("description")));
        titleLable.addTips(tips);
        evalFieldEnterBo.setAreacustname(areCustName);
    }

    public static void customDrawAttachAreaOfEvalResult(LoadCustomControlMetasArgs args, DynamicObject conf) {
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryentity");
        entryAp.setShowSeq(true);
        entryAp.setOrderAndFilter(1);
        FormShowParameter param = (FormShowParameter)args.getSource();
        if (param.getStatus() != OperationStatus.VIEW) {
            entryAp.setShowSelChexkbox(true);
        }
        entryAp.setMulti(true);
        for (DynamicObject fieldInfo : entryEntity) {
            EntryFieldAp entryFieldAp = new EntryFieldAp();
            String fieldKey = fieldInfo.getString("areafield.number");
            entryFieldAp.setId(fieldKey);
            entryFieldAp.setKey(fieldKey);
            entryFieldAp.isFireUpdEvt();
            entryFieldAp.setLock("new,edit,view,submit,audit");
            entryFieldAp.setNoDisplayScaleZero(false);
            entryFieldAp.setName(new LocaleString(fieldInfo.getString("fieldcustname")));
            int numAccuracy = Integer.parseInt((String)((FormShowParameter)args.getSource()).getCustomParam("numaccuracy"));
            DynamicObject areaField = fieldInfo.getDynamicObject("areafield");
            Field field = DrawAreaUtils.createField(areaField, numAccuracy);
            field.setId(fieldKey);
            field.setKey(fieldKey);
            field.setName(new LocaleString(fieldInfo.getString("fieldcustname")));
            entryFieldAp.setField(field);
            entryAp.getItems().add(entryFieldAp);
        }
        HashMap<String, String> mapEntry = new HashMap<String, String>(16);
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        mapEntry.put("selchexkbox", (String)entryAp.createControl().get("selchexkbox"));
        args.getItems().add(mapEntry);
    }

    public static boolean validateNumber(String value) {
        return value.matches("^-?([1-9]\\d*\\.\\d+|0\\.\\d*[1-9]\\d*|0\\.0+|[1-9]\\d*|0)$");
    }
}

