/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.assessrule.areaedit;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.opmc.epa.business.application.service.AssessRuleApplicationService;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.epa.formplugin.web.assessrule.areaedit.DrawAreaUtils;
import kd.opmc.epa.formplugin.web.assessrule.areaedit.MiddleAreaParentEdit;

public class NormalAreaEdit
extends MiddleAreaParentEdit {
    private static final AssessRuleApplicationService ASSESS_RULE_APP_SERVICE = AssessRuleApplicationService.getInstance();
    private static final String WEIGHT_FIELD = "weightfield";
    private static final String AREA_SCORE = "areascore";
    private static final String SCORE_LAB = "scorelab";
    private static final String WEIGHT_LAB = "weightlab";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = ASSESS_RULE_APP_SERVICE.queryNormalConfigByPk(confId);
        DrawAreaUtils.drawArea(args, conf);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (OperationStatus.VIEW == formShowParameter.getStatus()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"areaopap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"areaviewap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"areaviewap"});
        }
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = ASSESS_RULE_APP_SERVICE.queryNormalConfigByPk(confId);
        DynamicObject model = this.getModel().getDataEntity();
        model.set(AREA_SCORE, conf.get(AREA_SCORE));
        model.set(WEIGHT_FIELD, conf.get("weight"));
        model.set("description", conf.get("description"));
        this.getView().updateControlMetadata(AREA_SCORE, DrawAreaUtils.getPcScItemMap(formShowParameter));
        this.getView().updateControlMetadata("weight", DrawAreaUtils.getPcScItemMap(formShowParameter));
        this.getView().updateControlMetadata(WEIGHT_FIELD, DrawAreaUtils.getPcScItemMap(formShowParameter));
        ScoreCalcWayEnum scoreCalcWayEnum = ScoreCalcWayEnum.getScoreCalcWay((String)((String)formShowParameter.getCustomParam("scorecalcway")));
        Boolean isShowAreaScore = ScoreCalcWayEnum.SUM == scoreCalcWayEnum;
        this.getView().setVisible(isShowAreaScore, new String[]{AREA_SCORE});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            String scoreCalcWay = parentView.getModel().getDataEntity().getString("scorecalcway");
            if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{SCORE_LAB, AREA_SCORE});
                this.getView().setVisible(Boolean.TRUE, new String[]{WEIGHT_LAB, WEIGHT_FIELD});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{SCORE_LAB, AREA_SCORE});
                this.getView().setVisible(Boolean.FALSE, new String[]{WEIGHT_LAB, WEIGHT_FIELD});
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if ("editarea".equals(key) || "view".equals(key)) {
            BaseShowParameter confShowParam = DrawAreaUtils.getConfShowParam("epa_normalconf", this.getConfId(formShowParameter), new CloseCallBack((IFormPlugin)this, "epa_normalconf"));
            DynamicObject assessFormDynObj = this.getView().getParentView().getModel().getDataEntity();
            String scoreCalcWay = assessFormDynObj.getString("scorecalcway");
            confShowParam.setCustomParam("scorecalcway", (Object)scoreCalcWay);
            if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
                String consistentWithArea = assessFormDynObj.getString("consistentwitharea");
                confShowParam.setCustomParam("consistentwitharea", (Object)consistentWithArea);
                confShowParam.setCustomParam("scoresystem", (Object)assessFormDynObj.getLong("scoresystem.id"));
            }
            confShowParam.setCustomParam("evalway", formShowParameter.getCustomParam("evalway"));
            confShowParam.setCustomParam("numaccuracy", formShowParameter.getCustomParam("numaccuracy"));
            confShowParam.setCustomParam("limitmaxratio", formShowParameter.getCustomParam("limitmaxratio"));
            confShowParam.setCustomParam("evasumlimit", formShowParameter.getCustomParam("evasumlimit"));
            BigDecimal maxScore = assessFormDynObj.getBigDecimal("scoresystem.maxscore");
            confShowParam.setCustomParam("maxScore", (Object)maxScore);
            if ("view".equals(key)) {
                confShowParam.setStatus(OperationStatus.VIEW);
            }
            this.getView().showForm((FormShowParameter)confShowParam);
        }
    }

    private Long getConfId(FormShowParameter formShowParameter) {
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        if ("confedit".equals(formShowParameter.getCustomParam("conftype"))) {
            return confId;
        }
        return ASSESS_RULE_APP_SERVICE.copyNormalConfigByPk(confId);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && "epa_normalconf".equals(actionId)) {
            this.setReturnData("editarea", (Long)returnData);
        }
    }
}

