/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.assessrule.areaedit;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.AssessRuleApplicationService;
import kd.opmc.epa.common.constants.AreaConfigConstants;
import kd.opmc.epa.formplugin.web.assessrule.areaedit.DrawAreaUtils;

public class SumAreaEdit
extends HRDataBaseEdit
implements AreaConfigConstants {
    private static final AssessRuleApplicationService ASSESS_RULE_APP_SERVICE = AssessRuleApplicationService.getInstance();

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (OperationStatus.VIEW == formShowParameter.getStatus()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"areaopap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"areaviewap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"areaviewap"});
        }
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = ASSESS_RULE_APP_SERVICE.querySumConfigByPk(confId);
        HashMap<String, Object> areaNameMap = new HashMap<String, Object>(16);
        areaNameMap.put("caption", conf.get("areacustname"));
        this.getView().updateControlMetadata("lblareaname", areaNameMap);
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        for (DynamicObject fieldInfo : entryEntity) {
            if (!fieldInfo.getBoolean("isshow")) continue;
            HashMap<String, Object> fieldNameMap = new HashMap<String, Object>(16);
            fieldNameMap.put("caption", fieldInfo.get("fieldcustname"));
            String fieldKey = fieldInfo.getString("areafield.number");
            this.getView().setVisible(Boolean.TRUE, new String[]{fieldKey});
            this.getView().updateControlMetadata(fieldKey, fieldNameMap);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        BaseShowParameter confShowParam;
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if ("editarea".equals(key)) {
            confShowParam = DrawAreaUtils.getConfShowParam("epa_sumconf", this.getConfId(formShowParameter), new CloseCallBack((IFormPlugin)this, "epa_sumconf"));
            this.getView().showForm((FormShowParameter)confShowParam);
        }
        if ("view".equals(key)) {
            confShowParam = DrawAreaUtils.getConfShowParam("epa_sumconf", this.getConfId(formShowParameter), new CloseCallBack((IFormPlugin)this, "epa_sumconf"));
            confShowParam.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)confShowParam);
        }
    }

    private Long getConfId(FormShowParameter formShowParameter) {
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        if ("confedit".equals(formShowParameter.getCustomParam("conftype"))) {
            return confId;
        }
        return ASSESS_RULE_APP_SERVICE.copySumConfigByPk(confId);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && "epa_sumconf".equals(actionId)) {
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

