/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.indicator;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.indicator.IndicatorGroupApplicationService;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.formplugin.web.utils.AssignIndicatorPageUtils;

public class IndicatorGroupBasePlugin
extends HRDataBaseEdit {
    private static final IndicatorGroupApplicationService INDICATORGROUP_APPLICATION_SERVICE = new IndicatorGroupApplicationService();
    protected static final String SAVE = "save";

    public void initialize() {
        super.initialize();
    }

    public void beforeBindData(EventObject ev) {
        super.beforeBindData(ev);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (!this.checkName()) {
            args.setCancel(true);
            return;
        }
        if (SAVE.equals(source.getOperateKey()) && 0L == pkValue) {
            this.addIndicatorArea();
        }
    }

    private boolean checkName() {
        DynamicObjectCollection indicatorGroupEntry;
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        String nameOri = this.getModel().getDataEntity().getString("name");
        if (HRStringUtils.isEmpty((String)nameOri)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IndicatorGroupBasePlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return false;
        }
        String name = nameOri.trim();
        if (!nameOri.equals(name)) {
            this.getModel().setValue("name", (Object)name);
        }
        if ((indicatorGroupEntry = this.getView().getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("indicatorgroupentry")).size() == 0) {
            return true;
        }
        for (DynamicObject dynamicObject : indicatorGroupEntry) {
            DynamicObject indicatorGroup = dynamicObject.getDynamicObject("indicatorgroup");
            if (indicatorGroup == null) continue;
            String indicatorGroupName = indicatorGroup.getString("name");
            Long pkVal = (Long)indicatorGroup.getPkValue();
            if (pkVal.equals(pkValue)) continue;
            String groupName = AssignIndicatorPageUtils.getIndicatorGroupMetaName();
            if (!HRStringUtils.isNotEmpty((String)indicatorGroupName) || !indicatorGroupName.equals(name)) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5728\u540c\u4e00\u8003\u6838\u6d3b\u52a8\u4e2d\uff0c\u5236\u5b9a{0}\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\u3002", (String)"IndicatorGroupBasePlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{groupName}));
            return false;
        }
        return true;
    }

    private void addIndicatorArea() {
        String activityId = (String)this.getView().getFormShowParameter().getCustomParam("activityid");
        if (HRStringUtils.isEmpty((String)activityId)) {
            return;
        }
        DynamicObject assessForm = INDICATORGROUP_APPLICATION_SERVICE.queryAssessFormByActivityId(Long.valueOf(Long.parseLong(activityId)));
        if (assessForm == null) {
            return;
        }
        DynamicObjectCollection assTableConfOfRule = assessForm.getDynamicObjectCollection("areaconfentry");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("area", new Object[0]);
        vs.addField("areainstance", new Object[0]);
        vs.addField("areaconf", new Object[0]);
        for (DynamicObject assTableConf : assTableConfOfRule) {
            DynamicObject areaReg = assTableConf.getDynamicObject("areareg");
            Long areaRegId = areaReg.getLong("id");
            if (AssessRuleConstants.CUSTOM_AREA_PK.equals(areaRegId)) continue;
            Long areaInstanceId = INDICATORGROUP_APPLICATION_SERVICE.initIndicatorArea(areaReg, assTableConf.getLong("areaconf"));
            vs.addRow(new Object[]{areaReg.getLong("id"), areaInstanceId, assTableConf.getLong("areaconf")});
        }
        int[] rows = model.batchCreateNewEntryRow("indareaconfentry", vs);
        this.getView().updateView("indareaconfentry");
        model.setValue("activity", (Object)Long.parseLong(activityId));
        model.endInit();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if (SAVE.equals(key)) {
            this.getView().returnDataToParent(this.getModel().getDataEntity().getPkValue());
        }
    }
}

