/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.indicator;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.indicator.IndicatorGroupApplicationService;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.epa.formplugin.web.utils.AssignIndicatorPageUtils;

public class IndicatorGroupEditPlugin
extends HRDataBaseEdit
implements RowClickEventListener {
    private final IndicatorGroupApplicationService INDICATORGROUP_APPLICATION_SERVICE = IndicatorGroupApplicationService.getInstance();
    private static final String GUIDE_AP = "guideap";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"imptlap1"});
        this.addClickListeners(new String[]{GUIDE_AP});
    }

    public void click(EventObject evt) {
        super.click(evt);
        IFormView parentView = this.getView().getParentView().getParentView();
        if (parentView == null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"IndicatorGroupEditPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
            return;
        }
        Button source = (Button)evt.getSource();
        String key = source.getKey();
        if ("imptlap1".equals(key) && this.checkArea()) {
            this.showIndicatorImportStartView();
        } else if (GUIDE_AP.equals(key)) {
            this.showIndicatorGuideView();
        }
    }

    private void showIndicatorGuideView() {
        boolean notEdit = this.INDICATORGROUP_APPLICATION_SERVICE.isProcessOrDistrActevalObj(this.getModel().getDataEntity().getPkValue());
        FormShowParameter showParameter = new FormShowParameter();
        if (notEdit) {
            showParameter.setFormId("epa_indicatorguideview");
            showParameter.setStatus(OperationStatus.VIEW);
        } else {
            showParameter.setFormId("epa_indicatorguide");
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_indicatorguide"));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("indicatorguide");
        HashMap indGuide = Maps.newHashMapWithExpectedSize((int)entryEntity.size());
        for (DynamicObject dynamicObject : entryEntity) {
            indGuide.put(String.valueOf(dynamicObject.getString("locale.id")), dynamicObject.getString("indguide"));
        }
        showParameter.setHasRight(true);
        showParameter.setCustomParam("indguide", (Object)SerializationUtils.toJsonString((Object)indGuide));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        if (HRObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        String actionId = evt.getActionId();
        if ("epa_indicatorguide".equals(actionId)) {
            Map localeContent = (Map)SerializationUtils.fromJsonString((String)((String)returnData), Map.class);
            DynamicObjectCollection indicatorGuideEntry = this.getModel().getEntryEntity("indicatorguide");
            if (HRCollUtil.isEmpty((Collection)indicatorGuideEntry)) {
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                TableValueSetter vs = new TableValueSetter(new String[0]);
                vs.addField("locale", new Object[0]);
                vs.addField("indguide", new Object[0]);
                for (Map.Entry entry : localeContent.entrySet()) {
                    vs.addRow(new Object[]{entry.getKey(), entry.getValue()});
                }
                model.batchCreateNewEntryRow("indicatorguide", vs);
                this.getView().updateView("indicatorguide");
                model.endInit();
            } else {
                boolean isEntryDiff;
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                DynamicObjectCollection entryEntity = model.getEntryEntity("indicatorguide");
                boolean bl = isEntryDiff = entryEntity.size() != localeContent.size();
                if (!isEntryDiff) {
                    for (DynamicObject entry : entryEntity) {
                        String localeId = entry.getString("locale.id");
                        if (localeContent.containsKey(localeId)) {
                            entry.set("indguide", localeContent.get(localeId));
                            continue;
                        }
                        isEntryDiff = true;
                    }
                }
                if (isEntryDiff) {
                    model.deleteEntryData("indicatorguide");
                    TableValueSetter vs = new TableValueSetter(new String[0]);
                    vs.addField("locale", new Object[0]);
                    vs.addField("indguide", new Object[0]);
                    for (Map.Entry entry : localeContent.entrySet()) {
                        vs.addRow(new Object[]{entry.getKey(), entry.getValue()});
                    }
                    model.batchCreateNewEntryRow("indicatorguide", vs);
                }
                this.getView().updateView("indicatorguide");
                model.endInit();
            }
            this.getView().invokeOperation("save");
        }
    }

    private boolean checkArea() {
        String activityId = (String)this.getView().getFormShowParameter().getCustomParam("activityid");
        if (HRStringUtils.isEmpty((String)activityId)) {
            return false;
        }
        DynamicObject assessForm = this.INDICATORGROUP_APPLICATION_SERVICE.queryAssessFormByActivityId(Long.valueOf(Long.parseLong(activityId)));
        if (assessForm == null) {
            return false;
        }
        String groupName = AssignIndicatorPageUtils.getIndicatorGroupMetaName();
        if (this.INDICATORGROUP_APPLICATION_SERVICE.isProcessOrDistrActevalObj(this.getModel().getDataEntity().getPkValue())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5{0}\u5bf9\u5e94\u4eba\u5458\u5df2\u7ecf\u5f00\u542f\u5236\u5b9a\u6d41\u7a0b/\u7edf\u4e00\u6d3e\u53d1\uff0c\u4e0d\u53ef\u5bfc\u5165\u6307\u6807\u3002", (String)"IndicatorGroupEditPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{groupName}));
            return false;
        }
        return true;
    }

    private void showIndicatorImportStartView() {
        String activityId = (String)this.getView().getFormShowParameter().getCustomParam("activityid");
        if (HRStringUtils.isEmpty((String)activityId)) {
            return;
        }
        DynamicObject assessForm = this.INDICATORGROUP_APPLICATION_SERVICE.queryAssessFormByActivityId(Long.valueOf(Long.parseLong(activityId)));
        if (assessForm == null) {
            return;
        }
        DynamicObject scoresystem = assessForm.getDynamicObject("scoresystem");
        String scoreCalcway = assessForm.getString("scorecalcway");
        BigDecimal maxScore = scoresystem.getBigDecimal("maxscore");
        BigDecimal minScore = scoresystem.getBigDecimal("minscore");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_indicatorimportstart");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("indicatorgroupid", this.getModel().getDataEntity().getPkValue());
        showParameter.setCustomParam("numaccuracy", (Object)assessForm.getString("numaccuracy"));
        showParameter.setCustomParam("scorecalcway", (Object)scoreCalcway);
        showParameter.setCustomParam("maxscore", (Object)maxScore);
        showParameter.setCustomParam("minscore", (Object)minScore);
        showParameter.setCustomParam("isgroup", (Object)true);
        this.getView().showForm(showParameter);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.showIndAreaView();
        this.getView().getParentView().getPageCache().put("indicatorgroupeditpageid", this.getView().getPageId());
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        if (this.INDICATORGROUP_APPLICATION_SERVICE.isProcessOrDistrActevalObj(this.getModel().getDataEntity().getPkValue())) {
            Label guideLabel = (Label)this.getView().getControl(GUIDE_AP);
            guideLabel.setText(ResManager.loadKDString((String)"\u67e5\u770b\u6307\u6807\u586b\u5199\u6307\u5f15", (String)"IndicatorGroupEditPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"imptlap1"});
        }
    }

    private void showIndAreaView() {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        String activityId = (String)this.getView().getFormShowParameter().getCustomParam("activityid");
        if (HRStringUtils.isEmpty((String)activityId)) {
            return;
        }
        DynamicObject assessForm = this.INDICATORGROUP_APPLICATION_SERVICE.queryAssessFormByActivityId(Long.valueOf(Long.parseLong(activityId)));
        if (assessForm == null) {
            return;
        }
        DynamicObject scoresystem = assessForm.getDynamicObject("scoresystem");
        String scoreCalcway = assessForm.getString("scorecalcway");
        long maxscore = scoresystem.getLong("maxscore");
        long minscore = scoresystem.getLong("minscore");
        String scoreSystemName = scoresystem.getString("name");
        Label scoreSystemLabel = (Label)this.getControl("scoresystem");
        Label scoreCalcWayLabel = (Label)this.getControl("scorecalcway");
        scoreSystemLabel.setText(scoreSystemName);
        scoreCalcWayLabel.setText(ScoreCalcWayEnum.getScoreCalcWay((String)scoreCalcway).getText());
        this.getModel().setValue("maxscore", (Object)maxscore);
        this.getModel().setValue("minscore", (Object)minscore);
        DynamicObjectCollection areaConfEntry = billObj.getDynamicObjectCollection("indareaconfentry");
        FlexPanelAp areaFlex = new HRFlexPanelAp.Builder("areaflex").setDirection("column").setAlignItems("stretch").setJustifyContent("flex-start").setWrap(false).setGrow(0).setShrink(1).build();
        for (int i = 0; i < areaConfEntry.size(); ++i) {
            String areaItem = "areaitemflex" + i;
            FlexPanelAp tableItemAp = new HRFlexPanelAp.Builder(areaItem).setGrow(0).setShrink(1).build();
            areaFlex.getItems().add(tableItemAp);
            Long confId = ((DynamicObject)areaConfEntry.get(i)).getLong("areaconf");
            Long areaInstanceId = ((DynamicObject)areaConfEntry.get(i)).getLong("areainstance");
            DynamicObject areaReg = ((DynamicObject)areaConfEntry.get(i)).getDynamicObject("area");
            Long areaRegId = areaReg.getLong("id");
            if (areaRegId.equals(AssessRuleConstants.NORM_INDCTR_AREA_PK)) {
                this.showAreaInstanceView(assessForm, areaItem, confId, areaInstanceId, "epa_genareainstance");
                continue;
            }
            if (areaRegId.equals(AssessRuleConstants.PLUS_MINUS_AREA_PK)) {
                this.showAreaInstanceView(assessForm, areaItem, confId, areaInstanceId, "epa_addsubareains");
                continue;
            }
            if (!areaRegId.equals(AssessRuleConstants.ATTACH_AREA_PK)) continue;
            this.showAreaInstanceView(assessForm, areaItem, confId, areaInstanceId, "epa_attachareains");
        }
        this.getView().updateControlMetadata(areaFlex.getKey(), areaFlex.createControl());
    }

    private void showAreaInstanceView(DynamicObject ruleDy, String areaItem, Long confId, Long areaInstanceId, String pageId) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(pageId);
        showParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        showParameter.setPkId((Object)areaInstanceId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(areaItem);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, pageId));
        showParameter.setCustomParam("confid", (Object)confId);
        showParameter.setCustomParam("scorecalcway", (Object)ruleDy.getString("scorecalcway"));
        showParameter.setCustomParam("consistentwitharea", (Object)ruleDy.getString("consistentwitharea"));
        showParameter.setCustomParam("evalway", (Object)ruleDy.getString("evalway"));
        showParameter.setCustomParam("numaccuracy", (Object)ruleDy.getString("numaccuracy"));
        showParameter.setCustomParam("evasumlimit", (Object)ruleDy.getString("evasumlimit"));
        if (ruleDy.getBigDecimal("limitmaxratio") != null) {
            showParameter.setCustomParam("limitmaxratio", (Object)ruleDy.getBigDecimal("limitmaxratio").toString());
        }
        showParameter.setCustomParam("indicatorgroup", this.getModel().getDataEntity().getPkValue());
        showParameter.setCustomParam("scoresystem", (Object)ruleDy.getDynamicObject("scoresystem").getLong("id"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"closeView")) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Yes == result) {
                this.getView().getParentView().close();
                this.getView().sendFormAction(this.getView().getParentView());
            }
            return;
        }
    }
}

