/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.indicator;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.indicator.IndicatorGroupApplicationService;
import kd.opmc.epa.formplugin.web.activity.AssessActivityConfEdit;
import kd.opmc.epa.formplugin.web.activitymanage.targetformulate.FormulateBaseEdit;
import kd.opmc.epa.formplugin.web.utils.AssignIndicatorPageUtils;
import kd.opmc.pbs.common.utils.OpmcPermissionUtils;

public class IndicatorGroupSetEditPlugin
extends FormulateBaseEdit
implements RowClickEventListener {
    private static final Log LOG = LogFactory.getLog(AssessActivityConfEdit.class);
    private static final IndicatorGroupApplicationService Indicator_Group_Application_Service = IndicatorGroupApplicationService.getInstance();
    private static final AssessActivityApplicationService service = AssessActivityApplicationService.getInstance();
    private static final String LAST_SELECT_ROW = "lastSelectRow";
    private static final String LAST_SELECT_RANK = "lastSelectRank";
    private static final String ASS_GROUP_CHANGE_TAG = "assGroupChangeTag";
    private static final String BLANK_LAP = "blanklap";
    private static final String ENTRY_LAP = "entrylap";
    private static final String NEW_INDICATOR_GROUP = "newindicatorgroup";
    private static final String NEW_IND = "newind";
    private static final String COPY_INDICATOR_GROUP = "copyindicatorgroup";
    private static final String COPY_IND = "copyind";
    private static final String EDIT_INDICATOR_GROUP = "editindicatorgroup";
    private static final String IS_SELECT_ROW = "isselectrow";
    private static final String IS_SELECT_RANK = "isselectrank";
    private static final String EDIT = "edit";
    private static final String DONOTHING_EDIT = "donothing_edit";
    private static final String DELETE = "delete";
    private static final String DONOTHING_DELETE = "donothing_delete";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry assGroupEntry = (CardEntry)this.getView().getControl("indicatorgroupentry");
        assGroupEntry.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{NEW_INDICATOR_GROUP, COPY_INDICATOR_GROUP, NEW_IND, COPY_IND});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activityid");
        if (activityId == null || 0L == activityId) {
            return;
        }
        DynamicObject[] indicatorGroups = Indicator_Group_Application_Service.queryIndicatorGroups("name,description,activity", new QFilter[]{new QFilter("activity", "=", (Object)activityId)}, "createtime");
        List<Long> indicatorGroupsGroupIds = Arrays.stream(indicatorGroups).map(item -> item.getLong("id")).collect(Collectors.toList());
        this.addIndicatorGroup(indicatorGroupsGroupIds);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.selectIndGroupOf(0);
    }

    private void selectIndPeriodOfFirst() {
        DynamicObjectCollection indPeriodEntry = this.getModel().getEntryEntity("indperiodentry");
        if (!ObjectUtils.isEmpty((Object)indPeriodEntry)) {
            CardEntry assGroupCard = (CardEntry)this.getControl("indperiodentry");
            assGroupCard.selectCard(Integer.valueOf(0));
        } else {
            this.getView().getPageCache().remove(LAST_SELECT_ROW);
        }
    }

    private void selectIndGroupOf(int row) {
        DynamicObjectCollection assGroupEntry = this.getModel().getEntryEntity("indicatorgroupentry");
        if (!ObjectUtils.isEmpty((Object)assGroupEntry)) {
            CardEntry assGroupCard = (CardEntry)this.getControl("indicatorgroupentry");
            assGroupCard.selectCard(Integer.valueOf(row));
            this.getView().setVisible(Boolean.FALSE, new String[]{BLANK_LAP});
            this.getView().setVisible(Boolean.TRUE, new String[]{ENTRY_LAP, NEW_INDICATOR_GROUP, COPY_INDICATOR_GROUP});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{BLANK_LAP});
            this.getView().setVisible(Boolean.FALSE, new String[]{ENTRY_LAP, NEW_INDICATOR_GROUP, COPY_INDICATOR_GROUP});
        }
    }

    private void addCustomOp(List<Map<String, String>> opData, String opKey, String opName) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("key", opName);
        map.put("value", opKey);
        opData.add(map);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void click(EventObject evt) {
        Long activityId;
        super.click(evt);
        if (ObjectUtils.isEmpty((Object)super.getParentViewPageCache())) {
            return;
        }
        Button source = (Button)evt.getSource();
        String opKey = source.getKey();
        String groupName = AssignIndicatorPageUtils.getIndicatorGroupMetaName();
        if (opKey.contains(NEW_INDICATOR_GROUP) || opKey.contains(NEW_IND)) {
            activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activityid");
            this.showIndicatorGroup(null, OperationStatus.ADDNEW, NEW_INDICATOR_GROUP, activityId.toString(), ResManager.loadKDString((String)"\u65b0\u589e{0}", (String)"IndicatorGroupSetEditPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[]{groupName}));
        }
        if (opKey.contains(COPY_INDICATOR_GROUP) || opKey.contains(COPY_IND)) {
            activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activityid");
            DynamicObject dynamicObject = service.queryOne((Object)activityId);
            QFilter qFilter = new QFilter("activity.scheme", "=", (Object)dynamicObject.getLong("scheme.id"));
            ListShowParameter listShowParameter = this.openF7("epa_indicatorgroup", "bos_listf7");
            listShowParameter.getListFilterParameter().setFilter(qFilter);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, COPY_INDICATOR_GROUP));
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u590d\u5236\u5176\u4ed6{0}", (String)"IndicatorGroupSetEditPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{groupName}));
            this.getView().showForm((FormShowParameter)listShowParameter);
            DynamicObject[] indicatorGroups = Indicator_Group_Application_Service.queryIndicatorGroups("name,description,activity", new QFilter[]{qFilter}, "activity.period");
            Map<String, String> idNameMap = Arrays.stream(indicatorGroups).collect(Collectors.toMap(key -> key.getString("id"), value -> value.getString("name")));
            IHRAppCache cache = HRAppCache.get((String)"epa");
            cache.put(this.getView().getPageId(), idNameMap);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        if (ObjectUtils.isEmpty((Object)super.getParentViewPageCache())) {
            return;
        }
        Object source = evt.getSource();
        if (source instanceof CardEntry && HRStringUtils.equals((String)"indicatorgroupentry", (String)((CardEntry)source).getKey())) {
            int lastSelectRow;
            int row = evt.getRow();
            String lastSelectRowStr = this.getView().getPageCache().get(LAST_SELECT_ROW);
            if (!ObjectUtils.isEmpty((Object)lastSelectRowStr) && (lastSelectRow = Integer.parseInt(lastSelectRowStr)) == row) {
                return;
            }
            evt.getSource();
            DynamicObjectCollection assGroupEntry = this.getModel().getEntryEntity("indicatorgroupentry");
            for (int i = 0; i < assGroupEntry.size(); ++i) {
                this.getView().getModel().setValue(IS_SELECT_ROW, (Object)Boolean.FALSE, i);
                DynamicObject assGroup = ((DynamicObject)assGroupEntry.get(i)).getDynamicObject("indicatorgroup");
                if (assGroup != null && row == i && Indicator_Group_Application_Service.isProcessOrDistrActevalObj(assGroup.getPkValue())) {
                    this.getView().getModel().setValue("isview", (Object)Boolean.TRUE, i);
                    continue;
                }
                this.getView().getModel().setValue("isview", (Object)Boolean.FALSE, i);
            }
            this.getView().getModel().setValue(IS_SELECT_ROW, (Object)Boolean.TRUE, row);
            IDataModel entryOperate = this.getModel();
            DynamicObject entryRowEntity = entryOperate.getEntryRowEntity("indicatorgroupentry", row);
            DynamicObject indicatorGroup = entryRowEntity.getDynamicObject("indicatorgroup");
            DynamicObject indicatorGroupFromDB = Indicator_Group_Application_Service.queryIndicatorGroup(indicatorGroup.getPkValue());
            DynamicObject activity = indicatorGroupFromDB.getDynamicObject("activity");
            String activityId = null == activity ? null : activity.getString("id");
            this.showIndicatorGroupView(indicatorGroup.getPkValue(), activityId, entryRowEntity.getBoolean("isview"));
            this.getModel().setDataChanged(false);
            this.getView().getPageCache().put(LAST_SELECT_ROW, String.valueOf(row));
        }
    }

    private void showIndicatorGroupView(Object pkId, String activityId, boolean isView) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("epa_indicatorgroup");
        showParameter.setPkId(pkId);
        if (isView) {
            showParameter.setStatus(OperationStatus.VIEW);
        } else {
            showParameter.setStatus(OperationStatus.EDIT);
        }
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("indgroupflex");
        showParameter.setCustomParam("activityid", (Object)activityId);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private ListShowParameter openF7(String billFormId, String f7FormId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setBillFormId(billFormId);
        showParameter.setFormId(f7FormId);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(false);
        showParameter.setShowTitle(false);
        return showParameter;
    }

    private int[] addIndicatorGroup(List<Long> indGroupIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("indicatorgroup", new Object[0]);
        for (Long indGroupId : indGroupIds) {
            vs.addRow(new Object[]{indGroupId});
        }
        int[] rows = model.batchCreateNewEntryRow("indicatorgroupentry", vs);
        this.getView().updateView("indicatorgroupentry");
        model.endInit();
        this.getView().getPageCache().put(ASS_GROUP_CHANGE_TAG, "true");
        return rows;
    }

    private int[] refreshIndicatorGroup(List<Long> indicatorGroupIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.deleteEntryData("indicatorgroupentry");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("indicatorgroup", new Object[0]);
        for (Long indicatorGroupId : indicatorGroupIds) {
            vs.addRow(new Object[]{indicatorGroupId});
        }
        int[] rows = model.batchCreateNewEntryRow("indicatorgroupentry", vs);
        this.getView().updateView("indicatorgroupentry");
        model.endInit();
        this.getView().getPageCache().put(ASS_GROUP_CHANGE_TAG, "true");
        return rows;
    }

    private int[] addIndicatorPeriod(List<Long> activityIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("activity", new Object[0]);
        for (Long activityId : activityIds) {
            vs.addRow(new Object[]{activityId});
        }
        int[] ranks = model.batchCreateNewEntryRow("indperiodentry", vs);
        this.getView().updateView("indperiodentry");
        model.endInit();
        return ranks;
    }

    private void showIndicatorGroup(Object pkId, OperationStatus operationStatus, String closeCallBack, String activityId, String caption) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setPkId(pkId);
        showParameter.setFormId("epa_indicatorgroup_base");
        showParameter.setStatus(operationStatus);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("activityid", (Object)activityId);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBack));
        showParameter.setCaption(caption);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"closeView")) {
            this.getView().getPageCache().remove("isShowProcessTip");
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Yes == result) {
                this.getView().close();
            }
            return;
        }
        if (HRStringUtils.equals((String)callBackId, (String)DONOTHING_DELETE)) {
            OperateOption delOp = OperateOption.create();
            delOp.setVariableValue("systeminvoke", "true");
            this.getView().invokeOperation(DONOTHING_DELETE, delOp);
        }
    }

    protected boolean checkGroupActivityPermission() {
        boolean isPass = OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_activity", (String)"37LTQSOQE94P");
        if (!isPass) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8003\u6838\u6d3b\u52a8\u7684\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u6743\u9650", (String)"IndicatorGroupSetEditPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
        return isPass;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "newindicatorgroup": {
                if (!(returnData instanceof Long)) break;
                this.addIndicatorGroup(Collections.singletonList((Long)returnData));
                IDataModel entryOperate = this.getModel();
                DynamicObjectCollection entryEntity = entryOperate.getEntryEntity("indicatorgroupentry");
                if (entryEntity.size() > 0) {
                    this.selectIndGroupOf(entryEntity.size() - 1);
                }
                this.getView().invokeOperation("donothing_new");
                break;
            }
            case "copyindicatorgroup": {
                IHRAppCache cache = HRAppCache.get((String)"epa");
                if (returnData instanceof ListSelectedRowCollection) {
                    String title;
                    if (!this.checkGroupActivityPermission()) {
                        return;
                    }
                    ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)returnData;
                    List ids = listSelectedRowCollection.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
                    Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activityid");
                    DynamicObject[] indicatorGroups = Indicator_Group_Application_Service.queryIndicatorGroups("name,description,activity", new QFilter[]{new QFilter("activity", "=", (Object)activityId)}, "createtime");
                    Set isExistNames = Arrays.stream(indicatorGroups).map(item -> item.getString("name")).collect(Collectors.toSet());
                    Object[] selectIndicatorGroups = Indicator_Group_Application_Service.queryIndicatorGroups(ids);
                    if (HRArrayUtils.isEmpty((Object[])selectIndicatorGroups)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u88ab\u5220\u9664\uff0c\u4e0d\u53ef\u590d\u5236\u3002", (String)"IndicatorGroupSetEditPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    Tuple tuple = Indicator_Group_Application_Service.copyIndicatorGroup((DynamicObject)selectIndicatorGroups[0], isExistNames, activityId);
                    List msgList = (List)tuple.item2;
                    boolean copyResult = true;
                    if (HRObjectUtils.equals((Object)tuple.item1, (Object)0L)) {
                        copyResult = false;
                    } else {
                        List<Object> longs = Collections.singletonList(tuple.item1);
                        this.addIndicatorGroup(longs);
                        IDataModel entryOperate = this.getModel();
                        DynamicObjectCollection entryEntity = entryOperate.getEntryEntity("indicatorgroupentry");
                        if (entryEntity.size() > 0) {
                            this.selectIndGroupOf(entryEntity.size() - 1);
                        }
                    }
                    if (ids.size() > selectIndicatorGroups.length) {
                        List collect = Arrays.stream(selectIndicatorGroups).map(item -> item.getString("id")).collect(Collectors.toList());
                        Map idNameMap = (Map)cache.get(this.getView().getPageId(), Map.class);
                        StringBuilder builder = new StringBuilder();
                        for (Object id : ids) {
                            String strId = id.toString();
                            if (collect.contains(strId)) continue;
                            String name = (String)idNameMap.get(strId);
                            builder.append("\u201c").append(name).append("\u201d").append("\uff0c");
                        }
                        if (builder.toString().length() > 0) {
                            msgList.add(ResManager.loadKDString((String)"\u8be5{0}\u5df2\u88ab\u5220\u9664\uff0c\u4e0d\u53ef\u590d\u5236\u3002", (String)"IndicatorGroupSetEditPlugin_10", (String)"opmc-epa-formplugin", (Object[])new Object[]{builder.toString().substring(0, builder.toString().length() - 1)}));
                        }
                    }
                    if (copyResult) {
                        title = ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"IndicatorGroupSetEditPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                        if (msgList == null || msgList.isEmpty()) {
                            this.getView().showSuccessNotification(title);
                        } else {
                            this.getView().showMessage(title, String.join((CharSequence)"\n", msgList), MessageTypes.Default);
                        }
                    } else {
                        title = ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\u3002", (String)"IndicatorGroupSetEditPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                        if (msgList == null || msgList.isEmpty()) {
                            this.getView().showErrorNotification(title);
                        } else {
                            this.getView().showMessage(title, String.join((CharSequence)"\n", msgList), MessageTypes.Default);
                        }
                    }
                    this.getView().invokeOperation("donothing_copy");
                }
                cache.remove(this.getView().getPageId());
                break;
            }
            case "editindicatorgroup": {
                if (returnData == null) {
                    return;
                }
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("systeminvoke", "true");
                this.getView().invokeOperation(DONOTHING_EDIT, operateOption);
                String lastSelectRowStr = this.getView().getPageCache().get(LAST_SELECT_ROW);
                this.updateIndicatorGroup((Long)returnData, Integer.parseInt(lastSelectRowStr));
                break;
            }
        }
    }

    private void updateIndicatorGroup(Long indGroupId, int row) {
        IDataModel entryOperate = this.getModel();
        DynamicObject entryRowEntity = entryOperate.getEntryRowEntity("indicatorgroupentry", row);
        DynamicObject indicatorGroup = Indicator_Group_Application_Service.queryIndicatorGroup((Object)indGroupId);
        entryRowEntity.set("indicatorgroup", (Object)indicatorGroup);
        this.getView().updateView("indicatorgroupentry");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        int entryCurrentRowIndex;
        super.beforeDoOperation(args);
        String isShowProcessTip = this.getView().getPageCache().get("isShowProcessTip");
        if (this.getView().getParentView() == null) {
            if (!HRStringUtils.equals((String)isShowProcessTip, (String)"true")) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"IndicatorGroupSetEditPlugin_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
                this.getView().getPageCache().put("isShowProcessTip", "true");
            }
            args.setCancel(true);
            return;
        }
        FormOperate source = (FormOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        IDataModel entryOperate = this.getModel();
        DynamicObject entryRowEntity = entryOperate.getEntryRowEntity("indicatorgroupentry", entryCurrentRowIndex = entryOperate.getEntryCurrentRowIndex("indicatorgroupentry"));
        if (entryRowEntity == null) {
            return;
        }
        DynamicObject indicatorGroup = entryRowEntity.getDynamicObject("indicatorgroup");
        String groupName = AssignIndicatorPageUtils.getIndicatorGroupMetaName();
        switch (source.getOperateKey()) {
            case "donothing_edit": {
                if (HRStringUtils.equals((String)systemInvoke, (String)"true")) {
                    return;
                }
                if (Indicator_Group_Application_Service.isProcessOrDistrActevalObj(indicatorGroup.getPkValue())) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5{0}\u5bf9\u5e94\u4eba\u5458\u5df2\u7ecf\u5f00\u542f\u5236\u5b9a\u6d41\u7a0b/\u7edf\u4e00\u6d3e\u53d1\uff0c\u4e0d\u53ef\u7f16\u8f91{1}\u3002", (String)"IndicatorGroupSetEditPlugin_11", (String)"opmc-epa-formplugin", (Object[])new Object[]{groupName, groupName}));
                    args.setCancel(true);
                    return;
                }
                this.showIndicatorGroup(indicatorGroup.getPkValue(), OperationStatus.EDIT, EDIT_INDICATOR_GROUP, null, ResManager.loadKDString((String)"\u7f16\u8f91{0}", (String)"IndicatorGroupSetEditPlugin_8", (String)"opmc-epa-formplugin", (Object[])new Object[]{groupName}));
                args.setCancel(true);
                break;
            }
            case "donothing_delete": {
                if (this.delBeforeOp(args)) {
                    return;
                }
                if (Indicator_Group_Application_Service.isRefActevalObj(indicatorGroup.getPkValue())) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5{0}\u5df2\u7ecf\u88ab\u6307\u5b9a\u7ed9\u5236\u5b9a\u5bf9\u8c61\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"IndicatorGroupSetEditPlugin_12", (String)"opmc-epa-formplugin", (Object[])new Object[]{groupName}));
                    args.setCancel(true);
                    return;
                }
                Indicator_Group_Application_Service.deleteIndicatorGroup(indicatorGroup);
                this.getModel().deleteEntryRow("indicatorgroupentry", entryCurrentRowIndex);
                this.getView().getPageCache().remove(LAST_SELECT_ROW);
                if (entryCurrentRowIndex > 0) {
                    this.selectIndGroupOf(entryCurrentRowIndex - 1);
                    break;
                }
                this.selectIndGroupOf(0);
                String indicatorgroupeditpageid = this.getView().getPageCache().get("indicatorgroupeditpageid");
                IFormView indicatorGroupEditView = this.getView().getView(indicatorgroupeditpageid);
                indicatorGroupEditView.getModel().setDataChanged(false);
                indicatorGroupEditView.close();
                this.getView().sendFormAction(indicatorGroupEditView);
                break;
            }
        }
    }

    private boolean delBeforeOp(BeforeDoOperationEventArgs args) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        if (!HRStringUtils.equals((String)systemInvoke, (String)"true")) {
            String msg = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u6307\u6807\u5206\u7ec4\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c \u786e\u5b9a\u8981\u5220\u9664\u8be5\u6307\u6807\u5206\u7ec4\u5417\uff1f", (String)"IndicatorGroupSetEditPlugin_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DONOTHING_DELETE, (IFormPlugin)this));
            args.setCancel(true);
            return true;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }
}

