/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.indicator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.container.Tab;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.lang.Lang;
import kd.bos.metadata.form.container.TabPageAp;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class IndicatorGuidePlugin
extends HRDataBaseEdit
implements TabSelectListener {
    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Tab tab = (Tab)this.getView().getControl("tabap");
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.setLocale();
        this.getModel().setDataChanged(false);
    }

    private void setLocale() {
        String indGuide = (String)this.getView().getFormShowParameter().getCustomParam("indguide");
        this.getPageCache().put("LocaleContent", indGuide);
        Map localeContent = (Map)SerializationUtils.fromJsonString((String)indGuide, Map.class);
        RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl("indguidetext");
        InteServiceImpl intService = new InteServiceImpl();
        List enabledLangList = intService.getEnabledLang();
        Tab tab = (Tab)this.getView().getControl("tabap");
        ArrayList items = Lists.newArrayListWithExpectedSize((int)enabledLangList.size());
        for (EnabledLang enabledLang : enabledLangList) {
            TabPageAp tabPageAp = new TabPageAp();
            String langId = enabledLang.getId();
            tabPageAp.setKey(langId);
            tabPageAp.setName(new LocaleString(enabledLang.getName()));
            Map tabPageMap = tabPageAp.createControl();
            tabPageMap.put(langId, tabPageAp);
            items.add(tabPageMap);
            if (!Lang.get().name().equals(enabledLang.getNumber())) continue;
            if (tab == null) {
                richTextEditor.setText((String)localeContent.get(langId));
                return;
            }
            tab.activeTab(langId);
            richTextEditor.setText((String)localeContent.get(langId));
        }
        tab.addControls((List)items);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("confirm".equals(operateKey)) {
            RichTextEditor edit = (RichTextEditor)this.getView().getControl("indguidetext");
            String pageCache = this.getPageCache().get("LocaleContent");
            if (HRStringUtils.isNotEmpty((String)pageCache)) {
                Map localeContent = (Map)SerializationUtils.fromJsonString((String)pageCache, Map.class);
                Tab tab = (Tab)this.getView().getControl("tabap");
                String locale = tab.getCurrentTab();
                localeContent.put(locale, edit.getText());
                this.getView().getPageCache().put("LocaleContent", SerializationUtils.toJsonString((Object)localeContent));
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)localeContent));
            } else if (HRStringUtils.isNotEmpty((String)edit.getText())) {
                HashMap localeContent = Maps.newHashMapWithExpectedSize((int)4);
                Tab tab = (Tab)this.getView().getControl("tabap");
                String locale = tab.getCurrentTab();
                localeContent.put(locale, edit.getText());
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)localeContent));
            }
            this.getView().close();
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String oldKey = this.getPageCache().get("old_tab");
        if (!HRStringUtils.isEmpty((String)oldKey)) {
            String tabKey = tabSelectEvent.getTabKey();
            String contentCache = this.getPageCache().get("LocaleContent");
            HashMap localeContent = Objects.nonNull(contentCache) ? (Map)SerializationUtils.fromJsonString((String)contentCache, Map.class) : Maps.newHashMapWithExpectedSize((int)4);
            RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl("indguidetext");
            String oldContentText = richTextEditor.getText();
            localeContent.put(oldKey, oldContentText);
            this.getView().getPageCache().put("LocaleContent", SerializationUtils.toJsonString((Object)localeContent));
            Object text = localeContent.get(tabKey);
            if (!HRObjectUtils.isEmpty(text)) {
                richTextEditor.setText((String)text);
            } else {
                richTextEditor.setText(null);
            }
        }
        this.getPageCache().put("old_tab", tabSelectEvent.getTabKey());
    }
}

