/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.intactivity;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.TextColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.mutex.DataMutex;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.opmc.epa.business.application.service.interview.InterviewActivityConfApplication;
import kd.opmc.epa.business.domain.intactivity.enums.InterviewActivityStatus;
import kd.opmc.epa.business.domain.interview.enums.InterActStatusEnum;
import kd.opmc.epa.business.task.StartIntActivityTask;
import kd.opmc.epa.business.utils.InterViewObjUtils;
import kd.opmc.epa.formplugin.web.utils.ActivityDispatchUtils;
import kd.opmc.epa.formplugin.web.utils.IntActivityUtils;

public class IntActivityConfList
extends HRDataBaseList {
    private static final InterviewActivityConfApplication INTERVIEW_ACTIVITY_CONF_APPLICATION = InterviewActivityConfApplication.getInstance();
    private static final String START_UP_ACTIVITY = "startupactivity";
    private static final String END_ACTIVITY = "endactivity";
    private static final String ALL = "all";
    private static final String JOINED = "joined";
    private static final String HAVE_IN_HAND = "haveinhand";
    private static final String COMPLETED = "completed";
    private static final String DELETE = "delete";
    private static final String END_ACTIVITY_EXECUTE = "end_activity_execute";
    private Map<Long, Map<String, Integer>> INTER_OBJ_STATUS_MAP = new HashMap<Long, Map<String, Integer>>();

    public void beforePackageData(BeforePackageDataEvent event) {
        DynamicObjectCollection pageData = event.getPageData();
        List longList = pageData.stream().filter(dyc -> !InterActStatusEnum.TO_BE.getCode().equals(dyc.getString("activitystatus"))).map(dyc -> dyc.getLong("id")).collect(Collectors.toList());
        this.INTER_OBJ_STATUS_MAP = INTERVIEW_ACTIVITY_CONF_APPLICATION.queryCountByInteractId(longList);
    }

    public void packageData(PackageDataEvent event) {
        Object source = event.getSource();
        if (source instanceof TextColumnDesc && !ObjectUtils.isEmpty(this.INTER_OBJ_STATUS_MAP)) {
            TextColumnDesc columnDesc = (TextColumnDesc)source;
            Map<String, Integer> resultMap = this.INTER_OBJ_STATUS_MAP.get(event.getRowData().getLong("id"));
            if (!ObjectUtils.isEmpty(resultMap)) {
                switch (columnDesc.getKey()) {
                    case "all": {
                        event.setFormatValue((Object)resultMap.get(ALL));
                        break;
                    }
                    case "joined": {
                        event.setFormatValue((Object)resultMap.get("not_started"));
                        break;
                    }
                    case "haveinhand": {
                        event.setFormatValue((Object)resultMap.get("have_in_hand"));
                        break;
                    }
                    case "completed": {
                        event.setFormatValue((Object)resultMap.get(COMPLETED));
                        break;
                    }
                }
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        switch (fieldName = args.getFieldName()) {
            case "name": {
                args.setCancel(true);
                if (this.checkMutex()) {
                    return;
                }
                if (!InterViewObjUtils.checkInterViewProcessPermission((IFormView)this.getView())) {
                    return;
                }
                this.showProcessManagePage();
                break;
            }
        }
    }

    private void showProcessManagePage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("epa_interviewprocess");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setCustomParam("interact", (Object)((Long)this.getFocusRowPkId()));
        formShowParameter.setPageId(this.getView().getPageId() + this.getView().getFormShowParameter().getAppId() + this.getFocusRowPkId());
        String activityName = ((BillList)this.getControl("billlistap")).getCurrentSelectedRowInfo().getName();
        String caption = String.format(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406-%s", (String)"IntActivityConfList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), activityName);
        formShowParameter.setCaption(caption);
        this.getView().showForm(formShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "startupactivity": {
                if (!InterViewObjUtils.checkInterViewStartPermission((IFormView)this.getView())) {
                    args.setCancel(true);
                    return;
                }
                this.startUpActivity(args);
                break;
            }
            case "delete": {
                if (!InterViewObjUtils.checkInterViewDelPermission((IFormView)this.getView())) {
                    args.setCancel(true);
                    return;
                }
                ListSelectedRowCollection col = this.getSelectedRows();
                if (col.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"IntActivityConfList_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObject[] dynamicObjects = INTERVIEW_ACTIVITY_CONF_APPLICATION.queryInterviewByPkValue(col.getPrimaryKeyValues());
                List longList = Arrays.stream(col.getPrimaryKeyValues()).map(row -> Long.parseLong(row.toString())).collect(Collectors.toList());
                Map countByInteractId = INTERVIEW_ACTIVITY_CONF_APPLICATION.queryCountByInteractId(longList);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    Map integerMap;
                    String activityStatus = dynamicObject.getString("activitystatus");
                    if (HRStringUtils.equals((String)activityStatus, (String)InterviewActivityStatus.JOINED.getStatus()) || countByInteractId == null || (integerMap = (Map)countByInteractId.get(dynamicObject.getLong("id"))) == null || integerMap.get(ALL) == null || (Integer)integerMap.get(ALL) <= 0) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9762\u8c08\u6d3b\u52a8\u4e2d\u5df2\u6709\u53c2\u4e0e\u4eba\uff0c\u4e0d\u652f\u6301\u5220\u9664", (String)"IntActivityConfList_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                break;
            }
            case "endactivity": {
                if (!InterViewObjUtils.checkInterViewEndPermission((IFormView)this.getView())) {
                    args.setCancel(true);
                    return;
                }
                this.beforeEndActivity(args);
                break;
            }
        }
    }

    private void startUpActivity(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection col = this.getSelectedRows();
        if (this.isNotOnlyOneSelect(col)) {
            return;
        }
        DynamicObject interActivity = INTERVIEW_ACTIVITY_CONF_APPLICATION.queryOne((Long)col.getPrimaryKeyValues()[0]);
        if (HRObjectUtils.isEmpty((Object)interActivity)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9762\u8c08\u6d3b\u52a8\u5df2\u5220\u9664", (String)"IntActivityConfList_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        } else if (!HRStringUtils.equals((String)interActivity.getString("activitystatus"), (String)InterActStatusEnum.TO_BE.getCode())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u542f\u52a8\u72b6\u6001\u4e3a\u201c\u5f85\u6267\u884c\u201d\u7684\u6570\u636e", (String)"IntActivityConfList_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void beforeEndActivity(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (HRStringUtils.isEmpty((String)this.getPageCache().get(END_ACTIVITY_EXECUTE))) {
            this.endActivityCheck();
            args.setCancel(true);
        }
    }

    private void endActivityCheck() {
        ListSelectedRowCollection col = this.getSelectedRows();
        DynamicObject assessActivity = INTERVIEW_ACTIVITY_CONF_APPLICATION.queryOne((Long)col.getPrimaryKeyValues()[0]);
        if (this.isNotOnlyOneSelect(col) || HRObjectUtils.isEmpty((Object)assessActivity)) {
            return;
        }
        if (!HRStringUtils.equals((String)assessActivity.getString("activitystatus"), (String)"20")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u7ed3\u675f\u72b6\u6001\u4e3a\u201c\u6267\u884c\u4e2d\u201d\u7684\u9762\u8c08\u6d3b\u52a8", (String)"IntActivityConfList_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.refreshActivityList();
        } else if (INTERVIEW_ACTIVITY_CONF_APPLICATION.checkEndIntStatus((Long)col.getPrimaryKeyValues()[0])) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6d3b\u52a8\u4e2d\u8fd8\u6709\u672a\u5b8c\u6210\u7684\u9762\u8c08\u4efb\u52a1\uff0c\u6682\u4e0d\u652f\u6301\u7ed3\u675f\u9762\u8c08\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"IntActivityConfList_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.refreshActivityList();
        } else if (!INTERVIEW_ACTIVITY_CONF_APPLICATION.isExistsIntObj((Long)col.getPrimaryKeyValues()[0])) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9762\u8c08\u6d3b\u52a8\u4e2d\u65e0\u53c2\u4e0e\u9762\u8c08\u7684\u8bc4\u4f30\u5bf9\u8c61\uff0c\u662f\u5426\u7ee7\u7eed\u7ed3\u675f\uff1f", (String)"IntActivityConfList_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(END_ACTIVITY, (IFormPlugin)this));
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9762\u8c08\u6d3b\u52a8\u5c06\u7ed3\u675f\uff0c\u7ee7\u7eed\u7ed3\u675f\u5417\uff1f", (String)"IntActivityConfList_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(END_ACTIVITY, (IFormPlugin)this));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        boolean isSuccess;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        ListSelectedRowCollection col = this.getSelectedRows();
        boolean bl = isSuccess = !ObjectUtils.isEmpty((Object)args.getOperationResult()) && args.getOperationResult().isSuccess();
        if (isSuccess) {
            switch (operateKey) {
                case "startupactivity": {
                    this.showStartUpConfirmBox();
                    break;
                }
                case "endactivity": {
                    this.endActivity(col, isSuccess);
                    break;
                }
            }
        }
    }

    private void endActivity(ListSelectedRowCollection col, boolean isSuccess) {
        if (isSuccess && HRStringUtils.isNotEmpty((String)this.getPageCache().get(END_ACTIVITY_EXECUTE))) {
            INTERVIEW_ACTIVITY_CONF_APPLICATION.endActivity((Long)col.getPrimaryKeyValues()[0]);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u6210\u529f", (String)"IntActivityConfList_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.refreshActivityList();
            this.getPageCache().remove(END_ACTIVITY_EXECUTE);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult resultValue = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)resultValue)) {
            switch (actionId) {
                case "endactivity": {
                    this.getPageCache().put(END_ACTIVITY_EXECUTE, Boolean.TRUE.toString());
                    this.getView().invokeOperation(END_ACTIVITY);
                    this.getView().sendFormAction(this.getView());
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "auto_add_evaluation_objects": {
                ListSelectedRowCollection col = this.getSelectedRows();
                List longList = col.stream().map(ListSelectedRow2 -> (Long)ListSelectedRow2.getPrimaryKeyValue()).collect(Collectors.toList());
                int count = -1;
                if (longList.size() > 0) {
                    count = INTERVIEW_ACTIVITY_CONF_APPLICATION.countIntActObjByIntActivityIds((Long)longList.get(0));
                }
                String title = null;
                if (count > -1) {
                    title = ResManager.loadKDString((String)"\u6dfb\u52a0\u9762\u8c08\u5bf9\u8c61\u6210\u529f{0}\u6761", (String)"IntActivityConfList_10", (String)"opmc-epa-formplugin", (Object[])new Object[]{count});
                    this.getView().showSuccessNotification(title);
                } else {
                    title = ResManager.loadKDString((String)"\u6dfb\u52a0\u9762\u8c08\u5bf9\u8c61\u6210\u529f{0}\u6761", (String)"IntActivityConfList_10", (String)"opmc-epa-formplugin", (Object[])new Object[]{0});
                    this.getView().showMessage(title, (String)this.getView().getFormShowParameter().getCustomParam("errorMessage"), MessageTypes.Default);
                }
                this.refreshActivityList();
                break;
            }
            case "int_activity_startup": {
                Object returnDataObj = closedCallBackEvent.getReturnData();
                if (returnDataObj == null) {
                    return;
                }
                Map result = (Map)returnDataObj;
                Long intActivityId = (Long)result.get("int_activity_id");
                INTERVIEW_ACTIVITY_CONF_APPLICATION.updateIntActivityStatus(intActivityId);
                if (HRStringUtils.equals((String)((String)result.get("data")), (String)"1")) {
                    this.startUpAddEvaluationObjects(intActivityId);
                    break;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u52a8\u6210\u529f\u3002", (String)"IntActivityConfList_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.refreshActivityList();
                break;
            }
        }
    }

    private void refreshActivityList() {
        this.getView().invokeOperation("refresh");
        this.getView().sendFormAction(this.getView());
    }

    private void showStartUpConfirmBox() {
        ListSelectedRowCollection col = this.getSelectedRows();
        if (this.isNotOnlyOneSelect(col)) {
            return;
        }
        Long intActId = (Long)col.getPrimaryKeyValues()[0];
        DynamicObject intAct = INTERVIEW_ACTIVITY_CONF_APPLICATION.queryOne(intActId);
        boolean isDialog = IntActivityUtils.isNeedDialogFromOut();
        boolean isAct = intAct.getBoolean("isevaluteavtivity");
        if (isDialog && isAct) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("epa_intactivitystartup");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("int_activity_id", (Object)intActId);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "int_activity_startup"));
            this.getView().showForm(showParameter);
        } else if (!isDialog && isAct) {
            this.startUpAndAddIntObj();
        } else if (!isDialog && !isAct) {
            this.onlyStartUp();
        }
    }

    private void onlyStartUp() {
        ListSelectedRowCollection col = this.getSelectedRows();
        Long intActivityId = (Long)col.getPrimaryKeyValues()[0];
        INTERVIEW_ACTIVITY_CONF_APPLICATION.updateIntActivityStatus(intActivityId);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u52a8\u6210\u529f\u3002", (String)"IntActivityConfList_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        this.refreshActivityList();
    }

    private void startUpAndAddIntObj() {
        ListSelectedRowCollection col = this.getSelectedRows();
        Long intActivityId = (Long)col.getPrimaryKeyValues()[0];
        INTERVIEW_ACTIVITY_CONF_APPLICATION.updateIntActivityStatus(intActivityId);
        this.startUpAddEvaluationObjects(intActivityId);
    }

    private void startUpAddEvaluationObjects(Long activityId) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("int_activity_id", activityId);
        ActivityDispatchUtils.dispatch((AbstractFormPlugin)this, params, StartIntActivityTask.class.getName(), ResManager.loadKDString((String)"\u542f\u52a8\u6d3b\u52a8", (String)"IntActivityConfList_12", (String)"opmc-epa-formplugin", (Object[])new Object[0]), true, "auto_add_evaluation_objects");
    }

    private boolean isNotOnlyOneSelect(ListSelectedRowCollection col) {
        if (col.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"IntActivityConfList_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (col.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u6267\u884c1\u6761\u6570\u636e", (String)"IntActivityConfList_13", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<String> fixedColumnList = Arrays.asList("number", "name");
        fixedColumnList.forEach(column -> {
            if (args.getListColumn(column) != null) {
                args.getListColumn(column).setFixed(true);
            }
        });
    }

    private boolean checkMutex() {
        DataMutex dataMutex = DataMutex.create();
        String lockId = this.getFocusRowPkId() + "";
        Map lockInfo = dataMutex.getLockInfo(lockId, "process_netctrl", "epa_interviewprocess");
        long currUserId = RequestContext.get().getCurrUserId();
        if (lockInfo != null && lockInfo.size() > 0 && !HRStringUtils.equals((String)String.valueOf(currUserId), (String)((String)lockInfo.get("userid")))) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_user");
            long userId = Long.parseLong((String)lockInfo.get("userid"));
            Map cacheUserObjs = BusinessDataReader.loadFromCache((Object[])new Object[]{userId}, (DynamicObjectType)dt);
            DynamicObject userObj = (DynamicObject)cacheUserObjs.get(userId);
            String personName = "";
            if (userObj != null) {
                personName = userObj.getString("name");
            }
            String errMsg = ResManager.loadKDString((String)"{0}\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"IntActivityConfList_14", (String)"opmc-epa-formplugin", (Object[])new Object[]{personName});
            this.getView().showErrorNotification(errMsg);
            return true;
        }
        return false;
    }
}

