/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.interview.interviewobj;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.opmc.epa.formplugin.web.utils.BosListUtil;

public class InterviewObjBaseList
extends HRDataBaseList {
    private static final Log LOG = LogFactory.getLog(InterviewObjBaseList.class);
    private static final String PERFFILE_PMDPERSON_NAME = "perffile.pmdperson.name";
    private static final String BUSSINESSFIELD_NUMBER = "105010_S";

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (PERFFILE_PMDPERSON_NAME.equals(fieldName)) {
            List qFilters = args.getQfilters();
            qFilters.add(new QFilter("bussinessfield.number", "=", (Object)BUSSINESSFIELD_NUMBER));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("refresh".equals(operateKey)) {
            this.refreshCount();
        }
    }

    private void refreshCount() {
        IFormView parentView = this.getView().getParentView();
        if (!ObjectUtils.isEmpty((Object)parentView)) {
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<String> fixedColumnList = Arrays.asList("fseq", "person.headsculpture", "perffile.name", "perffile.billno");
        LOG.info("InterObjBaseList.beforeCreateListColumns fixedColumnList : {}", fixedColumnList);
        fixedColumnList.forEach(column -> {
            LOG.info("InterObjBaseList.beforeCreateListColumns  column : {}", column);
            if (args.getListColumn(column) != null) {
                LOG.info("InterObjBaseList.beforeCreateListColumns  args.getListColumn(column) != null : {}", column);
                args.getListColumn(column).setFixed(true);
            }
        });
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        BosListUtil.setListBgColor(this.getView(), "#ffffff");
        BosListUtil.setGripAndMargin(this.getView());
    }
}

