/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.interview.interviewobj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.interview.entityservice.InterviewActivityConfEntityService;

public class InterviewProcessPlugin
extends HRDynamicFormBasePlugin
implements RowClickEventListener,
TabSelectListener {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final AssessActivityApplicationService ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final InterviewActivityConfEntityService INTERVIEW_ACTIVITY_CONF_ENTITY_SERVICE = InterviewActivityConfEntityService.getInstance();
    private static final String FLOW_NODE_MAP = "flowNodeMap";
    private static final String FORMULATOR_LAB = "formulatorlab";
    private static final String FORMULATOR_TAB = "formulatortab";
    private static final String EVAL_OBJ_LAB = "evalobjlab";
    private static final String EVAL_OBJ_TAB = "evalobjtab";
    private static final String FORMULATOR_PAGE_ID = "FORMULATOR_PAGE_ID";
    private static final String EVAL_OBJ_ID = "EVAL_OBJ_ID";
    public static final String ENTRY_ROW_REFRESH = "entryRowRefresh";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        CardEntry nodeEntry = (CardEntry)this.getView().getControl("entryentity");
        nodeEntry.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{FORMULATOR_LAB, EVAL_OBJ_LAB});
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        this.getModel().setDataChanged(false);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("interact");
        Map flowMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryInterViewMonitorFlowsMap(activityId);
        DynamicObject[] flows = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFlowByPkValue(flowMap.keySet());
        DynamicObject perfWorkFlow = INTERVIEW_ACTIVITY_CONF_ENTITY_SERVICE.queryPerfWorkFlow(activityId);
        DynamicObjectCollection flowEntry = perfWorkFlow.getDynamicObjectCollection("flowentry");
        Map<Long, Boolean> temMap = flowEntry.stream().collect(Collectors.toMap(itemL -> itemL.getLong("flowvid"), itemB -> itemB.getBoolean("isdefaultflow")));
        Arrays.stream(flows).forEach(item -> {
            if (temMap.containsKey(item.getLong("id"))) {
                item.set("isdefault", temMap.get(item.getLong("id")));
            }
        });
        this.initFlowNodeMap(flows);
        this.buildComboItem(flowMap, flows);
        this.addNodeCard();
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.selectLastNode();
    }

    private void selectLastNode() {
        DynamicObjectCollection nodeEntry = this.getModel().getEntryEntity("entryentity");
        if (nodeEntry.size() > 0) {
            int lastNodeRow = 0;
            for (int i = 0; i < nodeEntry.size(); ++i) {
                int objNum = ((DynamicObject)nodeEntry.get(i)).getInt("objnum");
                lastNodeRow = objNum > 0 ? i : lastNodeRow;
            }
            CardEntry card = (CardEntry)this.getControl("entryentity");
            card.selectCard(Integer.valueOf(lastNodeRow));
        }
    }

    private IPageCache getParentViewPageCache() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"InterviewProcessPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
            return null;
        }
        return parentView.getPageCache();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"flowcombo")) {
            String flowId = (String)this.getModel().getValue("flowcombo");
            IPageCache parentViewPageCache = this.getParentViewPageCache();
            if (null == parentViewPageCache) {
                return;
            }
            parentViewPageCache.put("currentSelectFlow", flowId);
            parentViewPageCache.remove("lastSelectRow");
            this.addNodeCard();
            this.selectLastNode();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        MessageBoxResult result;
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"closeView") && MessageBoxResult.Yes == (result = event.getResult())) {
            this.getView().close();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Object source = evt.getSource();
        if (source instanceof CardEntry && HRStringUtils.equals((String)"entryentity", (String)((CardEntry)source).getKey())) {
            int lastSelectRow;
            int row = evt.getRow();
            DynamicObjectCollection nodeEntry = this.getModel().getEntryEntity("entryentity");
            IPageCache parentViewPageCache = this.getParentViewPageCache();
            if (parentViewPageCache == null || ObjectUtils.isEmpty((Object)nodeEntry)) {
                return;
            }
            String lastSelectRowStr = this.getView().getPageCache().get("lastSelectRow");
            if (!ObjectUtils.isEmpty((Object)lastSelectRowStr) && (lastSelectRow = Integer.parseInt(lastSelectRowStr)) == row) {
                return;
            }
            for (int i = 0; i < nodeEntry.size(); ++i) {
                this.getView().getModel().setValue("isselected", (Object)(row == i ? 1 : 0), i);
            }
            parentViewPageCache.put("lastSelectRow", String.valueOf(row));
            this.getView().getModel().setValue("isselected", (Object)Boolean.TRUE, row);
            String entryRowRefresh = this.getView().getPageCache().get(ENTRY_ROW_REFRESH);
            if (!HRStringUtils.isEmpty((String)entryRowRefresh) && "true".equals(entryRowRefresh)) {
                Integer entrySeq = ((DynamicObject)nodeEntry.get(row)).getDynamicObject("flownode").getInt("entryseq");
                Object pkValue = ((DynamicObject)nodeEntry.get(row)).getDynamicObject("flownode").getPkValue();
                this.showRightList(pkValue, entrySeq);
                this.getView().getPageCache().remove(ENTRY_ROW_REFRESH);
            } else {
                this.getView().invokeOperation("refresh");
                this.getView().getPageCache().put(ENTRY_ROW_REFRESH, "true");
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (HRStringUtils.equals((String)key, (String)FORMULATOR_LAB)) {
            this.getView().updateControlMetadata(FORMULATOR_LAB, this.getStyleMap(FORMULATOR_LAB, true));
            this.getView().updateControlMetadata(EVAL_OBJ_LAB, this.getStyleMap(EVAL_OBJ_LAB, false));
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab(FORMULATOR_TAB);
        } else if (HRStringUtils.equals((String)key, (String)EVAL_OBJ_LAB)) {
            this.getView().updateControlMetadata(EVAL_OBJ_LAB, this.getStyleMap(EVAL_OBJ_LAB, true));
            this.getView().updateControlMetadata(FORMULATOR_LAB, this.getStyleMap(FORMULATOR_LAB, false));
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab(EVAL_OBJ_TAB);
        }
    }

    private Map<String, Object> getStyleMap(String lab, boolean isSelect) {
        HashMap<String, Object> personStyleMap = new HashMap<String, Object>();
        personStyleMap.put("fc", isSelect ? "themeColor" : "");
        HashMap personStyle = new HashMap();
        HashMap<String, String> personBorder = new HashMap<String, String>();
        personBorder.put("r", isSelect ? "1px_solid_themeColor" : "1px_solid_#D9D9D9");
        personBorder.put("l", isSelect ? "1px_solid_themeColor" : "1px_solid_#D9D9D9");
        personBorder.put("t", isSelect ? "1px_solid_themeColor" : "1px_solid_#D9D9D9");
        personBorder.put("b", isSelect ? "1px_solid_themeColor" : "1px_solid_#D9D9D9");
        personStyle.put("b", personBorder);
        personStyleMap.put("s", personStyle);
        return personStyleMap;
    }

    private void showRightList(Object nodeId, Integer nodeIndex) {
        this.showPersonList(nodeIndex, "epa_intertaskviewlist", "interlist", nodeId);
    }

    private void showPersonList(Integer nodeIndex, String formId, String container, Object nodeId) {
        Long evalFlowId = Long.parseLong((String)this.getModel().getValue("flowcombo"));
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("interact");
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setBillFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(container);
        parameter.setCustomParam("nodeseq", (Object)nodeIndex);
        parameter.setCustomParam("interflow", (Object)evalFlowId);
        parameter.setCustomParam("flownode", nodeId);
        parameter.setCustomParam("interact", (Object)activityId);
        parameter.setCustomParam("objectscope", this.getView().getFormShowParameter().getCustomParam("objectscope"));
        String pageId = parameter.getPageId();
        if ("epa_formulatedetailview".equals(formId)) {
            this.getPageCache().put(FORMULATOR_PAGE_ID, pageId);
        } else if ("epa_formulatepersonview".equals(formId)) {
            this.getPageCache().put(EVAL_OBJ_ID, pageId);
        }
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void initFlowNodeMap(DynamicObject[] flows) {
        Map<Long, List> flowNodeMap = Arrays.stream(flows).collect(Collectors.toMap(flow -> flow.getLong("id"), flow -> {
            Long flowProcId = ((DynamicObject)flow.getDynamicObjectCollection("entryentity").get(0)).getLong("flowdefproc");
            DynamicObject flowProc = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFlowProcPkValue(flowProcId);
            return flowProc.getDynamicObjectCollection("nodeentry").stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }));
        this.getView().getPageCache().put(FLOW_NODE_MAP, SerializationUtils.toJsonString(flowNodeMap));
    }

    private void buildComboItem(Map<Object, Long> flowMap, DynamicObject[] flows) {
        DynamicObject defaultFlow = Arrays.stream(flows).filter(dy -> dy.getBoolean("isdefault")).findFirst().orElse(null);
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        if (defaultFlow != null) {
            String name = defaultFlow.getString("name");
            Long count = flowMap.get(defaultFlow.getPkValue());
            String value = name + "\uff08" + count + "\uff09";
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(defaultFlow.getPkValue()));
            item.setCaption(new LocaleString(value));
            item.setValue(String.valueOf(defaultFlow.getPkValue()));
            combos.add(item);
        }
        Arrays.stream(flows).filter(dy -> !dy.getBoolean("isdefault")).forEach(dy -> {
            String name = dy.getString("name");
            Long count = (Long)flowMap.get(dy.getPkValue());
            String value = name + "\uff08" + count + "\uff09";
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(dy.getPkValue()));
            item.setCaption(new LocaleString(value));
            item.setValue(String.valueOf(dy.getPkValue()));
            combos.add(item);
        });
        ComboEdit comboEdit = (ComboEdit)this.getControl("flowcombo");
        comboEdit.setComboItems(combos);
        if (!ObjectUtils.isEmpty(combos)) {
            this.getModel().setValue("flowcombo", (Object)((ComboItem)combos.get(0)).getId());
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"InterviewProcessPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
        }
        this.getModel().setValue("flowcombo", HRCollUtil.isNotEmpty(combos) ? ((ComboItem)combos.get(0)).getId() : Long.valueOf(0L));
    }

    public void pageRelease(EventObject e) {
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            parentView.getPageCache().remove("lastSelectRow");
            parentView.getPageCache().remove("currentSelectFlow");
        }
    }

    private void addNodeCard() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        this.dealWithSetter(setter);
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void dealWithSetter(TableValueSetter setter) {
        int seq = 1;
        setter.addField("flownode", new Object[0]);
        setter.addField("nodeseq", new Object[0]);
        setter.addField("nodeposition", new Object[0]);
        setter.addField("isselected", new Object[0]);
        setter.addField("objnum", new Object[0]);
        String flowId = String.valueOf(this.getModel().getValue("flowcombo"));
        String flowNodeMapStr = this.getView().getPageCache().get(FLOW_NODE_MAP);
        Map flowNodeMap = (Map)SerializationUtils.fromJsonString((String)flowNodeMapStr, Map.class);
        List nodeIds = (List)flowNodeMap.get(flowId);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Map ObjGroupByNodeMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFormulateEvaObjByFlow(Long.valueOf(Long.parseLong(flowId)), activityId);
        if (ObjectUtils.isEmpty((Object)nodeIds)) {
            return;
        }
        for (Long nodeId : nodeIds) {
            String position = null;
            if (seq == 1) {
                position = "top";
            } else if (nodeIds.indexOf(nodeId) == nodeIds.size() - 1) {
                position = "bottom";
            }
            int objNum = ObjGroupByNodeMap.get(nodeId) == null ? 0 : ((List)ObjGroupByNodeMap.get(nodeId)).size();
            setter.addRow(new Object[]{nodeId, seq, position, seq == 1, objNum});
            ++seq;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRStringUtils.equals((String)args.getOperateKey(), (String)"refresh")) {
            IPageCache parentViewPageCache = this.getParentViewPageCache();
            if (parentViewPageCache == null) {
                return;
            }
            String selectFlow = parentViewPageCache.get("currentSelectFlow");
            String selectRow = parentViewPageCache.get("lastSelectRow");
            if (!ObjectUtils.isEmpty((Object)selectFlow)) {
                this.getModel().setValue("flowcombo", (Object)selectFlow);
            }
            if (ObjectUtils.isEmpty((Object)selectRow)) {
                return;
            }
            CardEntry card = (CardEntry)this.getControl("entryentity");
            card.selectCard(Integer.valueOf(Integer.parseInt(selectRow)));
            parentViewPageCache.remove("lastSelectRow");
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        IListView page;
        String pageId;
        String itemKey = evt.getTabKey();
        if (FORMULATOR_TAB.equals(itemKey)) {
            IListView page2;
            String pageId2 = this.getPageCache().get(FORMULATOR_PAGE_ID);
            if (HRStringUtils.isNotEmpty((String)pageId2) && !HRObjectUtils.isEmpty((Object)(page2 = (IListView)this.getView().getView(pageId2)))) {
                page2.refresh();
                this.getView().sendFormAction((IFormView)page2);
            }
        } else if (EVAL_OBJ_TAB.equals(itemKey) && HRStringUtils.isNotEmpty((String)(pageId = this.getPageCache().get(EVAL_OBJ_ID))) && !HRObjectUtils.isEmpty((Object)(page = (IListView)this.getView().getView(pageId)))) {
            page.refresh();
            this.getView().sendFormAction((IFormView)page);
        }
    }
}

