/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.interview.interviewobj;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListModel;
import kd.bos.orm.query.LikeHint;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterHint;
import kd.hr.hbp.business.service.query.ksql.IKsqlConfig;
import kd.hr.hbp.business.service.query.ksql.KsqlConfig;
import kd.hr.hbp.business.service.query.ksql.KsqlListDataProvider;
import kd.hr.hbp.business.servicehelper.EntityReleaseInfoService;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.query.QueryListPlugin;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.interview.InterviewObjApplication;
import kd.opmc.epa.business.domain.interview.enums.InterStatusEnum;
import kd.opmc.epa.business.utils.InterViewObjUtils;
import kd.opmc.epa.formplugin.web.utils.BosListUtil;
import kd.opmc.epa.formplugin.web.utils.InterviewSchemeSearchUtils;
import kd.opmc.pbs.business.domain.workflow.entity.FlowCommonResultBo;

public class InterviewSetHandlerList
extends QueryListPlugin {
    private static final Log LOG = LogFactory.getLog(InterviewSetHandlerList.class);
    private static final InterviewObjApplication INTERVIEW_OBJ_APPLICATION = InterviewObjApplication.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private Map<Long, String> handlerMap = new HashMap<Long, String>(16);
    private static final String INT_ACTIVITY = "epa_interobj.interact";
    private static final String DEFPROC = "epa_interobj.interflow";
    private static final String INDEX = "pbs_flowrunode.index";
    private static final String INTER_STATUS = "epa_interobj.interstatus";
    private static final String FORMULATOR = "formulator";

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("interact");
        Object flowId = this.getView().getFormShowParameter().getCustomParam("flowDefId");
        Object seq = this.getView().getFormShowParameter().getCustomParam("seq");
        QFilter filter = new QFilter(INT_ACTIVITY, "=", (Object)activityId).and(INTER_STATUS, "=", (Object)InterStatusEnum.JOINED.getStatus()).and(INDEX, "=", seq).and(DEFPROC, "=", (Object)Long.parseLong(flowId.toString()));
        evt.getQFilters().add(filter);
        evt.setOrderBy("modifytime desc");
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        BosListUtil.setListBgColor(this.getView(), "#ffffff");
        BosListUtil.setGripAndMargin(this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        boolean hasPermission = InterViewObjUtils.checkInterViewProcessPermission((IFormView)this.getView());
        if (!hasPermission) {
            args.setCancel(true);
            return;
        }
        if (this.getView().getParentView().getParentView() == null) {
            args.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9762\u8c08\u6d3b\u52a8\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"InterviewSetHandlerList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
            return;
        }
        AbstractOperate source = (AbstractOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        String operateKey = source.getOperateKey();
        if ("sethandler".equals(operateKey) && !HRStringUtils.equals((String)systemInvoke, (String)"true")) {
            if (this.validateDataChange()) {
                args.setCancel(true);
                return;
            }
            FormShowParameter baseShowParameter = new FormShowParameter();
            baseShowParameter.setFormId("epa_setinterviewer");
            baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            baseShowParameter.setStatus(OperationStatus.EDIT);
            baseShowParameter.setCaption(ResManager.loadKDString((String)"\u8bbe\u7f6e\u5904\u7406\u4eba", (String)"InterviewSetHandlerList_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            baseShowParameter.setCustomParam("count", (Object)primaryKeyValues.length);
            baseShowParameter.setCustomParam("evaluaties", (Object)primaryKeyValues);
            baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_setinterviewer"));
            this.getView().showForm(baseShowParameter);
            args.setCancel(true);
        }
    }

    private boolean validateDataChange() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Long[] roleIdList = (Long[])Arrays.stream(selectedRows.getPrimaryKeyValues()).map(row -> Long.parseLong(row.toString())).toArray(Long[]::new);
        DynamicObject[] ruRoleId = INTERVIEW_OBJ_APPLICATION.queryFLowRuRoleById(roleIdList);
        Set roleId = Arrays.stream(ruRoleId).map(row -> row.getLong("id")).collect(Collectors.toSet());
        for (Long id : roleIdList) {
            if (roleId.contains(id)) continue;
            String msg = ResManager.loadKDString((String)"\u9875\u9762\u6570\u636e\u5df2\u53d8\u66f4\uff0c\u8bf7\u624b\u52a8\u5237\u65b0\u9875\u9762\u540e\u91cd\u65b0\u64cd\u4f5c", (String)"InterviewSetHandlerList_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return true;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("sethandler".equals(key) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object childMap = closedCallBackEvent.getReturnData();
        if (HRObjectUtils.isEmpty((Object)childMap)) {
            return;
        }
        if ("epa_setinterviewer".equals(actionId)) {
            Map handlers = (Map)childMap;
            List userIds = (List)handlers.get("handlers");
            List flowCommonResultBos = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.verifyUserIsValid(userIds);
            for (FlowCommonResultBo flowCommonResultBo : flowCommonResultBos) {
                if (!"-1".equals(flowCommonResultBo.getCode())) continue;
                this.getView().showErrorNotification(flowCommonResultBo.getMessage());
                return;
            }
            OperateOption setHandler = OperateOption.create();
            String returnStr = SerializationUtils.serializeToBase64((Object)childMap);
            setHandler.setVariableValue("return_str", returnStr);
            setHandler.setVariableValue("systeminvoke", "true");
            setHandler.setVariableValue("OP_SOURCE", "epa_setinterviewer");
            this.getView().invokeOperation("sethandler", setHandler);
        }
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        super.beforePackageData(event);
        DynamicObjectCollection pageData = event.getPageData();
        boolean selectedAllRows = ((ListModel)event.getSource()).isSelectedAllRows();
        if (!pageData.isEmpty() && !selectedAllRows) {
            List roleIds = pageData.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
            this.handlerMap = INTERVIEW_OBJ_APPLICATION.queryHandler(roleIds);
        }
    }

    private List<Long> getDefaultList() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("interact");
        Object flowId = this.getView().getFormShowParameter().getCustomParam("flowDefId");
        Object seq = this.getView().getFormShowParameter().getCustomParam("seq");
        return INTERVIEW_OBJ_APPLICATION.queryFormulatorByListDefaultFilter(activityId, seq, Long.parseLong(flowId.toString()));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        KsqlConfig ksqlConfig;
        DynamicObject entityReleaseInfo = EntityReleaseInfoService.getEntityReleaseInfoByName((String)"epa_interrolequery");
        if (Objects.isNull(entityReleaseInfo)) {
            return;
        }
        String ksqlQueryType = entityReleaseInfo.getString("ksqlquerytype");
        boolean ksqlUseUnion = entityReleaseInfo.getBoolean("ksqluseunion");
        String queryType = "FULLSQL";
        if (HRStringUtils.equals((String)ksqlQueryType, (String)"IDQUERY")) {
            queryType = "PKSQL";
        }
        if ((ksqlConfig = this.setCustomKSqlConfig()) == null) {
            ksqlConfig = new KsqlConfig();
        }
        args.setListDataProvider((IListDataProvider)new KsqlListDataProvider(this.getView(), (IKsqlConfig)ksqlConfig, queryType, ksqlUseUnion, true){

            public List<QFilter> getQFilters() {
                List qFilterList = super.getQFilters();
                for (int i = 0; i < qFilterList.size(); ++i) {
                    String property;
                    QFilter qFilter = (QFilter)qFilterList.get(i);
                    if (qFilter == null || !"evalpersonshow".equals(property = qFilter.getProperty())) continue;
                    List roleList = InterviewSetHandlerList.this.getDefaultList();
                    Map nameOrNumRoleSetMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryNameOrNumRoleSetMap(roleList);
                    qFilterList.remove(i);
                    --i;
                    QFilter roleFilter = InterviewSetHandlerList.this.getPersonToRoleFilter(qFilter, nameOrNumRoleSetMap);
                    if (roleFilter == null) continue;
                    qFilterList.add(roleFilter);
                }
                return qFilterList;
            }
        });
    }

    private QFilter like(QFilter qFilter, Map<String, Set<Long>> nameOrNumberRoleMap) {
        QFilterHint qFilterHint = qFilter.getQFilterHint();
        HashSet queryRoleIds = new HashSet(16);
        if (qFilterHint instanceof LikeHint) {
            boolean hasLeftPercent = ((LikeHint)qFilterHint).isAppendLeftPercent();
            boolean hasRightPercent = ((LikeHint)qFilterHint).isAppendRightPercent();
            Object value = qFilter.getOriginValue();
            if (value instanceof String) {
                nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                    if (hasLeftPercent && hasRightPercent) {
                        if (nameOrNum != null && nameOrNum.contains((String)value)) {
                            queryRoleIds.addAll(roleIds);
                        }
                    } else if (hasLeftPercent && !hasRightPercent) {
                        if (nameOrNum != null && nameOrNum.endsWith((String)value)) {
                            queryRoleIds.addAll(roleIds);
                        }
                    } else if (!hasLeftPercent && hasRightPercent && nameOrNum != null && nameOrNum.startsWith((String)value)) {
                        queryRoleIds.addAll(roleIds);
                    }
                });
            }
        }
        return new QFilter("id", "in", queryRoleIds);
    }

    private QFilter notLike(QFilter qFilter, Map<String, Set<Long>> nameOrNumberRoleMap) {
        HashSet queryRoleIds = new HashSet(16);
        Object value = qFilter.getOriginValue();
        if (value instanceof String) {
            nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                if (nameOrNum != null && nameOrNum.contains((String)value)) {
                    queryRoleIds.addAll(roleIds);
                }
            });
        }
        if (queryRoleIds.size() == 0) {
            return null;
        }
        return new QFilter("id", "not in", queryRoleIds);
    }

    private QFilter equalsValue(QFilter qFilter, Map<String, Set<Long>> nameOrNumberRoleMap) {
        HashSet queryRoleIds = new HashSet(16);
        Object value = qFilter.getOriginValue();
        if (value instanceof String) {
            nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                if (nameOrNum != null && nameOrNum.equals(value)) {
                    queryRoleIds.addAll(roleIds);
                }
            });
        } else if (value instanceof QEmptyValue) {
            nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                if (nameOrNum != null && HRStringUtils.isEmpty((String)nameOrNum)) {
                    queryRoleIds.addAll(roleIds);
                }
            });
        }
        return new QFilter("id", "in", queryRoleIds);
    }

    private QFilter notEqualsValue(QFilter qFilter, Map<String, Set<Long>> nameOrNumberRoleMap) {
        HashSet queryRoleIds = new HashSet(16);
        Object value = qFilter.getOriginValue();
        if (value instanceof String) {
            nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                if (nameOrNum != null && nameOrNum.equals(value)) {
                    queryRoleIds.addAll(roleIds);
                }
            });
        }
        if (queryRoleIds.size() == 0) {
            return null;
        }
        return new QFilter("id", "not in", queryRoleIds);
    }

    private QFilter notNullValue(Map<String, Set<Long>> nameOrNumberRoleMap) {
        HashSet queryRoleIds = new HashSet(16);
        nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
            if (nameOrNum != null && HRStringUtils.isNotEmpty((String)nameOrNum)) {
                queryRoleIds.addAll(roleIds);
            }
        });
        return new QFilter("id", "in", queryRoleIds);
    }

    private QFilter inValues(QFilter qFilter, Map<String, Set<Long>> nameOrNumberRoleMap) {
        HashSet queryRoleIds = new HashSet(16);
        Object value = qFilter.getOriginValue();
        if (value instanceof List) {
            nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                if (nameOrNum != null && ((List)value).contains(nameOrNum)) {
                    queryRoleIds.addAll(roleIds);
                }
            });
        }
        return new QFilter("id", "in", queryRoleIds);
    }

    private QFilter notInValues(QFilter qFilter, Map<String, Set<Long>> nameOrNumberRoleMap) {
        HashSet queryRoleIds = new HashSet(16);
        Object value = qFilter.getOriginValue();
        if (value instanceof List) {
            nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                if (nameOrNum != null && ((List)value).contains(nameOrNum)) {
                    queryRoleIds.addAll(roleIds);
                }
            });
        }
        if (queryRoleIds.size() == 0) {
            return null;
        }
        return new QFilter("id", "not in", queryRoleIds);
    }

    private QFilter getPersonToRoleFilter(QFilter qFilter, Map<String, Set<Long>> nameOrNumberRoleMap) {
        String cp = qFilter.getCP();
        cp = cp.toLowerCase();
        QFilter roleQFilter = null;
        switch (cp) {
            case "like": {
                roleQFilter = this.like(qFilter, nameOrNumberRoleMap);
                break;
            }
            case "not like": {
                roleQFilter = this.notLike(qFilter, nameOrNumberRoleMap);
                break;
            }
            case "=": {
                roleQFilter = this.equalsValue(qFilter, nameOrNumberRoleMap);
                break;
            }
            case "!=": {
                roleQFilter = this.notEqualsValue(qFilter, nameOrNumberRoleMap);
                break;
            }
            case "in": {
                roleQFilter = this.inValues(qFilter, nameOrNumberRoleMap);
                break;
            }
            case "not in": {
                roleQFilter = this.notInValues(qFilter, nameOrNumberRoleMap);
                break;
            }
            case "is not null": {
                roleQFilter = this.notNullValue(nameOrNumberRoleMap);
                break;
            }
        }
        return roleQFilter;
    }

    public void packageData(PackageDataEvent evt) {
        ColumnDesc columnDesc;
        super.packageData(evt);
        Object source = evt.getSource();
        if (source instanceof ColumnDesc && "evalpersonshow".equals((columnDesc = (ColumnDesc)source).getKey())) {
            DynamicObject rowData = evt.getRowData();
            String evalPersonShow = this.handlerMap.get(rowData.getLong("id"));
            evt.setFormatValue((Object)evalPersonShow);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<String> fixedColumnList = Arrays.asList("fseq", "epa_interobj.person.headsculpture", "epa_interobj.perffile.name", "epa_interobj.perffile.billno");
        fixedColumnList.forEach(column -> {
            if (args.getListColumn(column) != null) {
                args.getListColumn(column).setFixed(true);
            }
        });
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        InterviewSchemeSearchUtils.filterF7Select(this.getView(), args);
        super.filterContainerBeforeF7Select(args);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"closeView")) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Yes == result) {
                this.getView().close();
                this.getView().getParentView().close();
                this.getView().sendFormAction(this.getView().getParentView());
            }
            return;
        }
    }
}

