/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.interview.interviewobj;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.opmc.epa.business.application.service.interview.InterviewActivityConfApplication;
import kd.opmc.epa.business.application.service.interview.InterviewObjApplication;
import kd.opmc.epa.formplugin.web.activitymanage.targetformulate.TargetFormulateSettingPlugin;

public class InterviewSetHandlerPlugin
extends HRDynamicFormBasePlugin
implements RowClickEventListener {
    private static final Log logger = LogFactory.getLog(TargetFormulateSettingPlugin.class);
    private static final InterviewObjApplication INTERVIEW_OBJ_APPLICATION = InterviewObjApplication.getInstance();
    private static final InterviewActivityConfApplication INTERVIEW_ACTIVITY_CONF_APPLICATION = InterviewActivityConfApplication.getInstance();
    private static final String FLOW_NODE_MAP = "flowNodeMap";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        CardEntry nodeEntry = (CardEntry)this.getView().getControl("entryentity");
        nodeEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        this.getModel().setDataChanged(false);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("interact");
        Map flowMap = INTERVIEW_OBJ_APPLICATION.queryInterviewFlowsMap(activityId);
        DynamicObject[] flows = INTERVIEW_OBJ_APPLICATION.queryFlowByPkValue(flowMap.keySet());
        DynamicObject perfWorkFlow = INTERVIEW_ACTIVITY_CONF_APPLICATION.queryPerfWorkFlow(activityId);
        DynamicObjectCollection flowEntry = perfWorkFlow.getDynamicObjectCollection("flowentry");
        Map<Long, Boolean> temMap = flowEntry.stream().collect(Collectors.toMap(itemL -> itemL.getLong("flowvid"), itemB -> itemB.getBoolean("isdefaultflow")));
        Arrays.stream(flows).forEach(item -> {
            if (temMap.containsKey(item.getLong("id"))) {
                item.set("isdefault", temMap.get(item.getLong("id")));
            }
        });
        this.initFlowNodeMap(flows);
        this.buildComboItem(flowMap, flows);
        this.addNodeCard();
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.chooseFirstCard();
    }

    private void chooseFirstCard() {
        CardEntry nodeCard = (CardEntry)this.getControl("entryentity");
        String lastSelectRowStr = this.getView().getPageCache().get("lastSelectRow");
        if (HRStringUtils.isNotEmpty((String)lastSelectRowStr)) {
            int lastSelectRow = Integer.parseInt(lastSelectRowStr);
            nodeCard.selectCard(Integer.valueOf(lastSelectRow));
        } else {
            nodeCard.selectCard(Integer.valueOf(0));
        }
        this.getView().getPageCache().remove("lastSelectRow");
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"flowcombo")) {
            String flowId = (String)this.getModel().getValue("flowcombo");
            IPageCache parentViewPageCache = this.getParentViewPageCache();
            if (null == parentViewPageCache) {
                return;
            }
            parentViewPageCache.put("currentSelectFlow", flowId);
            parentViewPageCache.remove("lastSelectRow");
            this.addNodeCard();
            this.chooseFirstCard();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Object source = evt.getSource();
        if (source instanceof CardEntry && HRStringUtils.equals((String)"entryentity", (String)((CardEntry)source).getKey())) {
            int lastSelectRow;
            int row = evt.getRow();
            DynamicObjectCollection nodeEntry = this.getModel().getEntryEntity("entryentity");
            IPageCache parentViewPageCache = this.getParentViewPageCache();
            if (parentViewPageCache == null || ObjectUtils.isEmpty((Object)nodeEntry)) {
                return;
            }
            String lastSelectRowStr = this.getView().getPageCache().get("lastSelectRow");
            if (!ObjectUtils.isEmpty((Object)lastSelectRowStr) && (lastSelectRow = Integer.parseInt(lastSelectRowStr)) == row) {
                return;
            }
            for (int i = 0; i < nodeEntry.size(); ++i) {
                this.getView().getModel().setValue("isselected", (Object)(row == i ? 1 : 0), i);
            }
            parentViewPageCache.put("lastSelectRow", String.valueOf(row));
            this.getView().getModel().setValue("isselected", (Object)Boolean.TRUE, row);
            Integer entrySeq = ObjectUtils.isEmpty((Object)nodeEntry) ? 0 : ((DynamicObject)nodeEntry.get(row)).getDynamicObject("flownode").getInt("entryseq");
            Object pkValue = ((DynamicObject)nodeEntry.get(row)).getDynamicObject("flownode").getPkValue();
            this.showRightList(pkValue, entrySeq);
        }
    }

    private void showRightList(Object pkValue, Integer seq) {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("interact");
        Object flowId = this.getModel().getValue("flowcombo");
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setBillFormId("epa_setinterviewerlist");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("formulatorap");
        parameter.setCustomParam("interact", (Object)activityId);
        parameter.setCustomParam("flowDefId", flowId);
        parameter.setCustomParam("flownode", pkValue);
        parameter.setCustomParam("seq", (Object)seq);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void initFlowNodeMap(DynamicObject[] flows) {
        Map<Long, List> flowNodeMap = Arrays.stream(flows).collect(Collectors.toMap(flow -> flow.getLong("id"), flow -> {
            Long flowProcId = ((DynamicObject)flow.getDynamicObjectCollection("entryentity").get(0)).getLong("flowdefproc");
            DynamicObject flowProc = INTERVIEW_OBJ_APPLICATION.queryFlowProcPkValue(flowProcId);
            return flowProc.getDynamicObjectCollection("nodeentry").stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }));
        String mapStr = JSONObject.toJSONString(flowNodeMap);
        this.getView().getPageCache().put(FLOW_NODE_MAP, mapStr);
    }

    private void buildComboItem(Map<Object, Long> flowMap, DynamicObject[] flows) {
        DynamicObject defaultFlow = Arrays.stream(flows).filter(dy -> dy.getBoolean("isdefault")).findFirst().orElse(null);
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        if (defaultFlow != null) {
            String name = defaultFlow.getString("name");
            Long count = flowMap.get(defaultFlow.getPkValue());
            String value = name + "\uff08" + count + "\uff09";
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(defaultFlow.getPkValue()));
            item.setCaption(new LocaleString(value));
            item.setValue(String.valueOf(defaultFlow.getPkValue()));
            combos.add(item);
        }
        Arrays.stream(flows).filter(dy -> !dy.getBoolean("isdefault")).forEach(dy -> {
            String name = dy.getString("name");
            Long count = (Long)flowMap.get(dy.getPkValue());
            String value = name + "\uff08" + count + "\uff09";
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(dy.getPkValue()));
            item.setCaption(new LocaleString(value));
            item.setValue(String.valueOf(dy.getPkValue()));
            combos.add(item);
        });
        ComboEdit comboEdit = (ComboEdit)this.getControl("flowcombo");
        comboEdit.setComboItems(combos);
        if (!ObjectUtils.isEmpty(combos)) {
            this.getModel().setValue("flowcombo", (Object)((ComboItem)combos.get(0)).getId());
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"InterviewSetHandlerPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
        }
        this.getModel().setValue("flowcombo", HRCollUtil.isNotEmpty(combos) ? ((ComboItem)combos.get(0)).getId() : Long.valueOf(0L));
    }

    public void pageRelease(EventObject e) {
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            parentView.getPageCache().remove("lastSelectRow");
            parentView.getPageCache().remove("currentSelectFlow");
        }
    }

    private void addNodeCard() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        this.dealWithSetter(setter);
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void dealWithSetter(TableValueSetter setter) {
        int seq = 1;
        setter.addField("flownode", new Object[0]);
        setter.addField("nodeseq", new Object[0]);
        setter.addField("nodeposition", new Object[0]);
        setter.addField("isselected", new Object[0]);
        String flowId = String.valueOf(this.getModel().getValue("flowcombo"));
        String mapStr = this.getView().getPageCache().get(FLOW_NODE_MAP);
        JSONObject jsonObject = JSONObject.parseObject((String)mapStr);
        Object nodes = jsonObject.get((Object)flowId);
        List nodeIds = JSONObject.parseArray((String)JSONObject.toJSONString((Object)nodes), Long.class);
        if (ObjectUtils.isEmpty((Object)nodeIds)) {
            return;
        }
        for (Long nodeId : nodeIds) {
            String position = null;
            if (seq == 1) {
                position = "top";
            } else if (nodeIds.indexOf(nodeId) == nodeIds.size() - 1) {
                position = "bottom";
            }
            setter.addRow(new Object[]{nodeId, seq, position, seq == 1});
            ++seq;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRStringUtils.equals((String)args.getOperateKey(), (String)"refresh")) {
            IPageCache parentViewPageCache = this.getParentViewPageCache();
            if (parentViewPageCache == null) {
                return;
            }
            String selectFlow = parentViewPageCache.get("currentSelectFlow");
            String selectRow = parentViewPageCache.get("lastSelectRow");
            if (!ObjectUtils.isEmpty((Object)selectFlow)) {
                this.getModel().setValue("flowcombo", (Object)selectFlow);
            }
            if (ObjectUtils.isEmpty((Object)selectRow)) {
                return;
            }
            CardEntry card = (CardEntry)this.getControl("entryentity");
            card.selectCard(Integer.valueOf(Integer.parseInt(selectRow)));
            parentViewPageCache.remove("lastSelectRow");
        }
    }

    private IPageCache getParentViewPageCache() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"InterviewSetHandlerPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
            return null;
        }
        return parentView.getPageCache();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        MessageBoxResult result;
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"closeView") && MessageBoxResult.Yes == (result = event.getResult())) {
            this.getView().close();
        }
    }
}

