/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.interview.interviewobj;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.interview.InterviewObjApplication;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.common.enums.activitymanage.AssessStatusEnum;
import kd.opmc.epa.common.enums.per.NodeTypeEnum;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.domain.workflow.entity.FlowValidateResultBo;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;
import kd.opmc.pbs.business.external.hrpi.IEmployeeService;
import org.apache.commons.collections.MapUtils;

public class InterviewTaskProcessPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(InterviewTaskProcessPlugin.class);
    private static final IEmployeeService EMPLOYEE_SERVICE = IEmployeeService.getInstance();
    private final FlowRuProcApplicationService FLOW_RU_PROC_APPLICATION_SERVICE = FlowRuProcApplicationService.getInstance();
    private static final AssessActivityEntityService ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY_SERVICE = AssessFormEntityService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RU_SECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    private static final InterviewObjApplication INTERVIEW_OBJ_APPLICATION = InterviewObjApplication.getInstance();
    private static final String INTEROBJID = "interObjId";
    private static final String ISMODIFY = "isModify";

    public void initialize() {
        super.initialize();
        String isFromIntered = (String)this.getView().getFormShowParameter().getCustomParam("InteredList");
        if (HRStringUtils.isNotEmpty((String)isFromIntered) && "true".equals(isFromIntered)) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        String notfirstEnter = pageCache.get("notfirstEnter");
        if (HRStringUtils.isNotEmpty((String)notfirstEnter) && HRStringUtils.equals((String)"true", (String)notfirstEnter)) {
            return;
        }
        pageCache.put("notfirstEnter", "true");
        Long taskId = this.getTaskId();
        this.initNodeType(pageCache, taskId);
        this.initRoleDefReviewerCanEdit(pageCache, taskId);
        this.setTaskStatus();
        this.setAuditCache(taskId);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initShowPerfResult();
    }

    private void initShowPerfResult() {
        boolean isShow = this.getModel().getDataEntity().getBoolean("interact.isshowperfret");
        if (!isShow) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fsoptext", "flop"});
        }
    }

    private void initRoleDefReviewerCanEdit(IPageCache pageCache, Long taskId) {
        DynamicObject roleDefDy = this.FLOW_RU_PROC_APPLICATION_SERVICE.queryNodeRoleByTask(taskId);
        String reviewercanedit = roleDefDy.getString("reviewercanedit");
        pageCache.put("reviewercanedit", reviewercanedit);
    }

    private void initNodeType(IPageCache pageCache, Long taskId) {
        Long nodeType = this.FLOW_RU_PROC_APPLICATION_SERVICE.queryDefNodeByTaskId(taskId);
        pageCache.put("nodeType", null == nodeType ? "" : Long.toString(nodeType));
    }

    private Long getNodeType() {
        IPageCache pageCache = this.getPageCache();
        String nodeType = pageCache.get("nodeType");
        if (HRStringUtils.isEmpty((String)nodeType)) {
            return null;
        }
        return Long.parseLong(nodeType);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String isFromIntered;
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        Object interObjId = formShowParameter.getCustomParam("pkId");
        DynamicObject interObj = BusinessDataServiceHelper.loadSingle((Object)interObjId, (String)"epa_interobj");
        if (!HRObjectUtils.isEmpty((Object)interObj)) {
            String name = new LocaleString(interObj.getString("perffile.name")).getLocaleValue();
            formShowParameter.setCaption(ResManager.loadKDString((String)"{0}\u7684\u9762\u8c08\u8bb0\u5f55\u8868", (String)"InterviewTaskProcessPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[]{name}));
        }
        if (HRStringUtils.isNotEmpty((String)(isFromIntered = (String)formShowParameter.getCustomParam("InteredList"))) && "true".equals(isFromIntered)) {
            return;
        }
        Object taskId = formShowParameter.getCustomParam("taskId");
        long aLong = taskId instanceof String ? Long.parseLong((String)taskId) : (Long)taskId;
        String taskStatus = this.getTaskStatus(aLong);
        if (HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.EXPIRED.getCode())) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"InterviewTaskProcessPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        DynamicObject ruTask = FLOW_RU_SECOND_DOMAIN_SERVICE.queryTaskByPkValue(Long.valueOf(Long.parseLong(taskId.toString())));
        long handler = ruTask.getLong("handler.id");
        long currUserId = RequestContext.get().getCurrUserId();
        if (currUserId != handler) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5931\u6548\u6216\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5904\u7406\u4eba\u3002", (String)"InterviewTaskProcessPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        this.checkMutex(e, ruTask);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initInterObjInfo();
        this.setMutex();
        this.getView().getPageCache().put(ISMODIFY, "false");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status == OperationStatus.VIEW) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"attachmentpanelap"});
        }
        this.changeTaskStatus();
    }

    private void changeTaskStatus() {
        String isFromIntered = (String)this.getView().getFormShowParameter().getCustomParam("InteredList");
        Object taskId = this.getView().getFormShowParameter().getCustomParam("taskId");
        if (HRStringUtils.isNotEmpty((String)isFromIntered) && "true".equals(isFromIntered) || taskId == null) {
            return;
        }
        DynamicObject ruTask = FLOW_RU_SECOND_DOMAIN_SERVICE.queryTaskByPkValue(Long.valueOf(Long.parseLong(taskId.toString())));
        String taskStatus = ruTask.getString("taskstatus");
        if (AssessStatusEnum.ASSESS_WAITING.getCode().equals(taskStatus)) {
            ruTask.set("taskstatus", (Object)AssessStatusEnum.ASSESSING.getCode());
            FLOW_RU_SECOND_DOMAIN_SERVICE.saveTask(ruTask);
        }
    }

    private void initInterObjInfo() {
        Long interObjId = this.requireInterObjId();
        this.getView().getPageCache().put(INTEROBJID, String.valueOf(interObjId));
        DynamicObject interObj = BusinessDataServiceHelper.loadSingle((Object)interObjId, (String)"epa_interobj");
        this.initPersonInfo(interObj);
        this.initOtherInterInfo(interObj);
        String isFromIntered = (String)this.getView().getFormShowParameter().getCustomParam("InteredList");
        if (HRStringUtils.isNotEmpty((String)isFromIntered) && "true".equals(isFromIntered)) {
            this.setBtnVisible("1");
            this.getView().setVisible(Boolean.FALSE, new String[]{"interstatusap"});
        }
        this.initEvaResultInfo(interObj);
    }

    private Long requireInterObjId() {
        if (ObjectUtils.isEmpty((Object)this.getView().getFormShowParameter())) {
            return null;
        }
        Object pkId = this.getView().getFormShowParameter().getCustomParam("pkId");
        log.info("InterviewTaskProcessPlugin-pkId: {}", pkId);
        if (ObjectUtils.isEmpty((Object)pkId)) {
            return null;
        }
        long aLong = pkId instanceof String ? Long.parseLong((String)pkId) : (Long)pkId;
        return aLong;
    }

    private void initOtherInterInfo(DynamicObject interObj) {
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObjectCollection areaEntitys = interObj.getDynamicObjectCollection("areaentity");
        for (DynamicObject area : areaEntitys) {
            if (area.getLong("area.id") == 12L) {
                String isFromIntered;
                DynamicObject actinsInfo = BusinessDataServiceHelper.loadSingle((Object)area.getLong("areains"), (String)"epa_actins");
                this.getModel().initValue("actins", (Object)actinsInfo.getLong("id"));
                if (actinsInfo != null) {
                    this.getModel().initValue("interplace", (Object)actinsInfo.getString("interplace"));
                    this.getModel().initValue("intertime", (Object)actinsInfo.getString("intertime"));
                    try {
                        long activityId = this.getModel().getDataEntity().getLong("evalobj.activity.id");
                        DynamicObject atcivityDy = ACTIVITY_ENTITY_SERVICE.queryAssessFormByActivity(Long.valueOf(activityId));
                        Long assessFormId = atcivityDy.getLong("assessform_id");
                        DynamicObject assessForm = ASSESS_FORM_ENTITY_SERVICE.queryAssessFormByPk(assessFormId);
                        DynamicObject sumperflevel = assessForm.getDynamicObject("sumperflevel");
                        String numAccuracy = assessForm.getString("numaccuracy");
                        String scaleType = assessForm.getString("scaletype");
                        if (sumperflevel != null) {
                            Long sumPerfLevelId = (Long)sumperflevel.getPkValue();
                            DynamicObject sumPerfLevel = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryPerfLevelById(sumPerfLevelId);
                            DynamicObjectCollection levelEntry = sumPerfLevel.getDynamicObjectCollection("entryentity");
                            HashMap<String, String> levelMap = new HashMap<String, String>(16);
                            for (DynamicObject dy : levelEntry) {
                                int seq = dy.getInt("seq");
                                levelMap.put(String.valueOf(seq), dy.getString("levelname"));
                            }
                            this.getModel().initValue("flop", levelMap.get(interObj.getString("flop")));
                        } else {
                            this.getModel().initValue("flop", (Object)interObj.getString("flop"));
                        }
                        BigDecimal sop = interObj.getBigDecimal("fsop");
                        sop = sop.setScale(Integer.parseInt(numAccuracy), ScalaTypeEnum.get((String)scaleType).getType());
                        this.getModel().initValue("fsoptext", (Object)sop);
                    }
                    catch (Exception e) {
                        log.error("\u9762\u8c08\u4efb\u52a1\u9875\u9762\u8d4b\u503c\u7efc\u5408\u7ee9\u6548\u7b49\u7ea7\u548c\u7efc\u5408\u7ee9\u6548\u5f97\u5206\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                    }
                }
                if (HRStringUtils.isNotEmpty((String)(isFromIntered = (String)this.getView().getFormShowParameter().getCustomParam("InteredList"))) && "true".equals(isFromIntered)) {
                    currUserId = actinsInfo.getLong("user.id");
                    continue;
                }
                Long taskId = this.getTaskId();
                String taskStatus = this.getTaskStatus(taskId);
                if (!HRStringUtils.isNotEmpty((String)taskStatus) || !"40".equals(taskStatus) || ObjectUtils.isEmpty((Object)actinsInfo.getDynamicObject("user"))) continue;
                currUserId = actinsInfo.getLong("user.id");
                continue;
            }
            if (area.getLong("area.id") != 13L) continue;
            DynamicObject interinsInfo = BusinessDataServiceHelper.loadSingle((Object)area.getLong("areains"), (String)"epa_interins");
            this.getModel().initValue("interins", (Object)interinsInfo.getLong("id"));
            if (interinsInfo == null) continue;
            this.getModel().initValue("confirmation", (Object)interinsInfo.getString("confirmation"));
            this.getModel().initValue("confirmation_tag", (Object)interinsInfo.getString("confirmation_tag"));
            this.getModel().initValue("enhancement", (Object)interinsInfo.getString("enhancement"));
            this.getModel().initValue("enhancement_tag", (Object)interinsInfo.getString("enhancement_tag"));
            this.getModel().initValue("improvement", (Object)interinsInfo.getString("improvement"));
            this.getModel().initValue("improvement_tag", (Object)interinsInfo.getString("improvement_tag"));
            this.getModel().initValue("suggestion", (Object)interinsInfo.getString("suggestionsuggestion"));
            this.getModel().initValue("suggestion_tag", (Object)interinsInfo.getString("suggestionsuggestion_tag"));
        }
        this.getModel().initValue("user", (Object)currUserId);
        this.getView().updateView("actinsflex");
        this.getView().updateView("interinsflex");
    }

    private void initPersonInfo(DynamicObject interObj) {
        HashMap requestParam = Maps.newHashMapWithExpectedSize((int)3);
        Long employeeId = interObj.getLong("employee.id");
        ArrayList<Long> employeeIds = new ArrayList<Long>(10);
        if (employeeId != null) {
            employeeIds.add(employeeId);
        }
        requestParam.put("sign", "employee");
        requestParam.put("signList", employeeIds);
        requestParam.put("dateTime", new Date());
        String companyAge = "-";
        try {
            Map ageRetMap;
            Map map;
            Map queryResult = EMPLOYEE_SERVICE.listPersonServiceAgeWithIds((Map)requestParam);
            Boolean success = (Boolean)queryResult.get("success");
            if (success.booleanValue() && (map = (Map)(ageRetMap = (Map)queryResult.get("data")).get(employeeId)) != null && map.containsKey("companyWorkAge")) {
                BigDecimal entservicelen = (BigDecimal)map.get("companyWorkAge");
                entservicelen = entservicelen == null ? BigDecimal.ZERO : entservicelen;
                companyAge = entservicelen.stripTrailingZeros().toPlainString();
            }
        }
        catch (Exception e) {
            log.error("InterviewTaskProcessPlugin.EMPLOYEE_SERVICE.listPersonServiceAgeWithIds   error, requestParam:" + requestParam);
            log.error((Throwable)e);
        }
        Label companyageLabel = (Label)this.getControl("companyage");
        companyageLabel.setText(companyAge);
        Image image = (Image)this.getControl("headsculpture");
        image.setUrl(HRImageUrlUtil.getImageFullUrl((String)String.valueOf(interObj.getString("person.headsculpture"))));
        this.getModel().initValue("perffile", (Object)interObj.getLong("perffile.id"));
        this.getModel().initValue("affiliateadminorg", (Object)interObj.getLong("affiliateadminorg.id"));
        this.getModel().initValue("evalobj", (Object)interObj.getLong("evalobj.id"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (source.getOperateKey()) {
            case "interviewback": {
                this.showInterviewReturnDialog(args);
                break;
            }
            case "save": {
                this.checkStatusBeforeSave(args);
                break;
            }
        }
    }

    private void showInterviewReturnDialog(BeforeDoOperationEventArgs args) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String reason = source.getOption().getVariableValue("reason", "");
        if (HRStringUtils.isEmpty((String)reason)) {
            args.setCancel(true);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("epa_interviewreturndialog");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_returntaskdialog"));
            parameter.setHasRight(true);
            this.getView().showForm(parameter);
            return;
        }
        this.validate(reason, args);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "epa_returntaskdialog": {
                String reason = (String)event.getReturnData();
                if (HRStringUtils.isEmpty((String)reason)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("reason", reason);
                this.getView().invokeOperation("interviewback", operateOption);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        OperationResult operationResult = args.getOperationResult();
        switch (source.getOperateKey()) {
            case "save": {
                this.saveInterviewTask();
                String isSubmit = this.getView().getPageCache().get("isSubmit");
                if (!"1".equals(isSubmit)) break;
                args.getOperationResult().setShowMessage(false);
                this.getView().getPageCache().put("isSubmit", "0");
                break;
            }
            case "interviewback": {
                String reason = source.getOption().getVariableValue("reason", "");
                this.interviewBackTask(reason);
                break;
            }
            case "intersubmit": 
            case "insertaudit": {
                this.sumbitInterviewTask(operationResult, source.getOperateKey());
            }
        }
        this.getView().getPageCache().remove(ISMODIFY);
    }

    private void checkStatusBeforeSave(BeforeDoOperationEventArgs args) {
        Long taskId = this.getTaskId();
        Map taskStatusMap = FLOW_RU_SECOND_DOMAIN_SERVICE.queryTasksStatusByIds(Collections.singletonList(taskId));
        String taskStatusCode = (String)taskStatusMap.get(taskId);
        if (HRStringUtils.isEmpty((String)taskStatusCode) || !FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatusCode) && !FlowRuTaskStatusEnum.PROCESSING.getCode().equals(taskStatusCode)) {
            String taskStatusStr = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatusCode).getText();
            String failMsg = ResManager.loadKDString((String)"{0}\u4efb\u52a1\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"InterviewTaskProcessPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{taskStatusStr});
            this.getView().showErrorNotification(failMsg);
            this.setViewOperationStatus(OperationStatus.VIEW);
            this.getView().setEnable(Boolean.FALSE, new String[]{"attachmentpanelap"});
            args.setCancel(true);
        }
    }

    private void interviewBackTask(String reason) {
        Long taskId = this.getTaskId();
        FlowValidateResultBo flowValidateResultBo = FLOW_RU_SECOND_DOMAIN_SERVICE.batchRollbackTasks(Collections.singletonList(taskId), reason);
        String backFail = ResManager.loadKDString((String)"\u9000\u56de\u5931\u8d25", (String)"InterviewTaskProcessPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        if (null == flowValidateResultBo) {
            this.getView().showErrorNotification(backFail);
            return;
        }
        String code = flowValidateResultBo.getCode();
        Map validateMap = flowValidateResultBo.getValidateMap();
        if (HRStringUtils.equals((String)"1", (String)code) || MapUtils.isEmpty((Map)validateMap)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9000\u56de\u6210\u529f", (String)"InterviewTaskProcessPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.setTaskStatus();
            this.releaseMutex();
            return;
        }
        this.getView().showErrorNotification(backFail);
    }

    private void setViewOperationStatus(OperationStatus operationStatus) {
        IPageCache pageCache = this.getPageCache();
        String reviewercanedit = pageCache.get("reviewercanedit");
        Long nodeType = this.getNodeType();
        if (null != nodeType && nodeType.compareTo(NodeTypeEnum.INTERVIEW_AUDIT.getValue()) == 0 && HRStringUtils.isNotEmpty((String)reviewercanedit) && HRStringUtils.equals((String)reviewercanedit, (String)"false")) {
            this.getView().setStatus(OperationStatus.VIEW);
            return;
        }
        this.getView().setStatus(operationStatus);
    }

    private void validate(String reason, BeforeDoOperationEventArgs args) {
        if (HRStringUtils.isEmpty((String)reason)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9000\u56de\u539f\u56e0\u3002", (String)"InterviewTaskProcessPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        if (reason.length() > 255) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u957f\u5ea6\u4e0d\u8d85\u8fc7255\u7684\u9000\u56de\u539f\u56e0\u3002", (String)"InterviewTaskProcessPlugin_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        Long taskId = this.getTaskId();
        log.info("InterviewTaskProcessPlugin-submitTask {} ", (Object)taskId);
        Map taskStatusMap = FLOW_RU_SECOND_DOMAIN_SERVICE.queryTasksStatusByIds(Collections.singletonList(taskId));
        String taskStatusCode = (String)taskStatusMap.get(taskId);
        if (HRStringUtils.isEmpty((String)taskStatusCode) || !FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatusCode) && !FlowRuTaskStatusEnum.PROCESSING.getCode().equals(taskStatusCode)) {
            String taskStatusStr = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatusCode).getText();
            String failMsg = ResManager.loadKDString((String)"{0}\u4efb\u52a1\u4e0d\u80fd\u9000\u56de\u3002", (String)"InterviewTaskProcessPlugin_8", (String)"opmc-epa-formplugin", (Object[])new Object[]{taskStatusStr});
            this.getView().showErrorNotification(failMsg);
            args.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
    }

    private void sumbitInterviewTask(OperationResult operationResult, String operationKey) {
        boolean isOperationSuccess;
        boolean bl = isOperationSuccess = !HRObjectUtils.isEmpty((Object)operationResult) && operationResult.isSuccess();
        if (isOperationSuccess) {
            Long taskId = this.getTaskId();
            log.info("InterviewTaskProcessPlugin-submitTask {} ", (Object)taskId);
            Map taskStatusMap = FLOW_RU_SECOND_DOMAIN_SERVICE.queryTasksStatusByIds(Collections.singletonList(taskId));
            String taskStatusCode = (String)taskStatusMap.get(taskId);
            if (HRStringUtils.isEmpty((String)taskStatusCode) || !FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatusCode) && !FlowRuTaskStatusEnum.PROCESSING.getCode().equals(taskStatusCode)) {
                String taskStatusStr = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatusCode).getText();
                String failMsg = ResManager.loadKDString((String)"{0}\u4efb\u52a1\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"InterviewTaskProcessPlugin_9", (String)"opmc-epa-formplugin", (Object[])new Object[]{taskStatusStr});
                this.getView().showErrorNotification(failMsg);
                this.setViewOperationStatus(OperationStatus.VIEW);
                this.getView().setEnable(Boolean.FALSE, new String[]{"attachmentpanelap"});
                return;
            }
            this.getView().getPageCache().put("isSubmit", "1");
            this.getView().invokeOperation("save");
            String isSubmit = this.getView().getPageCache().get("isSubmit");
            if ("0".equals(isSubmit)) {
                boolean submitTask = this.FLOW_RU_PROC_APPLICATION_SERVICE.submitTask(taskId);
                log.info("InterviewTaskProcessPlugin-submitTask result {} ", (Object)submitTask);
                if (submitTask) {
                    log.info(" after submitTask {} ", (Object)taskId);
                    this.showSuccessNotification(operationKey);
                    this.setTaskStatus();
                    this.getView().setEnable(Boolean.FALSE, new String[]{"attachmentpanelap"});
                    this.releaseMutex();
                    return;
                }
                this.showFlowFailNotification();
            }
        }
    }

    private String getTaskStatus(Long taskId) {
        DynamicObject[] taskDyArr = FLOW_RU_SECOND_DOMAIN_SERVICE.queryTaskByIds(Collections.singletonList(taskId));
        if (null == taskDyArr || taskDyArr.length <= 0) {
            return "";
        }
        DynamicObject taskDy = taskDyArr[0];
        String taskStatus = taskDy.getString("taskstatus");
        this.setNodeIndex(taskDy);
        return taskStatus;
    }

    private void setNodeIndex(DynamicObject taskDy) {
        if (HRObjectUtils.isEmpty((Object)taskDy) || HRObjectUtils.isEmpty((Object)this.getPageCache())) {
            return;
        }
        IPageCache pageCache = this.getView().getPageCache();
        String nodeIndex = pageCache.get("nodeindex");
        if (HRStringUtils.isNotEmpty((String)nodeIndex)) {
            return;
        }
        pageCache.put("nodeindex", taskDy.getString("flowrunode.index"));
    }

    private void setTaskStatus() {
        String taskStatus;
        Long taskId = this.getTaskId();
        if (ObjectUtils.isEmpty((Object)taskId)) {
            return;
        }
        switch (taskStatus = this.getTaskStatus(taskId)) {
            case "20": 
            case "30": {
                this.setLabelText("interstatustxt", ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"InterviewTaskProcessPlugin_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.setAssessStatusStyles(AssessStatusEnum.ASSESSING.getForeColor(), AssessStatusEnum.ASSESSING.getBgColor(), AssessStatusEnum.ASSESSING.getBorderColor());
                this.setViewOperationStatus(OperationStatus.EDIT);
                this.setBtnVisible("0");
                break;
            }
            case "40": {
                this.setLabelText("interstatustxt", ResManager.loadKDString((String)"\u5df2\u5904\u7406", (String)"InterviewTaskProcessPlugin_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.setAssessStatusStyles(AssessStatusEnum.ASSESSED.getForeColor(), AssessStatusEnum.ASSESSED.getBgColor(), AssessStatusEnum.ASSESSED.getBorderColor());
                this.setViewOperationStatus(OperationStatus.VIEW);
                this.setBtnVisible("1");
                break;
            }
            case "60": {
                this.setLabelText("interstatustxt", ResManager.loadKDString((String)"\u5df2\u5931\u6548", (String)"InterviewTaskProcessPlugin_12", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.setAssessStatusStyles(AssessStatusEnum.EXPIRED.getForeColor(), AssessStatusEnum.EXPIRED.getBgColor(), AssessStatusEnum.EXPIRED.getBorderColor());
                this.setViewOperationStatus(OperationStatus.VIEW);
                this.setBtnVisible("1");
                break;
            }
            case "80": {
                this.setLabelText("interstatustxt", ResManager.loadKDString((String)"\u5df2\u9000\u56de", (String)"InterviewTaskProcessPlugin_13", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.setAssessStatusStyles(AssessStatusEnum.RETURNED.getForeColor(), AssessStatusEnum.RETURNED.getBgColor(), AssessStatusEnum.RETURNED.getBorderColor());
                this.setViewOperationStatus(OperationStatus.VIEW);
                this.setBtnVisible("1");
                break;
            }
            case "90": {
                this.setLabelText("interstatustxt", ResManager.loadKDString((String)"\u5df2\u6302\u8d77", (String)"InterviewTaskProcessPlugin_14", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.setAssessStatusStyles(AssessStatusEnum.PENDING.getForeColor(), AssessStatusEnum.PENDING.getBgColor(), AssessStatusEnum.PENDING.getBorderColor());
                this.setViewOperationStatus(OperationStatus.VIEW);
                this.setBtnVisible("1");
                break;
            }
        }
    }

    private void setBtnVisible(String type) {
        String nodeindex;
        if (HRStringUtils.equals((String)type, (String)"1")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"close"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"print", "approved", "back", "save", "submit"});
            return;
        }
        Long nodeType = this.getNodeType();
        if (null == nodeType) {
            return;
        }
        if (nodeType.compareTo(NodeTypeEnum.INTERVIEW_FILL_IN.getValue()) == 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"close", "save", "submit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"print", "approved"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"close", "approved", "save"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"print", "submit"});
        }
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if (operationStatus == OperationStatus.VIEW) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"save"});
        }
        if (HRStringUtils.isNotEmpty((String)(nodeindex = this.getView().getPageCache().get("nodeindex"))) && !HRStringUtils.equals((String)nodeindex, (String)"1")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"back"});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"back"});
    }

    private void setLabelText(String label, String text) {
        Label activityNameLab = (Label)this.getControl(label);
        activityNameLab.setText(text);
    }

    private void setAssessStatusStyles(String foreColor, String bgColor, String borderColor) {
        HashMap<String, String> foreColorMap = new HashMap<String, String>(16);
        foreColorMap.put("fc", foreColor);
        this.getView().updateControlMetadata("interstatustxt", foreColorMap);
        HashMap<String, String> bgColorMap = new HashMap<String, String>(16);
        bgColorMap.put("bc", bgColor);
        this.getView().updateControlMetadata("interstatusap", bgColorMap);
        HashMap<String, String> borderMap = new HashMap<String, String>(16);
        borderMap.put("r", "1px_solid_" + borderColor);
        borderMap.put("l", "1px_solid_" + borderColor);
        borderMap.put("t", "1px_solid_" + borderColor);
        borderMap.put("b", "1px_solid_" + borderColor);
        HashMap<String, HashMap<String, String>> statusapMap = new HashMap<String, HashMap<String, String>>(16);
        statusapMap.put("b", borderMap);
        HashMap<String, HashMap<String, HashMap<String, String>>> styleMap = new HashMap<String, HashMap<String, HashMap<String, String>>>(16);
        styleMap.put("s", statusapMap);
        this.getView().updateControlMetadata("interstatusap", styleMap);
    }

    private void saveInterviewTask() {
        DynamicObject actins = this.getModel().getDataEntity(true).getDynamicObject("actins");
        actins.set("user", (Object)this.getModel().getDataEntity(true).getLong("user.id"));
        actins.set("interplace", (Object)this.getModel().getDataEntity(true).getString("interplace"));
        actins.set("intertime", (Object)this.getModel().getDataEntity(true).getDate("intertime"));
        HRBaseServiceHelper actinsServiceHelper = new HRBaseServiceHelper("epa_actins");
        actinsServiceHelper.updateOne(actins);
        long interinsId = this.getModel().getDataEntity(true).getDynamicObject("interins").getLong("id");
        DynamicObject interins = BusinessDataServiceHelper.loadSingle((Object)interinsId, (String)"epa_interins");
        interins.set("confirmation", this.getModel().getValue("confirmation"));
        interins.set("confirmation_tag", this.getModel().getValue("confirmation_tag"));
        interins.set("enhancement", this.getModel().getValue("enhancement"));
        interins.set("enhancement_tag", this.getModel().getValue("enhancement_tag"));
        interins.set("improvement", this.getModel().getValue("improvement"));
        interins.set("improvement_tag", this.getModel().getValue("improvement_tag"));
        interins.set("suggestionsuggestion", this.getModel().getValue("suggestion"));
        interins.set("suggestionsuggestion_tag", this.getModel().getValue("suggestion_tag"));
        HRBaseServiceHelper interinsServiceHelper = new HRBaseServiceHelper("epa_interins");
        interinsServiceHelper.updateOne(interins);
    }

    private Long getTaskId() {
        if (ObjectUtils.isEmpty((Object)this.getView().getFormShowParameter())) {
            return null;
        }
        Object taskId = this.getView().getFormShowParameter().getCustomParam("taskId");
        log.info("InterviewTaskProcessPlugin-taskId: {}", taskId);
        if (ObjectUtils.isEmpty((Object)taskId)) {
            return null;
        }
        long aLong = taskId instanceof String ? Long.parseLong((String)taskId) : (Long)taskId;
        return aLong;
    }

    private void showSuccessNotification(String operationKey) {
        if (HRStringUtils.equals((String)operationKey, (String)"intersubmit")) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"InterviewTaskProcessPlugin_15", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f", (String)"InterviewTaskProcessPlugin_16", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
    }

    private void showFlowFailNotification() {
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u7528\u7ee9\u6548\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\u3002", (String)"InterviewTaskProcessPlugin_17", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
    }

    private void setAuditCache(long taskId) {
        Long nodeType = this.FLOW_RU_PROC_APPLICATION_SERVICE.queryDefNodeByTaskId(Long.valueOf(taskId));
        if (nodeType != null) {
            IPageCache pageCache = this.getView().getPageCache();
            if (nodeType.compareTo(NodeTypeEnum.INTERVIEW_FILL_IN.getValue()) == 0) {
                pageCache.put("isAudit", "false");
            } else {
                pageCache.put("isAudit", "true");
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u8282\u70b9\u7c7b\u578b\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\u3002", (String)"InterviewTaskProcessPlugin_25", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkMutex(PreOpenFormEventArgs args, DynamicObject ruTask) {
        String interObjId = (String)args.getFormShowParameter().getCustomParam("pkId");
        Long nodeType = this.FLOW_RU_PROC_APPLICATION_SERVICE.queryDefNodeByTaskId(Long.valueOf(ruTask.getLong("id")));
        if (nodeType != null) {
            if (nodeType.compareTo(NodeTypeEnum.INTERVIEW_FILL_IN.getValue()) == 0) {
                MutexHelper.release((String)"epa_intertaskprocess", (String)"modify", (String)interObjId);
            } else {
                DataMutex dataMutex = DataMutex.create();
                Map lockInfo = dataMutex.getLockInfo(interObjId, "default_netctrl", "epa_intertaskprocess");
                if (lockInfo != null && lockInfo.size() > 0) {
                    Long userId;
                    long ruNodeId = ruTask.getLong("flowrunode.id");
                    boolean isExistTask = FLOW_RU_SECOND_DOMAIN_SERVICE.queryEffectiveTask(ruNodeId, userId = Long.valueOf((String)lockInfo.get("userid")));
                    if (isExistTask) {
                        StringBuilder builder = new StringBuilder();
                        String client = (String)lockInfo.get("client");
                        if (userId == -1L) {
                            builder.append("guest");
                        } else {
                            DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
                            if (userObj != null) {
                                builder.append(userObj.getString("name"));
                            }
                        }
                        if (StringUtils.isNotBlank((CharSequence)client)) {
                            builder.append(ResManager.loadKDString((String)"\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"InterviewTaskProcessPlugin_18", (String)"bos-mservice-operation", (Object[])new Object[0]));
                        } else {
                            builder.append(ResManager.loadKDString((String)"\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"InterviewTaskProcessPlugin_19", (String)"bos-mservice-operation", (Object[])new Object[0]));
                        }
                        args.setCancel(true);
                        args.setCancelMessage(builder.toString());
                    } else {
                        String mutexObjId = (String)lockInfo.get("dataObjId");
                        MutexHelper.release((String)"epa_intertaskprocess", (String)"modify", (String)mutexObjId);
                    }
                }
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u8282\u70b9\u7c7b\u578b\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\u3002", (String)"InterviewTaskProcessPlugin_25", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
    }

    private void setMutex() {
        String isAudit = this.getView().getPageCache().get("isAudit");
        if ("true".equals(isAudit)) {
            Long interObjId = this.requireInterObjId();
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (OperationStatus.EDIT == status) {
                DataMutex dataMutex = DataMutex.create();
                Map lockInfo = dataMutex.getLockInfo(String.valueOf(interObjId), "default_netctrl", "epa_intertaskprocess");
                if (lockInfo == null || lockInfo.size() == 0) {
                    MutexLockInfo info = new MutexLockInfo(String.valueOf(interObjId), null, null, "epa_intertaskprocess", "modify", true, "default");
                    StringBuilder msgBuilder = new StringBuilder();
                    boolean bl = MutexHelper.require((MutexLockInfo)info, (StringBuilder)msgBuilder);
                }
                try {
                    dataMutex.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
    }

    private void releaseMutex() {
        String isAudit = this.getView().getPageCache().get("isAudit");
        if ("true".equals(isAudit)) {
            Long pkValue = this.requireInterObjId();
            MutexHelper.release((String)"epa_intertaskprocess", (String)"modify", (String)String.valueOf(pkValue));
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        this.releaseMutex();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit userF7 = (BasedataEdit)this.getView().getControl("user");
        userF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"workflowshow"});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fileKey = e.getProperty().getName();
        if (HRStringUtils.isNotEmpty((String)fileKey) && "user".equals(fileKey)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("enable", "=", (Object)"1"));
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("isforbidden", "=", (Object)"0"));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
        String close = this.getView().getPageCache().get("changeConfirm");
        String isModify = this.getView().getPageCache().get(ISMODIFY);
        if (HRStringUtils.isNotEmpty((String)isModify) && "true".equals(isModify)) {
            if (!"1".equals(close)) {
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"InterviewTaskProcessPlugin_20", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"InterviewTaskProcessPlugin_21", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f", (String)"InterviewTaskProcessPlugin_22", (String)"opmc-epa-formplugin", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"InterviewTaskProcessPlugin_23", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                msg = StringUtils.isNotBlank((CharSequence)msg) ? msg.replaceAll("\\\\r\\\\n", "\r\n") : msg;
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("changeConfirm", (IFormPlugin)this);
                this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
                e.setCancel(Boolean.TRUE.booleanValue());
            }
        } else {
            this.getView().getModel().setDataChanged(false);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if ("changeConfirm".equals(evt.getCallBackId()) && MessageBoxResult.Yes == evt.getResult()) {
            this.getView().getModel().setDataChanged(false);
            this.getView().getPageCache().remove(ISMODIFY);
            this.getView().getPageCache().put("changeConfirm", "1");
            this.getView().getPageCache().saveChanges();
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (HRStringUtils.isNotEmpty((String)name) && ("user".equals(name) || "interplace".equals(name) || "intertime".equals(name) || "confirmation".equals(name) || "confirmation_tag".equals(name) || "enhancement".equals(name) || "enhancement_tag".equals(name) || "improvement".equals(name) || "improvement_tag".equals(name) || "suggestion".equals(name) || "suggestion_tag".equals(name))) {
            this.getView().getPageCache().put(ISMODIFY, "true");
        }
    }

    private void initEvaResultInfo(DynamicObject interObj) {
        Label evaResultLab = (Label)this.getControl("evaresultlab");
        if (evaResultLab != null) {
            long perffileId = interObj.getLong("perffile.id");
            long activityId = interObj.getLong("evalobj.activity.id");
            String evaResult = INTERVIEW_OBJ_APPLICATION.getAuditedEvaResultByPerffileAndActivity(Long.valueOf(activityId), Long.valueOf(perffileId));
            evaResultLab.setText(evaResult);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("workflowshow".equals(key)) {
            Object interObjId = this.getView().getFormShowParameter().getCustomParam("pkId");
            DynamicObject interObj = BusinessDataServiceHelper.loadSingle((Object)interObjId, (String)"epa_interobj");
            if (interObj == null) {
                log.info("\u6253\u5f00\u9762\u8c08\u6d41\u7a0b\u56fe\u5931\u8d25\uff0c\u9762\u8c08\u5bf9\u8c61\u4e3a\u7a7a");
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setCustomParam("taskId", (Object)this.getTaskId());
            formShowParameter.setCustomParam("flowType", (Object)"interviewflow");
            formShowParameter.setCustomParam("evalflowinsId", (Object)interObj.getLong("interflowins.id"));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("epa_workflow_proc");
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u9762\u8c08\u4fe1\u606f\u6d41\u7a0b", (String)"InterviewTaskProcessPlugin_24", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("600");
            styleCss.setHeight("600");
            formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
            formShowParameter.setHasRight(true);
            this.getView().showForm(formShowParameter);
        }
    }
}

