/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.interview.interviewobj;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.extplugin.PluginFilter;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.opmc.epa.business.domain.activitymanage.extpoint.IInterviewedObjListService;
import kd.opmc.epa.business.domain.interview.enums.InterStatusEnum;
import kd.opmc.epa.business.utils.InterViewObjUtils;
import kd.opmc.epa.formplugin.web.utils.BosListUtil;
import kd.opmc.epa.formplugin.web.utils.InterviewSchemeSearchUtils;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;

public class InterviewedObjList
extends HRDataBaseList {
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();
    private static final IInterviewedObjListService iInterviewedObjListService = IInterviewedObjListService.getInstance();

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<String> fixedColumnList = Arrays.asList("fseq", "person.headsculpture", "perffile.name", "perffile.billno");
        fixedColumnList.forEach(column -> {
            if (args.getListColumn(column) != null) {
                args.getListColumn(column).setFixed(true);
            }
        });
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("interact");
        QFilter statusFilter = new QFilter("interact", "=", (Object)activityId).and("interstatus", "in", (Object)new String[]{InterStatusEnum.COMPLETED.getStatus(), InterStatusEnum.ENDED.getStatus()});
        evt.getQFilters().add(statusFilter);
        evt.getQFilters().add(statusFilter);
        evt.setOrderBy("modifytime desc");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        if (!InterViewObjUtils.checkInterViewProcessPermission((IFormView)this.getView())) {
            args.setCancel(true);
            return;
        }
        String operateKey = op.getOperateKey();
        if ("reset".equals(operateKey)) {
            this.beforeResetOp(args);
        }
    }

    private void beforeResetOp(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows;
        int size;
        AbstractOperate source = (AbstractOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        if (!HRStringUtils.equals((String)systemInvoke, (String)"true") && (size = (selectedRows = this.getSelectedRows()).size()) > 0) {
            String msg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u60a8\u5df2\u9009\u62e9{0}\u4eba\uff0c\u91cd\u7f6e\u540e\uff0c\u9762\u8c08\u5bf9\u8c61\u5c06\u9000\u56de\u81f3\u5f85\u9762\u8c08\uff0c\u9762\u8c08\u8868\u5355\u7684\u586b\u5199\u5185\u5bb9\u53ca\u624b\u52a8\u8bbe\u7f6e\u7684\u5904\u7406\u4eba\u5c06\u88ab\u4fdd\u7559\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"InterviewedObjList_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{this.getSelectedRows().size()}));
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("reset", (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "refresh": {
                this.getView().getParentView().invokeOperation("refreshnum");
                this.getView().sendFormAction(this.getView().getParentView());
                break;
            }
            case "reset": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("perffile_name".equals(fieldName)) {
            if (!InterViewObjUtils.checkInterViewProcessPermission((IFormView)this.getView())) {
                return;
            }
            IFormView formView = this.getView();
            if (formView instanceof IListView) {
                IListView listView = (IListView)formView;
                Long interobjId = (Long)listView.getFocusRowPkId();
                String formId = "epa_intertaskprocess";
                String pageId = this.getView().getPageId() + this.getView().getFormShowParameter().getAppId() + this.getFocusRowPkId();
                HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)iInterviewedObjListService, IInterviewedObjListService.class, (String)"kd.opmc.epa.business.domain.activitymanage.extpoint.IInterviewedObjListService#getInterObjInfoPage", (PluginFilter)null);
                List baseShowParameters = pluginProxy.callReplaceIfPresent(p -> p.getInterObjInfoPage(formId, interobjId, pageId));
                this.getView().showForm((FormShowParameter)baseShowParameters.get(0));
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setColumnFit();
    }

    private void setColumnFit() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("columnResizeMode", "fit");
        this.getView().updateControlMetadata("gridview", map);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        InterviewSchemeSearchUtils.filterF7Select(this.getView(), args);
        super.filterContainerBeforeF7Select(args);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        BosListUtil.setListBgColor(this.getView(), "#ffffff");
        BosListUtil.setGripAndMargin(this.getView());
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (!MessageBoxResult.Yes.equals((Object)result)) {
            return;
        }
        switch (callBackId) {
            case "reset": {
                OperateOption resetOp = OperateOption.create();
                resetOp.setVariableValue("systeminvoke", "true");
                resetOp.setVariableValue("OP_SOURCE", "epa_interviewedobj");
                this.getView().invokeOperation("reset", resetOp);
                break;
            }
        }
    }
}

