/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.interview.interviewobj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.interview.InterviewObjApplication;
import kd.opmc.epa.business.domain.activitymanage.entity.PushResultBo;
import kd.opmc.epa.business.domain.interview.entity.EndInterResultBo;
import kd.opmc.epa.business.domain.interview.entityservice.InterviewObjEntityService;
import kd.opmc.epa.business.domain.interview.enums.InterStatusEnum;
import kd.opmc.epa.business.domain.interview.service.InterviewObjDomainService;
import kd.opmc.epa.business.utils.InterViewObjUtils;
import kd.opmc.epa.formplugin.web.utils.BosListUtil;
import kd.opmc.epa.formplugin.web.utils.InterviewSchemeSearchUtils;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;

public class InterviewingObjList
extends HRDataBaseList {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final String PUSH_OBJ = "pushobj";
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();
    private static final InterviewObjDomainService INTERVIEW_OBJ_DOMAIN_SERVICE = InterviewObjDomainService.getInstance();
    private static final InterviewObjEntityService INTERVIEW_OBJ_ENTITY_SERVICE = InterviewObjEntityService.getInstance();
    private static final FlowRuProcApplicationService FLOW_RU_PROC_APPLICATION_SERVICE = FlowRuProcApplicationService.getInstance();
    private static final InterviewObjApplication INTERVIEW_OBJ_APPLICATION = InterviewObjApplication.getInstance();
    private Map<Long, Map<String, String>> CUR_NODE_MAP = new HashMap<Long, Map<String, String>>(16);
    private Map<Long, String> OBJ_FLOWINFO_MAP = new HashMap<Long, String>(16);
    private static final String INTER_PROCESS_AP = "interprocessap";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{INTER_PROCESS_AP});
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<String> fixedColumnList = Arrays.asList("fseq", "person.headsculpture", "perffile.name", "perffile.billno");
        fixedColumnList.forEach(column -> {
            if (args.getListColumn(column) != null) {
                args.getListColumn(column).setFixed(true);
            }
        });
    }

    public void setFilter(SetFilterEvent evt) {
        List qFilters = evt.getQFilters();
        InterviewSchemeSearchUtils.assembleSchemeSearchFilter(qFilters);
        super.setFilter(evt);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("interact");
        QFilter statusFilter = new QFilter("interact", "=", (Object)activityId).and("interstatus", "=", (Object)InterStatusEnum.HAVE_IN_HAND.getStatus());
        evt.getQFilters().add(statusFilter);
        evt.setOrderBy("modifytime desc");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        if (!InterViewObjUtils.checkInterViewProcessPermission((IFormView)this.getView())) {
            args.setCancel(true);
            return;
        }
        String operateKey = op.getOperateKey();
        if ("reset".equals(operateKey)) {
            this.beforeResetOp(args);
        } else if ("interprocess".equals(operateKey)) {
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("interact");
            DynamicObject[] dynamicObjects = INTERVIEW_OBJ_DOMAIN_SERVICE.queryByActAndNotEqualInterflowins("id", activityId, new String[]{"10", "50"});
            if (dynamicObjects == null || dynamicObjects.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u3002", (String)"InterviewingObjList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter baseShowParameter = new FormShowParameter();
            baseShowParameter.setFormId("epa_interprocess");
            baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            baseShowParameter.setStatus(OperationStatus.EDIT);
            baseShowParameter.setPageId("epa_interprocess" + activityId.toString());
            baseShowParameter.setCustomParam("interact", (Object)activityId);
            this.getView().showForm(baseShowParameter);
        }
    }

    private void beforeResetOp(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows;
        int size;
        AbstractOperate source = (AbstractOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        if (!HRStringUtils.equals((String)systemInvoke, (String)"true") && (size = (selectedRows = this.getSelectedRows()).size()) > 0) {
            String msg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u60a8\u5df2\u9009\u62e9{0}\u4eba\uff0c\u91cd\u7f6e\u540e\uff0c\u9762\u8c08\u5bf9\u8c61\u5c06\u9000\u56de\u81f3\u5f85\u9762\u8c08\uff0c\u9762\u8c08\u8868\u5355\u7684\u586b\u5199\u5185\u5bb9\u53ca\u624b\u52a8\u8bbe\u7f6e\u7684\u5904\u7406\u4eba\u5c06\u88ab\u4fdd\u7559\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"InterviewingObjList_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{size}));
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("reset", (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "reset": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "interend": {
                this.doInterEndOp();
                this.getView().invokeOperation("refresh");
                this.getView().getParentView().invokeOperation("refreshnum");
                this.getView().sendFormAction(this.getView().getParentView());
                break;
            }
            case "pushobj": {
                this.interObjPush();
                break;
            }
            case "refresh": {
                this.getView().getParentView().invokeOperation("refreshnum");
                this.getView().sendFormAction(this.getView().getParentView());
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (!MessageBoxResult.Yes.equals((Object)result)) {
            return;
        }
        switch (callBackId) {
            case "reset": {
                OperateOption resetOp = OperateOption.create();
                resetOp.setVariableValue("systeminvoke", "true");
                resetOp.setVariableValue("OP_SOURCE", "epa_interviewingobj");
                this.getView().invokeOperation("reset", resetOp);
                break;
            }
        }
    }

    private void doInterEndOp() {
        Long activityId;
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List objIds = Arrays.stream(selectedRows.getPrimaryKeyValues()).map(row -> Long.parseLong(row.toString())).collect(Collectors.toList());
        EndInterResultBo endInterResultBo = INTERVIEW_OBJ_DOMAIN_SERVICE.endEvaObjInterview(objIds, activityId = (Long)this.getView().getFormShowParameter().getCustomParam("interact"));
        if (endInterResultBo.getFailCount() == 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u6210\u529f", (String)"InterviewingObjList_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            String failMessage = endInterResultBo.getFailMessage();
            if (endInterResultBo.getObjCount() == 1) {
                this.getView().showTipNotification(failMessage);
            } else {
                String title = ResManager.loadKDString((String)"\u5171{0}\u6761\u5355\u636e\uff0c\u7ed3\u675f\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"InterviewingObjList_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{endInterResultBo.getObjCount(), endInterResultBo.getSuccessCount(), endInterResultBo.getFailCount()});
                this.getView().showMessage(title, failMessage, MessageTypes.Default);
            }
        }
    }

    private void interObjPush() {
        Long activityId;
        Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
        List objIds = Arrays.stream(primaryKeyValues).map(id -> Long.parseLong(id.toString())).collect(Collectors.toList());
        PushResultBo pushResultBo = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.pushByInterObjIds(objIds, activityId = (Long)this.getView().getFormShowParameter().getCustomParam("interact"));
        if (pushResultBo.getFailCount() > 0 && pushResultBo.getSuccessCount() > 0) {
            String title = ResManager.loadKDString((String)"\u5171\u52fe\u9009{0}\u4e2a\u9762\u8c08\u5bf9\u8c61\uff0c\u53ef\u50ac\u529e\u9762\u8c08\u4efb\u52a1\u5171{1}\u6761\uff0c\u50ac\u529e\u6210\u529f{2}\u6761\uff0c\u5931\u8d25{3}\u6761", (String)"InterviewingObjList_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{pushResultBo.getObjCount(), pushResultBo.getTaskCount(), pushResultBo.getSuccessCount(), pushResultBo.getFailCount()});
            this.getView().showMessage(title, pushResultBo.getFailMessage(), MessageTypes.Default);
        } else if ((long)pushResultBo.getSuccessCount() == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5171\u52fe\u9009{0}\u4e2a\u9762\u8c08\u5bf9\u8c61\uff0c\u53ef\u50ac\u529e\u9762\u8c08\u4efb\u52a1\u51710\u6761\uff0c\u50ac\u529e\u5931\u8d25", (String)"InterviewingObjList_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{pushResultBo.getObjCount()}));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5171\u52fe\u9009{0}\u4e2a\u9762\u8c08\u5bf9\u8c61\uff0c\u53ef\u50ac\u529e\u9762\u8c08\u4efb\u52a1\u5171{1}\u6761\uff0c\u5168\u90e8\u50ac\u529e\u6210\u529f", (String)"InterviewingObjList_7", (String)"opmc-epa-formplugin", (Object[])new Object[]{pushResultBo.getObjCount(), pushResultBo.getTaskCount()}));
        }
    }

    public void beforePackageData(BeforePackageDataEvent evt) {
        super.beforePackageData(evt);
        DynamicObjectCollection datas = evt.getPageData();
        boolean selectedAllRows = ((ListModel)evt.getSource()).isSelectedAllRows();
        if (!datas.isEmpty() && !selectedAllRows) {
            Map<Object, Object> objIdProcMap = new HashMap(16);
            List<Object> procIds = new ArrayList(10);
            List interObjIds = datas.stream().map(actObj -> actObj.getLong("id")).collect(Collectors.toList());
            String selectFiled = "id,interflowins";
            DynamicObject[] interObjs = INTERVIEW_OBJ_ENTITY_SERVICE.queryInterviewobjsById(selectFiled, interObjIds);
            objIdProcMap = Arrays.stream(interObjs).collect(Collectors.toMap(obj1 -> obj1.getLong("id"), obj2 -> obj2.getLong("interflowins.id")));
            procIds = Arrays.stream(interObjs).map(obj -> obj.getLong("interflowins.id")).collect(Collectors.toList());
            HashMap<Long, Map<String, String>> ret = new HashMap<Long, Map<String, String>>(objIdProcMap.size());
            DynamicObject[] procs = FLOW_RU_PROC_APPLICATION_SERVICE.queryProcByProcIds(procIds);
            HashMap<Long, DynamicObject> curNodeMap = new HashMap<Long, DynamicObject>(procs.length);
            for (DynamicObject proc : procs) {
                curNodeMap.put(proc.getLong("id"), proc.getDynamicObject("currentnode"));
            }
            List curNodeIds = Arrays.stream(procs).map(x -> x.getLong("currentnode.id")).collect(Collectors.toList());
            Map curNodeTaskMap = FLOW_RU_PROC_APPLICATION_SERVICE.queryTaskByNodeIds(curNodeIds);
            Date date = new Date();
            for (Map.Entry<Object, Object> objIdProcId : objIdProcMap.entrySet()) {
                HashMap<String, String> tempMap = new HashMap<String, String>(4);
                DynamicObject currentNode = (DynamicObject)curNodeMap.get(objIdProcId.getValue());
                if (currentNode != null) {
                    tempMap.put("currentnode", currentNode.getString("name"));
                    tempMap.put("duration", DateUtils.getIntervalDays((Date)date, (Date)currentNode.getDate("starttime")) + "d");
                    List tasks = (List)curNodeTaskMap.get(currentNode.getLong("id"));
                    tempMap.put("currenthandler", tasks == null ? "-" : this.getCurrentHandlerStr(tasks));
                    tempMap.put("assessprocess", tasks == null ? "0/0" : this.getNodeHandlerNumber(tasks));
                } else {
                    tempMap.put("currentnode", "-");
                    tempMap.put("duration", "0d");
                    tempMap.put("currenthandler", "-");
                    tempMap.put("assessprocess", "0/0");
                }
                ret.put((Long)objIdProcId.getKey(), tempMap);
            }
            this.CUR_NODE_MAP = ret;
            this.OBJ_FLOWINFO_MAP = INTERVIEW_OBJ_APPLICATION.getFlowInfoByObjIds(interObjIds);
        }
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        Object source = evt.getSource();
        if (source instanceof DynamicTextColumnDesc) {
            DynamicTextColumnDesc columnDesc = (DynamicTextColumnDesc)source;
            Map<String, String> map = this.CUR_NODE_MAP.get(evt.getRowData().getLong("id"));
            switch (columnDesc.getKey()) {
                case "duration": {
                    this.setNodeFormatValue(evt, map, "duration");
                    break;
                }
                case "currenthandler": {
                    this.setNodeFormatValue(evt, map, "currenthandler");
                    break;
                }
                case "ruflowinfo": {
                    evt.setFormatValue((Object)this.OBJ_FLOWINFO_MAP.get(evt.getRowData().getLong("id")));
                }
            }
        }
    }

    private void setNodeFormatValue(PackageDataEvent evt, Map<String, String> map, String fieldKey) {
        if (map == null || ObjectUtils.isEmpty((Object)map.get(fieldKey))) {
            return;
        }
        evt.setFormatValue((Object)map.get(fieldKey));
    }

    private String getCurrentHandlerStr(List<DynamicObject> tasks) {
        StringBuilder sb = new StringBuilder();
        Map<Long, List<DynamicObject>> taskMap = tasks.stream().filter(task -> {
            FlowRuTaskStatusEnum status = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)task.getString("taskstatus"));
            return status == FlowRuTaskStatusEnum.NOT_ACTIVE || status == FlowRuTaskStatusEnum.WAITING || status == FlowRuTaskStatusEnum.PROCESSING || status == FlowRuTaskStatusEnum.BE_WAITTING || status == FlowRuTaskStatusEnum.RETURNED || status == FlowRuTaskStatusEnum.PENDING;
        }).collect(Collectors.groupingBy(tas -> tas.getLong("flowrurole.id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : taskMap.entrySet()) {
            if (!CollectionUtils.isNotEmpty((Collection)entry.getValue())) continue;
            sb.append(entry.getValue().get(0).getString("flowrurole.roletype.name")).append('\uff1a');
            for (DynamicObject taskDetail : entry.getValue()) {
                sb.append(taskDetail.getString("handler.name"));
                String handlerNumber = taskDetail.getString("handler.number");
                if (!HRStringUtils.isBlank((CharSequence)handlerNumber)) {
                    sb.append('\uff08').append(handlerNumber).append('\uff09').append('\uff0c');
                    continue;
                }
                sb.append('\uff0c');
            }
            if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '\uff0c') {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append('\uff1b');
        }
        if (sb.length() < 1) {
            return "";
        }
        return sb.charAt(sb.length() - 1) == '\uff1b' ? sb.deleteCharAt(sb.length() - 1).toString() : sb.toString();
    }

    private String getNodeHandlerNumber(List<DynamicObject> tasks) {
        return tasks.stream().filter(x -> FlowRuTaskStatusEnum.PROCESSED.getCode().equals(x.getString("taskstatus"))).count() + "/" + tasks.stream().filter(task -> {
            FlowRuTaskStatusEnum status = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)task.getString("taskstatus"));
            return status == FlowRuTaskStatusEnum.NOT_ACTIVE || status == FlowRuTaskStatusEnum.WAITING || status == FlowRuTaskStatusEnum.PROCESSING || status == FlowRuTaskStatusEnum.BE_WAITTING || status == FlowRuTaskStatusEnum.RETURNED || status == FlowRuTaskStatusEnum.PROCESSED || status == FlowRuTaskStatusEnum.PENDING;
        }).count();
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        InterviewSchemeSearchUtils.filterF7Select(this.getView(), args);
        super.filterContainerBeforeF7Select(args);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        BosListUtil.setListBgColor(this.getView(), "#ffffff");
        BosListUtil.setGripAndMargin(this.getView());
    }
}

