/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.interview.process;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.interview.InterviewObjApplication;
import kd.opmc.epa.business.domain.activity.enums.ActivityStatusEnum;
import kd.opmc.epa.business.utils.InterViewObjUtils;
import kd.opmc.epa.formplugin.web.interview.process.InterViewBaseList;
import kd.opmc.epa.formplugin.web.utils.InterviewSchemeSearchUtils;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.business.domain.workflow.entity.FlowCommonResultBo;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;

public class InterviewDetailList
extends InterViewBaseList {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final InterviewObjApplication INTERVIEW_OBJ_APPLICATION = InterviewObjApplication.getInstance();
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();

    public void setFilter(SetFilterEvent event) {
        Integer nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeseq");
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("interact");
        Long evalFlowId = (Long)this.getView().getFormShowParameter().getCustomParam("interflow");
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("epa_interobj");
        QFilter resultFilter = new QFilter("interact", "=", (Object)activityId).and("interstatus", "not in", (Object)new String[]{"10", "50"}).and(new QFilter("interflow", "=", (Object)evalFlowId));
        DynamicObject[] dynamicObjects = baseServiceHelper.queryOriginalArray("interflowins", new QFilter[]{resultFilter});
        List interflowins = Stream.of(dynamicObjects).filter(dynamicObject -> 0L != dynamicObject.getLong("interflowins")).map(dynamicObject -> dynamicObject.getLong("interflowins")).collect(Collectors.toList());
        HRBaseServiceHelper nodeHelper = new HRBaseServiceHelper("pbs_flowrunode");
        QFilter nodeFilter = new QFilter("index", "=", (Object)nodeIndex).and("flowruproc.id", "in", interflowins);
        DynamicObject[] ids = nodeHelper.queryOriginalArray("id", new QFilter[]{nodeFilter});
        List nodeids = Stream.of(ids).filter(dynamicObject -> 0L != dynamicObject.getLong("id")).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        QFilter nodeIndexFilter = new QFilter("flowrunode.id", "in", nodeids);
        QFilter evalFlowFilter = new QFilter("flowruproc.id", "in", interflowins);
        event.getQFilters().add(nodeIndexFilter);
        event.getQFilters().add(evalFlowFilter);
        event.setOrderBy("updatestatustime desc");
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        DynamicObject rowData = evt.getRowData();
        AbstractColumnDesc source = (AbstractColumnDesc)evt.getSource();
        String fieldKey = source.getFieldKey();
        if (HRStringUtils.equals((String)fieldKey, (String)"duration")) {
            Date date = rowData.getDate("updatestatustime");
            int intervalDays = DateUtils.getIntervalDays((Date)date, (Date)new Date());
            evt.setFormatValue((Object)(intervalDays + "d"));
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (super.isCloseParentView()) {
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (!HRStringUtils.equals((String)operateKey, (String)"closeinterview") && !InterViewObjUtils.checkInterViewProcessPermission((IFormView)this.getView())) {
            args.setCancel(true);
            return;
        }
        switch (operateKey) {
            case "urging": {
                this.handleUrging(args);
                break;
            }
            case "adjusthandler": {
                this.handleSetFormulator(args, "adjusthandler");
                break;
            }
            case "returnformulate": {
                if (!this.validateTaskStatus()) {
                    args.setCancel(true);
                    return;
                }
                this.returnFormulateOp(args);
                break;
            }
            case "closeinterview": {
                this.getView().close();
                this.getView().getParentView().close();
                this.getView().sendFormAction(this.getView().getParentView());
                break;
            }
            case "delhandler": {
                this.delHandlerBeforeOp(args);
                break;
            }
        }
    }

    private void delHandlerBeforeOp(BeforeDoOperationEventArgs args) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        if (!HRStringUtils.equals((String)systemInvoke, (String)"true")) {
            String msg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5220\u9664\u5904\u7406\u4eba\u662f\u4ee5\u4efb\u52a1\u4e3a\u7ef4\u5ea6\uff0c\u5220\u9664\u9009\u4e2d\u7684{0}\u6761\u4efb\u52a1\u540e\uff0c\u4efb\u52a1\u72b6\u6001\u53d8\u66f4\u4e3a\u201c\u5df2\u5931\u6548\u201d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"InterviewDetailList_0", (String)"opmc-epa-formplugin", (Object[])new Object[]{this.getSelectedRows().size()}));
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delhandler", (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    private boolean validateTaskStatus() {
        List<Object> selectIdList = this.getSelectIdList();
        if (selectIdList.size() == 1) {
            DynamicObject[] tasks = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryTaskById(selectIdList);
            DynamicObject task = tasks[0];
            String taskStatus = task.getString("taskstatus");
            Long objId = task.getLong("flowruproc.actevalobj");
            String handlerName = task.getString("handler.name");
            Map objMap = INTERVIEW_OBJ_APPLICATION.queryEvalObjById(Collections.singletonList(objId));
            DynamicObject objDy = (DynamicObject)objMap.get(objId);
            String desc = objDy.getString("perffile.name") + " " + objDy.getString("perffile.billno");
            String activityStatus = objDy.getString("interstatus");
            if (!HRStringUtils.equals((String)ActivityStatusEnum.TO_BE_EXECUTE.getValue(), (String)activityStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"{0} {1}\uff1a\u9762\u8c08\u5bf9\u8c61\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u9762\u8c08\u4e2d\u201d\uff0c\u4e0d\u80fd\u9000\u56de\u3002", (String)"InterviewDetailList_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{desc, handlerName}));
                return false;
            }
            if (FlowRuTaskStatusEnum.PENDING.getCode().equals(taskStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u5df2\u6302\u8d77\u201d\u4e0d\u80fd\u9000\u56de\u3002", (String)"InterviewDetailList_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{desc, handlerName}));
                return false;
            }
            if (FlowRuTaskStatusEnum.EXPIRED.getCode().equals(taskStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u5df2\u5931\u6548\u201d\u4e0d\u80fd\u9000\u56de\u3002", (String)"InterviewDetailList_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{desc, handlerName}));
                return false;
            }
            if (FlowRuTaskStatusEnum.RETURNED.getCode().equals(taskStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u5df2\u9000\u56de\u201d\u4e0d\u80fd\u9000\u56de\u3002", (String)"InterviewDetailList_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{desc, handlerName}));
                return false;
            }
            if (FlowRuTaskStatusEnum.PROCESSING.getCode().equals(taskStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u5904\u7406\u4e2d\u201d\u4e0d\u80fd\u9000\u56de\u3002", (String)"InterviewDetailList_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{desc, handlerName}));
                return false;
            }
            if (FlowRuTaskStatusEnum.NOT_ACTIVE.getCode().equals(taskStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u672a\u6fc0\u6d3b\u201d\u4e0d\u80fd\u9000\u56de\u3002", (String)"InterviewDetailList_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{desc, handlerName}));
                return false;
            }
            if (FlowRuTaskStatusEnum.BE_WAITTING.getCode().equals(taskStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u7b49\u5f85\u4e2d\u201d\u4e0d\u80fd\u9000\u56de\u3002", (String)"InterviewDetailList_7", (String)"opmc-epa-formplugin", (Object[])new Object[]{desc, handlerName}));
                return false;
            }
            if (FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u5f85\u5904\u7406\u201d\u4e0d\u80fd\u9000\u56de\u3002", (String)"InterviewDetailList_8", (String)"opmc-epa-formplugin", (Object[])new Object[]{desc, handlerName}));
                return false;
            }
        }
        return true;
    }

    private void returnFormulateOp(BeforeDoOperationEventArgs args) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String reason = source.getOption().getVariableValue("reason", "");
        if (HRStringUtils.isEmpty((String)reason)) {
            args.setCancel(true);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("epa_interviewreturn");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("dataCount", (Object)this.getSelectedRows().size());
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "returnformulate"));
            parameter.setHasRight(true);
            this.getView().showForm(parameter);
        }
    }

    private List<Object> getSelectIdList() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        return selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
    }

    private void handleSetFormulator(BeforeDoOperationEventArgs args, String operateKey) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        if (!HRStringUtils.equals((String)systemInvoke, (String)"true")) {
            FormShowParameter baseShowParameter = new FormShowParameter();
            baseShowParameter.setFormId("epa_setupinterviewer");
            baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            baseShowParameter.setStatus(OperationStatus.EDIT);
            String addCaption = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.getLocaleString((String)"\u65b0\u589e\u5904\u7406\u4eba", (String)"InterviewDetailList_0", (String)"opmc-epa-formplugin").getLocaleValue());
            String adjustCaption = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.getLocaleString((String)"\u8c03\u6574\u5904\u7406\u4eba", (String)"InterviewDetailList_1", (String)"opmc-epa-formplugin").getLocaleValue());
            baseShowParameter.setCaption(HRStringUtils.equals((String)operateKey, (String)"addhandler") ? addCaption : adjustCaption);
            Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            baseShowParameter.setCustomParam("SELECTED_ROW", (Object)primaryKeyValues.length);
            baseShowParameter.setCustomParam("ROW_DATA", (Object)primaryKeyValues);
            baseShowParameter.setCustomParam("operateKey", (Object)operateKey);
            baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
            this.getView().showForm(baseShowParameter);
            args.setCancel(true);
        }
    }

    private void handleUrging(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows;
        int size;
        AbstractOperate source = (AbstractOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        if (!HRStringUtils.equals((String)systemInvoke, (String)"true") && (size = (selectedRows = this.getSelectedRows()).size()) > 0) {
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u5c06\u53d1\u9001\u6d88\u606f\u7ed9\u672a\u5b8c\u6210\u4efb\u52a1\u7684\u5904\u7406\u4eba\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u50ac\u529e\u3002", (String)"InterviewDetailList_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]), this.getSelectedRows().size(), size);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("urging", (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"closeView")) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Yes == result) {
                this.getView().getParentView().close();
                this.getView().sendFormAction(this.getView().getParentView());
            }
            return;
        }
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (!MessageBoxResult.Yes.equals((Object)result)) {
            return;
        }
        switch (callBackId) {
            case "urging": {
                if (!InterViewObjUtils.checkInterViewProcessPermission((IFormView)this.getView())) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("systeminvoke", "true");
                operateOption.setVariableValue("OP_SOURCE", "formulate");
                this.getView().invokeOperation("urging", operateOption);
                break;
            }
            case "sendprocessingtask": {
                if (!InterViewObjUtils.checkInterViewProcessPermission((IFormView)this.getView())) break;
                OperateOption sendOp = OperateOption.create();
                sendOp.setVariableValue("systeminvoke", "true");
                sendOp.setVariableValue("OP_SOURCE", "formulate");
                this.getView().invokeOperation("sendprocessingtask", sendOp);
                break;
            }
            case "delhandler": {
                if (!InterViewObjUtils.checkInterViewProcessPermission((IFormView)this.getView())) break;
                OperateOption delOp = OperateOption.create();
                delOp.setVariableValue("systeminvoke", "true");
                delOp.setVariableValue("OP_SOURCE", "formulate");
                this.getView().invokeOperation("delhandler", delOp);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object childMap = event.getReturnData();
        if (HRObjectUtils.isEmpty((Object)childMap)) {
            return;
        }
        switch (actionId) {
            case "returnformulate": {
                String reason = (String)event.getReturnData();
                if (HRStringUtils.isEmpty((String)reason)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("reason", reason);
                this.getView().invokeOperation("returnformulate", operateOption);
                break;
            }
            case "adjusthandler": 
            case "addhandler": {
                Map handlers = (Map)childMap;
                List userIds = (List)handlers.get("handlers");
                List flowCommonResultBos = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.verifyUserIsValid(userIds);
                for (FlowCommonResultBo flowCommonResultBo : flowCommonResultBos) {
                    if (!"-1".equals(flowCommonResultBo.getCode())) continue;
                    this.getView().showErrorNotification(flowCommonResultBo.getMessage());
                    return;
                }
                OperateOption option = OperateOption.create();
                String returnStr = SerializationUtils.serializeToBase64((Object)childMap);
                option.setVariableValue("return_str", returnStr);
                option.setVariableValue("select_size", String.valueOf(this.getSelectedRows().size()));
                option.setVariableValue("systeminvoke", "true");
                option.setVariableValue("OP_SOURCE", "epa_interprocess");
                this.getView().invokeOperation(actionId, option);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperateOption operateOption;
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (!HRObjectUtils.isEmpty((Object)operationResult) && operationResult.isSuccess() && ("adjusthandler".equals(key) || "sendprocessingtask".equals(key) || "addhandler".equals(key) || "delhandler".equals(key) || "returnformulate".equals(key))) {
            operateOption = OperateOption.create();
            operateOption.setVariableValue("systeminvoke", "true");
            this.getView().invokeOperation("refresh", operateOption);
        }
        if ("urging".equals(key)) {
            operateOption = OperateOption.create();
            operateOption.setVariableValue("systeminvoke", "true");
            this.getView().invokeOperation("refresh", operateOption);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<String> fixedColumnList = Arrays.asList("epa_interobj.person.headsculpture", "epa_interobj.perffile.name", "epa_interobj.perffile.billno");
        fixedColumnList.forEach(column -> {
            if (args.getListColumn(column) != null) {
                args.getListColumn(column).setFixed(true);
            }
        });
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        InterviewSchemeSearchUtils.filterF7Select(this.getView(), args);
        super.filterContainerBeforeF7Select(args);
    }
}

