/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.interview.process;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.ListShowParameter;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.opmc.epa.business.application.service.interview.InterviewActivityConfApplication;
import kd.opmc.epa.business.domain.interview.enums.InterActStatusEnum;
import kd.opmc.epa.business.domain.interview.enums.InterStatusEnum;
import kd.opmc.epa.business.utils.InterViewObjUtils;

public class InterviewProcessExecuteEditPlugin
extends HRDynamicFormBasePlugin
implements TabSelectListener,
ClickListener {
    private static final InterviewActivityConfApplication INTERVIEW_ACTIVITY_CONF_APPLICATION = InterviewActivityConfApplication.getInstance();
    private static final String[] LABEL_KEY_STR = new String[]{"activityname", "activitystatus", "interviewform", "interviewflow", "relatedactivity"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Vector vector = (Vector)this.getControl("activityicon");
        vector.addClickListener((ClickListener)this);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "activityicon": {
                boolean hasPermission = InterViewObjUtils.checkInterViewProcessPermission((IFormView)this.getView());
                if (!hasPermission) {
                    return;
                }
                this.showInterActInfoPage();
                break;
            }
        }
    }

    private void showInterActInfoPage() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long activityId = this.getInterActId();
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("epa_interactconf");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPageId(this.getView().getPageId() + formShowParameter.getAppId() + activityId);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setPkId((Object)activityId);
        showParameter.setCustomParam("source", (Object)"processExecute");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private Long getInterActId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return (Long)formShowParameter.getCustomParam("interact");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initActivityInfo();
        this.refreshObjNum();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.addMutexLock();
        this.showDefaultTab();
    }

    private void showDefaultTab() {
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab("tobeinterviewap");
    }

    private void refreshObjNum() {
        HashMap<String, String> tabKeyMap = new HashMap<String, String>(){
            {
                this.put("tobeinterview", ResManager.loadKDString((String)"\u5f85\u9762\u8c08\uff08%s\uff09", (String)"InterviewProcessExecuteEditPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.put("inhand", ResManager.loadKDString((String)"\u9762\u8c08\u4e2d\uff08%s\uff09", (String)"InterviewProcessExecuteEditPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.put("complete", ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\uff08%s\uff09", (String)"InterviewProcessExecuteEditPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
        };
        Long activityId = this.getInterActId();
        HashMap<String, Integer> statMap = new HashMap<String, Integer>(16);
        statMap.put("tobeinterviewnum", 0);
        statMap.put("inhandnum", 0);
        statMap.put("completenum", 0);
        Map objCountGroupByStatus = INTERVIEW_ACTIVITY_CONF_APPLICATION.queryObjCountGroupByStatus(activityId);
        if (objCountGroupByStatus != null) {
            Integer endNum;
            Integer completeNum;
            Integer inHandNum;
            Integer tobeNum = (Integer)objCountGroupByStatus.get(InterStatusEnum.JOINED.getStatus());
            if (tobeNum != null) {
                statMap.put("tobeinterviewnum", tobeNum);
            }
            if ((inHandNum = (Integer)objCountGroupByStatus.get(InterStatusEnum.HAVE_IN_HAND.getStatus())) != null) {
                statMap.put("inhandnum", inHandNum);
            }
            if ((completeNum = (Integer)objCountGroupByStatus.get(InterStatusEnum.COMPLETED.getStatus())) == null) {
                completeNum = 0;
            }
            if ((endNum = (Integer)objCountGroupByStatus.get(InterStatusEnum.ENDED.getStatus())) != null) {
                completeNum = completeNum + endNum;
            }
            statMap.put("completenum", completeNum);
        }
        for (Map.Entry tabKeyEntry : tabKeyMap.entrySet()) {
            String tabKey = (String)tabKeyEntry.getKey();
            TabPage tabPage = (TabPage)this.getControl(tabKey + "ap");
            if (tabPage == null) continue;
            tabPage.setText(new LocaleString(ResManager.loadKDString((String)((String)tabKeyEntry.getValue()), (String)("InterviewProcessExecuteEditPlugin_refreshObjNum_" + tabKey), (String)"opmc-epa-formplugin", (Object[])new Object[]{statMap.get(tabKey + "num")})));
        }
    }

    private void initActivityInfo() {
        Long activityId = this.getInterActId();
        DynamicObject dynamicObject = INTERVIEW_ACTIVITY_CONF_APPLICATION.queryInterviewProcessInfoById(activityId);
        HashMap<String, String> actInfoMap = new HashMap<String, String>(16);
        if (dynamicObject != null) {
            String activityName = dynamicObject.getString("name");
            String activitystatus = dynamicObject.getString("activitystatus");
            String intActStatusName = InterActStatusEnum.TO_BE.getText();
            InterActStatusEnum interActStatusEnum = InterActStatusEnum.getEnum((String)activitystatus);
            if (interActStatusEnum != null) {
                intActStatusName = interActStatusEnum.getText();
            }
            String interformName = dynamicObject.getString("interform.name");
            String flowName = dynamicObject.getString("perfworkflow.name");
            DynamicObjectCollection relActivityList = dynamicObject.getDynamicObjectCollection("activityids");
            ArrayList<String> activityNameList = new ArrayList<String>(10);
            for (DynamicObject activityObj : relActivityList) {
                activityNameList.add(activityObj.getDynamicObject(1).getString("name"));
            }
            actInfoMap.put("activityname", activityName);
            actInfoMap.put("activitystatus", intActStatusName);
            actInfoMap.put("interviewform", ResManager.loadKDString((String)"\u9762\u8c08\u8868\u5355\uff1a%s", (String)"InterviewProcessExecuteEditPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{interformName}));
            actInfoMap.put("interviewflow", ResManager.loadKDString((String)"\u9762\u8c08\u6d41\u7a0b\uff1a%s", (String)"InterviewProcessExecuteEditPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{flowName}));
            actInfoMap.put("relatedactivity", ResManager.loadKDString((String)"\u5173\u8054\u6d3b\u52a8\uff1a%s", (String)"InterviewProcessExecuteEditPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{String.join((CharSequence)"\uff0c", activityNameList)}));
        }
        for (String labelKey : LABEL_KEY_STR) {
            Label control = (Label)this.getControl(labelKey + "lab");
            if (control == null) continue;
            control.setText((String)actInfoMap.get(labelKey));
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        String tabViewPageId = this.getView().getPageCache().get(tabKey);
        IFormView rightListView = this.getView().getView(tabViewPageId);
        if (rightListView != null) {
            rightListView.invokeOperation("refresh");
            this.getView().sendFormAction(rightListView);
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        Long interActId = this.getInterActId();
        parameter.setCustomParam("interact", (Object)interActId);
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(tabKey);
        switch (tabKey) {
            case "tobeinterviewap": {
                parameter.setBillFormId("epa_todointerviewobj");
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "inhandap": {
                parameter.setBillFormId("epa_interviewingobj");
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "completeap": {
                parameter.setBillFormId("epa_interviewedobj");
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
        this.getView().getPageCache().put(tabKey, parameter.getPageId());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "refreshnum": {
                this.refreshObjNum();
                break;
            }
        }
    }

    private void addMutexLock() {
        String isLocked = this.getView().getPageCache().get("isLocked");
        if (!"true".equals(isLocked)) {
            Long interActId = this.getInterActId();
            DynamicObject interActInfo = INTERVIEW_ACTIVITY_CONF_APPLICATION.queryInterviewProcessInfoById(interActId);
            String number = interActInfo.getString("number");
            String lockId = interActId + "";
            this.getPageCache().put("id", lockId);
            MutexLockInfo lockInfo = new MutexLockInfo(lockId, number, "process_netctrl", "epa_interviewprocess", "modify", true, "default");
            DataMutex dataMutex = DataMutex.create();
            boolean require = dataMutex.require(lockInfo);
            if (!require) {
                this.getView().getPageCache().put("isLocked", "false");
                Map currLockInfo = dataMutex.getLockInfo(lockId, "process_netctrl", "epa_interviewprocess");
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_user");
                long userId = Long.parseLong((String)currLockInfo.get("userid"));
                Map cacheUserObjs = BusinessDataReader.loadFromCache((Object[])new Object[]{userId}, (DynamicObjectType)dt);
                DynamicObject userObj = (DynamicObject)cacheUserObjs.get(userId);
                String personName = "";
                if (userObj != null) {
                    personName = userObj.getString("name");
                }
                String errMsg = ResManager.loadKDString((String)"{0}\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"InterviewProcessExecuteEditPlugin_7", (String)"opmc-epa-formplugin", (Object[])new Object[]{personName});
                this.getView().getParentView().showErrorNotification(errMsg);
                this.getView().sendFormAction(this.getView().getParentView());
                this.getModel().setDataChanged(false);
                this.getView().close();
            } else {
                this.getView().getPageCache().put("isLocked", "true");
            }
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        this.releaseMutex();
    }

    private void releaseMutex() {
        String isLocked = this.getView().getPageCache().get("isLocked");
        if (!"false".equals(isLocked)) {
            Long interActId = this.getInterActId();
            String lockId = interActId + "";
            MutexHelper.release((String)"epa_interviewprocess", (String)"modify", (String)lockId);
        }
    }
}

