/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.perfresult;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListColumn;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.opmc.epa.common.enums.activitymanage.DataSourceEnum;

public class HisPerResultListPlugin
extends HRDataBaseList {
    private static final String DATA_SOURCE = "datasource";
    private static final String OP_REVISE = "revise";
    private static final Set<String> HIDE_SET = new HashSet<String>(Arrays.asList("index", "issyspreset", "description", "enable", "changedescription"));

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"versionchangecomparebtn", "insertdatabtn"});
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List columns = args.getListColumns();
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            IListColumn column = (IListColumn)iterator.next();
            if (!HIDE_SET.contains(column.getListFieldKey())) continue;
            iterator.remove();
        }
    }

    public void packageData(PackageDataEvent event) {
        if (event.getSource() instanceof ListOperationColumnDesc && event.getRowData().containsProperty("datastatus")) {
            List operationColItems = (List)event.getFormatValue();
            operationColItems.stream().filter(opItem -> OP_REVISE.equals(opItem.getOperationKey())).forEach(opItem -> opItem.setVisible(false));
            super.packageData(event);
        }
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        List qFilters = event.getQFilters();
        QFilter qFilter = new QFilter(DATA_SOURCE, "=", (Object)DataSourceEnum.HIS_PERRESULT.getCode());
        qFilters.add(qFilter);
        event.setOrderBy("modifytime desc,createtime desc");
    }
}

