/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.perfresult;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.formplugin.web.utils.permission.HisPerResultUtils;
import kd.opmc.pmd.business.domain.perffile.entityservice.PerffileEntityService;

public class HisPerResultPlugin
extends HRDataBaseEdit {
    private static final PerffileEntityService PERFFILE_ENTITY_SERVICE = PerffileEntityService.getInstance();
    private static final String LABELAP = "labelap";
    private static final String PERSON_NAME = "name";
    private static final String PERSON_NUMBER = "personnumber";
    private static final String YEAR = "year";
    private static final String PERIOD = "period";
    private static final String ADMIN_ORG_NAME = "adminorgname";
    private static final String POSITIONNAME = "positionname";
    private static final String JOBNAME = "jobname";
    private static final String ADMINORG_NAME = "adminorg.name";
    private static final String POSITION_NAME = "position.name";
    private static final String JOB_NAME = "job.name";
    private static final String ASSESS_PERIOD = "assessperiod";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((Label)this.getView().getControl(LABELAP)).addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (HRStringUtils.equals((String)key, (String)LABELAP)) {
            this.setPerffile();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if (StringUtils.equals((CharSequence)YEAR, (CharSequence)name) || StringUtils.equals((CharSequence)PERIOD, (CharSequence)name)) {
            Date date = this.getView().getModel().getDataEntity().getDate(YEAR);
            String period = this.getView().getModel().getDataEntity().getString(PERIOD);
            if (!Objects.isNull(date) && !Objects.isNull(period)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                int year = calendar.get(1);
                this.getView().getModel().setValue(ASSESS_PERIOD, (Object)(year + period));
            }
        }
    }

    private void setPerffile() {
        String personName = this.getModel().getDataEntity().getString(PERSON_NAME);
        String personNumber = this.getModel().getDataEntity().getString(PERSON_NUMBER);
        Date date = this.getModel().getDataEntity().getDate(YEAR);
        String period = this.getModel().getDataEntity().getString(PERIOD);
        String adminOrgName = this.getModel().getDataEntity().getString(ADMIN_ORG_NAME);
        String positionName = this.getModel().getDataEntity().getString(POSITIONNAME);
        String jobName = this.getModel().getDataEntity().getString(JOBNAME);
        if (StringUtils.isBlank((CharSequence)personName) || StringUtils.isBlank((CharSequence)personNumber) || StringUtils.isBlank((Object)date) || StringUtils.isBlank((CharSequence)period)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u540e\u8fdb\u884c\u667a\u80fd\u5339\u914d\u3002", (String)"HisPerResultPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] dynamicObjects = PERFFILE_ENTITY_SERVICE.queryPerffileByDepempNumberAndName(personNumber, personName);
        if (dynamicObjects.length <= 0) {
            return;
        }
        List<DynamicObject> orgAndPositionCollect = Stream.of(dynamicObjects).filter(dynamicObject -> !HRStringUtils.isBlank((CharSequence)adminOrgName) && HRStringUtils.equals((String)dynamicObject.getString(ADMINORG_NAME), (String)adminOrgName)).filter(dynamicObject -> !HRStringUtils.isBlank((CharSequence)positionName) && HRStringUtils.equals((String)dynamicObject.getString(POSITION_NAME), (String)positionName)).collect(Collectors.toList());
        if (!orgAndPositionCollect.isEmpty()) {
            this.getClosestDate(date, period, orgAndPositionCollect);
            return;
        }
        List<DynamicObject> orgAndJobCollect = Stream.of(dynamicObjects).filter(dynamicObject -> !HRStringUtils.isBlank((CharSequence)adminOrgName) && HRStringUtils.equals((String)dynamicObject.getString(ADMINORG_NAME), (String)adminOrgName)).filter(dynamicObject -> !HRStringUtils.isBlank((CharSequence)jobName) && HRStringUtils.equals((String)dynamicObject.getString(JOB_NAME), (String)jobName)).collect(Collectors.toList());
        if (!orgAndJobCollect.isEmpty()) {
            this.getClosestDate(date, period, orgAndJobCollect);
            return;
        }
        List<DynamicObject> orgCollect = Stream.of(dynamicObjects).filter(dynamicObject -> !HRStringUtils.isBlank((CharSequence)adminOrgName) && HRStringUtils.equals((String)dynamicObject.getString(ADMINORG_NAME), (String)adminOrgName)).collect(Collectors.toList());
        if (!orgCollect.isEmpty()) {
            this.getClosestDate(date, period, orgCollect);
            return;
        }
        List<DynamicObject> positionCollect = Stream.of(dynamicObjects).filter(dynamicObject -> !HRStringUtils.isBlank((CharSequence)positionName) && HRStringUtils.equals((String)dynamicObject.getString(POSITION_NAME), (String)positionName)).collect(Collectors.toList());
        if (!positionCollect.isEmpty()) {
            this.getClosestDate(date, period, positionCollect);
            return;
        }
        List<DynamicObject> jobCollect = Stream.of(dynamicObjects).filter(dynamicObject -> !HRStringUtils.isBlank((CharSequence)jobName) && HRStringUtils.equals((String)dynamicObject.getString(JOB_NAME), (String)jobName)).collect(Collectors.toList());
        if (!jobCollect.isEmpty()) {
            this.getClosestDate(date, period, jobCollect);
            return;
        }
        List<DynamicObject> collect = Stream.of(dynamicObjects).collect(Collectors.toList());
        this.getClosestDate(date, period, collect);
    }

    private void getClosestDate(Date date, String period, List<DynamicObject> orgAndJobCollect) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        Map<Date, DynamicObject> map = orgAndJobCollect.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getDate("bsed"), dynamicObject -> dynamicObject, (v1, v2) -> v1));
        Date closestDate = HisPerResultUtils.getClosestDateFromMap(year, period, map);
        DynamicObject dynamicObject2 = map.get(closestDate);
        this.getView().getModel().setValue("perffilef7", (Object)dynamicObject2.getLong("id"));
    }
}

