/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.perfresult;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.openservicehelper.permission.HRPermissionServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.AssessRuleApplicationService;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.domain.activity.enums.ActivityStatusEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActEvalObjManageDomainService;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.RuleGradeEntityService;
import kd.opmc.epa.business.domain.hbss.enums.CycleTypeEnum;
import kd.opmc.epa.business.domain.perfresult.entityservice.PerfResultEntityService;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.constants.PerformSummaryConstants;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.activitymanage.DataSourceEnum;
import kd.opmc.epa.common.enums.assessrule.EvaSumLimit;

public class PerfResultEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final AssessRuleApplicationService ASSESS_RULE_APP_SERVICE = AssessRuleApplicationService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY = AssessFormEntityService.getInstance();
    private static final RuleGradeEntityService RULE_GRADE_ENTITY_SERVICE = RuleGradeEntityService.getInstance();
    private final AssessActivityApplicationService service = AssessActivityApplicationService.getInstance();
    private final PerfResultEntityService PERF_SERVICE = PerfResultEntityService.getInstance();
    private static final String SCORE = "score";
    private static final String ASSESS_LEVEL = "assesslevel";
    private static final String RANK_NEW_ENTRY = "ranknewentry";
    private static final String RANK_DELETE_ENTRY = "rankdeleteentry";
    private static final String OVERALL_NEW_ENTRY = "overallnewentry";
    private static final String OVERALL_DELETE_ENTRY = "overalldeleteentry";
    private static final Map<String, String> RELATIONSHIP_MAP = new HashMap<String, String>();
    private static final Map<String, String> DETAIL_KEY_MAP;
    private static final String DATA_SOURCE = "datasource";
    private static final Map<String, String> DY_MAP;

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit activityF7 = (BasedataEdit)this.getView().getControl("activity");
        activityF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        activityF7.addAfterF7SelectListener((AfterF7SelectListener)this);
        EntryGrid rankEntryGrid = (EntryGrid)this.getView().getControl("rankresultentity");
    }

    public void afterCreateNewData(EventObject e) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status == OperationStatus.ADDNEW) {
            this.getModel().setValue(DATA_SOURCE, (Object)DataSourceEnum.MANUAL_ADDITION.getCode());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)status)) {
            DynamicObject perfLevelF7 = this.getModel().getDataEntity().getDynamicObject("perflevelf7");
            if (!ObjectUtils.isEmpty((Object)perfLevelF7)) {
                DynamicObject dynamicObject = this.service.queryPerfLevelById(Long.valueOf(perfLevelF7.getLong("id")));
                this.initAssessLevel(dynamicObject);
            }
            this.assessLevelMustInput();
            this.scoreMustInput();
            this.setDefShowOnEdit("rankresultentity");
            this.setDefShowOnEdit("levelresultentity");
            this.setDefShowOnEdit("overallresultentity");
            Object dataSource = this.getModel().getValue(DATA_SOURCE);
            if (DataSourceEnum.EXT_INTEGRATION.getCode().equals(dataSource)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"activity"});
            }
            this.setOverallEnable();
            DynamicObject activity = this.getModel().getDataEntity().getDynamicObject("activity");
            this.updateScoreNumAccuracy(activity);
        } else if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"assessperiod"});
        }
    }

    private void setOverallEnable() {
        DynamicObject activity = this.getModel().getDataEntity().getDynamicObject("activity");
        DynamicObject workFlowDy = this.service.queryPerfWorkFlow(Long.valueOf(activity.getLong("id")));
        boolean dependentSummary = ActEvalObjManageDomainService.getInstance().isDependentSummary(Long.valueOf(workFlowDy.getLong("id")));
        this.getView().setEnable(Boolean.valueOf(!dependentSummary), new String[]{"overalladdrow", "delrow1"});
        if (dependentSummary) {
            this.getModel().deleteEntryData("overallresultentity");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = ((Control)evt.getSource()).getKey();
        if (HRStringUtils.equals((String)"activity", (String)fieldKey)) {
            ArrayList<String> statusList = new ArrayList<String>(10);
            statusList.add(ActivityStatusEnum.COMPLETED.getValue());
            QFilter qFilter = new QFilter("activitystatus", "in", (Object)statusList.toArray());
            evt.addCustomQFilter(qFilter);
            long userId = RequestContext.get().getCurrUserId();
            HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"36", (String)"24E05ECYZ6K0", (String)"epa_performanceresult", (String)"47150e89000000ac");
            if (!result.hasAllOrgPerm()) {
                List hasPermOrgs;
                evt.addCustomQFilter(new QFilter("scheme.org", "in", (Object)result.getHasPermOrgs()));
                AuthorizedOrgResult activityPermResult = HRPermissionServiceHelper.getAuthorizedAdminOrgSet((Long)userId, (String)"24E05ECYZ6K0", (String)"epa_performanceresult", (String)"47150e89000000ac", (String)"affiliateadminorg");
                if (!activityPermResult.isHasAllOrgPerm() && !ObjectUtils.isEmpty((Object)(hasPermOrgs = activityPermResult.getHasPermOrgs()))) {
                    evt.addCustomQFilter(new QFilter("scheme.adminorg", "in", (Object)hasPermOrgs));
                }
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        String fieldKey = ((Control)evt.getSource()).getKey();
        DynamicObject activity = this.getModel().getDataEntity().getDynamicObject("activity");
        if (HRStringUtils.equals((String)"activity", (String)fieldKey) && !HRObjectUtils.isEmpty((Object)activity)) {
            DynamicObject assessForm;
            String assessPeriod = activity.getString("period");
            this.getModel().setValue("assessperiod", (Object)assessPeriod);
            DynamicObject workFlowDy = this.service.queryPerfWorkFlow(Long.valueOf(activity.getLong("id")));
            boolean dependentSummary = ActEvalObjManageDomainService.getInstance().isDependentSummary(Long.valueOf(workFlowDy.getLong("id")));
            boolean isFollowAssForm = this.isFollowAssForm(activity, workFlowDy);
            long scoreSystemId = workFlowDy.getLong("scoresystem.id");
            long sumPerfLevelId = workFlowDy.getLong("sumperflevel.id");
            long assessFormId = activity.getLong("assessform.id");
            DynamicObject dynamicObject = assessForm = assessFormId == 0L ? null : ASSESS_FORM_ENTITY.queryOne((Object)assessFormId);
            if (isFollowAssForm && assessForm != null) {
                scoreSystemId = assessForm.getLong("scoresystem.id");
                sumPerfLevelId = assessForm.getLong("sumperflevel.id");
            }
            if (!dependentSummary && scoreSystemId == 0L && assessForm != null) {
                scoreSystemId = assessForm.getLong("scoresystem.id");
            }
            if (!dependentSummary && sumPerfLevelId == 0L && assessForm != null) {
                sumPerfLevelId = assessForm.getLong("sumperflevel.id");
            }
            this.getModel().setValue("rulescoref7", (Object)scoreSystemId);
            long schemeId = activity.getLong("scheme.id");
            this.getModel().setValue("schemef7", (Object)schemeId);
            this.getModel().setValue("perflevelf7", (Object)sumPerfLevelId);
            if (sumPerfLevelId != 0L) {
                DynamicObject dynamicObject2 = this.service.queryPerfLevelById(Long.valueOf(sumPerfLevelId));
                this.initAssessLevel(dynamicObject2);
                this.getModel().setValue(ASSESS_LEVEL, null);
            }
            this.scoreMustInput();
            this.assessLevelMustInput();
            this.updateScoreNumAccuracy(activity);
            this.setOverallEnable();
        }
    }

    private boolean isFollowAssForm(DynamicObject activity, DynamicObject workFlowDy) {
        boolean isYearSum = activity.getBoolean("isneedmpgenway");
        String mpSopCategory = activity.getString("mpsopcategory");
        String mpGenWay = activity.getString("mpgenway");
        DynamicObjectCollection nodeEntry = workFlowDy.getDynamicObjectCollection("entryentity");
        boolean isExistSum = nodeEntry.stream().anyMatch(nodeInfo -> nodeInfo.getLong("node.id") == AssessNodeStatusEnum.MPED.getNodeId().longValue() && nodeInfo.getBoolean("isshow"));
        boolean isExistAssess = nodeEntry.stream().anyMatch(nodeInfo -> nodeInfo.getLong("node.id") == AssessNodeStatusEnum.EVALUATED.getNodeId().longValue() && nodeInfo.getBoolean("isshow"));
        boolean isSop = isYearSum && isExistSum && isExistAssess && HRStringUtils.equals((String)mpSopCategory, (String)CycleTypeEnum.YEAR.getRef()) && HRStringUtils.equals((String)mpGenWay, (String)"1");
        return isSop || !isExistSum && isExistAssess;
    }

    private void assessLevelMustInput() {
        DynamicObject perfLevelF7 = this.getModel().getDataEntity().getDynamicObject("perflevelf7");
        ComboEdit assessLevel = (ComboEdit)this.getView().getControl(ASSESS_LEVEL);
        assessLevel.setMustInput(!ObjectUtils.isEmpty((Object)perfLevelF7) && HRStringUtils.isNotEmpty((String)perfLevelF7.getString("name")));
    }

    private void initAssessLevel(DynamicObject dynamicObject) {
        if (!ObjectUtils.isEmpty((Object)dynamicObject)) {
            DynamicObjectCollection levelConf = dynamicObject.getDynamicObjectCollection("entryentity");
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
            for (DynamicObject level : levelConf) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(level.getString("levelname")));
                comboItem.setValue(level.getString("seq"));
                comboItems.add(comboItem);
            }
            ComboEdit comboEdit = (ComboEdit)this.getControl(ASSESS_LEVEL);
            comboEdit.setComboItems(comboItems);
        }
    }

    private void scoreMustInput() {
        DynamicObject ruleScoreF7 = this.getModel().getDataEntity().getDynamicObject("rulescoref7");
        DecimalEdit score = (DecimalEdit)this.getView().getControl(SCORE);
        score.setMustInput(!ObjectUtils.isEmpty((Object)ruleScoreF7) && HRStringUtils.isNotEmpty((String)ruleScoreF7.getString("name")));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        switch (name = args.getProperty().getName()) {
            case "oeveralldefshow": 
            case "levelrankshow": {
                this.switchDefShow(RELATIONSHIP_MAP.get(name));
                break;
            }
            case "assesslevel": {
                this.initRuleLevelResult(args);
                break;
            }
            case "totalrankpeople": 
            case "ranking": {
                this.rankProportion(name);
                break;
            }
            case "score": {
                this.scoreCheck();
                break;
            }
            case "rankdimension": 
            case "dimensionname": {
                this.rankResultUniqueCheck(name);
                break;
            }
            case "roletype": 
            case "assessuser": {
                this.overallResultUniqueCheck(name);
                break;
            }
            case "activity": {
                this.activityUniqueCheck(true);
                break;
            }
        }
    }

    private void activityUniqueCheck(boolean isPropChange) {
        DynamicObject activity = this.getModel().getDataEntity().getDynamicObject("activity");
        if (!HRObjectUtils.isEmpty((Object)activity)) {
            OperationStatus operationStatus;
            DynamicObject perffile = this.getModel().getDataEntity().getDynamicObject("perffilef7");
            long perffileId = perffile.getLong("id");
            long activityId = activity.getLong("id");
            DynamicObject perfResult = this.PERF_SERVICE.queryByPerfIdAndActivityId(perffileId, activityId);
            String msg = ResManager.loadKDString((String)"\u4e00\u4e2a\u7ee9\u6548\u6863\u6848\u5728\u4e00\u4e2a\u8003\u6838\u6d3b\u52a8\u4e0b\u53ea\u80fd\u6709\u4e00\u4e2a\u7ed3\u679c\u3002", (String)"PerfResultEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            if (isPropChange) {
                if (!ObjectUtils.isEmpty((Object)perfResult)) {
                    this.getModel().setValue("activity", null);
                    this.getView().showTipNotification(msg);
                }
                this.clearPropVal();
            } else if (!ObjectUtils.isEmpty((Object)perfResult) && OperationStatus.ADDNEW == (operationStatus = this.getView().getFormShowParameter().getStatus())) {
                this.getModel().setValue("activity", null);
                this.clearPropVal();
                this.getView().showTipNotification(msg);
            }
        }
    }

    private void clearPropVal() {
        this.getModel().setValue("assessmodelf7", null);
        this.getModel().setValue("rulescoref7", null);
        this.getModel().setValue(SCORE, (Object)new BigDecimal(BigInteger.ZERO));
        this.scoreMustInput();
        this.getModel().setValue("perflevelf7", null);
        ComboEdit assessLevel = (ComboEdit)this.getControl(ASSESS_LEVEL);
        assessLevel.setComboItems(new ArrayList(10));
        this.assessLevelMustInput();
        this.getModel().setValue("schemef7", null);
        this.getModel().deleteEntryData("levelresultentity");
    }

    private void rankProportion(String name) {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("rankresultentity");
        DynamicObject row = (DynamicObject)this.getModel().getEntryEntity("rankresultentity").get(currentRowIndex);
        BigDecimal totalPeople = row.getBigDecimal("totalrankpeople");
        BigDecimal ranking = row.getBigDecimal("ranking");
        if (totalPeople.compareTo(new BigDecimal(0)) <= 0) {
            this.getModel().setValue("rankproportion", (Object)new BigDecimal(0), currentRowIndex);
            return;
        }
        if (ranking.compareTo(totalPeople) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6392\u540d\u4e0d\u5f97\u5927\u4e8e\u6392\u540d\u603b\u4eba\u6570", (String)"PerfResultEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(name, null, currentRowIndex);
            this.getModel().setValue("rankproportion", null, currentRowIndex);
            return;
        }
        BigDecimal newVal = ranking.divide(totalPeople, 2, 4);
        this.getModel().setValue("rankproportion", (Object)newVal, currentRowIndex);
    }

    private void initRuleLevelResult(PropertyChangedArgs args) {
        Object newValue = args.getChangeSet()[0].getNewValue();
        if (ObjectUtils.isEmpty((Object)newValue)) {
            return;
        }
        DynamicObject perfLevelF7 = this.getModel().getDataEntity().getDynamicObject("perflevelf7");
        if (!ObjectUtils.isEmpty((Object)perfLevelF7)) {
            int index = Integer.parseInt(newValue.toString()) - 1;
            DynamicObjectCollection levelConf = perfLevelF7.getDynamicObjectCollection("entryentity");
            this.getModel().setValue("assessleveltext", (Object)new LocaleString(((DynamicObject)levelConf.get(index)).getString("levelname")));
            DynamicObjectCollection ruleMapEntryEntity = perfLevelF7.getDynamicObjectCollection("rulemapentryentity");
            if (ObjectUtils.isEmpty((Object)ruleMapEntryEntity)) {
                return;
            }
            List<DynamicObject> ruleMapSorted = ruleMapEntryEntity.stream().sorted(Comparator.comparing(ruleMapDy -> ruleMapDy.getDynamicObject("rulegrade").getString("id"))).collect(Collectors.toList());
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("levelresultentity", this.getTableValueSetter(index, ruleMapSorted));
            model.endInit();
            this.getView().updateView("levelresultentity");
        }
    }

    private TableValueSetter getTableValueSetter(int index, List<DynamicObject> ruleMapSorted) {
        int defShowIndex = this.getDefShowIndex();
        this.clearEntity();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("rulelevelnumber", new Object[0]);
        vs.addField("rulelevelname", new Object[0]);
        vs.addField("rulelevel", new Object[0]);
        vs.addField("levelrankshow", new Object[0]);
        vs.addField("leveldetail", new Object[0]);
        vs.addField("rulegrade", new Object[0]);
        for (int i = 0; i < ruleMapSorted.size(); ++i) {
            DynamicObject ruleGrade = ruleMapSorted.get(i).getDynamicObject("rulegrade");
            String number = ruleGrade.getString("number");
            String ruleGradeName = ruleGrade.getString("name");
            DynamicObjectCollection rulesubentryentity = ruleMapSorted.get(i).getDynamicObjectCollection("rulesubentryentity");
            long ruleGradeId = ruleGrade.getLong("id");
            DynamicObject dynamicObject = RULE_GRADE_ENTITY_SERVICE.queryOne((Object)ruleGradeId);
            DynamicObjectCollection gradeConfigEntry = dynamicObject.getDynamicObjectCollection("gradeconfigentry");
            int ruleGradeLevelIndex = ((DynamicObject)rulesubentryentity.get(index)).getInt("rulegradelevel") - 1;
            String rulegrade = ((DynamicObject)gradeConfigEntry.get(ruleGradeLevelIndex)).getString("rulegrade");
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"levelrankshow"});
            vs.addRow(new Object[]{number, ruleGradeName, rulegrade, i == defShowIndex, this.getDetailEntryKey("levelresultentity"), ruleGradeId});
        }
        return vs;
    }

    private int getDefShowIndex() {
        int defShowIndex = 0;
        DynamicObjectCollection levelResultEntity = this.getModel().getEntryEntity("levelresultentity");
        if (!ObjectUtils.isEmpty((Object)levelResultEntity)) {
            for (int i = 0; i < levelResultEntity.size(); ++i) {
                if (!((DynamicObject)levelResultEntity.get(i)).getBoolean("levelrankshow")) continue;
                defShowIndex = i;
                break;
            }
        }
        return defShowIndex;
    }

    private void clearEntity() {
        DynamicObjectCollection levelResultEntity = this.getModel().getEntryEntity("levelresultentity");
        levelResultEntity.clear();
        this.getModel().updateEntryCache(levelResultEntity);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        switch (source.getOperateKey()) {
            case "ranknewentry": {
                if (!this.isMaxLimit("rankresultentity")) break;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6392\u540d\u7ed3\u679c\u6700\u591a\u53ea\u80fd\u6dfb\u52a010\u884c", (String)"PerfResultEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                break;
            }
            case "overallnewentry": {
                if (!this.isMaxLimit("overallresultentity")) break;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u603b\u8bc4\u7ed3\u679c\u6700\u591a\u53ea\u80fd\u6dfb\u52a010\u884c", (String)"PerfResultEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                break;
            }
            case "rankdeleteentry": {
                this.isCanDelRow(args, "rankresultentity");
                break;
            }
            case "overalldeleteentry": {
                this.isCanDelRow(args, "overallresultentity");
                break;
            }
            case "save": 
            case "changesave": 
            case "submit": 
            case "auditconfirmchange": {
                this.activityUniqueCheck(false);
                this.scoreCheck();
            }
        }
    }

    private void isCanDelRow(BeforeDoOperationEventArgs args, String entityKey) {
        DynamicObjectCollection resultEntity = this.getModel().getEntryEntity(entityKey);
        if (resultEntity.size() > 1 && this.isDefShowRow(entityKey)) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u5b58\u5728\u591a\u6761\u6570\u636e\u65f6,\u9ed8\u8ba4\u5c55\u793a\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664", (String)"PerfResultEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
    }

    private void scoreCheck() {
        BigDecimal newValue;
        DynamicObject dyo = this.getModel().getDataEntity();
        DynamicObject ruleScoreF7 = dyo.getDynamicObject("rulescoref7");
        BigDecimal maxScore = BigDecimal.ZERO;
        BigDecimal minScore = BigDecimal.ZERO;
        if (!ObjectUtils.isEmpty((Object)ruleScoreF7)) {
            maxScore = ruleScoreF7.getBigDecimal("maxscore");
            minScore = ruleScoreF7.getBigDecimal("minscore");
        }
        if (ObjectUtils.isEmpty((Object)(newValue = (BigDecimal)this.getModel().getValue(SCORE)))) {
            return;
        }
        DynamicObject activity = this.getModel().getDataEntity().getDynamicObject("activity");
        if (HRObjectUtils.isEmpty((Object)activity)) {
            return;
        }
        DynamicObject workFlowDy = this.service.queryPerfWorkFlow(Long.valueOf(activity.getLong("id")));
        DynamicObjectCollection nodeEntry = workFlowDy.getDynamicObjectCollection("entryentity");
        boolean isExistSum = nodeEntry.stream().anyMatch(nodeInfo -> nodeInfo.getLong("node.id") == AssessNodeStatusEnum.MPED.getNodeId().longValue() && nodeInfo.getBoolean("isshow"));
        String resultSource = (String)this.getModel().getValue("resultsource");
        if (!this.isFollowAssForm(activity, workFlowDy) || isExistSum && HRStringUtils.equals((String)resultSource, (String)"20")) {
            maxScore = PerformSummaryConstants.MAX_SCORE_BIG;
            minScore = PerformSummaryConstants.MIN_SCORE_BIG;
        } else {
            DynamicObjectCollection areaEntry;
            List plusMinusList;
            DynamicObject assessForm = ASSESS_FORM_ENTITY.queryOne("evasumlimit,limitmaxscore,limitminscore,areaconfentry.areareg,areaconfentry.areaconf,numaccuracy,scaletype", (Object)activity.getLong("assessform.id"));
            if (HRObjectUtils.isEmpty((Object)assessForm)) {
                return;
            }
            String evaSumLimit = assessForm.getString("evasumlimit");
            if (HRStringUtils.equals((String)evaSumLimit, (String)EvaSumLimit.APPOINT_SUM_LIMIT.getValue())) {
                maxScore = assessForm.getBigDecimal("limitmaxscore");
                minScore = assessForm.getBigDecimal("limitminscore");
            }
            if (HRStringUtils.equals((String)evaSumLimit, (String)EvaSumLimit.NOT_LIMIT.getValue()) && CollectionUtils.isNotEmpty(plusMinusList = (areaEntry = assessForm.getDynamicObjectCollection("areaconfentry")).stream().filter(entry -> AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(entry.getDynamicObject("areareg").getPkValue())).collect(Collectors.toList()))) {
                Long areaConf = ((DynamicObject)plusMinusList.get(0)).getLong("areaconf");
                DynamicObject plusMinusConfigDy = ASSESS_RULE_APP_SERVICE.queryPlusMinusConfigByPk(areaConf);
                maxScore = maxScore.add(plusMinusConfigDy.getBigDecimal("pluslimit"));
                minScore = minScore.add(plusMinusConfigDy.getBigDecimal("minuslimit"));
            }
        }
        if (newValue.compareTo(minScore) < 0 || newValue.compareTo(maxScore) > 0) {
            this.getModel().setValue(SCORE, (Object)new BigDecimal(BigInteger.ZERO));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u7efc\u5408\u7ee9\u6548\u5f97\u5206\u201d\u9700\u5927\u4e8e\u7b49\u4e8e{0}\uff0c\u5c0f\u4e8e\u7b49\u4e8e{1}", (String)"PerfResultEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{minScore.stripTrailingZeros().toPlainString(), maxScore.stripTrailingZeros().toPlainString()}));
        }
    }

    private boolean scoreIsChange(DynamicObject dyo) {
        Iterable bizChangedProperties = dyo.getDataEntityState().getBizChangedProperties();
        boolean scoreIsChange = false;
        for (IDataEntityProperty property : bizChangedProperties) {
            if (!HRStringUtils.equals((String)property.getName(), (String)SCORE)) continue;
            scoreIsChange = true;
            break;
        }
        return scoreIsChange;
    }

    private boolean isDefShowRow(String entityKey) {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(entityKey);
        DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity(entityKey).get(currentRowIndex);
        return entry.getString(RELATIONSHIP_MAP.get(entityKey)).equals("true");
    }

    private void rankResultUniqueCheck(String name) {
        HashSet<String> groupSet = new HashSet<String>(16);
        DynamicObjectCollection rankResultList = this.getModel().getEntryEntity("rankresultentity");
        if (!ObjectUtils.isEmpty((Object)rankResultList)) {
            for (DynamicObject row : rankResultList) {
                DynamicObject rankDimension = row.getDynamicObject("rankdimension");
                String dimensionName = row.getString("dimensionname");
                if (ObjectUtils.isEmpty((Object)rankDimension) || HRStringUtils.isEmpty((String)dimensionName)) continue;
                String groupName = rankDimension.getString("id") + "-" + dimensionName;
                if (groupSet.contains(groupName)) {
                    this.getModel().setValue(name, null);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u201c\u6392\u540d\u7ef4\u5ea6\u201d\u548c\u201c\u7ef4\u5ea6\u540d\u79f0\u201d\u7ec4\u5408\u503c\u4e0d\u80fd\u91cd\u590d\u3002", (String)"PerfResultEdit_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    continue;
                }
                groupSet.add(groupName);
            }
        }
    }

    private void overallResultUniqueCheck(String name) {
        HashSet<String> groupSet = new HashSet<String>(16);
        DynamicObjectCollection overAllResultList = this.getModel().getEntryEntity("overallresultentity");
        if (!ObjectUtils.isEmpty((Object)overAllResultList)) {
            for (DynamicObject row : overAllResultList) {
                DynamicObject roleType = row.getDynamicObject("roletype");
                DynamicObject assessUser = row.getDynamicObject("assessuser");
                if (ObjectUtils.isEmpty((Object)roleType) || ObjectUtils.isEmpty((Object)assessUser)) continue;
                String groupName = roleType.getString("id") + "-" + assessUser.getString("number");
                if (groupSet.contains(groupName)) {
                    this.getModel().setValue(name, null);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u201c\u8bc4\u4f30\u89d2\u8272\u201d\u548c\u201c\u8bc4\u4f30\u4eba\u5de5\u53f7\u201d\u7ec4\u5408\u503c\u4e0d\u80fd\u91cd\u590d\u3002", (String)"PerfResultEdit_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    continue;
                }
                groupSet.add(groupName);
            }
        }
    }

    private boolean isMaxLimit(String entityKey) {
        return this.getModel().getEntryCurrentRowIndex(entityKey) >= 9;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "ranknewentry": {
                this.setDefShow("rankresultentity");
                break;
            }
            case "overallnewentry": {
                this.setDefShow("overallresultentity");
                break;
            }
            case "save": 
            case "changesave": 
            case "submit": 
            case "auditconfirmchange": {
                DynamicObject activity = this.getModel().getDataEntity().getDynamicObject("activity");
                if (HRObjectUtils.isEmpty((Object)activity)) break;
                this.updateScoreNumAccuracy(activity);
                break;
            }
        }
    }

    private void updateScoreNumAccuracy(DynamicObject activity) {
        DynamicObject workFlowDy = this.service.queryPerfWorkFlow(Long.valueOf(activity.getLong("id")));
        int numAccuracy = 2;
        boolean dependentSummary = ActEvalObjManageDomainService.getInstance().isDependentSummary(Long.valueOf(workFlowDy.getLong("id")));
        if (dependentSummary) {
            numAccuracy = workFlowDy.getInt("mpnumaccuracy");
        } else {
            long assessFormId = activity.getLong("assessform.id");
            if (assessFormId != 0L) {
                DynamicObject assessForm = ASSESS_FORM_ENTITY.queryOne((Object)assessFormId);
                numAccuracy = assessForm.getInt("numaccuracy");
            }
        }
        HashMap<String, Integer> pcScMap = new HashMap<String, Integer>(16);
        pcScMap.put("pc", numAccuracy + 13);
        pcScMap.put("sc", numAccuracy);
        HashMap<String, HashMap<String, Integer>> itemMap = new HashMap<String, HashMap<String, Integer>>(16);
        itemMap.put("item", pcScMap);
        this.getView().updateControlMetadata(SCORE, itemMap);
    }

    private void setDefShow(String entityKey) {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(entityKey);
        this.getModel().setValue(DETAIL_KEY_MAP.get(entityKey), (Object)this.getDetailEntryKey(entityKey), currentRowIndex);
        if (currentRowIndex == 0) {
            this.getModel().setValue(RELATIONSHIP_MAP.get(entityKey), (Object)Boolean.TRUE, currentRowIndex);
            this.getView().setEnable(Boolean.FALSE, currentRowIndex, new String[]{RELATIONSHIP_MAP.get(entityKey)});
        }
    }

    private String getDetailEntryKey(String entityKey) {
        if ("rankresultentity".equals(entityKey)) {
            return ResManager.loadKDString((String)"\u6392\u540d\u8be6\u60c5", (String)"PerfResultEdit_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        }
        if ("levelresultentity".equals(entityKey)) {
            return ResManager.loadKDString((String)"\u6807\u5c3a\u7b49\u7ea7\u8be6\u60c5", (String)"PerfResultEdit_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u603b\u8bc4\u8be6\u60c5", (String)"PerfResultEdit_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
    }

    private void setDefShowOnEdit(String entityKey) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entityKey);
        if (ObjectUtils.isEmpty((Object)entryEntity)) {
            return;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            String defShowName = RELATIONSHIP_MAP.get(entityKey);
            if (!"true".equals(((DynamicObject)entryEntity.get(i)).getString(defShowName))) continue;
            this.getModel().setValue(DETAIL_KEY_MAP.get(entityKey), (Object)this.getDetailEntryKey(entityKey), i);
            this.getView().setEnable(Boolean.FALSE, i, new String[]{defShowName});
            this.getModel().setValue(defShowName, (Object)Boolean.TRUE, i);
            return;
        }
    }

    private void switchDefShow(String entityKey) {
        if (HRStringUtils.isEmpty((String)entityKey)) {
            return;
        }
        BaseShowParameter parameter = (BaseShowParameter)this.getView().getFormShowParameter();
        BillOperationStatus billStatus = parameter.getBillStatus();
        if (HRStringUtils.equals((String)BillOperationStatus.AUDIT.name(), (String)billStatus.name()) || HRStringUtils.equals((String)BillOperationStatus.SUBMIT.name(), (String)billStatus.name())) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entityKey);
        if (ObjectUtils.isEmpty((Object)entryEntity)) {
            return;
        }
        int defShowRowIndex = 0;
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (!((DynamicObject)entryEntity.get(i)).getString(RELATIONSHIP_MAP.get(entityKey)).equals("true")) continue;
            defShowRowIndex = i;
            break;
        }
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(entityKey);
        this.getModel().setValue(RELATIONSHIP_MAP.get(entityKey), (Object)Boolean.FALSE, defShowRowIndex);
        this.getView().setEnable(Boolean.TRUE, defShowRowIndex, new String[]{RELATIONSHIP_MAP.get(entityKey)});
        this.getModel().setValue(RELATIONSHIP_MAP.get(entityKey), (Object)Boolean.TRUE, currentRowIndex);
        this.getView().setEnable(Boolean.FALSE, currentRowIndex, new String[]{RELATIONSHIP_MAP.get(entityKey)});
    }

    public void beforeClosed(BeforeClosedEvent closedEvent) {
        super.beforeClosed(closedEvent);
        DynamicObject dyo = this.getModel().getDataEntity(true);
        DynamicProperty nameProp = dyo.getDynamicObjectType().getProperty("name");
        dyo.getDataEntityState().setBizChanged(nameProp.getOrdinal(), false);
        DynamicProperty numberProp = dyo.getDynamicObjectType().getProperty("number");
        dyo.getDataEntityState().setBizChanged(numberProp.getOrdinal(), false);
        DynamicProperty sculptureProp = dyo.getDynamicObjectType().getProperty("headsculpture");
        dyo.getDataEntityState().setBizChanged(sculptureProp.getOrdinal(), false);
        for (String value : DY_MAP.values()) {
            DynamicProperty personProp = dyo.getDynamicObjectType().getProperty(value);
            dyo.getDataEntityState().setBizChanged(personProp.getOrdinal(), false);
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)status)) {
            this.setBizChanged(dyo, "rankresultentity");
            this.setBizChanged(dyo, "levelresultentity");
            this.setBizChanged(dyo, "overallresultentity");
        }
    }

    private void setBizChanged(DynamicObject dyo, String entryKey) {
        DynamicObjectCollection dynamicObjectCollection = dyo.getDynamicObjectCollection(entryKey);
        if (!ObjectUtils.isEmpty((Object)dynamicObjectCollection)) {
            for (DynamicObject dyc : dynamicObjectCollection) {
                DataEntityState dycState = dyc.getDataEntityState();
                DataEntityPropertyCollection props = dyc.getDataEntityType().getProperties();
                for (IDataEntityProperty prop : props) {
                    if (!prop.getName().equals(DETAIL_KEY_MAP.get(entryKey))) continue;
                    dycState.setBizChanged(prop.getOrdinal(), false);
                }
            }
        }
    }

    static {
        RELATIONSHIP_MAP.put("rankresultentity", "rankdefshow");
        RELATIONSHIP_MAP.put("rankdefshow", "rankresultentity");
        RELATIONSHIP_MAP.put("overallresultentity", "oeveralldefshow");
        RELATIONSHIP_MAP.put("oeveralldefshow", "overallresultentity");
        RELATIONSHIP_MAP.put("levelrankshow", "levelresultentity");
        RELATIONSHIP_MAP.put("levelresultentity", "levelrankshow");
        DETAIL_KEY_MAP = new HashMap<String, String>();
        DETAIL_KEY_MAP.put("rankresultentity", "rankdetail");
        DETAIL_KEY_MAP.put("rankdetail", "rankresultentity");
        DETAIL_KEY_MAP.put("overallresultentity", "overalldetail");
        DETAIL_KEY_MAP.put("overalldetail", "overallresultentity");
        DETAIL_KEY_MAP.put("leveldetail", "levelresultentity");
        DETAIL_KEY_MAP.put("levelresultentity", "leveldetail");
        DY_MAP = new HashMap<String, String>();
        DY_MAP.put("person", "person_id");
        DY_MAP.put("empposrel", "empposrel_id");
        DY_MAP.put("employee", "employee_id");
        DY_MAP.put("affiliateadminorg", "affiliateadminorg_id");
        DY_MAP.put("depemp", "depemp_id");
        DY_MAP.put("perffilef7", "perffilef7_id");
    }
}

