/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.perfresult;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.expt.common.plugin.AfterQueryDataEventArgs;
import kd.hr.expt.common.plugin.BeforeCreateHeaderColumnEventArgs;
import kd.hr.expt.common.plugin.BeforeWriteDataEventArgs;
import kd.hr.expt.common.plugin.HRExportPlugin;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hies.business.export.ExportHeaderWriterFormat;

public class PerfResultExportPlugin
implements HRExportPlugin {
    private static final Log LOG = LogFactory.getLog(PerfResultExportPlugin.class);
    private static final Map<String, List<DynamicObject>> allResultMap = new HashMap<String, List<DynamicObject>>(16);
    private static final Map<String, List<DynamicObject>> levelResultMap = new HashMap<String, List<DynamicObject>>(16);

    public void afterQueryData(AfterQueryDataEventArgs args) {
        LOG.info("PerfResultExportPlugin.afterQueryData:{}", (Object)SerializationUtils.toJsonString((Object)args));
        List queryDataList = args.getQueryDataList();
        ArrayList resultIds = new ArrayList(10);
        for (Map dataMap : queryDataList) {
            Map perfResultData = (Map)dataMap.get("epa_performanceresult");
            resultIds.addAll(perfResultData.values().stream().map(resultDy -> resultDy.getLong("id")).collect(Collectors.toList()));
        }
        HRBaseServiceHelper overAllResultHelper = new HRBaseServiceHelper("epa_overallresult");
        DynamicObject[] allResultDys = overAllResultHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("boid", "in", resultIds)});
        allResultMap.clear();
        allResultMap.putAll(Arrays.stream(allResultDys).collect(Collectors.groupingBy(dy -> dy.getString("boid.number"))));
        HRBaseServiceHelper levelResultHelper = new HRBaseServiceHelper("epa_levelresult");
        DynamicObject[] levelResultDys = levelResultHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("boid", "in", resultIds)});
        levelResultMap.clear();
        levelResultMap.putAll(Arrays.stream(levelResultDys).collect(Collectors.groupingBy(dy -> dy.getString("boid.number"))));
    }

    public void beforeCreateHeaderColumn(BeforeCreateHeaderColumnEventArgs args) {
        super.beforeCreateHeaderColumn(args);
        Lang lang = RequestContext.get().getLang();
        List headerWriterFormats = args.getHeaderWriterFormats();
        for (ExportHeaderWriterFormat headerWriterFormat : headerWriterFormats) {
            Map flexColumn = headerWriterFormat.getFlexColumn();
            HashMap newFlexColumn = new HashMap(16);
            flexColumn.forEach((key, values) -> {
                List newValues = values.stream().filter(value -> value.contains(lang.name())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(newValues)) {
                    newFlexColumn.put(key, newValues);
                }
            });
            if (ObjectUtils.isEmpty(newFlexColumn)) continue;
            flexColumn.putAll(newFlexColumn);
        }
        args.getFieldCaptions();
    }

    public void beforeWriteData(BeforeWriteDataEventArgs args) {
        Integer overAllResult;
        List tplDataRows = args.getTplDataRows();
        Map entityIdStartIndex = args.getEntityIdStartIndex();
        Integer levelResult = (Integer)entityIdStartIndex.get("epa_levelresult");
        if (levelResult != null) {
            this.processTplData(args, tplDataRows, levelResultMap);
        }
        if ((overAllResult = (Integer)entityIdStartIndex.get("epa_overallresult")) != null) {
            this.processTplData(args, tplDataRows, allResultMap);
        }
    }

    private void processTplData(BeforeWriteDataEventArgs args, List<Map<Integer, Map<String, Object>>> tplDataRows, Map<String, List<DynamicObject>> resultMap) {
        Map<Integer, Map<String, Object>> integerMap = tplDataRows.remove(0);
        Map perfNumberFieldMap = integerMap.values().stream().filter(dataInfo -> HRStringUtils.equals((String)((String)dataInfo.get("key")), (String)"boid.number")).findFirst().orElseGet(() -> new HashMap());
        String perfNumber = (String)perfNumberFieldMap.get("val");
        if (HRStringUtils.isEmpty((String)perfNumber)) {
            return;
        }
        List<DynamicObject> allResultDys = resultMap.remove(perfNumber);
        if (ObjectUtils.isEmpty(allResultDys)) {
            return;
        }
        for (DynamicObject allResultDy : allResultDys) {
            HashMap newIntegerMap = new HashMap(16);
            for (Map.Entry<Integer, Map<String, Object>> integerMapEntry : integerMap.entrySet()) {
                HashMap<String, Object> newValue = new HashMap<String, Object>(16);
                Map<String, Object> value = integerMapEntry.getValue();
                for (Map.Entry<String, Object> entry : value.entrySet()) {
                    newValue.put(entry.getKey(), entry.getValue());
                }
                String key = (String)newValue.get("key");
                Object val = allResultDy.get(key);
                if (val instanceof DynamicObject) {
                    newValue.put("val", ((DynamicObject)val).getString("name"));
                } else {
                    newValue.put("val", allResultDy.getString(key));
                }
                newIntegerMap.put(integerMapEntry.getKey(), newValue);
            }
            tplDataRows.add(newIntegerMap);
        }
        args.setTplDataRows(tplDataRows);
    }
}

