/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.perfresult;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterColumnSetFilterEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.IListColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.opmc.epa.common.enums.activitymanage.DataSourceEnum;

public class PerfResultList
extends HRDataBaseList {
    private static final Map<String, String> DETAIL_MAP = new HashMap<String, String>();

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        String fieldName = event.getFieldName();
        if (Objects.equals(fieldName, "epa_rankresult_rankdetail") || Objects.equals(fieldName, "epa_levelresult_leveldetail") || Objects.equals(fieldName, "epa_overallresult_overalldetail")) {
            args.setCancel(true);
            ListSelectedRow currentRow = event.getCurrentRow();
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId(DETAIL_MAP.get(event.getFieldName()));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCustomParam("perfResultId", currentRow.getPrimaryKeyValue());
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"versionchangecomparebtn"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        IFormView view;
        IFormView parentView;
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"openperffilef7") && !ObjectUtils.isEmpty((Object)(parentView = (view = this.getView()).getParentView()))) {
            BasedataEdit baseData = (BasedataEdit)parentView.getControl("perffilef7");
            baseData.click();
            view.sendFormAction(parentView);
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        IFormView view;
        IFormView homeView;
        super.beforeClosed(event);
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("epa_perfresultreelist".equals(formId) && !ObjectUtils.isEmpty((Object)(homeView = (view = this.getView()).getParentView()))) {
            homeView.close();
            view.sendFormAction(homeView);
        }
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        List qFilters = event.getQFilters();
        QFilter qFilter = new QFilter("datasource", "!=", (Object)DataSourceEnum.HIS_PERRESULT.getCode());
        qFilters.add(qFilter);
        HasPermOrgResult result = this.getHasPermOrgResult();
        if (!result.hasAllOrgPerm()) {
            event.setMainOrgQFilter(new QFilter("pmdorg", "in", (Object)result.getHasPermOrgs()));
        }
        event.setOrderBy("modifytime desc,createtime desc");
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (HRStringUtils.equals((String)"pmdorg.name", (String)fieldName) || "pmdorg.id".equals(fieldName) || "pmdorg.number".equals(fieldName)) {
            List qFilters = args.getQfilters();
            HasPermOrgResult result = this.getHasPermOrgResult();
            if (!result.hasAllOrgPerm()) {
                qFilters.add(new QFilter("id", "in", (Object)result.getHasPermOrgs()));
            }
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List<String> fixedColumnList = Arrays.asList("fseq", "number", "perffilef7.number", "person.number", "person.name");
        fixedColumnList.forEach(column -> {
            if (args.getListColumn(column) != null) {
                args.getListColumn(column).setFixed(true);
            }
        });
        List listColumns = args.getListColumns();
        listColumns.add(this.getDataSourceIndex(listColumns), args.getListColumn("status"));
        args.setListColumns(listColumns);
    }

    private int getDataSourceIndex(List<IListColumn> listColumns) {
        int index = listColumns.size();
        for (int i = 0; i < listColumns.size(); ++i) {
            if (!listColumns.get(i).getListFieldKey().equals("datasource")) continue;
            index = i;
            break;
        }
        return index;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        SchemeFilterColumn dataStatusSchemeColumn = new SchemeFilterColumn();
        dataStatusSchemeColumn.setKey("status");
        dataStatusSchemeColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u72b6\u6001", (String)"PerfResultList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        dataStatusSchemeColumn.setFieldName("status");
        dataStatusSchemeColumn.setType("text");
        args.addFilterColumn((FilterColumn)dataStatusSchemeColumn);
        CommonFilterColumn dataStatusColumn = new CommonFilterColumn();
        dataStatusColumn.setKey("status");
        dataStatusColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u72b6\u6001", (String)"PerfResultList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        dataStatusColumn.setFieldName("status");
        dataStatusColumn.setType("text");
        List<ComboItem> combos = this.buildComboItems();
        dataStatusColumn.setComboItems(combos);
        dataStatusColumn.setMulti(true);
        args.addFilterColumn((FilterColumn)dataStatusColumn);
        HasPermOrgResult result = this.getHasPermOrgResult();
        if (result.hasAllOrgPerm()) {
            return;
        }
        this.initOrg(args, result);
    }

    private HasPermOrgResult getHasPermOrgResult() {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"36", (String)"24E05ECYZ6K0", (String)"epa_performanceresult", (String)"47150e89000000ac");
        return result;
    }

    private void initOrg(FilterContainerInitArgs args, HasPermOrgResult result) {
        HRBaseServiceHelper orgHelper = new HRBaseServiceHelper("bos_org_structure");
        QFilter viewFilter = new QFilter("view", "=", (Object)36L);
        QFilter orgFilter = new QFilter("org", "in", (Object)result.getHasPermOrgs());
        DynamicObject[] orgs = orgHelper.query("id, name, org", new QFilter[]{orgFilter, viewFilter});
        ArrayList<ComboItem> orgCombos = new ArrayList<ComboItem>(10);
        for (DynamicObject org : orgs) {
            if (org == null) continue;
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(org.getLong("org.id")));
            item.setCaption(new LocaleString(org.getString("org.name")));
            item.setValue(String.valueOf(org.getLong("org.id")));
            orgCombos.add(item);
        }
        List schemeFilterCols = args.getSchemeFilterColumns().stream().map(filterFilterCol -> (SchemeFilterColumn)filterFilterCol).collect(Collectors.toList());
        for (SchemeFilterColumn schemeFilterColumn : schemeFilterCols) {
            String fieldName = schemeFilterColumn.getFieldName();
            if (!HRStringUtils.equals((String)fieldName, (String)"org.name") && !HRStringUtils.equals((String)fieldName, (String)"org.number")) continue;
            schemeFilterColumn.setComboItems(orgCombos);
        }
        List commonFilterCols = args.getCommonFilterColumns().stream().map(commonFilterCol -> (CommonFilterColumn)commonFilterCol).collect(Collectors.toList());
        for (CommonFilterColumn commonFilterColumn : commonFilterCols) {
            String fieldName = commonFilterColumn.getFieldName();
            if (!HRStringUtils.equals((String)fieldName, (String)"pmdorg.name")) continue;
            commonFilterColumn.setComboItems(orgCombos);
        }
    }

    private List<ComboItem> buildComboItems() {
        ArrayList combos = Lists.newArrayListWithExpectedSize((int)16);
        ComboItem temp = new ComboItem();
        temp.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6682\u5b58", (String)"PerfResultList_1", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        temp.setValue("A");
        combos.add(temp);
        ComboItem submit = new ComboItem();
        submit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"PerfResultList_2", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        submit.setValue("B");
        combos.add(submit);
        ComboItem audit = new ComboItem();
        audit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"PerfResultList_3", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        audit.setValue("C");
        combos.add(audit);
        return combos;
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        List commonFilterValue = ((FilterColumnSetFilterEvent)args).getCommonFilterValue("pmd_perffilef7.org.name");
        if (!ObjectUtils.isEmpty((Object)commonFilterValue)) {
            commonFilterValue.clear();
        }
    }

    static {
        DETAIL_MAP.put("epa_rankresult_rankdetail", "epa_rankresultdetail");
        DETAIL_MAP.put("epa_levelresult_leveldetail", "epa_levelresultdetail");
        DETAIL_MAP.put("epa_overallresult_overalldetail", "epa_overallresultdetail");
    }
}

