/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.perfresult.excel;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.impt.common.plugin.AfterConvertDynamicObjectsEventArgs;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.opmc.epa.formplugin.web.utils.permission.HisPerResultUtils;
import kd.opmc.pmd.business.domain.perffile.entityservice.PerffileEntityService;

public class HisPerResultImportPlugin
implements HRImportPlugin {
    private static final PerffileEntityService PERFFILE_ENTITY_SERVICE = PerffileEntityService.getInstance();
    private static final String PERSON_NUMBER = "personnumber";
    private static final String YEAR = "year";
    private static final String PERIOD = "period";
    private static final String ADMIN_ORG_NAME = "adminorgname";
    private static final String ADMINORG_NAME = "adminorg.name";
    private static final String POSITION_NAME = "position.name";
    private static final String JOB_NAME = "job.name";
    private static final String ASSESS_PERIOD = "assessperiod";
    private static final String POSITIONNAME = "positionname";
    private static final String JOBNAME = "jobname";

    public void afterConvertDynamicObjects(AfterConvertDynamicObjectsEventArgs args) {
        Map map = args.getDynamicObjects();
        DynamicObject[] dynamicObjects = (DynamicObject[])map.get("default");
        if (dynamicObjects == null) {
            return;
        }
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject dynamicObject = dynamicObjects[i];
            this.setAssessPeriod(dynamicObject);
            this.setPerffile(dynamicObject);
        }
    }

    private void setPerffile(DynamicObject dynamicObject) {
        if (dynamicObject.get("perffilef7") instanceof DynamicObject && !Objects.isNull(dynamicObject.getDynamicObject("perffilef7"))) {
            return;
        }
        String personNumber = dynamicObject.getString(PERSON_NUMBER);
        String personName = dynamicObject.getString("name");
        Date date = dynamicObject.getDate(YEAR);
        String period = dynamicObject.getString(PERIOD);
        String adminOrgName = dynamicObject.getString(ADMIN_ORG_NAME);
        String positionName = dynamicObject.getString(POSITIONNAME);
        String jobName = dynamicObject.getString(JOBNAME);
        DynamicObject[] dynamicObjects = PERFFILE_ENTITY_SERVICE.queryPerffileByDepempNumberAndName(personNumber, personName);
        if (dynamicObjects.length <= 0) {
            return;
        }
        List<DynamicObject> orgAndPositionCollect = Stream.of(dynamicObjects).filter(tmpDynamicObject -> !Objects.isNull(adminOrgName) && HRStringUtils.equals((String)tmpDynamicObject.getString(ADMINORG_NAME), (String)adminOrgName)).filter(tmpDynamicObject -> !Objects.isNull(positionName) && HRStringUtils.equals((String)tmpDynamicObject.getString(POSITION_NAME), (String)positionName)).collect(Collectors.toList());
        if (!orgAndPositionCollect.isEmpty()) {
            this.getClosestDate(date, period, orgAndPositionCollect, dynamicObject);
            return;
        }
        List<DynamicObject> orgAndJobCollect = Stream.of(dynamicObjects).filter(tmpDynamicObject -> !Objects.isNull(adminOrgName) && HRStringUtils.equals((String)tmpDynamicObject.getString(ADMINORG_NAME), (String)adminOrgName)).filter(tmpDynamicObject -> !Objects.isNull(jobName) && HRStringUtils.equals((String)tmpDynamicObject.getString(JOB_NAME), (String)jobName)).collect(Collectors.toList());
        if (!orgAndJobCollect.isEmpty()) {
            this.getClosestDate(date, period, orgAndJobCollect, dynamicObject);
            return;
        }
        List<DynamicObject> orgCollect = Stream.of(dynamicObjects).filter(tmpDynamicObject -> !Objects.isNull(adminOrgName) && HRStringUtils.equals((String)tmpDynamicObject.getString(ADMINORG_NAME), (String)adminOrgName)).collect(Collectors.toList());
        if (!orgCollect.isEmpty()) {
            this.getClosestDate(date, period, orgCollect, dynamicObject);
            return;
        }
        List<DynamicObject> positionCollect = Stream.of(dynamicObjects).filter(tmpDynamicObject -> !Objects.isNull(positionName) && HRStringUtils.equals((String)tmpDynamicObject.getString(POSITION_NAME), (String)positionName)).collect(Collectors.toList());
        if (!positionCollect.isEmpty()) {
            this.getClosestDate(date, period, positionCollect, dynamicObject);
            return;
        }
        List<DynamicObject> jobCollect = Stream.of(dynamicObjects).filter(tmpDynamicObject -> !Objects.isNull(jobName) && HRStringUtils.equals((String)tmpDynamicObject.getString(JOB_NAME), (String)jobName)).collect(Collectors.toList());
        if (!jobCollect.isEmpty()) {
            this.getClosestDate(date, period, jobCollect, dynamicObject);
            return;
        }
        List<DynamicObject> collect = Stream.of(dynamicObjects).collect(Collectors.toList());
        this.getClosestDate(date, period, collect, dynamicObject);
    }

    private void setAssessPeriod(DynamicObject dynamicObject) {
        Date date = dynamicObject.getDate(YEAR);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        String period = dynamicObject.getString(PERIOD);
        dynamicObject.set(ASSESS_PERIOD, (Object)(year + period));
    }

    private void getClosestDate(Date date, String period, List<DynamicObject> orgAndJobCollect, DynamicObject dynamicObject) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        Map<Date, DynamicObject> map = orgAndJobCollect.stream().collect(Collectors.toMap(tmpDynamicObject -> tmpDynamicObject.getDate("bsed"), tmpDynamicObject -> tmpDynamicObject, (v1, v2) -> v1));
        Date closestDate = HisPerResultUtils.getClosestDateFromMap(year, period, map);
        dynamicObject.set("perffilef7", (Object)map.get(closestDate));
    }
}

