/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.perfworkflow;

import com.google.common.collect.Maps;
import java.text.DecimalFormat;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.application.service.workflow.WorkFlowApplicationService;

public class PerfFlowHisChangeStylePlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final WorkFlowApplicationService WORK_FLOW_APPLICATION_SERVICE = WorkFlowApplicationService.getInstance();
    private static final String VERSION_ENTRY = "versionentry";
    private static final String VERSION_ENTRY_ID = "entryid";
    private static final String CHANGE_STYLE = "radiogroupfield";
    private static final String STYLE_NEW_VERSION = "1";
    private static final String STYLE_MODIFY_TEMP_VERSION = "2";
    private static final String OP_CONFIRM = "confirm";
    private static final String WORK_FLOW_PAGE_ID = "workFlowPageId";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entry = (EntryGrid)this.getView().getControl(VERSION_ENTRY);
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject event) {
        long flowBoId = (Long)this.getView().getFormShowParameter().getCustomParam("boid");
        DynamicObject tempVersion = WORK_FLOW_APPLICATION_SERVICE.getCurrentTempWorkflow(flowBoId);
        if (tempVersion != null) {
            this.getModel().batchCreateNewEntryRow(VERSION_ENTRY, 1);
            this.getModel().setValue(VERSION_ENTRY_ID, (Object)flowBoId, 0);
            String version = HRStringUtils.isEmpty((String)((String)tempVersion.get("hisversion"))) ? this.getMaxVersion(flowBoId) : (String)tempVersion.get("hisversion");
            this.getModel().setValue("version", (Object)version, 0);
            this.getModel().setValue("name", tempVersion.get("name"), 0);
            this.getModel().setValue("modifier", tempVersion.get("modifier"), 0);
            this.getModel().setValue("modifytime", tempVersion.get("modifytime"), 0);
            this.getModel().setValue("datastatus", tempVersion.get("datastatus"), 0);
        }
    }

    private String getMaxVersion(long flowId) {
        String version;
        DynamicObject workflowVersion = WORK_FLOW_APPLICATION_SERVICE.getWorkflowVersion(flowId);
        String flowVersion = "V0001";
        if (!HRObjectUtils.isEmpty((Object)workflowVersion) && HRStringUtils.isNotEmpty((String)(version = workflowVersion.getString("hisversion")))) {
            DecimalFormat decimalFormat = new DecimalFormat("0000");
            flowVersion = "V" + decimalFormat.format(Integer.parseInt(version.split("V")[1]) + 1);
        }
        return flowVersion;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String key = args.getProperty().getName();
        if (HRStringUtils.equals((String)CHANGE_STYLE, (String)key)) {
            String style = (String)args.getChangeSet()[0].getNewValue();
            if (HRStringUtils.equals((String)style, (String)STYLE_NEW_VERSION)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{VERSION_ENTRY});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{VERSION_ENTRY});
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        long pkId = (Long)this.getModel().getValue(VERSION_ENTRY_ID, rowIndex);
        this.showFlowItem(pkId);
    }

    private void showFlowItem(long flowId) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("epa_assessworkflow");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_assessworkflow"));
        if (HRStringUtils.isEmpty((String)this.getView().getParentView().getPageCache().get(WORK_FLOW_PAGE_ID + flowId))) {
            this.getView().getParentView().getPageCache().put(WORK_FLOW_PAGE_ID + flowId, baseShowParameter.getPageId());
        }
        baseShowParameter.setPkId((Object)flowId);
        baseShowParameter.setPageId(this.getView().getPageCache().get(WORK_FLOW_PAGE_ID + flowId));
        long vid = (Long)this.getView().getFormShowParameter().getCustomParam("vid");
        String flowType = (String)this.getView().getFormShowParameter().getCustomParam("flowType");
        baseShowParameter.setCustomParam("vid", (Object)vid);
        baseShowParameter.setCustomParam("assessruleid", this.getView().getFormShowParameter().getCustomParam("assessruleid"));
        baseShowParameter.setCustomParam("tipRef", (Object)Boolean.TRUE);
        baseShowParameter.setCustomParam("flowType", (Object)flowType);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)OP_CONFIRM)) {
            String changeStyle = (String)this.getModel().getValue(CHANGE_STYLE);
            HashMap map = Maps.newHashMapWithExpectedSize((int)2);
            int focusRowIndex = this.getModel().getEntryCurrentRowIndex(VERSION_ENTRY);
            long flowId = (Long)this.getModel().getValue(VERSION_ENTRY_ID, focusRowIndex);
            map.put("tempVersionId", flowId);
            map.put("flowid", flowId);
            if (HRStringUtils.equals((String)changeStyle, (String)STYLE_NEW_VERSION)) {
                DynamicObject currentVersion = WORK_FLOW_APPLICATION_SERVICE.getCurrentWorkflow(flowId);
                if (null != currentVersion) {
                    map.put("tempVersionId", currentVersion.getLong("id"));
                }
                map.put(CHANGE_STYLE, STYLE_NEW_VERSION);
                this.getView().returnDataToParent((Object)map);
            } else {
                map.put(CHANGE_STYLE, STYLE_MODIFY_TEMP_VERSION);
                this.getView().returnDataToParent((Object)map);
            }
        }
    }
}

