/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.perfworkflow;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListColumn;
import kd.bos.list.ListOperationColumn;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.opmc.epa.business.application.service.upgradeparam.UpgradeParamApplicationService;
import kd.opmc.epa.business.domain.perfworkflow.entutyservice.PerfWorkFlowEntityService;
import kd.opmc.pbs.business.application.service.workflow.WorkFlowApplicationService;

public class PerfWorkFlowList
extends HRDataBaseList {
    private static final WorkFlowApplicationService WORK_FLOW_APPLICATION_SERVICE = WorkFlowApplicationService.getInstance();
    private static final PerfWorkFlowEntityService PERF_WORK_FLOW_ENTITY_SERVICE = PerfWorkFlowEntityService.getInstance();
    private static final UpgradeParamApplicationService UPGRADE_PARAM_APPLICATION_SERVICE = UpgradeParamApplicationService.getInstance();
    private static final String VERSION_CHANGE_COMPARE_BTN = "versionchangecomparebtn";
    private static final String INSERT_DATA_BTN = "insertdatabtn";
    private static final String UPGRADE_BTN = "tblupgrade";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{UPGRADE_BTN});
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        QFilter activityIdFilter = new QFilter("activityid", "is null", null).or(new QFilter("activityid", "=", (Object)0));
        evt.getQFilters().add(activityIdFilter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("upgrade".equals(operateKey)) {
            OperationResult operationResult = args.getOperationResult();
            if (operationResult.isSuccess()) {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("epa_upgradepage");
                formShowParameter.setStatus(OperationStatus.EDIT);
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(formShowParameter);
            } else {
                this.getView().showOperationResult(operationResult);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{VERSION_CHANGE_COMPARE_BTN, INSERT_DATA_BTN});
        DynamicObject upgradeParamObj = UPGRADE_PARAM_APPLICATION_SERVICE.getUpgradeParam();
        boolean isupgrade = upgradeParamObj.getBoolean("isupgrade");
        this.getView().setVisible(Boolean.valueOf(isupgrade), new String[]{UPGRADE_BTN});
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        for (IListColumn listColumn : args.getListColumns()) {
            if (!(listColumn instanceof ListOperationColumn)) continue;
            ListOperationColumn listOperationColumn = (ListOperationColumn)listColumn;
            List<String> removeKeys = Arrays.asList("revise", "his_copy", "changebed", "cancelchange");
            listOperationColumn.getOperationColItems().removeIf(e -> removeKeys.contains(e.getOperationKey()));
        }
    }
}

