/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.permission;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IPageCache;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;

public class ExeSchemeCardDynamicPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"delbutton"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        List exeSchemeIds = (List)this.getView().getFormShowParameter().getCustomParam("exeSchemeId");
        if (ObjectUtils.isEmpty((Object)exeSchemeIds)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("executeplan", new Object[0]);
        setter.addField("schemeCardApKey", new Object[0]);
        for (Long exeSchemeId : exeSchemeIds) {
            setter.addRow(new Object[]{exeSchemeId, this.getView().getFormShowParameter().getCustomParam("schemeCardApKey")});
        }
        model.deleteEntryData("executecard");
        model.batchCreateNewEntryRow("executecard", setter);
        model.endInit();
        this.getView().updateView("executecard");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CardEntry executeCard = (CardEntry)this.getView().getControl("executecard");
        if (ObjectUtils.isEmpty((Object)executeCard)) {
            return;
        }
        Object[] dataEntitys = executeCard.getEntryData().getDataEntitys();
        if (ObjectUtils.isEmpty((Object[])dataEntitys)) {
            return;
        }
        if (dataEntitys.length == 1) {
            executeCard.setChildVisible(false, 0, new String[]{"delflexap"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (HRStringUtils.equalsIgnoreCase((String)"delbutton", (String)source.getKey())) {
            CardEntry entryGrid = (CardEntry)this.getView().getControl("executecard");
            int[] rows = entryGrid.getSelectRows();
            DynamicObjectCollection collection = this.getModel().getEntryEntity("executecard");
            collection.remove(rows[0]);
            if (collection.size() <= 1) {
                entryGrid.setChildVisible(false, 0, new String[]{"delflexap"});
            }
            this.getView().updateView("executecard");
        }
        DynamicObjectCollection collection = this.getModel().getEntryEntity("executecard");
        List exeSchemeIds = collection.stream().map(execute -> execute.getLong("executeplan.id")).collect(Collectors.toList());
        List exeSchemeNames = collection.stream().map(execute -> execute.getString("executeplan.name")).collect(Collectors.toList());
        String schemeCardApKey = ((DynamicObject)collection.get(0)).getString("schemeCardApKey");
        HashMap idNameMap = new HashMap(2);
        idNameMap.put("exeIds", exeSchemeIds);
        idNameMap.put("exeNames", exeSchemeNames);
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        pageCache.put(schemeCardApKey, SerializationUtils.toJsonString(idNameMap));
        Container container = (Container)this.getView().getParentView().getControl(schemeCardApKey);
        container.click();
    }
}

