/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.permission;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.mutex.DataMutex;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.scheme.ExecuteSchemeApplicationService;

public class PermissionBatchDynamicPlugin
extends AbstractFormPlugin {
    private static final ExecuteSchemeApplicationService EXECUTE_SCHEME_APPLICATION_SERVICE = ExecuteSchemeApplicationService.getInstance();

    public void onGetControl(OnGetControlArgs evt) {
        super.onGetControl(evt);
        if (evt.getKey().toLowerCase(Locale.ROOT).contains("schemecardap")) {
            Container container = new Container();
            container.setKey(evt.getKey());
            container.setView(this.getView());
            container.setModel(this.getModel());
            container.addClickListener((ClickListener)this);
            evt.setControl((Control)container);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long schemeId = (Long)formShowParameter.getCustomParam("schemeId");
        Object[] executeScheme = EXECUTE_SCHEME_APPLICATION_SERVICE.queryListBySchemeId(schemeId);
        if (ObjectUtils.isEmpty((Object[])executeScheme)) {
            return;
        }
        Map map = Arrays.stream(executeScheme).collect(Collectors.groupingBy(scheme -> scheme.getLong("assessform.id") + "-" + scheme.getLong("perfworkflow.id"), LinkedHashMap::new, Collectors.toList()));
        if (ObjectUtils.isEmpty((Object)map)) {
            return;
        }
        int keySize = map.size();
        this.getPageCache().put("schemeCardSize", String.valueOf(keySize));
        Map<Long, String> assessFormMap = Arrays.stream(executeScheme).filter(scheme -> !ObjectUtils.isEmpty((Object)scheme.getDynamicObject("assessform"))).collect(Collectors.toMap(scheme -> scheme.getLong("assessform.id"), scheme -> scheme.getString("assessform.name"), (v1, v2) -> v2));
        Map<Long, String> perfWorkFlowMap = Arrays.stream(executeScheme).collect(Collectors.toMap(scheme -> scheme.getLong("perfworkflow.id"), scheme -> scheme.getString("perfworkflow.name"), (v1, v2) -> v2));
        Label size = (Label)this.getControl("size");
        size.setText(String.valueOf(keySize));
        for (int i = 0; i < keySize; ++i) {
            String[] exeScheme = map.keySet().toArray()[i].toString().split("-");
            String assessFormId = exeScheme[0];
            String flowId = exeScheme[1];
            Container contextAp = (Container)this.getControl("contextap");
            FlexPanelAp schemeCardAp = this.buildSchemeCardAp(i);
            FlexPanelAp sizePanelAp = this.buildSizePanelAp(i);
            FlexPanelAp formFlowAp = this.buildFormFlowAp(assessFormMap, perfWorkFlowMap, i, assessFormId, flowId);
            FlexPanelAp exeSchemeCardEntryAp = new HRFlexPanelAp.Builder("exeshcmecardentryap" + this.getView().getPageId() + i).setShrink(0).setGrow(0).setHeight("90px").setOverflow("hidden").setDirection("row").setWrap(true).build();
            schemeCardAp.getItems().add(sizePanelAp);
            schemeCardAp.getItems().add(formFlowAp);
            schemeCardAp.getItems().add(exeSchemeCardEntryAp);
            ArrayList<Map> controls = new ArrayList<Map>(10);
            controls.add(schemeCardAp.createControl());
            contextAp.addControls(controls);
            List executeSchemeList = (List)map.values().toArray()[i];
            List<Long> exeSchemeIds = executeSchemeList.stream().map(scheme -> scheme.getLong("id")).collect(Collectors.toList());
            List exeSchemeNames = executeSchemeList.stream().map(scheme -> scheme.getString("name")).collect(Collectors.toList());
            IPageCache pageCache = this.getView().getPageCache();
            HashMap<String, List<Long>> idNameMap = new HashMap<String, List<Long>>(2);
            idNameMap.put("exeIds", exeSchemeIds);
            idNameMap.put("exeNames", exeSchemeNames);
            pageCache.put("schemecardap" + this.getView().getPageId() + i, SerializationUtils.toJsonString(idNameMap));
            String schemeCardApKey = "schemecardap" + this.getView().getPageId() + i;
            this.showFlexPanelAp(exeSchemeCardEntryAp.getKey(), exeSchemeIds, schemeCardApKey);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String currentSelectMap = this.getPageCache().get("currentSelectMap");
        if (HRStringUtils.isEmpty((String)currentSelectMap)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6279\u91cf\u8bbe\u7f6e\u65b9\u6848", (String)"PermissionBatchDynamicPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Map idNameMap = (Map)SerializationUtils.fromJsonString((String)currentSelectMap, Map.class);
        List exeSchemeList = (List)idNameMap.get("exeIds");
        List exeSchemeName = (List)idNameMap.get("exeNames");
        if (exeSchemeList.size() == exeSchemeName.size()) {
            DataMutex dataMutex = DataMutex.create();
            StringBuilder lockNumber = new StringBuilder();
            int len = exeSchemeList.size();
            for (int i = 0; i < len; ++i) {
                Long lockId = (Long)exeSchemeList.get(i);
                Map lockInfo = dataMutex.getLockInfo(String.valueOf(lockId), "permission_netctrl", "epa_permissionsetting");
                if (lockInfo == null || lockInfo.size() <= 0) continue;
                lockNumber.append((String)exeSchemeName.get(i)).append("\u3001");
            }
            if (lockNumber.length() > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8003\u6838\u6267\u884c\u8ba1\u5212-{0}\u6b63\u5728\u8fdb\u884c\u6743\u9650\u8bbe\u7f6e\uff0c\u8bf7\u52ff\u91cd\u590d\u8bbe\u7f6e!", (String)"PermissionBatchDynamicPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{lockNumber.substring(0, lockNumber.length() - 1)}));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("confirm".equals(operateKey) & args.getOperationResult().isSuccess()) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long schemeId = (Long)formShowParameter.getCustomParam("schemeId");
            this.showPermissionSetting(String.valueOf(schemeId), true);
        }
    }

    private void showPermissionSetting(String executeschemeId, boolean isBatch) {
        HashMap returnDate = Maps.newHashMap();
        returnDate.put("executeschemeId", executeschemeId);
        returnDate.put("BATCH_SETTING", isBatch);
        returnDate.put("exeIdsNNames", this.getPageCache().get("currentSelectMap"));
        returnDate.put("schemeCardName", this.getPageCache().get("schemeCardName"));
        this.getView().returnDataToParent((Object)returnDate);
        this.getView().close();
    }

    private FlexPanelAp buildFormFlowAp(Map<Long, String> assessFormMap, Map<Long, String> perfWorkFlowMap, int i, String assessFormId, String flowId) {
        FlexPanelAp formFlowAp = this.buildFormFlowAp(i);
        FlexPanelAp formAp = this.buildFormAp(i, assessFormMap, assessFormId);
        formFlowAp.getItems().add(formAp);
        FlexPanelAp flowAp = this.buildFlowAp(perfWorkFlowMap, i, flowId);
        formFlowAp.getItems().add(flowAp);
        FlexPanelAp assessPlanNameAp = new HRFlexPanelAp.Builder("assessplannameap" + this.getView().getPageId() + i).setShrink(1).setGrow(1).setFontSize(12).setHeight("22px").setDirection("row").setWrap(true).build();
        formFlowAp.getItems().add(assessPlanNameAp);
        LabelAp planNameLabel = new HRLabelAp.Builder("plannamelabel" + i).build();
        planNameLabel.setKey("plannamelabel" + i);
        planNameLabel.setName(new LocaleString(ResManager.loadKDString((String)"\u8003\u6838\u6267\u884c\u8ba1\u5212\uff1a", (String)"PermissionBatchDynamicPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{i + 1})));
        planNameLabel.setHeight(new LocaleString("22px"));
        planNameLabel.setForeColor("#999999");
        assessPlanNameAp.getItems().add(planNameLabel);
        return formFlowAp;
    }

    private FlexPanelAp buildFlowAp(Map<Long, String> perfWorkFlowMap, int i, String flowId) {
        FlexPanelAp flowAp = new HRFlexPanelAp.Builder("flowap" + this.getView().getPageId() + i).setShrink(1).setGrow(1).setFontSize(12).setHeight("22px").setDirection("row").setJustifyContent("flex-start").setWrap(true).setOverflow("hidden").build();
        Style flowApStyle = new Style();
        Margin flowApMargin = new Margin();
        flowApMargin.setBottom("2px");
        flowApStyle.setMargin(flowApMargin);
        flowAp.setStyle(flowApStyle);
        LabelAp flowLabelAp = new HRLabelAp.Builder("flowlabelap" + i).build();
        flowLabelAp.setKey("flowlabelap" + i);
        flowLabelAp.setName(new LocaleString(ResManager.loadKDString((String)"\u7ee9\u6548\u6d41\u7a0b\uff1a", (String)"PermissionBatchDynamicPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{i + 1})));
        flowLabelAp.setHeight(new LocaleString("22px"));
        flowLabelAp.setForeColor("#999999");
        flowLabelAp.setWidth(new LocaleString("60px"));
        flowAp.getItems().add(flowLabelAp);
        LabelAp flowName = new HRLabelAp.Builder("flowname" + i).build();
        flowName.setKey("flowname" + i);
        flowName.setName(new LocaleString(perfWorkFlowMap.get(Long.parseLong(flowId))));
        flowName.setHeight(new LocaleString("22px"));
        flowName.setForeColor(" #666666");
        flowName.setWidth(new LocaleString("175px"));
        flowAp.getItems().add(flowName);
        return flowAp;
    }

    private FlexPanelAp buildFormAp(int i, Map<Long, String> assessFormMap, String assessFormId) {
        FlexPanelAp formAp = new HRFlexPanelAp.Builder("formap" + this.getView().getPageId() + i).setShrink(1).setGrow(1).setFontSize(12).setHeight("22px").setDirection("row").setJustifyContent("flex-start").setWrap(true).setOverflow("hidden").build();
        Style formApStyle = new Style();
        Margin formApMargin = new Margin();
        formApMargin.setBottom("2px");
        formApStyle.setMargin(formApMargin);
        formAp.setStyle(formApStyle);
        LabelAp assessFormLabelAp = new HRLabelAp.Builder("assessformlabelap" + i).build();
        assessFormLabelAp.setKey("assessformlabelap" + i);
        assessFormLabelAp.setName(new LocaleString(ResManager.loadKDString((String)"\u8bc4\u4f30\u8868\u5355\uff1a", (String)"PermissionBatchDynamicPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{i + 1})));
        assessFormLabelAp.setHeight(new LocaleString("22px"));
        assessFormLabelAp.setForeColor("#999999");
        assessFormLabelAp.setWidth(new LocaleString("60px"));
        formAp.getItems().add(assessFormLabelAp);
        LabelAp assessFormName = new HRLabelAp.Builder("assessformname" + i).build();
        assessFormName.setKey("assessformlabelap" + i);
        assessFormName.setName(new LocaleString(assessFormMap.get(Long.parseLong(assessFormId))));
        assessFormName.setHeight(new LocaleString("22px"));
        assessFormName.setForeColor(" #666666");
        assessFormName.setWidth(new LocaleString("175px"));
        formAp.getItems().add(assessFormName);
        return formAp;
    }

    private FlexPanelAp buildFormFlowAp(int i) {
        FlexPanelAp formFlowAp = new HRFlexPanelAp.Builder("formflowap" + this.getView().getPageId() + i).setShrink(0).setGrow(0).setHeight("70px").setOverflow("hidden").setWrap(true).setDirection("column").setJustifyContent("space-between").setAlignItems("flex-start").build();
        Style formFlowApStyle = new Style();
        Margin formFlowApMargin = new Margin();
        formFlowApMargin.setBottom("2px");
        formFlowApStyle.setMargin(formFlowApMargin);
        formFlowAp.setStyle(formFlowApStyle);
        return formFlowAp;
    }

    private FlexPanelAp buildSizePanelAp(int i) {
        FlexPanelAp sizePanelAp = new HRFlexPanelAp.Builder("sizepanelap" + this.getView().getPageId() + i).setShrink(0).setGrow(0).setFontSize(14).setForeColor("#212121").setHeight("24px").setDirection("row").setJustifyContent("flex-start").setAlignItems("flex-start").setOverflow("hidden").build();
        Style sizePanelApStyle = new Style();
        Margin sizePanelApMargin = new Margin();
        sizePanelApMargin.setTop("12px");
        sizePanelApMargin.setBottom("4px");
        sizePanelApStyle.setMargin(sizePanelApMargin);
        sizePanelAp.setStyle(sizePanelApStyle);
        LabelAp numlabelAp = new HRLabelAp.Builder("schemenumlabel" + i).build();
        numlabelAp.setKey("schemenumlabel" + i);
        numlabelAp.setName(new LocaleString(ResManager.loadKDString((String)"\u6279\u91cf\u8bbe\u7f6e\u65b9\u6848{0}", (String)"PermissionBatchDynamicPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{i + 1})));
        numlabelAp.setHeight(new LocaleString("24px"));
        numlabelAp.setFontWeight("bold");
        sizePanelAp.getItems().add(numlabelAp);
        return sizePanelAp;
    }

    private FlexPanelAp buildSchemeCardAp(int i) {
        FlexPanelAp schemeCardAp = new HRFlexPanelAp.Builder("schemecardap" + this.getView().getPageId() + i).setShrink(0).setGrow(0).setBackColor("#F3F5F8").setWidth("270px").setHeight("218px").setRadius("2").setDirection("column").setJustifyContent("flex-start").setAlignItems("stretch").setOverflow("hidden").setShadow(true).setClickable(true).build();
        schemeCardAp.setStyle(this.getSchemeCardStyle(schemeCardAp));
        return schemeCardAp;
    }

    private Style getSchemeCardStyle(FlexPanelAp schemeCardAp) {
        Style schemeCardApStyle = new Style();
        Margin schemeCardApMargin = new Margin();
        schemeCardApMargin.setLeft("5px");
        schemeCardApMargin.setRight("5px");
        schemeCardApMargin.setBottom("10px");
        schemeCardApStyle.setMargin(schemeCardApMargin);
        Border border = new Border();
        border.setLeft("1px");
        border.setRight("1px");
        schemeCardApStyle.setBorder(border);
        Padding padding = new Padding();
        padding.setLeft("16px");
        padding.setRight("16px");
        schemeCardApStyle.setPadding(padding);
        schemeCardAp.setStyle(schemeCardApStyle);
        return schemeCardApStyle;
    }

    private void showFlexPanelAp(String targetKey, List<Long> exeSchemeId, String schemeCardApKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_exechmecard");
        showParameter.setCustomParam("exeSchemeId", exeSchemeId);
        showParameter.setCustomParam("schemeCardApKey", (Object)schemeCardApKey);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        this.getView().showForm(showParameter);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String schemeCardSizeStr = this.getPageCache().get("schemeCardSize");
        if (HRStringUtils.isEmpty((String)schemeCardSizeStr)) {
            return;
        }
        int schemeCardSize = Integer.parseInt(schemeCardSizeStr);
        for (int i = 0; i < schemeCardSize; ++i) {
            String schemeCardApKey = "schemecardap" + this.getView().getPageId() + i;
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            if (source.getKey().equals(schemeCardApKey)) {
                this.getPageCache().put("currentSelectMap", this.getPageCache().get(schemeCardApKey));
                String schemeCardName = new LocaleString(ResManager.loadKDString((String)"\u6279\u91cf\u8bbe\u7f6e\u65b9\u6848{0}", (String)"PermissionBatchDynamicPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{i + 1})).getLocaleValue();
                this.getPageCache().put("schemeCardName", schemeCardName);
                HashMap style = new HashMap(16);
                HashMap<String, String> color = new HashMap<String, String>(16);
                color.put("t", "2px_solid_#5582F3");
                color.put("r", "2px_solid_#5582F3");
                color.put("b", "2px_solid_#5582F3");
                color.put("l", "2px_solid_#5582F3");
                style.put("b", color);
                map.put("s", style);
                map.put("bc", "#ebf0fe");
            } else {
                HashMap style = new HashMap(16);
                HashMap<String, String> color = new HashMap<String, String>(16);
                color.put("t", "2px_solid_#F3F5F8");
                color.put("r", "2px_solid_#F3F5F8");
                color.put("b", "2px_solid_#F3F5F8");
                color.put("l", "2px_solid_#F3F5F8");
                style.put("b", color);
                map.put("s", style);
                map.put("bc", "#F3F5F8");
            }
            this.getView().updateControlMetadata(schemeCardApKey, map);
        }
    }
}

