/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.scheme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessGroupApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssignManagerApplicationService;
import kd.opmc.epa.formplugin.web.utils.SchemeStatusValidateUtils;
import kd.opmc.epa.formplugin.web.utils.permission.AssessObjectPermissionUtils;

public class AssessObjectEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
AfterF7SelectListener,
ItemClickListener {
    private static final Log LOG = LogFactory.getLog(AssessObjectEdit.class);
    private static final AssessObjectApplicationService ASSESS_OBJECT = AssessObjectApplicationService.getInstance();
    private static final AssessGroupApplicationService ASSESS_GROUP = AssessGroupApplicationService.getInstance();
    private static final AssignManagerApplicationService ASSIGN_MANAGER_APPLICATION_SERVICE = AssignManagerApplicationService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ActivityEvaluationObjectApplicationService EVALUATION_OBJECT_APPLICATION_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final AssessObjectApplicationService ASSESS_OBJECT_APPLICATION_SERVICE = AssessObjectApplicationService.getInstance();
    private static final String PERF_FILE_F7 = "perffilef7";
    private static final String GROUP_F7 = "groupf7";
    private static final String ADD_ASSESS_OBJECT = "addassessobject";
    private static final String ASSESS_OBJECT_ENTRY_ENTITY = "assessobjectentryentity";
    private static final String ASSESSSCOPE = "assessscope";
    private static final String EMPENTRYENTITY = "empentryentity";
    private static final String ADDAOAP = "addaoap";
    private static final String DELETEAP = "deleteap";
    private static final String SET_GROUP = "setgroup";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit perfFileF7 = (BasedataEdit)this.getView().getControl(PERF_FILE_F7);
        BasedataEdit groupF7 = (BasedataEdit)this.getView().getControl(GROUP_F7);
        BasedataEdit group = (BasedataEdit)this.getView().getControl("group");
        groupF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        groupF7.addAfterF7SelectListener((AfterF7SelectListener)this);
        group.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        group.addAfterF7SelectListener((AfterF7SelectListener)this);
        perfFileF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        perfFileF7.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam("pageType");
        if ("notJoin".equals(pageType)) {
            this.showNotJoinPage();
        } else if ("processjoinedlist".equals(pageType)) {
            this.getModel().setValue("groupenable", (Object)"1");
        }
    }

    private void showNotJoinPage() {
        Object[] primaryKeyValues;
        IListView parentView = (IListView)this.getView().getParentView();
        ListSelectedRowCollection selectedRows = parentView.getSelectedRows();
        ArrayList<Long> perfFileIds = new ArrayList<Long>(10);
        for (Object primaryKeyValue : primaryKeyValues = selectedRows.getPrimaryKeyValues()) {
            if (!(primaryKeyValue instanceof Long)) continue;
            perfFileIds.add((Long)primaryKeyValue);
        }
        Long schemeId = this.getSchemeId();
        DynamicObject[] assessGroup = ASSESS_GROUP.queryObjectScopeListBySchemeId(schemeId);
        DynamicObject defaultAssessGroup = Arrays.stream(assessGroup).filter(group -> group.get("isdefault").equals(Boolean.TRUE)).findFirst().orElse(null);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        DynamicObject[] perfFileList = this.queryPerfFileListByIds(perfFileIds);
        TableValueSetter setter = new TableValueSetter(new String[0]);
        Map<Long, DynamicObject[]> perfFileMap = this.getPerfFileMapAndTableSetter(perfFileList, setter);
        for (DynamicObject perfFile : perfFileList) {
            long id = perfFile.getLong("id");
            if (HRObjectUtils.isEmpty((Object)defaultAssessGroup)) continue;
            setter.addRow(new Object[]{perfFile.getLong("id"), defaultAssessGroup.getLong("id"), defaultAssessGroup.getDynamicObject("objectscope").getLong("id"), perfFileMap.get(id)[0] != null ? Long.valueOf(perfFileMap.get(id)[0].getLong("id")) : null, perfFileMap.get(id)[1] != null ? Long.valueOf(perfFileMap.get(id)[1].getLong("id")) : null, perfFileMap.get(id)[2] != null ? Long.valueOf(perfFileMap.get(id)[2].getLong("id")) : null});
        }
        model.batchCreateNewEntryRow(ASSESS_OBJECT_ENTRY_ENTITY, setter);
        this.getView().setVisible(Boolean.FALSE, new String[]{ADDAOAP, DELETEAP});
        this.getView().updateView(ASSESS_OBJECT_ENTRY_ENTITY);
        model.endInit();
    }

    private Map<Long, DynamicObject[]> getPerfFileMapAndTableSetter(DynamicObject[] perfFileList, TableValueSetter setter) {
        setter.addField("perffile", new Object[0]);
        setter.addField("group", new Object[0]);
        setter.addField(ASSESSSCOPE, new Object[0]);
        setter.addField("person", new Object[0]);
        setter.addField("empposorgrel", new Object[0]);
        setter.addField("employee", new Object[0]);
        HashMap<Long, DynamicObject[]> perfFileMap = new HashMap<Long, DynamicObject[]>(16);
        for (DynamicObject dynamicObject : perfFileList) {
            DynamicObject[] perfFileMapInfo = new DynamicObject[3];
            perfFileMapInfo[0] = dynamicObject.getDynamicObject("person");
            DynamicObjectCollection empEntryEntity = dynamicObject.getDynamicObjectCollection(EMPENTRYENTITY);
            if (CollectionUtils.isNotEmpty((Collection)empEntryEntity)) {
                perfFileMapInfo[1] = ((DynamicObject)empEntryEntity.get(0)).getDynamicObject("empposorgrel");
            }
            perfFileMap.put(dynamicObject.getLong("id"), perfFileMapInfo);
            perfFileMapInfo[2] = dynamicObject.getDynamicObject("employee");
        }
        return perfFileMap;
    }

    private DynamicObject[] queryPerfFileListByIds(List<Long> ids) {
        return ASSESS_OBJECT.getPerffileListByIds(ids);
    }

    public void addItemClickListeners(String ... keys) {
        super.addItemClickListeners(keys);
        this.addClickListeners(new String[]{SET_GROUP, ADD_ASSESS_OBJECT});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        this.checkItemPermission(args);
        SchemeStatusValidateUtils.checkSchemeStatusValidate(args, this.getView());
        switch (source.getOperateKey()) {
            case "joinin": {
                this.checkAssessObjectForJoinIn(args);
                break;
            }
            case "addassessobject": {
                this.createPerfFileF7Select();
                break;
            }
            case "setgroup": {
                this.createGroupF7Select();
                break;
            }
        }
        this.getModel().setDataChanged(false);
    }

    private void checkAssessObjectForJoinIn(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection assessObject = this.getModel().getEntryEntity(ASSESS_OBJECT_ENTRY_ENTITY);
        if (CollectionUtils.isEmpty((Collection)assessObject)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u4fdd\u5b58\u7684\u6570\u636e\uff0c\u8bf7\u6dfb\u52a0\u6570\u636e", (String)"AssessObjectEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam("pageType");
        if (!"processjoinedlist".equals(pageType)) {
            boolean permission;
            boolean bl = permission = "notJoin".equals(pageType) ? AssessObjectPermissionUtils.checkJoinInPermissionNotMsg() : AssessObjectPermissionUtils.checkAddPermissionNotMsg();
            if (!permission) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"AssessObjectEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            List<Long> ids = assessObject.stream().map(obj -> (Long)obj.getDynamicObject("perffile.affiliateadminorg").getPkValue()).collect(Collectors.toList());
            if (!this.checkPermission(ids)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"AssessObjectEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        if ("joinin".equals(source.getOperateKey())) {
            this.savePerfFile2AssessObject();
        }
    }

    private void savePerfFile2AssessObject() {
        DynamicObjectCollection assessObject = this.getModel().getEntryEntity(ASSESS_OBJECT_ENTRY_ENTITY);
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam("pageType");
        if (!"processjoinedlist".equals(pageType)) {
            Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
            ASSESS_OBJECT.saveAssessObject(schemeId, assessObject, null);
        }
        IListView parentView = (IListView)this.getView().getParentView();
        parentView.invokeOperation("refresh");
        this.getView().sendFormAction((IFormView)parentView);
    }

    private void createGroupF7Select() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ASSESS_OBJECT_ENTRY_ENTITY);
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AssessObjectEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam("pageType");
        if (!"processjoinedlist".equals(pageType)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ASSESS_OBJECT_ENTRY_ENTITY);
            ArrayList<Long> ids = new ArrayList<Long>(10);
            for (int index : rows) {
                long orgId = ((DynamicObject)entryEntity.get(index)).getLong("perffile.affiliateadminorg.id");
                ids.add(orgId);
            }
            if (!this.checkPermission(ids)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"AssessObjectEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        BasedataEdit assessRule = (BasedataEdit)this.getView().getControl(GROUP_F7);
        assessRule.click();
    }

    private void createPerfFileF7Select() {
        BasedataEdit assessRule = (BasedataEdit)this.getView().getControl(PERF_FILE_F7);
        assessRule.click();
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        DynamicObject group;
        String fieldKey = ((Control)evt.getSource()).getKey();
        if (PERF_FILE_F7.equals(fieldKey)) {
            this.addAssessObjects();
        }
        if (GROUP_F7.equals(fieldKey)) {
            this.changeAssessGroup();
        }
        if ("group".equals(fieldKey) && (group = (DynamicObject)this.getModel().getValue("group")) != null) {
            this.getModel().setValue(ASSESSSCOPE, (Object)group.getDynamicObject("objectscope").getLong("id"), this.getModel().getEntryCurrentRowIndex(ASSESS_OBJECT_ENTRY_ENTITY));
            this.getView().updateView(ASSESS_OBJECT_ENTRY_ENTITY);
        }
    }

    private void changeAssessGroup() {
        List<Long> groupIds;
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject(GROUP_F7);
        long groupId = dynamicObject.getLong("id");
        String pageId = this.getView().getParentView().getPageCache().get("epa_schememanagement");
        if (StringUtils.isNotBlank((CharSequence)pageId) && pageId.contains("epa_schememanagement") && !ObjectUtils.isEmpty(groupIds = this.getGroupIds()) && !groupIds.contains(groupId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"AssessObjectEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ASSESS_OBJECT_ENTRY_ENTITY);
        int[] rows = entryGrid.getSelectRows();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        for (int i = 0; i < rows.length; ++i) {
            this.getModel().setValue("group", (Object)groupId, rows[i]);
            this.getModel().setValue(ASSESSSCOPE, (Object)dynamicObject.getDynamicObject("objectscope").getLong("id"), rows[i]);
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"group"});
        }
        model.endInit();
        this.getView().updateView(ASSESS_OBJECT_ENTRY_ENTITY);
    }

    private void addAssessObjects() {
        DynamicObjectCollection perfFileF7Selected = this.getModel().getDataEntity().getDynamicObjectCollection(PERF_FILE_F7);
        Set entryIds = this.getModel().getEntryEntity(ASSESS_OBJECT_ENTRY_ENTITY).stream().map(assessObject -> assessObject.getDynamicObject("perffile").getLong("id")).collect(Collectors.toSet());
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam("pageType");
        DynamicObject defaultAssessGroup = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryDefaultGroup(this.getSchemeId());
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        DynamicObject[] perfFileList = this.queryPerfFileListByIds(new ArrayList<Long>(10));
        Map<Long, DynamicObject[]> perfFileMap = this.getPerfFileMapAndTableSetter(perfFileList, setter);
        for (DynamicObject perfFile : perfFileF7Selected) {
            long id = perfFile.getDynamicObject("fbasedataid").getLong("id");
            if (entryIds.contains(id) || HRObjectUtils.isEmpty((Object)defaultAssessGroup) && !"processjoinedlist".equals(pageType)) continue;
            setter.addRow(new Object[]{perfFile.getDynamicObject("fbasedataid").getLong("id"), HRObjectUtils.isEmpty((Object)defaultAssessGroup) ? null : Long.valueOf(defaultAssessGroup.getLong("id")), HRObjectUtils.isEmpty((Object)defaultAssessGroup) ? null : Long.valueOf(defaultAssessGroup.getLong("objectscope.id")), perfFileMap.get(id)[0] != null ? Long.valueOf(perfFileMap.get(id)[0].getLong("id")) : null, perfFileMap.get(id)[1] != null ? Long.valueOf(perfFileMap.get(id)[1].getLong("id")) : null, perfFileMap.get(id)[2] != null ? Long.valueOf(perfFileMap.get(id)[2].getLong("id")) : null});
        }
        model.batchCreateNewEntryRow(ASSESS_OBJECT_ENTRY_ENTITY, setter);
        model.endInit();
        this.getView().updateView(ASSESS_OBJECT_ENTRY_ENTITY);
        this.getModel().setValue(PERF_FILE_F7, null);
    }

    private Long getSchemeId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return (Long)formShowParameter.getCustomParam("schemeId");
    }

    private DynamicObject getManagerData() {
        Long schemeId = this.getSchemeId();
        long sysUserId = RequestContext.get().getCurrUserId();
        return ASSIGN_MANAGER_APPLICATION_SERVICE.queryBySchmeIdAndUserId(schemeId, sysUserId);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        if (HRStringUtils.isNotEmpty((String)fieldKey)) {
            Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            String pageType = (String)this.getView().getFormShowParameter().getCustomParam("pageType");
            if (PERF_FILE_F7.equals(fieldKey)) {
                List joinInPerfFileIds;
                DynamicObject[] allJoinInList;
                if ("processjoinedlist".equals(pageType)) {
                    allJoinInList = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryEvaObjByActivityId(activityId);
                    joinInPerfFileIds = Arrays.stream(allJoinInList).map(perfFile -> perfFile.getDynamicObject("perffile").getLong("id")).collect(Collectors.toList());
                } else {
                    allJoinInList = ASSESS_OBJECT.queryPerffileBySchemeId(schemeId);
                    joinInPerfFileIds = Arrays.stream(allJoinInList).map(perfFile -> perfFile.getDynamicObject("perfile").getLong("id")).collect(Collectors.toList());
                }
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                DynamicObjectCollection filteredEmptyObject = this.getModel().getEntryEntity(ASSESS_OBJECT_ENTRY_ENTITY).stream().filter(org -> !HRObjectUtils.isEmpty((Object)org.getDynamicObject("perffile"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
                List emptyIds = filteredEmptyObject.stream().map(org -> org.getDynamicObject("perffile").getLong("id")).collect(Collectors.toList());
                joinInPerfFileIds.addAll(emptyIds);
                if (CollectionUtils.isNotEmpty(joinInPerfFileIds)) {
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", joinInPerfFileIds));
                }
            } else if (GROUP_F7.equals(fieldKey) || "group".equals(fieldKey)) {
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                if ("processjoinedlist".equals(pageType)) {
                    DynamicObject activity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
                    DynamicObjectCollection col = activity.getDynamicObjectCollection("assgroupentry");
                    List groupIds = col.stream().map(dy -> dy.getLong("assgroup.id")).collect(Collectors.toList());
                    QFilter filter = new QFilter("id", "in", groupIds);
                    showParameter.getListFilterParameter().getQFilters().add(filter);
                } else {
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("scheme", "=", (Object)schemeId));
                    this.setFilterParameter(showParameter);
                }
            }
        }
    }

    private void setFilterParameter(ListShowParameter showParameter) {
        List<Long> groupIds;
        String pageId = this.getView().getParentView().getPageCache().get("epa_schememanagement");
        if (StringUtils.isNotBlank((CharSequence)pageId) && pageId.contains("epa_schememanagement") && !ObjectUtils.isEmpty(groupIds = this.getGroupIds())) {
            QFilter filter = new QFilter("id", "in", groupIds);
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    private List<Long> getGroupIds() {
        boolean groupCheck;
        List<Long> groupIds = new ArrayList<Long>(10);
        DynamicObject manager = this.getManagerData();
        if (!ObjectUtils.isEmpty((Object)manager) && !(groupCheck = manager.getBoolean("isgroupcheck"))) {
            DynamicObjectCollection groups = manager.getDynamicObjectCollection("assessgroup");
            groupIds = groups.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
        }
        return groupIds;
    }

    private boolean checkPermission(List<Long> ids) {
        boolean orgCheck;
        DynamicObject manager;
        String pageId = this.getView().getParentView().getPageCache().get("epa_schememanagement");
        if (StringUtils.isNotBlank((CharSequence)pageId) && pageId.contains("epa_schememanagement") && !ObjectUtils.isEmpty((Object)(manager = this.getManagerData())) && !(orgCheck = manager.getBoolean("isorgcheck"))) {
            DynamicObjectCollection orgColl = manager.getDynamicObjectCollection("org");
            List orgIds = orgColl.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
            return orgIds.containsAll(ids);
        }
        return true;
    }

    private void checkItemPermission(BeforeDoOperationEventArgs args) {
        String manageItems;
        DynamicObject manager;
        String pageId = this.getView().getParentView().getPageCache().get("epa_schememanagement");
        if (StringUtils.isNotBlank((CharSequence)pageId) && pageId.contains("epa_schememanagement") && !ObjectUtils.isEmpty((Object)(manager = this.getManagerData())) && !(manageItems = manager.getString("manageitems")).contains("1")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"AssessObjectEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }
}

