/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.scheme;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.scheme.AssessObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssignManagerApplicationService;

public class AssessObjectHomePlugin
extends HRDataBaseEdit
implements AfterF7SelectListener,
TabSelectListener {
    private static final Log LOG = LogFactory.getLog(AssessObjectHomePlugin.class);
    private static final AssessObjectApplicationService ASSESS_OBJECT = AssessObjectApplicationService.getInstance();
    private static final AssignManagerApplicationService ASSIGN_MANAGER_APPLICATION_SERVICE = AssignManagerApplicationService.getInstance();
    private static final String JOIN_TAB = "jointab";
    private static final String NOT_JOIN_TAB = "notjointab";
    private static final String GROUP_F7 = "groupf7";
    private static final String JOIN_PAGE_ID = "joinPageId";
    private static final String NOT_JOIN_PAGE_ID = "notJoinPageId";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit groupF7 = (BasedataEdit)this.getView().getControl(GROUP_F7);
        groupF7.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit resPersonF7 = (BasedataEdit)this.getView().getControl("respersonf7");
        resPersonF7.addAfterF7SelectListener((AfterF7SelectListener)this);
        Tab tab = (Tab)this.getView().getControl("datatabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.loadListView();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        if (HRStringUtils.equals((String)"refreshobjnum", (String)args.getOperateKey())) {
            String sourceView;
            switch (sourceView = source.getOption().getVariableValue("refreshView", "false")) {
                case "epa_assessobject_perffile": {
                    this.showJoinView();
                    break;
                }
                case "epa_assessobject": {
                    this.showNotJoinView();
                    break;
                }
            }
        }
    }

    private void loadListView() {
        this.showNotJoinView();
        this.showJoinView();
    }

    private void showJoinView() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId("epa_assessobject");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long schemeId = (Long)formShowParameter.getCustomParam("schemeId");
        showParameter.setCustomParam("schemeId", (Object)schemeId);
        this.getPageCache().put(JOIN_PAGE_ID, showParameter.getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("joinpage");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showNotJoinView() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId("epa_assessobject_perffile");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long schemeId = (Long)formShowParameter.getCustomParam("schemeId");
        showParameter.setCustomParam("schemeId", (Object)schemeId);
        this.getPageCache().put(NOT_JOIN_PAGE_ID, showParameter.getPageId());
        showParameter.getOpenStyle().setTargetKey("notjoinpage");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        String fieldKey = ((Control)evt.getSource()).getKey();
        if (GROUP_F7.equals(fieldKey)) {
            DynamicObject group = this.getModel().getDataEntity().getDynamicObject(GROUP_F7);
            String childPageId = this.getPageCache().get(JOIN_PAGE_ID);
            IListView childView = (IListView)this.getView().getView(childPageId);
            ListSelectedRowCollection selectedRows = childView.getSelectedRows();
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            DynamicObject[] assessObjectData = ASSESS_OBJECT.loadDynamicObjectArrayByIds(primaryKeyValues);
            if (!this.checkPermission(assessObjectData, group)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"AssessObjectHomePlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return;
            }
            for (DynamicObject assessObjectDatum : assessObjectData) {
                assessObjectDatum.set("assgroup", (Object)group.getLong("id"));
            }
            ASSESS_OBJECT.save(assessObjectData);
            childView.refresh();
            childView.showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u8003\u6838\u7ec4\u6210\u529f", (String)"AssessObjectHomePlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("systeminvoke", "true");
            childView.invokeOperation("changegroup", operateOption);
            this.getView().sendFormAction((IFormView)childView);
        } else if (HRStringUtils.equals((String)"respersonf7", (String)fieldKey)) {
            DynamicObject[] assessObjects;
            String childPageId = this.getPageCache().get(JOIN_PAGE_ID);
            IListView childView = (IListView)this.getView().getView(childPageId);
            ListSelectedRowCollection selectedRows = childView.getSelectedRows();
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            ArrayList<Long> idList = new ArrayList<Long>(10);
            for (Object primaryKeyValue : primaryKeyValues) {
                idList.add((Long)primaryKeyValue);
            }
            DynamicObjectCollection personF7 = (DynamicObjectCollection)this.getModel().getValue("respersonf7");
            for (DynamicObject assessObject : assessObjects = ASSESS_OBJECT.queryListByIds(idList)) {
                DynamicObjectCollection personColl = this.getResPersonColl(personF7, assessObject);
                assessObject.set("resperson", (Object)personColl);
            }
            ASSESS_OBJECT.save(assessObjects);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u8003\u6838\u8d23\u4efb\u4eba\u6210\u529f", (String)"AssessObjectHomePlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            childView.invokeOperation("confirm");
            childView.invokeOperation("refresh");
            this.getView().sendFormAction((IFormView)childView);
        }
    }

    private DynamicObjectCollection getResPersonColl(DynamicObjectCollection personF7, DynamicObject assessObject) {
        DynamicObjectCollection personColl = assessObject.getDynamicObjectCollection("resperson");
        personColl.clear();
        for (DynamicObject person : personF7) {
            DynamicObject newCurrency = new DynamicObject(personColl.getDynamicObjectType());
            newCurrency.set("fbasedataid", person.get("fbasedataid"));
            personColl.add((Object)newCurrency);
        }
        return personColl;
    }

    public void tabSelected(TabSelectEvent evt) {
        IListView page;
        String joinPageId;
        String itemKey = evt.getTabKey();
        if (JOIN_TAB.equals(itemKey)) {
            IListView page2;
            String joinPageId2 = this.getPageCache().get(JOIN_PAGE_ID);
            if (HRStringUtils.isNotEmpty((String)joinPageId2) && !HRObjectUtils.isEmpty((Object)(page2 = (IListView)this.getView().getView(joinPageId2)))) {
                page2.refresh();
                this.getView().sendFormAction((IFormView)page2);
            }
        } else if (NOT_JOIN_TAB.equals(itemKey) && HRStringUtils.isNotEmpty((String)(joinPageId = this.getPageCache().get(NOT_JOIN_PAGE_ID))) && !HRObjectUtils.isEmpty((Object)(page = (IListView)this.getView().getView(joinPageId)))) {
            page.refresh();
            this.getView().sendFormAction((IFormView)page);
        }
    }

    private boolean checkPermission(DynamicObject[] dys, DynamicObject group) {
        String pageId;
        IFormView parentView = this.getView().getParentView();
        String string = pageId = parentView != null ? this.getView().getParentView().getPageId() : "";
        if (pageId.contains("epa_schememanagement")) {
            ArrayList<Long> chooseOrgIds = new ArrayList<Long>(10);
            ArrayList<Long> chooseGroupIds = new ArrayList<Long>(10);
            for (DynamicObject dy : dys) {
                chooseOrgIds.add(dy.getLong("perfile.affiliateadminorg.id"));
                chooseGroupIds.add(dy.getLong("assgroup.id"));
            }
            chooseGroupIds.add((Long)group.getPkValue());
            Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
            long sysUserId = RequestContext.get().getCurrUserId();
            DynamicObject manager = ASSIGN_MANAGER_APPLICATION_SERVICE.queryBySchmeIdAndUserId(schemeId, sysUserId);
            if (!ObjectUtils.isEmpty((Object)manager)) {
                boolean groupCheck;
                boolean orgPermiss = true;
                boolean groupPermiss = true;
                boolean orgCheck = manager.getBoolean("isorgcheck");
                if (!orgCheck) {
                    DynamicObjectCollection orgs = manager.getDynamicObjectCollection("org");
                    List orgIds = orgs.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
                    orgPermiss = orgIds.containsAll(chooseOrgIds);
                }
                if (!(groupCheck = manager.getBoolean("isgroupcheck"))) {
                    DynamicObjectCollection groups = manager.getDynamicObjectCollection("assessgroup");
                    List groupIds = groups.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
                    groupPermiss = groupIds.containsAll(chooseGroupIds);
                }
                return orgPermiss && groupPermiss;
            }
        }
        return true;
    }
}

