/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.scheme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.opmc.epa.business.application.service.scheme.AssessGroupApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssignManagerApplicationService;
import kd.opmc.epa.business.application.service.scheme.ObjectScopeApplicationService;
import kd.opmc.epa.formplugin.web.utils.BosListUtil;
import kd.opmc.epa.formplugin.web.utils.SchemeStatusValidateUtils;
import kd.opmc.pbs.business.external.hrcs.IHRCSTipService;

public class AssessObjectJoinInList
extends HRDataBaseList {
    private static final AssessObjectApplicationService ASSESS_OBJECT = AssessObjectApplicationService.getInstance();
    private static final AssignManagerApplicationService ASSIGN_MANAGER_APPLICATION_SERVICE = AssignManagerApplicationService.getInstance();
    private static final AssessGroupApplicationService ASSESS_GROUP_APPLICATION_SERVICE = AssessGroupApplicationService.getInstance();
    private static final ObjectScopeApplicationService OBJECT_SCOPE = ObjectScopeApplicationService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final IHRCSTipService IHRCS_TIP_SERVICE = IHRCSTipService.getInstance();
    private static final String CHANGE_GROUP = "changegroup";
    private static final String MODIFY_CYCLE = "modifycycle";
    private static final String REMOVE_RES_PERSON = "removeresperson";
    private static final String OBJECTSCOPE_NAME = "assgroup.objectscope.name";
    private static final String OBJECTSCOPE_ID = "assgroup.objectscope.id";

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List qFilters = args.getQfilters();
        Object schemeId = this.getView().getParentView().getFormShowParameter().getCustomParams().get("schemeId");
        if ("assgroup.name".equals(fieldName) || "assgroup.id".equals(fieldName)) {
            DynamicObject[] groups = ASSESS_GROUP_APPLICATION_SERVICE.queryListBySchemeId((Long)schemeId);
            List ids = Arrays.stream(groups).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            qFilters.add(new QFilter("id", "in", ids));
        } else if (OBJECTSCOPE_NAME.equals(fieldName) || OBJECTSCOPE_ID.equals(fieldName)) {
            DynamicObject[] assObjs = OBJECT_SCOPE.queryListBySchemeId((Long)schemeId);
            List ids = Arrays.stream(assObjs).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            qFilters.add(new QFilter("id", "in", ids));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List<ComboItem> groupCombos = this.buildGroupComboItems();
        List<ComboItem> assObjCombos = this.buildAssessObjectComboItems();
        List schemeFilterCols = args.getSchemeFilterColumns().stream().map(filterFilterCol -> (SchemeFilterColumn)filterFilterCol).collect(Collectors.toList());
        for (SchemeFilterColumn schemeFilterColumn : schemeFilterCols) {
            String fieldName = schemeFilterColumn.getFieldName();
            if (HRStringUtils.equals((String)fieldName, (String)"assgroup.name")) {
                schemeFilterColumn.setComboItems(groupCombos);
                continue;
            }
            if (!HRStringUtils.equals((String)fieldName, (String)OBJECTSCOPE_NAME)) continue;
            schemeFilterColumn.setComboItems(assObjCombos);
        }
        List commonFilterCols = args.getCommonFilterColumns().stream().map(commonFilterCol -> (CommonFilterColumn)commonFilterCol).collect(Collectors.toList());
        for (CommonFilterColumn commonFilterColumn : commonFilterCols) {
            String fieldName = commonFilterColumn.getFieldName();
            if (HRStringUtils.equals((String)fieldName, (String)"assgroup.name")) {
                commonFilterColumn.setComboItems(groupCombos);
                continue;
            }
            if (!HRStringUtils.equals((String)fieldName, (String)OBJECTSCOPE_NAME)) continue;
            commonFilterColumn.setComboItems(assObjCombos);
        }
    }

    private List<ComboItem> buildAssessObjectComboItems() {
        DynamicObject[] assObjs;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        Object schemeId = this.getView().getParentView().getFormShowParameter().getCustomParams().get("schemeId");
        for (DynamicObject assObj : assObjs = OBJECT_SCOPE.queryListBySchemeId((Long)schemeId)) {
            if (assObj == null) continue;
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(assObj.getPkValue()));
            item.setCaption(new LocaleString(assObj.getString("name")));
            item.setValue(String.valueOf(assObj.getPkValue()));
            combos.add(item);
        }
        return combos;
    }

    private List<ComboItem> buildGroupComboItems() {
        DynamicObject[] groups;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        Object schemeId = this.getView().getParentView().getFormShowParameter().getCustomParams().get("schemeId");
        for (DynamicObject group : groups = ASSESS_GROUP_APPLICATION_SERVICE.queryListBySchemeId((Long)schemeId)) {
            if (group == null) continue;
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(group.getPkValue()));
            item.setCaption(new LocaleString(group.getString("name")));
            item.setValue(String.valueOf(group.getPkValue()));
            combos.add(item);
        }
        return combos;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObject[] assessObjectData;
        super.closedCallBack(closedCallBackEvent);
        Map childMap = (Map)closedCallBackEvent.getReturnData();
        if (HRObjectUtils.isEmpty((Object)childMap)) {
            return;
        }
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        for (DynamicObject assessObjectDatum : assessObjectData = ASSESS_OBJECT.loadDynamicObjectArrayByIds(primaryKeyValues)) {
            assessObjectDatum.set("startcycle", childMap.get("startTime"));
            assessObjectDatum.set("endcycle", childMap.get("endTime"));
        }
        ASSESS_OBJECT.save(assessObjectData);
        IListView listView = (IListView)this.getView();
        listView.showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u53c2\u4e0e\u8003\u6838\u5468\u671f\u6210\u529f", (String)"AssessObjectJoinInList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        listView.refresh();
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        List<String> fixedColumnList = Arrays.asList("fseq", "person.headsculpture", "person.name");
        List listColumn = billList.getListFieldsControlColumns();
        ArrayList<Map> listFixedColumn = new ArrayList<Map>(10);
        for (Map map : listColumn) {
            String fieldKey = (String)map.get("listFieldKey");
            if (fixedColumnList.contains(fieldKey)) {
                map.replace("fixed", Boolean.TRUE);
            }
            listFixedColumn.add(map);
        }
        billList.setListFieldsControlColumns(listFixedColumn);
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        List qFilters = evt.getQFilters();
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        QFilter qFilter = new QFilter("scheme", "=", (Object)schemeId);
        qFilters.add(qFilter);
        this.setDataFilter(qFilters);
        ArrayList<Object> dataFilters = evt.getDataPermQFilters() == null ? new ArrayList<QFilter>(10) : new ArrayList(evt.getDataPermQFilters());
        if (!ObjectUtils.isEmpty((Object)evt.getMainOrgQFilter())) {
            dataFilters.add(evt.getMainOrgQFilter());
        }
        dataFilters.add(qFilter);
        this.setDataFilter(dataFilters);
        int joinNum = ASSESS_OBJECT.countJoinObj(dataFilters);
        if (this.getView().getParentView() == null) {
            return;
        }
        Label joinNumLab = (Label)this.getView().getParentView().getControl("joinnumlab");
        joinNumLab.setText(String.valueOf(joinNum));
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void setDataFilter(List<QFilter> qFilters) {
        String pageId = this.getParentPageId();
        if (StringUtils.isNotBlank((CharSequence)pageId) && pageId.contains("epa_schememanagement")) {
            this.getView().getPageCache().put("epa_schememanagement", "epa_schememanagement");
            this.getView().setVisible(Boolean.FALSE, new String[]{"addap"});
            DynamicObject manager = this.getManagerData();
            if (!ObjectUtils.isEmpty((Object)manager)) {
                boolean groupCheck;
                boolean orgCheck = manager.getBoolean("isorgcheck");
                if (!orgCheck) {
                    DynamicObjectCollection orgs = manager.getDynamicObjectCollection("org");
                    List orgIds = orgs.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
                    QFilter filter = new QFilter("perfile.affiliateadminorg", "in", orgIds);
                    qFilters.add(filter);
                }
                if (!(groupCheck = manager.getBoolean("isgroupcheck"))) {
                    DynamicObjectCollection groups = manager.getDynamicObjectCollection("assessgroup");
                    List groupIds = groups.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
                    QFilter filter = new QFilter("assgroup", "in", groupIds);
                    qFilters.add(filter);
                }
            }
        }
    }

    private String getParentPageId() {
        if (this.getView() != null && this.getView().getParentView() != null && this.getView().getParentView().getParentView() != null) {
            return this.getView().getParentView().getParentView().getPageId();
        }
        return "";
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        boolean returnOpKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operationKey = afterDoOperationEventArgs.getOperateKey();
        boolean notSelected = CollectionUtils.isEmpty((Collection)this.getSelectedRows());
        boolean bl = returnOpKey = CHANGE_GROUP.equals(operationKey) || MODIFY_CYCLE.equals(operationKey);
        if (notSelected && returnOpKey) {
            return;
        }
        switch (operationKey) {
            case "add": {
                this.showJoinInPage();
                break;
            }
            case "modifycycle": {
                this.modifyCycle();
                break;
            }
            case "setresperson": {
                IFormView parentView = this.getView().getParentView();
                BasedataEdit resPersonF7 = (BasedataEdit)parentView.getControl("respersonf7");
                parentView.getModel().setValue("respersonf7", null);
                resPersonF7.click();
                this.getView().sendFormAction(parentView);
                break;
            }
            case "removeresperson": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "delete": {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("refreshView", ((IListView)this.getView()).getBillFormId());
                this.getView().getParentView().invokeOperation("refreshobjnum", operateOption);
                this.getView().sendFormAction(this.getView().getParentView());
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (!this.checkItemPermission()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"AssessObjectJoinInList_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        SchemeStatusValidateUtils.checkSchemeStatusValidate(args, this.getView());
        switch (operateKey) {
            case "changegroup": 
            case "modifycycle": 
            case "delete": 
            case "setresperson": {
                boolean result = this.checkPermission();
                if (result) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"AssessObjectJoinInList_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
        switch (operateKey) {
            case "changegroup": {
                String schStatus;
                String systemInvoke = op.getOption().getVariableValue("systeminvoke", "false");
                if (HRStringUtils.equals((String)systemInvoke, (String)"true")) break;
                Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
                DynamicObject schemeDyn = ASSESS_SCHEME_APPLICATION_SERVICE.queryOneById(schemeId);
                if (schemeDyn != null && (schStatus = schemeDyn.getString("schstatus")).equals("20")) {
                    return;
                }
                this.changeGroup();
                args.setCancel(true);
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        boolean result;
        super.beforeItemClick(evt);
        if (!this.checkItemPermission()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"AssessObjectJoinInList_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
        if ("delete".equals(evt.getOperationKey()) && !(result = this.checkPermission())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"AssessObjectJoinInList_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private boolean checkPermission() {
        String pageId = this.getParentPageId();
        if (StringUtils.isNotBlank((CharSequence)pageId) && pageId.contains("epa_schememanagement")) {
            ListSelectedRowCollection col = this.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)col)) {
                return false;
            }
            List ids = col.stream().map(obj -> (Long)obj.getPrimaryKeyValue()).collect(Collectors.toList());
            DynamicObject[] dys = ASSESS_OBJECT.queryListByIds(ids);
            ArrayList<Long> chooseOrgIds = new ArrayList<Long>(10);
            ArrayList<Long> chooseGroupIds = new ArrayList<Long>(10);
            for (DynamicObject dy : dys) {
                chooseOrgIds.add(dy.getLong("perfile.affiliateadminorg.id"));
                chooseGroupIds.add(dy.getLong("assgroup.id"));
            }
            DynamicObject manager = this.getManagerData();
            if (!ObjectUtils.isEmpty((Object)manager)) {
                boolean groupCheck;
                boolean orgPermiss = true;
                boolean groupPermiss = true;
                boolean orgCheck = manager.getBoolean("isorgcheck");
                if (!orgCheck) {
                    DynamicObjectCollection orgs = manager.getDynamicObjectCollection("org");
                    List orgIds = orgs.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
                    orgPermiss = orgIds.containsAll(chooseOrgIds);
                }
                if (!(groupCheck = manager.getBoolean("isgroupcheck"))) {
                    DynamicObjectCollection groups = manager.getDynamicObjectCollection("assessgroup");
                    List groupIds = groups.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
                    groupPermiss = groupIds.containsAll(chooseGroupIds);
                }
                return orgPermiss && groupPermiss;
            }
        }
        return true;
    }

    private void modifyCycle() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List ids = selectedRows.stream().map(obj -> (Long)obj.getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObject[] dys = ASSESS_OBJECT.queryListByIds(ids);
        ArrayList<Long> chooseOrgIds = new ArrayList<Long>(10);
        ArrayList<Long> chooseGroupIds = new ArrayList<Long>(10);
        for (DynamicObject dy : dys) {
            chooseOrgIds.add(dy.getLong("perfile.affiliateadminorg.id"));
            chooseGroupIds.add(dy.getLong("assgroup.id"));
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_assessobject_modify");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        showParameter.setCustomParam("schemeId", (Object)schemeId);
        showParameter.setCustomParam("orgIds", chooseOrgIds);
        showParameter.setCustomParam("groupIds", chooseGroupIds);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_assessobject_modify"));
        this.getView().showForm(showParameter);
    }

    private void changeGroup() {
        IFormView parentView = this.getView().getParentView();
        BasedataEdit control = (BasedataEdit)parentView.getControl("groupf7");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long schemeId = (Long)formShowParameter.getCustomParam("schemeId");
        ArrayList<QFilter> list = new ArrayList<QFilter>(10);
        list.add(new QFilter("scheme", "=", (Object)schemeId));
        List<Long> groupIds = this.getGroupIds();
        if (!ObjectUtils.isEmpty(groupIds)) {
            list.add(new QFilter("id", "in", groupIds));
        }
        control.setQFilters(list);
        control.click();
        this.getView().sendFormAction(parentView);
    }

    private List<Long> getGroupIds() {
        boolean groupCheck;
        DynamicObject manager;
        String pageId = this.getParentPageId();
        if (StringUtils.isNotBlank((CharSequence)pageId) && pageId.contains("epa_schememanagement") && !ObjectUtils.isEmpty((Object)(manager = this.getManagerData())) && !(groupCheck = manager.getBoolean("isgroupcheck"))) {
            DynamicObjectCollection groups = manager.getDynamicObjectCollection("assessgroup");
            List<Long> groupIds = groups.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
            return groupIds;
        }
        return null;
    }

    private void showJoinInPage() {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("epa_assessobject_joinin");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        showParameter.setCustomParam("schemeId", (Object)schemeId);
        showParameter.setCustomParam("pageType", (Object)"joinIn");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_assessobject_joinin"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BosListUtil.setGripMargin(this.getView());
    }

    private boolean checkItemPermission() {
        DynamicObject manager;
        String pageId = this.getParentPageId();
        if (StringUtils.isNotBlank((CharSequence)pageId) && pageId.contains("epa_schememanagement") && !ObjectUtils.isEmpty((Object)(manager = this.getManagerData()))) {
            String manageitems = manager.getString("manageitems");
            return manageitems.contains("1");
        }
        return true;
    }

    private DynamicObject getManagerData() {
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        long sysUserId = RequestContext.get().getCurrUserId();
        return ASSIGN_MANAGER_APPLICATION_SERVICE.queryBySchmeIdAndUserId(schemeId, sysUserId);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initTips();
    }

    private void initTips() {
        String tipsStr = "";
        DynamicObject dy = this.getModel().getDataEntity();
        List tipsStrList = IHRCS_TIP_SERVICE.getTips("epa_assessobject", "resperson", dy);
        if (!ObjectUtils.isEmpty((Object)tipsStrList)) {
            tipsStr = (String)tipsStrList.get(0);
        }
        HashMap<String, Tips> props = new HashMap<String, Tips>(16);
        Tips tips = new Tips();
        tips.setType("text");
        tips.setContent(new LocaleString(tipsStr));
        props.put("tips", tips);
        this.getView().updateControlMetadata("baritemap1", props);
    }
}

