/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.scheme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssignManagerApplicationService;
import kd.opmc.epa.business.domain.scheme.enums.AssessObjectEnums;
import kd.opmc.epa.formplugin.web.utils.TimeTagUtil;
import kd.opmc.epa.formplugin.web.utils.permission.AssessObjectPermissionUtils;
import kd.opmc.pbs.common.utils.OpmcDateUtils;

public class AssessObjectModifyCyclePlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(AssessObjectModifyCyclePlugin.class);
    private static final AssessSchemeApplicationService ASSESS_SCHEME = AssessSchemeApplicationService.getInstance();
    private static final AssignManagerApplicationService ASSIGN_MANAGER_APPLICATION_SERVICE = AssignManagerApplicationService.getInstance();
    private static final String CONFIRM = "confirm";
    private static final String PARTTYPE = "parttype";
    private static final String TIMETAG = "timetag";
    private static final String STARTTIME = "starttime";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit control = (BasedataEdit)this.getView().getControl(TIMETAG);
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{CONFIRM});
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        super.propertyChanged(changedArgs);
        String fieldKey = changedArgs.getProperty().getName();
        if (PARTTYPE.equals(fieldKey)) {
            this.setDefaultValue(this.getCurScheme());
        } else if (STARTTIME.equals(fieldKey)) {
            this.getModel().setValue(TIMETAG, null);
        }
    }

    private void setDefaultValue(DynamicObject scheme) {
        String partType = this.getModel().getDataEntity().getString(PARTTYPE);
        if (AssessObjectEnums.PARTAKE_START_TIME.getValue().equals(partType)) {
            this.setDefaultYear(scheme, "startyear");
        }
        if (AssessObjectEnums.PARTAKE_END_TIME.getValue().equals(partType)) {
            this.setDefaultYear(scheme, "endyear");
        }
    }

    private void setDefaultYear(DynamicObject scheme, String startOrEnd) {
        try {
            int curYear;
            int startYear = OpmcDateUtils.getYear((Date)scheme.getDate("startyear"));
            int endYear = 2199;
            if (scheme.getDate("endyear") != null) {
                endYear = OpmcDateUtils.getYear((Date)scheme.getDate("endyear"));
            }
            if ((curYear = OpmcDateUtils.getYear((Date)new Date())) >= startYear && curYear <= endYear) {
                this.getModel().setValue(STARTTIME, (Object)HRDateTimeUtils.parseDate((String)HRDateTimeUtils.formatDate((Date)new Date()), (String)"yyyy"));
            } else {
                this.getModel().setValue(STARTTIME, (Object)scheme.getDate(startOrEnd));
            }
            this.setYearMaxAndMin(scheme);
        }
        catch (ParseException ex) {
            LOGGER.error("assess object format error !", (Throwable)ex);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ee9\u6548\u8003\u6838\u65b9\u6848\u8bc4\u4f30\u5bf9\u8c61\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"AssessObjectModifyCyclePlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
    }

    private void setYearMaxAndMin(DynamicObject scheme) {
        DateEdit dateEdit = (DateEdit)this.getControl(STARTTIME);
        dateEdit.setMinDate(scheme.getDate("startyear"));
        if (scheme.getDate("endyear") != null) {
            dateEdit.setMaxDate(scheme.getDate("endyear"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean result;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        String partType = (String)this.getModel().getValue(PARTTYPE);
        boolean permission = AssessObjectPermissionUtils.checkModifyCyclePermission(this.getView());
        if (!permission) {
            args.setCancel(true);
            return;
        }
        if (!this.checkItemPermission()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"AssessObjectModifyCyclePlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject scheme = this.getCurScheme();
        if (!this.validateModifyCycle(scheme)) {
            args.setCancel(true);
        }
        if (CONFIRM.equals(operateKey) && !(result = this.checkPermission())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"AssessObjectModifyCyclePlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private DynamicObject getCurScheme() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long schemeId = (Long)formShowParameter.getCustomParam("schemeId");
        return ASSESS_SCHEME.queryCycleInfoById(schemeId);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (CONFIRM.equals(operateKey)) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            DynamicObject scheme = this.getCurScheme();
            String partType = (String)this.getModel().getValue(PARTTYPE);
            if (partType.equals(AssessObjectEnums.PARTAKE_ALL.getValue())) {
                map.put("startTime", this.getStartCycle(scheme, ""));
                map.put("endTime", this.getEndCycle(scheme, ""));
            }
            if (partType.equals(AssessObjectEnums.PARTAKE_START_TIME.getValue())) {
                map.put("startTime", this.getStartCycle(scheme, HRDateTimeUtils.format((Date)this.getModel().getDataEntity().getDate(STARTTIME), (String)"yyyy")));
                map.put("endTime", this.getEndCycle(scheme, ""));
            }
            if (partType.equals(AssessObjectEnums.PARTAKE_END_TIME.getValue())) {
                map.put("startTime", this.getStartCycle(scheme, ""));
                map.put("endTime", this.getEndCycle(scheme, HRDateTimeUtils.format((Date)this.getModel().getDataEntity().getDate(STARTTIME), (String)"yyyy")));
            }
            if (partType.equals(AssessObjectEnums.NOT_PARTAKE.getValue())) {
                map.put("startTime", "");
                map.put("endTime", "");
            }
            map.put(PARTTYPE, partType);
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    private String getStartCycle(DynamicObject scheme, String selectYear) {
        String timeTag = scheme.getDynamicObject("starttimetag").getString("name");
        if (HRStringUtils.isEmpty((String)selectYear)) {
            selectYear = HRDateTimeUtils.format((Date)scheme.getDate("startyear"), (String)"yyyy");
        } else {
            DynamicObject selectTimeTagDy = this.getModel().getDataEntity().getDynamicObject(TIMETAG);
            timeTag = selectTimeTagDy == null ? timeTag : selectTimeTagDy.getString("name");
        }
        return selectYear + timeTag;
    }

    private String getEndCycle(DynamicObject scheme, String selectYear) {
        if (HRStringUtils.isEmpty((String)selectYear) && scheme.getDate("endyear") == null) {
            return "";
        }
        String timeTag = scheme.getDynamicObject("endtimetag").getString("name");
        if (HRStringUtils.isEmpty((String)selectYear)) {
            selectYear = HRDateTimeUtils.format((Date)scheme.getDate("endyear"), (String)"yyyy");
        } else {
            DynamicObject selectTimeTagDy = this.getModel().getDataEntity().getDynamicObject(TIMETAG);
            timeTag = selectTimeTagDy == null ? timeTag : selectTimeTagDy.getString("name");
        }
        return selectYear + timeTag;
    }

    private boolean validateModifyCycle(DynamicObject scheme) {
        String partType = this.getModel().getDataEntity().getString(PARTTYPE);
        if (AssessObjectEnums.PARTAKE_ALL.getValue().equals(partType) || AssessObjectEnums.NOT_PARTAKE.getValue().equals(partType)) {
            return true;
        }
        int endYear = 2199;
        if (scheme.getDate("endyear") != null) {
            endYear = OpmcDateUtils.getYear((Date)scheme.getDate("endyear"));
        }
        int startYear = OpmcDateUtils.getYear((Date)scheme.getDate("startyear"));
        int curYear = OpmcDateUtils.getYear((Date)this.getModel().getDataEntity().getDate(STARTTIME));
        if (curYear > endYear || curYear < startYear) {
            this.showValidateModifyCycle();
            return false;
        }
        return true;
    }

    private void showValidateModifyCycle() {
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e74\u4efd\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e\u8003\u6838\u8ba1\u5212\u7684\u7ed3\u675f\u5e74\u4efd", (String)"AssessObjectModifyCyclePlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fileKey = evt.getProperty().getName();
        if (HRStringUtils.isNotEmpty((String)fileKey) && TIMETAG.equals(fileKey)) {
            DynamicObject scheme = this.getCurScheme();
            int curYear = OpmcDateUtils.getYear((Date)this.getModel().getDataEntity().getDate(STARTTIME));
            List<Long> timeTagRangeByYear = TimeTagUtil.getTimeTagRangeByYear(curYear, scheme.getLong("id"));
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", timeTagRangeByYear));
        }
    }

    private boolean checkPermission() {
        String pageId = this.getView().getParentView().getPageCache().get("epa_schememanagement");
        if (StringUtils.isNotBlank((CharSequence)pageId) && pageId.contains("epa_schememanagement")) {
            Object orgObj = this.getView().getFormShowParameter().getCustomParam("orgIds");
            Object groupObj = this.getView().getFormShowParameter().getCustomParam("groupIds");
            String orgJson = JSON.toJSONString((Object)orgObj);
            String groupJson = JSON.toJSONString((Object)groupObj);
            List chooseOrgIds = JSONObject.parseArray((String)orgJson, Long.class);
            List chooseGroupIds = JSONObject.parseArray((String)groupJson, Long.class);
            DynamicObject manager = this.getManagerData();
            if (!ObjectUtils.isEmpty((Object)manager)) {
                boolean groupCheck;
                boolean orgPermiss = true;
                boolean groupPermiss = true;
                boolean orgCheck = manager.getBoolean("isorgcheck");
                if (!orgCheck) {
                    DynamicObjectCollection orgs = manager.getDynamicObjectCollection("org");
                    List orgIds = orgs.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
                    orgPermiss = orgIds.containsAll(chooseOrgIds);
                }
                if (!(groupCheck = manager.getBoolean("isgroupcheck"))) {
                    DynamicObjectCollection groups = manager.getDynamicObjectCollection("assessgroup");
                    List groupIds = groups.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
                    groupPermiss = groupIds.containsAll(chooseGroupIds);
                }
                return orgPermiss && groupPermiss;
            }
        }
        return true;
    }

    private boolean checkItemPermission() {
        DynamicObject manager;
        String pageId = this.getView().getParentView().getPageCache().get("epa_schememanagement");
        if (StringUtils.isNotBlank((CharSequence)pageId) && pageId.contains("epa_schememanagement") && !ObjectUtils.isEmpty((Object)(manager = this.getManagerData()))) {
            String manageitems = manager.getString("manageitems");
            return manageitems.contains("1");
        }
        return true;
    }

    private DynamicObject getManagerData() {
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        long sysUserId = RequestContext.get().getCurrUserId();
        return ASSIGN_MANAGER_APPLICATION_SERVICE.queryBySchmeIdAndUserId(schemeId, sysUserId);
    }
}

