/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.scheme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.opmc.epa.business.application.service.scheme.AssessObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssignManagerApplicationService;
import kd.opmc.epa.formplugin.web.utils.BosListUtil;
import kd.opmc.epa.formplugin.web.utils.SchemeStatusValidateUtils;

public class AssessObjectPerffileList
extends HRDataBaseList {
    private static final AssessObjectApplicationService ASSESS_OBJECT = AssessObjectApplicationService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME = AssessSchemeApplicationService.getInstance();
    private static final AssignManagerApplicationService ASSIGN_MANAGER_APPLICATION_SERVICE = AssignManagerApplicationService.getInstance();

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        List<String> fixedColumnList = Arrays.asList("fseq", "person.headsculpture", "person.name");
        List listColumn = billList.getListFieldsControlColumns();
        ArrayList<Map> listFixedColumn = new ArrayList<Map>(10);
        for (Map map : listColumn) {
            String fieldKey = (String)map.get("listFieldKey");
            if (fixedColumnList.contains(fieldKey)) {
                map.replace("fixed", Boolean.TRUE);
            }
            listFixedColumn.add(map);
        }
        billList.setListFieldsControlColumns(listFixedColumn);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean result;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        this.checkItemPermission(args);
        SchemeStatusValidateUtils.checkSchemeStatusValidate(args, this.getView());
        if ("joinin".equals(operateKey) && !(result = this.checkPermission())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"AssessObjectPerffileList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private boolean checkPermission() {
        String pageId = this.getParentPageId();
        if (StringUtils.isNotBlank((CharSequence)pageId) && pageId.contains("epa_schememanagement")) {
            boolean orgCheck;
            long sysUserId;
            ListSelectedRowCollection col = this.getSelectedRows();
            if (kd.bos.orm.util.CollectionUtils.isEmpty((Collection)col)) {
                return false;
            }
            List ids = col.stream().map(obj -> (Long)obj.getPrimaryKeyValue()).collect(Collectors.toList());
            DynamicObject[] dys = ASSESS_OBJECT.getPerffileListByIds(ids);
            List chooseOrgIds = Arrays.stream(dys).map(obj -> obj.getLong("affiliateadminorg.id")).collect(Collectors.toList());
            Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
            DynamicObject manager = ASSIGN_MANAGER_APPLICATION_SERVICE.queryBySchmeIdAndUserId(schemeId, sysUserId = RequestContext.get().getCurrUserId());
            if (!ObjectUtils.isEmpty((Object)manager) && !(orgCheck = manager.getBoolean("isorgcheck"))) {
                DynamicObjectCollection orgs = manager.getDynamicObjectCollection("org");
                List orgIds = orgs.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
                return orgIds.containsAll(chooseOrgIds);
            }
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        IListView view = (IListView)this.getView();
        if ("joinin".equals(operateKey) && CollectionUtils.isNotEmpty((Collection)view.getSelectedRows())) {
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("epa_assessobject_joinin");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.ADDNEW);
            Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
            showParameter.setCustomParam("schemeId", (Object)schemeId);
            showParameter.setCustomParam("pageType", (Object)"notJoin");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_assessobject_joinin"));
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (HRStringUtils.equals((String)operateKey, (String)"refresh")) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("refreshView", ((IListView)this.getView()).getBillFormId());
            this.getView().getParentView().invokeOperation("refreshobjnum", operateOption);
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        List qFilters = evt.getQFilters();
        HashSet<Long> orgIdsSet = new HashSet<Long>(16);
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        DynamicObject scheme = ASSESS_SCHEME.queryOrgEntryById(schemeId);
        DynamicObjectCollection orgEntryData = scheme.getDynamicObjectCollection("orgentryentity");
        ArrayList<Long> querySubOrgIds = new ArrayList<Long>(16);
        for (DynamicObject org : orgEntryData) {
            long adminOrgId = org.getLong("orgbasedata_id");
            if (org.getBoolean("iscontainlower")) {
                querySubOrgIds.add(adminOrgId);
                continue;
            }
            orgIdsSet.add(adminOrgId);
        }
        this.batchGetSubOrgIds(orgIdsSet, querySubOrgIds);
        ArrayList<Long> orgIds = new ArrayList<Long>(orgIdsSet);
        qFilters.add(new QFilter("affiliateadminorg.id", "in", orgIds));
        qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        DynamicObject[] joinInAssessObjectLists = ASSESS_OBJECT.queryPerffileBySchemeId(schemeId);
        List joinInIds = Arrays.stream(joinInAssessObjectLists).map(obj -> obj.getDynamicObject("perfile").getLong("id")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(joinInIds)) {
            qFilters.add(new QFilter("id", "not in", joinInIds));
        }
        this.setDataFilter(qFilters);
        ArrayList<Object> dataFilters = evt.getDataPermQFilters() == null ? new ArrayList<QFilter>(10) : new ArrayList(evt.getDataPermQFilters());
        dataFilters.add(new QFilter("initstatus", "=", (Object)"2"));
        dataFilters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        dataFilters.add(new QFilter("datastatus", "!=", (Object)"-1"));
        dataFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        dataFilters.add(evt.getMainOrgQFilter());
        dataFilters.add(new QFilter("affiliateadminorg.id", "in", orgIds));
        if (CollectionUtils.isNotEmpty(joinInIds)) {
            dataFilters.add(new QFilter("id", "not in", joinInIds));
        }
        this.setDataFilter(dataFilters);
        int notJoinNum = ASSESS_OBJECT.countNoJoinObj(dataFilters);
        if (this.getView().getParentView() == null) {
            return;
        }
        Label notJoinNumLab = (Label)this.getView().getParentView().getControl("notjoinnumlab");
        notJoinNumLab.setText(String.valueOf(notJoinNum));
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void setDataFilter(List<QFilter> qFilters) {
        String pageId = this.getParentPageId();
        if (StringUtils.isNotBlank((CharSequence)pageId) && pageId.contains("epa_schememanagement")) {
            boolean orgCheck;
            this.getPageCache().put("epa_schememanagement", "epa_schememanagement");
            DynamicObject manager = this.getManagerData();
            if (!ObjectUtils.isEmpty((Object)manager) && !(orgCheck = manager.getBoolean("isorgcheck"))) {
                DynamicObjectCollection orgs = manager.getDynamicObjectCollection("org");
                List orgIds = orgs.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
                QFilter filter = new QFilter("affiliateadminorg", "in", orgIds);
                qFilters.add(filter);
            }
        }
    }

    private String getParentPageId() {
        if (this.getView() != null && this.getView().getParentView() != null && this.getView().getParentView().getParentView() != null) {
            return this.getView().getParentView().getParentView().getPageId();
        }
        return "";
    }

    private void batchGetSubOrgIds(Set<Long> orgIdsSet, List<Long> orgIds) {
        List maps = ASSESS_OBJECT.batchGetAllSubOrg(orgIds, new Date());
        for (Map map : maps) {
            orgIdsSet.add((Long)map.get("orgId"));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BosListUtil.setGripMargin(this.getView());
    }

    private void checkItemPermission(BeforeDoOperationEventArgs args) {
        String manageitems;
        DynamicObject manager;
        String pageId = this.getParentPageId();
        if (StringUtils.isNotBlank((CharSequence)pageId) && pageId.contains("epa_schememanagement") && !ObjectUtils.isEmpty((Object)(manager = this.getManagerData())) && !(manageitems = manager.getString("manageitems")).contains("1")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"AssessObjectPerffileList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private DynamicObject getManagerData() {
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        long sysUserId = RequestContext.get().getCurrUserId();
        return ASSIGN_MANAGER_APPLICATION_SERVICE.queryBySchmeIdAndUserId(schemeId, sysUserId);
    }
}

