/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.scheme;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.TipsSupport;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.scheme.AssignManagerApplicationService;
import kd.opmc.epa.formplugin.web.scheme.AssessSchemeViewUtils;

public class AssessSchemeWizardEdit
extends HRDataBaseEdit {
    private static final AssignManagerApplicationService ASSIGN_MANAGER_APPLICATION_SERVICE = AssignManagerApplicationService.getInstance();
    protected static final Map<Integer, String> pageMap;
    public static final String OP_LASTPAGE = "donothing_lastpage";
    public static final String OP_NEXTPAGE = "donothing_nextpage";
    private static final String[] WIZARDS;

    public void initialize() {
        super.initialize();
        this.addClickListeners(WIZARDS);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (!(source instanceof TipsSupport)) {
            return;
        }
        String key = ((TipsSupport)source).getKey();
        boolean switchSuccess = AssessSchemeViewUtils.wizardSwitch(key, WIZARDS, this.getView(), ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58", (String)"AssessSchemeWizardEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        if (switchSuccess) {
            this.refreshTabPage(key);
        }
    }

    private void refreshTabPage(String key) {
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        this.getPageCache().put("toPage", String.valueOf(1));
        if (key.contains("assobjscope")) {
            this.showSubPage(pkValue, "epa_objectscope_base", "assobjscopepage", null);
            this.getPageCache().put("toPage", String.valueOf(2));
        } else if (key.contains("excutescheme")) {
            this.showSubPage(pkValue, "epa_executescheme_base", "excuteschemepage", null);
            this.getPageCache().put("toPage", String.valueOf(3));
        } else if (key.contains("assactivity")) {
            this.showActivityPage(pkValue);
        } else if (key.contains("allotadmin")) {
            this.showAssignManager(pkValue);
            this.getPageCache().put("toPage", String.valueOf(4));
        }
        this.setButtonVisible(Integer.parseInt(StringUtils.isEmpty((CharSequence)this.getPageCache().get("toPage")) ? "1" : this.getPageCache().get("toPage")));
    }

    protected void setButtonVisible(int toPage) {
        this.getView().setVisible(Boolean.valueOf(toPage != 1), new String[]{"lastpage"});
        this.getView().setVisible(Boolean.valueOf(toPage != pageMap.size()), new String[]{"nextpage"});
        this.getView().setVisible(Boolean.valueOf(toPage == 1), new String[]{"bar_save"});
        this.getView().setVisible(Boolean.valueOf(toPage == pageMap.size()), new String[]{"close"});
    }

    private void toNextPage(AfterDoOperationEventArgs args) {
        String focuspage = this.getPageCache().get("toPage");
        if (StringUtils.isEmpty((CharSequence)focuspage)) {
            this.toPage(2);
        } else {
            this.toPage(Integer.parseInt(focuspage) + 1);
        }
    }

    private void toLastPage(AfterDoOperationEventArgs args) {
        String focuspage = this.getPageCache().get("toPage");
        this.toPage(Integer.parseInt(focuspage) - 1);
    }

    private void toPage(int page) {
        int minPage = 1;
        int maxPage = pageMap.size();
        if (page <= maxPage && page >= minPage) {
            this.setTab(page);
        }
    }

    protected void setTab(int toPage) {
        String tabKey = pageMap.get(toPage);
        boolean switchSuccess = AssessSchemeViewUtils.wizardSwitch(tabKey, WIZARDS, this.getView(), ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58", (String)"AssessSchemeWizardEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        if (switchSuccess) {
            if (StringUtils.isNotEmpty((CharSequence)tabKey)) {
                if (toPage == 1) {
                    Label baseInfoLab = (Label)this.getControl("baseinfolab");
                    if (baseInfoLab != null) {
                        baseInfoLab.click();
                    }
                } else {
                    this.refreshTabPage(tabKey);
                }
            }
            this.setButtonVisible(toPage);
            this.getModel().setDataChanged(false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"save") && args.getOperationResult().isSuccess()) {
            this.showWizardView();
        }
        switch (key = args.getOperateKey()) {
            case "donothing_lastpage": {
                this.toLastPage(args);
                break;
            }
            case "donothing_nextpage": {
                this.toNextPage(args);
                break;
            }
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.showWizardView();
        this.setButtonVisible(1);
    }

    private void showWizardView() {
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (pkValue == 0L) {
            return;
        }
        String pageId = this.getView().getPageId();
        if (!pageId.contains("epa_schememanagement")) {
            this.showSubPage(pkValue, "epa_objectscope_base", "assobjscopepage", null);
            this.showSubPage(pkValue, "epa_executescheme_base", "excuteschemepage", null);
            this.showAssignManager(pkValue);
            Label baseInfoLab = (Label)this.getControl("baseinfolab");
            if (baseInfoLab != null) {
                baseInfoLab.click();
            }
        } else {
            long sysUserId = RequestContext.get().getCurrUserId();
            DynamicObject manager = ASSIGN_MANAGER_APPLICATION_SERVICE.queryBySchmeIdAndUserId(pkValue, sysUserId);
            if (ObjectUtils.isEmpty((Object)manager)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"assactivitytab"});
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6743\u9650", (String)"AssessSchemeWizardEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return;
            }
            String items = manager.getString("manageitems");
            if (items.contains("2")) {
                this.showActivityPage(pkValue);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"assactivitytab"});
            }
        }
    }

    private void showActivityPage(Long pkValue) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setCustomParam("schemeId", (Object)pkValue);
        parameter.setBillFormId("epa_activity");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("assactivitypage");
        parameter.getListFilterParameter().getQFilters().add(new QFilter("scheme", "=", (Object)pkValue));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showSubPage(Long schemeId, String pageId, String targetKey, DynamicObject manager) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(pageId);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCustomParam("schemeId", (Object)schemeId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        DynamicObject cycleType = (DynamicObject)this.getModel().getValue("cycletype");
        showParameter.setCustomParam("cycletype", (Object)cycleType.getLong("id"));
        this.setFilterParameter(showParameter, manager);
        this.getView().showForm(showParameter);
    }

    private void showAssignManager(Long pkValue) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setCustomParam("schemeId", (Object)pkValue);
        parameter.setBillFormId("epa_assignmanager");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("assignmanager");
        parameter.getListFilterParameter().getQFilters().add(new QFilter("scheme", "=", (Object)pkValue));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void setFilterParameter(FormShowParameter showParameter, DynamicObject manager) {
        if (!ObjectUtils.isEmpty((Object)manager)) {
            boolean groupCheck;
            boolean orgCheck = manager.getBoolean("isorgcheck");
            if (!orgCheck) {
                DynamicObjectCollection orgs = manager.getDynamicObjectCollection("org");
                ArrayList orgIds = ObjectUtils.isEmpty((Object)orgs) ? new ArrayList(16) : orgs.stream().map(org -> org.getLong("fbasedataid_id")).collect(Collectors.toList());
                showParameter.setCustomParam("org", orgIds);
            }
            if (!(groupCheck = manager.getBoolean("isgroupcheck"))) {
                DynamicObjectCollection groups = manager.getDynamicObjectCollection("assessgroup");
                ArrayList groupIds = ObjectUtils.isEmpty((Object)groups) ? new ArrayList(16) : groups.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
                showParameter.setCustomParam("assessgroup", groupIds);
            }
        }
    }

    static {
        WIZARDS = new String[]{"baseinfoap", "baseinfostep", "baseinfolab", "assobjscopeap", "assobjscopestep", "assobjscopelab", "excuteschemeap", "excuteschemestep", "excuteschemelab", "assactivityap", "assactivitystep", "assactivitylab", "allotadminap", "allotadminstep", "allotadminlab"};
        pageMap = new HashMap<Integer, String>(16);
        pageMap.put(1, "baseinfoap");
        pageMap.put(2, "assobjscopeap");
        pageMap.put(3, "excuteschemeap");
    }
}

